/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.options;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.mercurial.remote.HgModuleConfig;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.options.Bundle;
import org.netbeans.modules.mercurial.remote.options.MercurialOptionsPanelController;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;

final class MercurialPanel
extends JPanel {
    private final MercurialOptionsPanelController controller;
    private final DocumentListener listener;
    private final ActionListener actionListener;
    private String initialUserName;
    private String[] keywords;
    final JButton addButton = new JButton();
    final JTextField annotationTextField = new JTextField();
    private JCheckBox cbAskBeforeCommitAfterMerge;
    final JComboBox cbBuildHost = new JComboBox();
    private JCheckBox cbInternalMergeToolEnabled;
    private JCheckBox cbOpenOutputWindow;
    final JCheckBox excludeNewFiles = new JCheckBox();
    final JButton execPathBrowseButton = new JButton();
    final JTextField executablePathTextField = new JTextField();
    private JLabel exportFilename;
    final JButton exportFilenameBrowseButton = new JButton();
    final JTextField exportFilenameTextField = new JTextField();
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTextPane jTextPane1;
    private JLabel lblWarning;
    final JButton manageButton = new JButton();
    final JTextField userNameTextField = new JTextField();

    MercurialPanel(MercurialOptionsPanelController controller) {
        this.controller = controller;
        this.listener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                MercurialPanel.this.nameChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MercurialPanel.this.nameChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                MercurialPanel.this.nameChange();
            }
        };
        this.actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MercurialPanel.this.nameChange();
            }
        };
        this.initComponents();
        this.lblWarning.setForeground(UIManager.getDefaults().getColor("nb.errorForeground"));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.userNameTextField.getDocument().addDocumentListener(this.listener);
        this.executablePathTextField.getDocument().addDocumentListener(this.listener);
        this.exportFilenameTextField.getDocument().addDocumentListener(this.listener);
        this.annotationTextField.getDocument().addDocumentListener(this.listener);
        this.cbOpenOutputWindow.addActionListener(this.actionListener);
        this.cbAskBeforeCommitAfterMerge.addActionListener(this.actionListener);
        this.cbInternalMergeToolEnabled.addActionListener(this.actionListener);
        this.excludeNewFiles.addActionListener(this.actionListener);
    }

    @Override
    public void removeNotify() {
        this.userNameTextField.getDocument().removeDocumentListener(this.listener);
        super.removeNotify();
    }

    Collection<String> getKeywords() {
        if (this.keywords == null) {
            this.keywords = new String[]{"HG", "MERCURIAL", Bundle.MercurialPanel_kw1().toUpperCase(Locale.getDefault()), Bundle.MercurialPanel_kw2().toUpperCase(Locale.getDefault()), Bundle.MercurialPanel_kw3().toUpperCase(Locale.getDefault())};
        }
        return Collections.unmodifiableList(Arrays.asList(this.keywords));
    }

    private void initComponents() {
        this.jLabel10 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.exportFilename = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jTextPane1 = new JTextPane();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.cbOpenOutputWindow = new JCheckBox();
        this.cbAskBeforeCommitAfterMerge = new JCheckBox();
        this.cbInternalMergeToolEnabled = new JCheckBox();
        this.lblWarning = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.jLabel10, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.jLabel10.text"));
        this.jLabel1.setLabelFor(this.userNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.jLabel1.text"));
        this.jLabel2.setLabelFor(this.executablePathTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.jLabel2.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.execPathBrowseButton, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.browseButton.text"));
        this.exportFilename.setLabelFor(this.exportFilenameTextField);
        Mnemonics.setLocalizedText((JLabel)this.exportFilename, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.ExportFilename.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.exportFilenameBrowseButton, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.browseButton2.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.jLabel5.text"));
        this.jLabel3.setLabelFor(this.annotationTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.jLabel3.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.addButton.text"));
        this.annotationTextField.setText(NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.annotationTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.jLabel6.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.manageButton, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.manageButton.text"));
        this.jTextPane1.setBackground(this.jLabel1.getBackground());
        this.jTextPane1.setText(NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.jTextPane1.text"));
        this.cbOpenOutputWindow.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cbOpenOutputWindow, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.cbOpenOutputWindow.text"));
        this.cbOpenOutputWindow.setToolTipText(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_cbOpenOutputWindow"));
        this.cbOpenOutputWindow.setBorder(null);
        this.cbAskBeforeCommitAfterMerge.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cbAskBeforeCommitAfterMerge, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.cbAskBeforeCommitAfterMerge.text"));
        this.cbAskBeforeCommitAfterMerge.setToolTipText(NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.cbAskBeforeCommitAfterMerge.toolTipText"));
        this.cbAskBeforeCommitAfterMerge.setBorder(null);
        this.cbInternalMergeToolEnabled.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cbInternalMergeToolEnabled, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.cbInternalMergeToolEnabled.text"));
        this.cbInternalMergeToolEnabled.setToolTipText(NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.cbInternalMergeToolEnabled.toolTipText"));
        this.cbInternalMergeToolEnabled.setBorder(null);
        Mnemonics.setLocalizedText((AbstractButton)this.excludeNewFiles, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.excludeNewFiles.text"));
        this.excludeNewFiles.setToolTipText(NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.excludeNewFiles.toolTipText"));
        this.excludeNewFiles.setBorder(null);
        this.excludeNewFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MercurialPanel.this.excludeNewFilesActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lblWarning, (String)" ");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbOpenOutputWindow).addComponent(this.cbAskBeforeCommitAfterMerge).addComponent(this.cbInternalMergeToolEnabled).addComponent(this.excludeNewFiles))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel6, -1, -1, Short.MAX_VALUE).addGap(201, 201, 201))).addGap(248, 248, 248)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.annotationTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addButton, -2, 125, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jTextPane1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.manageButton)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(92, 92, 92).addComponent(this.jSeparator2)))).addGroup(layout.createSequentialGroup().addComponent(this.lblWarning).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.exportFilename).addComponent(this.jLabel1).addComponent(this.jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbBuildHost, 0, -1, Short.MAX_VALUE).addComponent(this.userNameTextField).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.executablePathTextField).addComponent(this.exportFilenameTextField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.exportFilenameBrowseButton).addComponent(this.execPathBrowseButton))))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.cbBuildHost, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.userNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.executablePathTextField, -2, -1, -2).addComponent(this.execPathBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.exportFilename).addComponent(this.exportFilenameTextField, -2, -1, -2).addComponent(this.exportFilenameBrowseButton)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.annotationTextField, -2, -1, -2).addComponent(this.addButton)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel6).addComponent(this.jSeparator2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.manageButton).addComponent(this.jTextPane1, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.cbOpenOutputWindow).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbAskBeforeCommitAfterMerge).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbInternalMergeToolEnabled).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.excludeNewFiles).addGap(18, 18, 18).addComponent(this.lblWarning).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(1, this.addButton, this.annotationTextField, this.jLabel3);
        this.userNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_userNameTextField"));
        this.executablePathTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_executablePathTextField"));
        this.execPathBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_execPathBrowseButton"));
        this.exportFilenameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_exportFileNameTextField"));
        this.exportFilenameBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_exportFilenameBrowseButton"));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_addButton"));
        this.manageButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_manageButton"));
        this.cbOpenOutputWindow.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_cbOpenOutputWindow"));
    }

    private void excludeNewFilesActionPerformed(ActionEvent evt) {
    }

    void fileSystemChanged(FileSystem fileSystem) {
        boolean enabled = fileSystem != null;
        this.addButton.setEnabled(enabled);
        this.annotationTextField.setEnabled(enabled);
        this.cbAskBeforeCommitAfterMerge.setEnabled(enabled);
        this.cbInternalMergeToolEnabled.setEnabled(enabled);
        this.cbOpenOutputWindow.setEnabled(enabled);
        this.excludeNewFiles.setEnabled(enabled);
        this.execPathBrowseButton.setEnabled(enabled);
        this.executablePathTextField.setEnabled(enabled);
        this.exportFilenameBrowseButton.setEnabled(enabled);
        this.exportFilenameTextField.setEnabled(enabled);
        this.manageButton.setEnabled(enabled);
        this.userNameTextField.setEnabled(enabled);
    }

    private void nameChange() {
        if (this.controller.getFS() == null) {
            return;
        }
        VCSFileProxy root = this.controller.getRoot();
        boolean isChanged = this.userNameTextField.isEnabled() && !this.initialUserName.equals(this.userNameTextField.getText()) || !HgModuleConfig.getDefault(root).getExecutableBinaryPath().equals(this.executablePathTextField.getText()) || !HgModuleConfig.getDefault(root).getExportFilename().equals(this.exportFilenameTextField.getText()) || !HgModuleConfig.getDefault(root).getAnnotationFormat().equals(this.annotationTextField.getText()) || HgModuleConfig.getDefault(root).getAutoOpenOutput() != this.cbOpenOutputWindow.isSelected() || HgModuleConfig.getDefault(root).getConfirmCommitAfterMerge() != this.cbAskBeforeCommitAfterMerge.isSelected() || HgModuleConfig.getDefault(root).isInternalMergeToolEnabled() != this.cbInternalMergeToolEnabled.isSelected() || HgModuleConfig.getDefault(root).getExludeNewFiles() != this.excludeNewFiles.isSelected();
        this.controller.changed(isChanged);
    }

    void load() {
        final VCSFileProxy root = this.controller.getRoot();
        this.userNameTextField.setEnabled(false);
        this.userNameTextField.setText(Bundle.CTL_UsernameLoading());
        Mercurial.getInstance().getParallelRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                MercurialPanel.this.initialUserName = HgModuleConfig.getDefault(root).getSysUserName();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MercurialPanel.this.userNameTextField.setText(MercurialPanel.this.initialUserName);
                        MercurialPanel.this.userNameTextField.setEnabled(true);
                    }
                });
            }
        });
        this.executablePathTextField.setText(HgModuleConfig.getDefault(root).getExecutableBinaryPath());
        this.exportFilenameTextField.setText(HgModuleConfig.getDefault(root).getExportFilename());
        this.annotationTextField.setText(HgModuleConfig.getDefault(root).getAnnotationFormat());
        this.cbOpenOutputWindow.setSelected(HgModuleConfig.getDefault(root).getAutoOpenOutput());
        this.cbAskBeforeCommitAfterMerge.setSelected(HgModuleConfig.getDefault(root).getConfirmCommitAfterMerge());
        this.cbInternalMergeToolEnabled.setSelected(HgModuleConfig.getDefault(root).isInternalMergeToolEnabled());
        this.excludeNewFiles.setSelected(HgModuleConfig.getDefault(root).getExludeNewFiles());
    }

    void store() {
        if (this.controller.getFS() == null) {
            return;
        }
        VCSFileProxy root = this.controller.getRoot();
        if (this.userNameTextField.isEnabled() && !this.initialUserName.equals(this.userNameTextField.getText())) {
            try {
                HgModuleConfig.getDefault(root).setUserName(this.userNameTextField.getText());
            }
            catch (IOException ex) {
                HgModuleConfig.notifyParsingError();
            }
        }
        HgModuleConfig.getDefault(root).setExecutableBinaryPath(this.executablePathTextField.getText());
        Mercurial.getInstance().asyncInit(root);
        HgModuleConfig.getDefault(root).setExportFilename(this.exportFilenameTextField.getText());
        HgModuleConfig.getDefault(root).setAnnotationFormat(this.annotationTextField.getText());
        HgModuleConfig.getDefault(root).setAutoOpenOutput(this.cbOpenOutputWindow.isSelected());
        HgModuleConfig.getDefault(root).setConfirmCommitAfterMerge(this.cbAskBeforeCommitAfterMerge.isSelected());
        HgModuleConfig.getDefault(root).setInternalMergeToolEnabled(this.cbInternalMergeToolEnabled.isSelected());
        HgModuleConfig.getDefault(root).setExcludeNewFiles(this.excludeNewFiles.isSelected());
    }

    void showError(String message) {
        if (message == null) {
            this.lblWarning.setText(" ");
        } else {
            this.lblWarning.setText(message);
        }
    }
}

