/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.commons.collections;

import com.sun.org.apache.commons.collections.Predicate;
import com.sun.org.apache.commons.collections.Transformer;
import com.sun.org.apache.commons.collections.iterators.ArrayIterator;
import com.sun.org.apache.commons.collections.iterators.CollatingIterator;
import com.sun.org.apache.commons.collections.iterators.EnumerationIterator;
import com.sun.org.apache.commons.collections.iterators.FilterIterator;
import com.sun.org.apache.commons.collections.iterators.FilterListIterator;
import com.sun.org.apache.commons.collections.iterators.IteratorChain;
import com.sun.org.apache.commons.collections.iterators.IteratorEnumeration;
import com.sun.org.apache.commons.collections.iterators.ListIteratorWrapper;
import com.sun.org.apache.commons.collections.iterators.SingletonIterator;
import com.sun.org.apache.commons.collections.iterators.SingletonListIterator;
import com.sun.org.apache.commons.collections.iterators.TransformIterator;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class IteratorUtils {
    public static final Iterator EMPTY_ITERATOR = new EmptyIterator();
    public static final ListIterator EMPTY_LIST_ITERATOR = new EmptyListIterator();
    static /* synthetic */ Class class$java$util$Iterator;

    private IteratorUtils() {
    }

    public static Iterator emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static ListIterator emptyListIterator() {
        return EMPTY_LIST_ITERATOR;
    }

    public static Iterator singletonIterator(Object object) {
        return new SingletonIterator(object);
    }

    public static ListIterator singletonListIterator(Object object) {
        return new SingletonListIterator(object);
    }

    public static Iterator arrayIterator(Object[] objectArray) {
        return new ArrayIterator(objectArray);
    }

    public static Iterator arrayIterator(Object[] objectArray, int n) {
        return new ArrayIterator(objectArray, n);
    }

    public static Iterator arrayIterator(Object[] objectArray, int n, int n2) {
        return new ArrayIterator(objectArray, n, n2);
    }

    public static Iterator chainedIterator(Iterator iterator, Iterator iterator2) {
        return new IteratorChain(iterator, iterator2);
    }

    public static Iterator chainedIterator(Iterator[] iteratorArray) {
        return new IteratorChain(iteratorArray);
    }

    public static Iterator chainedIterator(Collection collection) {
        return new IteratorChain(collection);
    }

    public static Iterator collatedIterator(Comparator comparator, Iterator iterator, Iterator iterator2) {
        return new CollatingIterator(comparator, iterator, iterator2);
    }

    public static Iterator collatedIterator(Comparator comparator, Iterator[] iteratorArray) {
        return new CollatingIterator(comparator, iteratorArray);
    }

    public static Iterator collatedIterator(Comparator comparator, Collection collection) {
        return new CollatingIterator(comparator, collection);
    }

    public static Iterator transformedIterator(Iterator iterator, Transformer transformer) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        if (transformer == null) {
            throw new NullPointerException("Transformer must not be null");
        }
        return new TransformIterator(iterator, transformer);
    }

    public static Iterator filteredIterator(Iterator iterator, Predicate predicate) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        if (predicate == null) {
            throw new NullPointerException("Predicate must not be null");
        }
        return new FilterIterator(iterator, predicate);
    }

    public static ListIterator filteredListIterator(ListIterator listIterator, Predicate predicate) {
        if (listIterator == null) {
            throw new NullPointerException("ListIterator must not be null");
        }
        if (predicate == null) {
            throw new NullPointerException("Predicate must not be null");
        }
        return new FilterListIterator(listIterator, predicate);
    }

    public static Iterator asIterator(Enumeration enumeration) {
        if (enumeration == null) {
            throw new NullPointerException("Enumeration must not be null");
        }
        return new EnumerationIterator(enumeration);
    }

    public static Iterator asIterator(Enumeration enumeration, Collection collection) {
        if (enumeration == null) {
            throw new NullPointerException("Enumeration must not be null");
        }
        if (collection == null) {
            throw new NullPointerException("Collection must not be null");
        }
        return new EnumerationIterator(enumeration, collection);
    }

    public static Enumeration asEnumeration(Iterator iterator) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        return new IteratorEnumeration(iterator);
    }

    public static ListIterator toListIterator(Iterator iterator) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        return new ListIteratorWrapper(iterator);
    }

    public static Object[] toArray(Iterator iterator) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        List list = IteratorUtils.toList(iterator, 100);
        return list.toArray();
    }

    public static Object[] toArray(Iterator iterator, Class clazz) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        if (clazz == null) {
            throw new NullPointerException("Array class must not be null");
        }
        List list = IteratorUtils.toList(iterator, 100);
        return list.toArray((Object[])Array.newInstance(clazz, list.size()));
    }

    public static List toList(Iterator iterator) {
        return IteratorUtils.toList(iterator, 10);
    }

    public static List toList(Iterator iterator, int n) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        if (n < 1) {
            throw new IllegalArgumentException("Estimated size must be greater than 0");
        }
        ArrayList arrayList = new ArrayList(n);
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public static Iterator getIterator(Object object) {
        if (object == null) {
            return IteratorUtils.emptyIterator();
        }
        if (object instanceof Iterator) {
            return (Iterator)object;
        }
        if (object instanceof Collection) {
            return ((Collection)object).iterator();
        }
        if (object instanceof Object[]) {
            return new ArrayIterator(object);
        }
        if (object instanceof Enumeration) {
            return new EnumerationIterator((Enumeration)object);
        }
        if (object instanceof Map) {
            return ((Map)object).values().iterator();
        }
        if (object instanceof Dictionary) {
            return new EnumerationIterator(((Dictionary)object).elements());
        }
        if (object != null && object.getClass().isArray()) {
            return new ArrayIterator(object);
        }
        try {
            Iterator iterator;
            Method method = object.getClass().getMethod("iterator", null);
            if ((class$java$util$Iterator == null ? (class$java$util$Iterator = IteratorUtils.class$("java.util.Iterator")) : class$java$util$Iterator).isAssignableFrom(method.getReturnType()) && (iterator = (Iterator)method.invoke(object, null)) != null) {
                return iterator;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return IteratorUtils.singletonIterator(object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class EmptyListIterator
    extends EmptyIterator
    implements ListIterator {
        EmptyListIterator() {
        }

        public boolean hasPrevious() {
            return false;
        }

        public Object previous() {
            throw new NoSuchElementException();
        }

        public int nextIndex() {
            return 0;
        }

        public int previousIndex() {
            return -1;
        }

        public void add(Object object) {
            throw new UnsupportedOperationException("add() not supported for empty Iterator");
        }

        public void set(Object object) {
            throw new UnsupportedOperationException("set() not supported for empty Iterator");
        }
    }

    static class EmptyIterator
    implements Iterator {
        EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException("remove() not supported for empty Iterator");
        }
    }
}

