/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeMemory;
import org.clank.support.NativePointer;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.clank.support.void;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.support.AllocatorBase;
import org.llvm.support.MallocAllocator;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;
import org.llvm.support.sys.Memory;

public class BumpPtrAllocatorImpl
extends AllocatorBase<BumpPtrAllocatorImpl>
implements Destructors.ClassWithDestructor,
NativeMemory.BumpAllocator {
    final int SlabSize;
    final int SizeThreshold;
    final int MaxSlabSize;
    char.ptr CurPtr;
    char.ptr End;
    SmallVector<char.ptr> Slabs;
    SmallVector<std_pair.pairTypeInt<char.ptr>> CustomSizedSlabs;
    private int BytesAllocated;
    private NativeMemory.Allocator Allocator;

    public BumpPtrAllocatorImpl() {
        this(new MallocAllocator());
    }

    public BumpPtrAllocatorImpl(NativeMemory.Allocator Allocator2) {
        this(Allocator2, 4096);
    }

    public BumpPtrAllocatorImpl(NativeMemory.Allocator Allocator2, int SlabSize) {
        this(Allocator2, SlabSize, SlabSize);
    }

    public BumpPtrAllocatorImpl(NativeMemory.Allocator Allocator2, int SlabSize, int SizeThreshold) {
        this(Allocator2, SlabSize, SizeThreshold, NativeMemory.Allocator.MaxPageSize);
    }

    public BumpPtrAllocatorImpl(NativeMemory.Allocator Allocator2, int SlabSize, int SizeThreshold, int MaxSlabSize) {
        this.Slabs = new SmallVector<char.ptr>(4, (char.ptr)null);
        this.CustomSizedSlabs = new SmallVector<std_pair.pairTypeInt>(0, new std_pair.pairTypeInt(null, 0));
        this.CurPtr = null;
        this.End = null;
        this.BytesAllocated = 0;
        this.Allocator = Allocator2;
        this.SlabSize = SlabSize;
        this.SizeThreshold = SizeThreshold;
        this.MaxSlabSize = MaxSlabSize;
    }

    public BumpPtrAllocatorImpl(BumpPtrAllocatorImpl Old) {
        this.CurPtr = Native.$tryClone((char.ptr)Old.CurPtr);
        this.End = Native.$tryClone((char.ptr)Old.End);
        this.Slabs = new SmallVector((SmallVector)std.move(Old.Slabs));
        this.CustomSizedSlabs = new SmallVector((SmallVector)std.move(Old.CustomSizedSlabs));
        this.BytesAllocated = Old.BytesAllocated;
        this.Allocator = (NativeMemory.Allocator)std.move((Object)Old.Allocator);
        Old.End = null;
        Old.CurPtr = null;
        Old.BytesAllocated = 0;
        Old.Slabs.clear();
        Old.CustomSizedSlabs.clear();
        this.SlabSize = Old.SlabSize;
        this.SizeThreshold = Old.SizeThreshold;
        this.MaxSlabSize = Old.MaxSlabSize;
        assert (this.SlabSize <= this.MaxSlabSize) : this.SlabSize + " is bigger than " + this.MaxSlabSize;
    }

    @Override
    public void $destroy() {
        this.DeallocateSlabs(this.Slabs, 0);
        this.DeallocateCustomSizedSlabs();
        this.CustomSizedSlabs.$destroy();
        this.Slabs.$destroy();
        super.$destroy();
    }

    public BumpPtrAllocatorImpl $assign(BumpPtrAllocatorImpl RHS) {
        this.DeallocateSlabs(this.Slabs, 0);
        this.DeallocateCustomSizedSlabs();
        this.CurPtr = RHS.CurPtr;
        this.End = RHS.End;
        this.BytesAllocated = RHS.BytesAllocated;
        this.Slabs = (SmallVector)std.move(RHS.Slabs);
        this.CustomSizedSlabs = (SmallVector)std.move(RHS.CustomSizedSlabs);
        this.Allocator = (NativeMemory.Allocator)std.move((Object)RHS.Allocator);
        RHS.End = null;
        RHS.CurPtr = null;
        RHS.BytesAllocated = 0;
        RHS.Slabs.clear();
        RHS.CustomSizedSlabs.clear();
        return this;
    }

    public void Reset() {
        if (this.Slabs.empty()) {
            return;
        }
        this.BytesAllocated = 0;
        this.CurPtr = Native.$tryClone((char.ptr)((char.ptr)this.Slabs.front()));
        this.End = (char.ptr)this.CurPtr.$add(this.SlabSize);
        this.DeallocateSlabs(this.Slabs, 1);
        this.Slabs.erase((SmallVectorImpl.iterator)std.next((abstract_iterator)this.Slabs.begin()), (SmallVectorImpl.iterator)this.Slabs.end());
        this.DeallocateCustomSizedSlabs();
        this.CustomSizedSlabs.clear();
    }

    public char.ptr Allocate(int Size, int Alignment) {
        assert (Alignment > 0) : "0-byte alignnment is not allowed. Use 1 instead.";
        this.BytesAllocated += Size;
        int Adjustment = llvm.alignmentAdjustment(this.CurPtr, Alignment);
        assert (Adjustment + Size >= Size) : "Adjustment + Size must not overflow";
        if (Adjustment + Size <= Native.$sub_ptr((char.ptr)this.End, (char.ptr)this.CurPtr)) {
            char.ptr AlignedPtr = (char.ptr)this.CurPtr.$add(Adjustment);
            this.CurPtr = Native.$tryClone((char.ptr)((char.ptr)AlignedPtr.$add(Size)));
            return AlignedPtr;
        }
        int PaddedSize = Size + Alignment - 1;
        if (PaddedSize > this.SizeThreshold) {
            char.ptr NewSlab = this.Allocator.AllocateSlab(PaddedSize);
            this.CustomSizedSlabs.push_back((std_pair.pairTypeInt<char.ptr>)std.make_pair_T_int((Object)NewSlab, (int)PaddedSize));
            int AlignedAddr = llvm.alignAddr(NewSlab, Alignment);
            assert (AlignedAddr + Size <= NewSlab.$index() + PaddedSize);
            char.ptr AlignedPtr = NativePointer.create_char$ptr((byte[])NewSlab.$array(), (int)AlignedAddr);
            return AlignedPtr;
        }
        this.StartNewSlab();
        int AlignedAddr = llvm.alignAddr(this.CurPtr, Alignment);
        assert (AlignedAddr + Size <= this.End.$index()) : "Unable to allocate memory!";
        char.ptr AlignedPtr = NativePointer.create_char$ptr((byte[])this.CurPtr.$array(), (int)AlignedAddr);
        this.CurPtr = Native.$tryClone((char.ptr)((char.ptr)AlignedPtr.$add(Size)));
        return AlignedPtr;
    }

    public int AllocateAndGetIndex(int Size) {
        return this.AllocateAndGetIndex(Size, 8);
    }

    public int AllocateAndGetIndex(int Size, int Alignment) {
        assert (Alignment > 0) : "0-byte alignnment is not allowed. Use 1 instead.";
        this.BytesAllocated += Size;
        int Adjustment = llvm.alignmentAdjustment(this.CurPtr, Alignment);
        assert (Adjustment + Size >= Size) : "Adjustment + Size must not overflow";
        if (Adjustment + Size <= Native.$sub_ptr((char.ptr)this.End, (char.ptr)this.CurPtr)) {
            int AlignedPtr = Native.$ptr_index((char.ptr)this.CurPtr);
            Native.$setIndex((char.ptr)this.CurPtr, (int)(AlignedPtr + Size));
            assert (AlignedPtr < this.MaxSlabSize) : String.valueOf(AlignedPtr) + " is bigger or equal to " + this.MaxSlabSize;
            return AlignedPtr;
        }
        int PaddedSize = Size + Alignment - 1;
        if (PaddedSize > this.SizeThreshold) {
            char.ptr NewSlab = this.Allocator.AllocateSlab(PaddedSize);
            this.CustomSizedSlabs.push_back((std_pair.pairTypeInt<char.ptr>)std.make_pair_T_int((Object)NewSlab, (int)PaddedSize));
            int AlignedAddr = llvm.alignAddr(NewSlab, Alignment);
            assert (AlignedAddr + Size <= NewSlab.$index() + PaddedSize);
            assert (AlignedAddr < this.MaxSlabSize) : String.valueOf(AlignedAddr) + " is bigger or equal to " + this.MaxSlabSize;
            return AlignedAddr;
        }
        this.StartNewSlab();
        int AlignedAddr = llvm.alignAddr(this.CurPtr, Alignment);
        assert (AlignedAddr + Size <= this.End.$index()) : "Unable to allocate memory!";
        Native.$setIndex((char.ptr)this.CurPtr, (int)(AlignedAddr + Size));
        assert (AlignedAddr < this.MaxSlabSize) : String.valueOf(AlignedAddr) + " is bigger or equal to " + this.MaxSlabSize;
        return AlignedAddr;
    }

    public byte[] GetLastAllocationStorage() {
        assert (this.CurPtr != null) : "can be called only once after AllocateAndGetIndex";
        return this.CurPtr.$array();
    }

    public char.ptr Allocate(int Size) {
        return this.Allocate(Size, 8);
    }

    public <T> void.ptr Allocate(Class<T> cls, int Num) {
        return null;
    }

    public char.ptr AllocateSlab(int Size) {
        throw new UnsupportedOperationException("Bump Pointer should not be used for other allocators");
    }

    public void DeallocateSlab(char.ptr $Prm0, int $Prm1) {
        throw new UnsupportedOperationException("Bump Pointer should not be used for other allocators");
    }

    public void Deallocate(Object Ptr) {
    }

    public void Deallocate$NotSameRemoveCV(Object Ptr) {
    }

    public int GetNumSlabs() {
        return this.Slabs.size() + this.CustomSizedSlabs.size();
    }

    @Override
    public long getTotalMemory() {
        int TotalMemory = 0;
        int E = this.Slabs.size();
        for (int I = 0; I < E; ++I) {
            TotalMemory += this.computeSlabSize(I);
        }
        int end = this.CustomSizedSlabs.size();
        for (int index = 0; index < end; ++index) {
            std_pair.pairTypeInt PtrAndSize = (std_pair.pairTypeInt)this.CustomSizedSlabs.$at(index);
            TotalMemory += PtrAndSize.second;
        }
        return TotalMemory;
    }

    public void PrintStats() {
        this.PrintStats("", llvm.errs());
    }

    public long PrintStats(String container, raw_ostream OS) {
        return llvm.support.detail.printBumpPtrAllocatorStats(container, OS, this.Slabs.size(), this.BytesAllocated, this.getTotalMemory(), this.SizeThreshold, this.SlabSize);
    }

    private int computeSlabSize(int SlabIdx) {
        return BumpPtrAllocatorImpl.computeSlabSize(this.SlabSize, this.MaxSlabSize, SlabIdx);
    }

    static int computeSlabSize(int SlabSize, int MaxSlabSize, int SlabIdx) {
        int NextSlabSize = SlabSize * (1 << std.min((int)30, (int)(SlabIdx / 128)));
        if (NextSlabSize <= 0) {
            return MaxSlabSize;
        }
        assert (NextSlabSize >= 0) : NextSlabSize;
        return Math.min(NextSlabSize, MaxSlabSize);
    }

    private void StartNewSlab() {
        int AllocatedSlabSize = this.computeSlabSize(this.Slabs.size());
        char.ptr NewSlab = this.Allocator.AllocateSlab(AllocatedSlabSize);
        this.Slabs.push_back(NewSlab);
        this.CurPtr = Native.$tryClone((char.ptr)NewSlab);
        this.End = (char.ptr)NewSlab.$add(AllocatedSlabSize);
    }

    private void DeallocateSlabs(SmallVectorImpl<char.ptr> Slabs, int fromIndex) {
        char.ptr[] $Array = Slabs.$array();
        int end = Slabs.size();
        for (int index = fromIndex; index < end; ++index) {
            int AllocatedSlabSize = this.computeSlabSize(index);
            char.ptr Ptr = $Array[index];
            if (AllocatedSlabSize != 0) {
                Memory.setRangeWritable((void.ptr)Ptr, AllocatedSlabSize);
                std.memset((char.ptr)Ptr, (byte)-51, (int)AllocatedSlabSize);
            }
            this.Allocator.DeallocateSlab(Ptr, AllocatedSlabSize);
        }
    }

    private void DeallocateCustomSizedSlabs() {
        T[] $Array = this.CustomSizedSlabs.$array();
        int end = this.CustomSizedSlabs.size();
        for (int index = 0; index < end; ++index) {
            std_pair.pairTypeInt PtrAndSize = (std_pair.pairTypeInt)$Array[index];
            char.ptr Ptr = (char.ptr)PtrAndSize.first;
            int Size = PtrAndSize.second;
            Memory.setRangeWritable((void.ptr)Ptr, Size);
            std.memset((char.ptr)Ptr, (byte)-51, (int)Size);
            this.Allocator.DeallocateSlab(Ptr, Size);
        }
    }

    @Override
    public String toString() {
        return "CurPtr=" + this.CurPtr + ", End=" + this.End + ", Slabs=" + this.Slabs + ", CustomSizedSlabs=" + this.CustomSizedSlabs + ", BytesAllocated=" + this.BytesAllocated + ", Allocator=" + this.Allocator + super.toString();
    }
}

