/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.ri.platform.installer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerListModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.validation.adapters.WizardDescriptorAdapter;
import org.netbeans.modules.javacard.common.GuiUtils;
import org.netbeans.modules.javacard.common.KeysAndValues;
import org.netbeans.modules.javacard.common.Utils;
import org.netbeans.modules.javacard.spi.Card;
import org.netbeans.modules.javacard.spi.JavacardPlatform;
import org.netbeans.modules.javacard.spi.capabilities.PortProvider;
import org.netbeans.validation.api.AbstractValidator;
import org.netbeans.validation.api.Problem;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Severity;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.builtin.stringvalidation.StringValidators;
import org.netbeans.validation.api.conversion.Converter;
import org.netbeans.validation.api.ui.ValidationUI;
import org.netbeans.validation.api.ui.swing.SwingValidationGroup;
import org.openide.WizardDescriptor;
import org.openide.awt.HtmlRenderer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class DevicePropertiesPanel
extends JPanel
implements DocumentListener,
FocusListener,
ValidationUI,
Runnable {
    private final ChangeSupport supp = new ChangeSupport((Object)this);
    private boolean updating;
    private SwingValidationGroup group = SwingValidationGroup.create((ValidationUI[])new ValidationUI[]{this});
    private final ComboEditor ceditor = new ComboEditor();
    String displayName = "";
    boolean remoteBoxManuallyChanged = false;
    boolean inUpdate;
    private JTextField cardManagerUrlField;
    private JLabel cardManagerUrlLabel;
    private JLabel cardSettingsLabel;
    private JLabel commInfoLabel;
    private JLabel contactedPortLabel;
    private JTextField contactedPortTextField;
    private JComboBox contactedProtocolComboBox;
    private JLabel contactedProtocolLabel;
    private JLabel contactlessPortLabel;
    private JTextField contactlessPortTextField;
    private JLabel corSizeLabel;
    private JSpinner corSpinner;
    private JLabel debugEmulatorLabel;
    private JLabel debugInfoLabel;
    private JSpinner e2pSpinner;
    private JLabel eepromSizeLabel;
    private JComboBox hostComboBox;
    private JLabel hostLabel;
    private JLabel httpPortLabel;
    private JTextField httpPortTextField;
    private JLabel ideDebugLabel;
    private JComboBox loggerLevelComboBox;
    private JLabel loggerLevelLabel;
    private JTextField proxy2cjcrePortTextField;
    private JTextField proxy2idePortTextField;
    private JLabel ramSizeLabel;
    private JSpinner ramSpinner;
    private JCheckBox remoteCheckbox;
    private JCheckBox secureModeCheckBox;
    private JTextField serverUrlField;
    private JLabel serverUrlLabel;
    private JCheckBox suspendCheckBox;
    private boolean serverUrlModified;

    @Override
    public void run() {
        int i;
        int i2;
        this.initComponents();
        ProtocolRenderer r = new ProtocolRenderer();
        this.contactedProtocolComboBox.setRenderer(r);
        this.loggerLevelComboBox.setRenderer(r);
        GuiUtils.filterNonNumericKeys((JTextComponent)this.httpPortTextField);
        GuiUtils.filterNonNumericKeys((JTextComponent)this.contactlessPortTextField);
        GuiUtils.filterNonNumericKeys((JTextComponent)this.contactedPortTextField);
        GuiUtils.filterNonNumericKeys((JTextComponent)this.proxy2idePortTextField);
        GuiUtils.filterNonNumericKeys((JTextComponent)this.proxy2cjcrePortTextField);
        this.ramSpinner.setValue("1M");
        this.e2pSpinner.setValue("8M");
        this.corSpinner.setValue("4K");
        this.loggerLevelComboBox.setSelectedItem(NbBundle.getBundle(DevicePropertiesPanel.class).getString("info"));
        this.contactedProtocolComboBox.setSelectedItem("T=1");
        Set<Integer> ports = DevicePropertiesPanel.allPortsInUse();
        for (int i3 = 8019; i3 < 65536; i3 += 2) {
            if (ports.contains(i3)) continue;
            this.httpPortTextField.setText(i3 + "");
            break;
        }
        int idePort = 0;
        for (i2 = 7019; i2 < 65536; i2 += 2) {
            String str = "" + i2;
            idePort = (short)(i2 + 1);
            if (ports.contains(i2)) continue;
            this.proxy2cjcrePortTextField.setText(str);
            break;
        }
        for (i2 = idePort; i2 < 65536; i2 += 2) {
            if (ports.contains(i2)) continue;
            this.proxy2idePortTextField.setText(i2 + "");
            break;
        }
        int cl = 8081;
        for (i = 9025; i < 65536; i += 2) {
            if (ports.contains(i)) continue;
            this.contactedPortTextField.setText(i + "");
            break;
        }
        for (i = cl; i < 65536; i += 2) {
            if (ports.contains(i)) continue;
            this.contactlessPortTextField.setText("" + i);
            break;
        }
        this.initHostModel();
        Validator portvalidator = Converter.find(String.class, Document.class).convert(new Validator[]{StringValidators.REQUIRE_NON_EMPTY_STRING.trim(), StringValidators.REQUIRE_VALID_INTEGER.trim(), StringValidators.REQUIRE_NON_NEGATIVE_NUMBER.trim(), StringValidators.trimString((Validator)StringValidators.numberRange((Number)1, (Number)65535)), new PortOverlapValidator()});
        int httpPort = Integer.parseInt(this.httpPortTextField.getText());
        this.serverUrlField.setText("http://localhost:" + httpPort);
        this.cardManagerUrlField.setText("http://localhost:" + httpPort + "/cardmanager");
        this.group.add((Object)this.httpPortTextField, portvalidator);
        this.group.add((Object)this.contactlessPortTextField, portvalidator);
        this.group.add((Object)this.contactedPortTextField, portvalidator);
        this.group.add((Object)this.proxy2cjcrePortTextField, portvalidator);
        this.group.add((Object)this.proxy2idePortTextField, portvalidator);
        final RemoteVsLocalhostMismatchValidator remoteValidator = new RemoteVsLocalhostMismatchValidator();
        this.group.add((JTextComponent)this.cardManagerUrlField, new Validator[]{StringValidators.REQUIRE_NON_EMPTY_STRING, StringValidators.MAY_NOT_START_WITH_DIGIT, StringValidators.URL_MUST_BE_VALID, remoteValidator});
        this.group.add((JTextComponent)this.serverUrlField, new Validator[]{StringValidators.REQUIRE_NON_EMPTY_STRING, StringValidators.MAY_NOT_START_WITH_DIGIT, StringValidators.URL_MUST_BE_VALID, remoteValidator});
        Validator v = Converter.find(String.class, Document.class).convert((Validator)new PortMismatchValidator());
        this.group.add((Object)new AbstractButton[]{this.remoteCheckbox}, (Validator)new AbstractValidator<ButtonModel[]>(ButtonModel[].class){

            public void validate(Problems prblms, String string, ButtonModel[] t) {
                remoteValidator.validate(prblms, string, (t.length > 0 && t[0].isSelected()) + "");
            }
        });
        this.group.add((Object)this.httpPortTextField, v);
        this.group.add((Object)this.serverUrlField, v);
        this.group.add((Object)this.httpPortTextField, v);
        this.group.add(this.hostComboBox, new Validator[]{StringValidators.REQUIRE_NON_EMPTY_STRING, StringValidators.HOST_NAME_OR_IP_ADDRESS, remoteValidator});
        this.hostComboBox.setEditor(this.ceditor);
        this.group.add((JTextComponent)this.ceditor.field, new Validator[]{StringValidators.REQUIRE_NON_EMPTY_STRING, StringValidators.HOST_NAME_OR_IP_ADDRESS});
        for (Component c : this.getComponents()) {
            DevicePropertiesPanel.localizeName(c);
        }
        this.serverUrlModified = false;
        this.httpPortTextField.getDocument().addDocumentListener(this);
        this.cardManagerUrlField.getDocument().addDocumentListener(this);
        this.serverUrlField.getDocument().addDocumentListener(this);
        HelpCtx.setHelpIDString((JComponent)this, (String)"org.netbeans.modules.javacard.CustomizeDevice");
    }

    void initHostModel() {
        DefaultComboBoxModel<String> mdl = new DefaultComboBoxModel<String>();
        String hosts = NbPreferences.forModule(DevicePropertiesPanel.class).get("knownHosts", "localhost,127.0.0.1");
        String[] h = hosts.split(",");
        boolean localhostFound = false;
        boolean oneTwentySevenFound = false;
        for (int i = 0; i < h.length; ++i) {
            localhostFound |= "localhost".compareToIgnoreCase(h[i]) == 0;
            oneTwentySevenFound |= "127.0.0.1".equals(h[i]);
            mdl.addElement(h[i]);
        }
        if (!localhostFound) {
            mdl.addElement("localhost");
        }
        if (!oneTwentySevenFound) {
            mdl.addElement("127.0.0.1");
        }
    }

    private static final void localizeName(Component c) {
        if (c.getName() != null) {
            c.setName(NbBundle.getMessage(DevicePropertiesPanel.class, (String)c.getName()));
        }
    }

    public SwingValidationGroup getValidationGroup() {
        return this.group;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.group.performValidation();
    }

    public DevicePropertiesPanel() {
        this.initializeComponent();
    }

    public DevicePropertiesPanel(Properties props) {
        this.initializeComponent();
        this.read((KeysAndValues<?>)new KeysAndValues.PropertiesAdapter(props));
    }

    private void initializeComponent() {
        this.group.runWithValidationSuspended((Runnable)this);
    }

    public void write(KeysAndValues<?> s) {
        s.put("javacard.device.ramSize", this.getRAMSize());
        s.put("javacard.device.e2pSize", this.getE2PSize());
        s.put("javacard.device.corSize", this.getCORSize());
        String port = this.getHTTPPort();
        s.put("javacard.device.httpPort", port);
        s.put("javacard.device.proxy2cjcrePort", this.getProxy2cjcrePort());
        s.put("javacard.device.proxy2idePort", this.getProxy2idePort());
        s.put("javacard.device.contactedPort", this.getContactedPort());
        s.put("javacard.device.contactedProtocol", this.getContactedProtocol());
        s.put("javacard.device.apdutool.contactedProtocol", "T=0".equals(this.getContactedProtocol()) ? "-t0" : "");
        s.put("javacard.device.contactlessPort", this.getContactlessPort());
        s.put("javacard.device.loggerLevel", this.getLoggerLevel());
        s.put("javacard.device.secureMode", this.getSecureMode());
        s.put("javacard.device.is.remotehost", this.remoteCheckbox.isSelected() + "");
        s.put("javacard.device.suspend", this.suspendCheckBox.isSelected() + "");
        String host = this.hostComboBox.getSelectedItem().toString();
        s.put("javacard.device.host", host);
        NbPreferences.forModule(DevicePropertiesPanel.class).put("knownHosts", this.getKnownHosts());
        String serverUrl = this.getServerUrl();
        String cardManagerUrl = this.getCardManagerUrl();
        try {
            URL url = new URL(serverUrl);
            URL curl = new URL(cardManagerUrl);
            StringBuilder usb = new StringBuilder(url.getProtocol());
            StringBuilder csb = new StringBuilder(curl.getProtocol());
            usb.append("://");
            csb.append("://");
            if (url.getHost().equalsIgnoreCase(host)) {
                usb.append("${");
                usb.append("javacard.device.host");
                usb.append("}");
            } else {
                usb.append(url.getHost());
            }
            if (curl.getHost().equalsIgnoreCase(host)) {
                csb.append("${");
                csb.append("javacard.device.host");
                csb.append("}");
            } else {
                csb.append(curl.getHost());
            }
            if (port.equals("" + url.getPort())) {
                usb.append(":${");
                usb.append("javacard.device.httpPort");
                usb.append('}');
            } else {
                usb.append(':');
                usb.append(url.getPort());
            }
            if (port.equals("" + curl.getPort())) {
                csb.append(":${");
                csb.append("javacard.device.httpPort");
                csb.append('}');
            } else {
                csb.append(':');
                csb.append(curl.getPort());
            }
            if (url.getPath() != null) {
                usb.append(url.getPath());
            }
            if (curl.getPath() != null) {
                csb.append(curl.getPath());
            }
            if (!usb.toString().endsWith("/")) {
                usb.append("/");
            }
            if (!csb.toString().endsWith("/")) {
                csb.append("/");
            }
            serverUrl = usb.toString();
            cardManagerUrl = csb.toString();
        }
        catch (MalformedURLException ex) {
            s.put("javacard.device.serverurl", this.getServerUrl());
            s.put("javacard.device.cardmanagerurl", this.getCardManagerUrl());
            return;
        }
        s.put("javacard.device.serverurl", serverUrl);
        s.put("javacard.device.cardmanagerurl", cardManagerUrl);
    }

    private String getKnownHosts() {
        ComboBoxModel mdl = this.hostComboBox.getModel();
        StringBuilder sb = new StringBuilder();
        HashSet<String> s = new HashSet<String>();
        for (int i = 0; i < mdl.getSize(); ++i) {
            String host = (String)mdl.getElementAt(mdl.getSize() - (i + 1));
            if ("localhost".compareToIgnoreCase(host) == 0 || "127.0.0.1".equals(host)) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(host);
            s.add(host);
        }
        if (!s.contains(mdl.getSelectedItem().toString())) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(mdl.getSelectedItem().toString().trim());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(KeysAndValues<?> s) {
        this.updating = true;
        this.displayName = s.get("javacard.device.name");
        try {
            String val = s.get("javacard.device.ramSize");
            if (val != null) {
                this.ramSpinner.setValue(val);
            }
            if ((val = s.get("javacard.device.e2pSize")) != null) {
                this.e2pSpinner.setValue(val);
            }
            if ((val = s.get("javacard.device.corSize")) != null) {
                this.corSpinner.setValue(val);
            }
            if ((val = s.get("javacard.device.host")) != null) {
                this.hostComboBox.setSelectedItem(val);
                DefaultComboBoxModel mdl = (DefaultComboBoxModel)this.hostComboBox.getModel();
                if (mdl.getIndexOf(val) < 0) {
                    mdl.addElement(val);
                }
            }
            if ((val = s.get("javacard.device.httpPort")) != null) {
                this.httpPortTextField.setText(val);
            }
            if ((val = s.get("javacard.device.proxy2cjcrePort")) != null) {
                this.proxy2cjcrePortTextField.setText(val);
            }
            if ((val = s.get("javacard.device.proxy2idePort")) != null) {
                this.proxy2idePortTextField.setText(val);
            }
            if ((val = s.get("javacard.device.contactedPort")) != null) {
                this.contactedPortTextField.setText(val);
            }
            if ((val = s.get("javacard.device.contactedProtocol")) != null) {
                this.contactedProtocolComboBox.setSelectedItem(val);
            }
            if ((val = s.get("javacard.device.contactlessPort")) != null) {
                this.contactlessPortTextField.setText(s.get("javacard.device.contactlessPort"));
            }
            if ((val = s.get("javacard.device.loggerLevel")) != null) {
                this.loggerLevelComboBox.setSelectedItem(val);
            }
            if ((val = s.get("javacard.device.secureMode")) != null) {
                this.secureModeCheckBox.setSelected(Boolean.valueOf(val));
            }
            if ((val = s.get("javacard.device.serverurl")) != null) {
                this.serverUrlField.setText(val);
            }
            if ((val = s.get("javacard.device.cardmanagerurl")) != null) {
                this.cardManagerUrlField.setText(val);
            }
            if ((val = s.get("javacard.device.suspend")) == null) {
                val = "false";
            }
            this.suspendCheckBox.setSelected(Boolean.valueOf(val));
            val = s.get("javacard.device.is.remotehost");
            if (val != null) {
                this.remoteCheckbox.setSelected(Boolean.valueOf(val));
            }
        }
        finally {
            this.updating = false;
            this.serverUrlModified = false;
        }
    }

    public String getRAMSize() {
        return this.ramSpinner.getValue().toString();
    }

    public String getE2PSize() {
        return this.e2pSpinner.getValue().toString();
    }

    public String getCORSize() {
        return this.corSpinner.getValue().toString();
    }

    public String getHTTPPort() {
        return this.httpPortTextField.getText().trim();
    }

    public String getProxy2cjcrePort() {
        return this.proxy2cjcrePortTextField.getText().trim();
    }

    public String getProxy2idePort() {
        return this.proxy2idePortTextField.getText().trim();
    }

    public String getContactedPort() {
        return this.contactedPortTextField.getText().trim();
    }

    public String getContactedProtocol() {
        return this.contactedProtocolComboBox.getSelectedItem().toString();
    }

    public String getContactlessPort() {
        return this.contactlessPortTextField.getText().trim();
    }

    public String getLoggerLevel() {
        return this.loggerLevelComboBox.getSelectedItem().toString();
    }

    public String getSecureMode() {
        return "" + this.secureModeCheckBox.isSelected();
    }

    public String getServerUrl() {
        return this.serverUrlField.getText();
    }

    public String getCardManagerUrl() {
        return this.cardManagerUrlField.getText();
    }

    public boolean isAllDataValid() {
        try {
            Problem p = this.group.performValidation();
            return p == null || !p.isFatal();
        }
        catch (StackOverflowError err) {
            Logger.getLogger(DevicePropertiesPanel.class.getName()).log(Level.SEVERE, null, err);
            return true;
        }
    }

    void setWizardDescriptor(WizardDescriptor wizardDescriptor) {
        this.group.addUI((ValidationUI)new WizardDescriptorAdapter(wizardDescriptor));
        this.fireChange();
    }

    private void initComponents() {
        this.secureModeCheckBox = new JCheckBox();
        this.loggerLevelComboBox = new JComboBox();
        this.corSpinner = new JSpinner();
        this.e2pSpinner = new JSpinner();
        this.ramSpinner = new JSpinner();
        this.ramSizeLabel = new JLabel();
        this.eepromSizeLabel = new JLabel();
        this.corSizeLabel = new JLabel();
        this.loggerLevelLabel = new JLabel();
        this.httpPortTextField = new JTextField();
        this.httpPortLabel = new JLabel();
        this.debugEmulatorLabel = new JLabel();
        this.proxy2cjcrePortTextField = new JTextField();
        this.suspendCheckBox = new JCheckBox();
        this.contactedPortTextField = new JTextField();
        this.contactlessPortTextField = new JTextField();
        this.debugInfoLabel = new JLabel();
        this.ideDebugLabel = new JLabel();
        this.proxy2idePortTextField = new JTextField();
        this.commInfoLabel = new JLabel();
        this.serverUrlLabel = new JLabel();
        this.serverUrlField = new JTextField();
        this.cardManagerUrlLabel = new JLabel();
        this.cardManagerUrlField = new JTextField();
        this.contactedProtocolLabel = new JLabel();
        this.contactedProtocolComboBox = new JComboBox();
        this.contactedPortLabel = new JLabel();
        this.contactlessPortLabel = new JLabel();
        this.remoteCheckbox = new JCheckBox();
        this.hostLabel = new JLabel();
        this.hostComboBox = new JComboBox();
        this.cardSettingsLabel = new JLabel();
        this.secureModeCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.secureModeCheckBox, (String)NbBundle.getBundle(DevicePropertiesPanel.class).getString("Run_In_Secure_Mode"));
        this.secureModeCheckBox.setToolTipText(NbBundle.getBundle(DevicePropertiesPanel.class).getString("tip_bypass_security"));
        this.secureModeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DevicePropertiesPanel.this.secureModeCheckBoxActionPerformed(evt);
            }
        });
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 12));
        this.setLayout(new GridBagLayout());
        this.loggerLevelComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"none", "fatal", "error", "warn", "info", "verbose", "debug", "all"}));
        this.loggerLevelComboBox.setToolTipText(NbBundle.getBundle(DevicePropertiesPanel.class).getString("debuglevel_1"));
        this.loggerLevelComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DevicePropertiesPanel.this.loggerLevelComboBoxActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 40;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(8, 3, 0, 0);
        this.add((Component)this.loggerLevelComboBox, gridBagConstraints);
        this.corSpinner.setModel(new SpinnerListModel(new String[]{"512", "1K", "2K", "4K"}));
        this.corSpinner.setToolTipText(NbBundle.getBundle(DevicePropertiesPanel.class).getString("tip_sizeofclear"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 110;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(8, 3, 0, 0);
        this.add((Component)this.corSpinner, gridBagConstraints);
        this.e2pSpinner.setModel(new SpinnerListModel(new String[]{"128K", "512K", "1M", "2M", "4M", "8M", "16M", "32M"}));
        this.e2pSpinner.setToolTipText(NbBundle.getBundle(DevicePropertiesPanel.class).getString("tip_persistent_memory_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 102;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(8, 3, 0, 0);
        this.add((Component)this.e2pSpinner, gridBagConstraints);
        this.ramSpinner.setModel(new SpinnerListModel(new String[]{"24K", "32K", "48K", "64K", "96K", "128K", "512K", "1M", "2M", "4M", "8M", "16M", "32M"}));
        this.ramSpinner.setToolTipText(NbBundle.getBundle(DevicePropertiesPanel.class).getString("tip_ramsize_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 110;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(20, 3, 0, 0);
        this.add((Component)this.ramSpinner, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.ramSizeLabel, (String)"RAM Size:");
        this.ramSizeLabel.setToolTipText("RAM size for this Instance.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(20, 20, 0, 0);
        this.add((Component)this.ramSizeLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.eepromSizeLabel, (String)"EEPROM Size:");
        this.eepromSizeLabel.setToolTipText(NbBundle.getBundle(DevicePropertiesPanel.class).getString("tip_persistent_memory_size"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 20, 0, 0);
        this.add((Component)this.eepromSizeLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.corSizeLabel, (String)"COR Size:");
        this.corSizeLabel.setToolTipText(NbBundle.getBundle(DevicePropertiesPanel.class).getString("tip_clear_on_reset"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 20, 0, 0);
        this.add((Component)this.corSizeLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.loggerLevelLabel, (String)"Logger Level:");
        this.loggerLevelLabel.setToolTipText(NbBundle.getBundle(DevicePropertiesPanel.class).getString("tip_debug_level"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 20, 0, 0);
        this.add((Component)this.loggerLevelLabel, gridBagConstraints);
        this.httpPortTextField.setText("8019");
        this.httpPortTextField.setToolTipText(NbBundle.getBundle(DevicePropertiesPanel.class).getString("tip_http_port_1"));
        this.httpPortTextField.setName("HTTP Port");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(20, 10, 0, 20);
        this.add((Component)this.httpPortTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.httpPortLabel, (String)"HTTP Port:");
        this.httpPortLabel.setToolTipText(NbBundle.getBundle(DevicePropertiesPanel.class).getString("tip_http_port_2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(20, 12, 0, 0);
        this.add((Component)this.httpPortLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.debugEmulatorLabel, (String)"Debug Proxy <-> Emulator Port: ");
        this.debugEmulatorLabel.setToolTipText(NbBundle.getBundle(DevicePropertiesPanel.class).getString("tip_debug_port"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(16, 20, 0, 0);
        this.add((Component)this.debugEmulatorLabel, gridBagConstraints);
        this.proxy2cjcrePortTextField.setText("7019");
        this.proxy2cjcrePortTextField.setToolTipText(NbBundle.getBundle(DevicePropertiesPanel.class).getString("tip_ide_port_1"));
        this.proxy2cjcrePortTextField.setName("Debug CJCRE Port");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(16, 10, 0, 0);
        this.add((Component)this.proxy2cjcrePortTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.suspendCheckBox, (String)"Suspend Threads on startup");
        this.suspendCheckBox.setToolTipText("<html>Check this checkbox if you want to start<br>stepping through code in the debugger<br>as soon as the card is started");
        this.suspendCheckBox.setHorizontalTextPosition(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 20, 0, 0);
        this.add((Component)this.suspendCheckBox, gridBagConstraints);
        this.contactedPortTextField.setText("9025");
        this.contactedPortTextField.setToolTipText(NbBundle.getBundle(DevicePropertiesPanel.class).getString("tip_apdu_port"));
        this.contactedPortTextField.setName("Contacted Port");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(8, 10, 0, 20);
        this.add((Component)this.contactedPortTextField, gridBagConstraints);
        this.contactlessPortTextField.setText("9026");
        this.contactlessPortTextField.setToolTipText(NbBundle.getBundle(DevicePropertiesPanel.class).getString("tip_APDU_Contactless_port"));
        this.contactlessPortTextField.setName("Contactless Port");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(8, 10, 0, 20);
        this.add((Component)this.contactlessPortTextField, gridBagConstraints);
        this.debugInfoLabel.setFont(this.debugInfoLabel.getFont().deriveFont(this.debugInfoLabel.getFont().getStyle() | 1));
        Mnemonics.setLocalizedText((JLabel)this.debugInfoLabel, (String)"Debugger Info");
        this.debugInfoLabel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getDefaults().getColor("controlShadow")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(20, 20, 0, 20);
        this.add((Component)this.debugInfoLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.ideDebugLabel, (String)"IDE <-> Debug Proxy Port: ");
        this.ideDebugLabel.setToolTipText(NbBundle.getBundle(DevicePropertiesPanel.class).getString("tip_ide_debug_proxy_port"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 20, 0, 0);
        this.add((Component)this.ideDebugLabel, gridBagConstraints);
        this.proxy2idePortTextField.setText("7020");
        this.proxy2idePortTextField.setToolTipText(NbBundle.getBundle(DevicePropertiesPanel.class).getString("tip_ide_debug_port_1"));
        this.proxy2idePortTextField.setName("IDE Debug Port");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(8, 10, 0, 0);
        this.add((Component)this.proxy2idePortTextField, gridBagConstraints);
        this.commInfoLabel.setFont(this.commInfoLabel.getFont().deriveFont(this.commInfoLabel.getFont().getStyle() | 1));
        Mnemonics.setLocalizedText((JLabel)this.commInfoLabel, (String)"Communication Info");
        this.commInfoLabel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getDefaults().getColor("controlShadow")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(20, 20, 0, 20);
        this.add((Component)this.commInfoLabel, gridBagConstraints);
        this.serverUrlLabel.setLabelFor(this.serverUrlField);
        Mnemonics.setLocalizedText((JLabel)this.serverUrlLabel, (String)"Server URL");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 21;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(14, 20, 0, 0);
        this.add((Component)this.serverUrlLabel, gridBagConstraints);
        this.serverUrlField.setText("http://localhost:8019");
        this.serverUrlField.setToolTipText("The general URL for interacting with this card");
        this.serverUrlField.setName("Server URL");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 21;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(8, 10, 0, 20);
        this.add((Component)this.serverUrlField, gridBagConstraints);
        this.cardManagerUrlLabel.setLabelFor(this.cardManagerUrlField);
        Mnemonics.setLocalizedText((JLabel)this.cardManagerUrlLabel, (String)"Card Manager URL");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 23;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(14, 20, 0, 0);
        this.add((Component)this.cardManagerUrlLabel, gridBagConstraints);
        this.cardManagerUrlField.setText("http://localhost:8019/cardmanager");
        this.cardManagerUrlField.setToolTipText("The URL used for deploying projects to this card");
        this.cardManagerUrlField.setName("Card Manager URL");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 23;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(8, 10, 0, 20);
        this.add((Component)this.cardManagerUrlField, gridBagConstraints);
        this.contactedProtocolLabel.setLabelFor(this.contactedProtocolComboBox);
        Mnemonics.setLocalizedText((JLabel)this.contactedProtocolLabel, (String)"Contacted Protocol:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(13, 12, 0, 0);
        this.add((Component)this.contactedProtocolLabel, gridBagConstraints);
        this.contactedProtocolComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"T=0", "T=1"}));
        this.contactedProtocolComboBox.setToolTipText("Select the protocol to use on contacted port.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(8, 10, 0, 20);
        this.add((Component)this.contactedProtocolComboBox, gridBagConstraints);
        this.contactedPortLabel.setLabelFor(this.contactedPortTextField);
        Mnemonics.setLocalizedText((JLabel)this.contactedPortLabel, (String)"Contacted Port:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 12, 0, 0);
        this.add((Component)this.contactedPortLabel, gridBagConstraints);
        this.contactlessPortLabel.setLabelFor(this.contactlessPortTextField);
        Mnemonics.setLocalizedText((JLabel)this.contactlessPortLabel, (String)"Contactless Port:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.add((Component)this.contactlessPortLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.remoteCheckbox, (String)"Card Manager is on a remote computer");
        this.remoteCheckbox.setToolTipText("<html>If true, this card is not running on the same computer<br>as the IDE is");
        this.remoteCheckbox.setHorizontalTextPosition(10);
        this.remoteCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DevicePropertiesPanel.this.onRemoteCheckboxChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 25;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(8, 0, 20, 20);
        this.add((Component)this.remoteCheckbox, gridBagConstraints);
        this.hostLabel.setLabelFor(this.hostComboBox);
        Mnemonics.setLocalizedText((JLabel)this.hostLabel, (String)"Host");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(20, 20, 0, 0);
        this.add((Component)this.hostLabel, gridBagConstraints);
        this.hostComboBox.setEditable(true);
        this.hostComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"localhost", "127.0.0.1"}));
        this.hostComboBox.setToolTipText("<html>The computer the IDE should communicate with<br>to talk to this Card");
        this.hostComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DevicePropertiesPanel.this.hostComboChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(20, 10, 0, 20);
        this.add((Component)this.hostComboBox, gridBagConstraints);
        this.cardSettingsLabel.setFont(this.cardSettingsLabel.getFont().deriveFont(this.cardSettingsLabel.getFont().getStyle() | 1));
        Mnemonics.setLocalizedText((JLabel)this.cardSettingsLabel, (String)"Card Settings");
        this.cardSettingsLabel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getDefaults().getColor("controlShadow")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(20, 20, 0, 20);
        this.add((Component)this.cardSettingsLabel, gridBagConstraints);
    }

    private void secureModeCheckBoxActionPerformed(ActionEvent evt) {
        this.fireChange();
    }

    private void loggerLevelComboBoxActionPerformed(ActionEvent evt) {
        this.fireChange();
    }

    private void onRemoteCheckboxChanged(ActionEvent evt) {
        if (this.inUpdate) {
            return;
        }
        this.remoteBoxManuallyChanged = true;
        this.group.performValidation();
    }

    private void hostComboChanged(ItemEvent evt) {
        this.insertUpdate(null);
    }

    public void setCorSize(String value) {
        this.corSpinner.setValue(value);
    }

    public boolean isSuspendThreads() {
        return this.suspendCheckBox.isSelected();
    }

    private boolean affectsServerURL(Object o) {
        Document hostEditorDocument = this.hostComboBox.getEditor().getEditorComponent() instanceof JTextField ? ((JTextField)this.hostComboBox.getEditor().getEditorComponent()).getDocument() : null;
        return o == null || o == this.httpPortTextField.getDocument() || o == this.hostComboBox || o != null && o == hostEditorDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertUpdate(DocumentEvent e) {
        this.serverUrlModified |= e != null && (e.getDocument() == this.serverUrlField.getDocument() || e.getDocument() == this.cardManagerUrlField.getDocument());
        if (!this.serverUrlModified && this.affectsServerURL(e == null ? null : e.getDocument())) {
            Document hostEditorDocument = this.hostComboBox.getEditor().getEditorComponent() instanceof JTextField ? ((JTextField)this.hostComboBox.getEditor().getEditorComponent()).getDocument() : null;
            this.inUpdate = true;
            try {
                int port = Integer.parseInt(this.httpPortTextField.getText());
                String host = this.hostComboBox.getSelectedItem().toString().trim();
                URL sUrl = new URL(this.serverUrlField.getText());
                URL cUrl = new URL(this.cardManagerUrlField.getText());
                final URL newSurl = new URL(sUrl.getProtocol(), host, port, sUrl.getFile());
                final URL newCurl = new URL(cUrl.getProtocol(), host, port, cUrl.getFile());
                final boolean local = "localhost".compareToIgnoreCase(host) == 0 || "127.0.0.1".equals(host);
                this.group.runWithValidationSuspended(new Runnable(){

                    @Override
                    public void run() {
                        DevicePropertiesPanel.this.serverUrlField.setText(newSurl.toString());
                        DevicePropertiesPanel.this.cardManagerUrlField.setText(newCurl.toString());
                        DevicePropertiesPanel.this.serverUrlModified = false;
                        if (!DevicePropertiesPanel.this.remoteBoxManuallyChanged) {
                            DevicePropertiesPanel.this.remoteCheckbox.setSelected(!local);
                        }
                    }
                });
                this.group.performValidation();
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (MalformedURLException malformedURLException) {
            }
            finally {
                this.inUpdate = false;
            }
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.insertUpdate(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.insertUpdate(e);
    }

    @Override
    public void focusGained(FocusEvent e) {
        ((JTextComponent)e.getComponent()).selectAll();
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public void clearProblem() {
        this.fireChange();
    }

    public void showProblem(Problem p) {
        this.fireChange();
    }

    public void removeChangeListener(ChangeListener arg0) {
        this.supp.removeChangeListener(arg0);
    }

    public void fireChange() {
        if (!this.updating) {
            this.updating = true;
            try {
                this.supp.fireChange();
            }
            finally {
                this.updating = false;
            }
        }
    }

    public void addChangeListener(ChangeListener arg0) {
        this.supp.addChangeListener(arg0);
    }

    private static final Set<Integer> allPortsInUse() {
        HashSet<Integer> result = new HashSet<Integer>();
        for (FileObject platformFile : Utils.sfsFolderForRegisteredJavaPlatforms().getChildren()) {
            try {
                JavacardPlatform pform;
                if (!platformFile.getNameExt().endsWith("jcplatform") && DataObject.find((FileObject)platformFile).getNodeDelegate().getLookup().lookup(JavacardPlatform.class) == null || (pform = (JavacardPlatform)DataObject.find((FileObject)platformFile).getNodeDelegate().getLookup().lookup(JavacardPlatform.class)) == null) continue;
                for (Card card : pform.getCards().getCards(false)) {
                    PortProvider ports = (PortProvider)card.getCapability(PortProvider.class);
                    if (ports == null) continue;
                    result.addAll(ports.getClaimedPorts());
                }
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return result;
    }

    private static final class ProtocolRenderer
    implements ListCellRenderer {
        HtmlRenderer.Renderer ren = HtmlRenderer.createRenderer();

        private ProtocolRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.ren.setHtml(true);
            value = NbBundle.getMessage(ProtocolRenderer.class, (String)value.toString(), (Object)value);
            return this.ren.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }

    private class PortOverlapValidator
    extends AbstractValidator<String> {
        PortOverlapValidator() {
            super(String.class);
        }

        public void validate(Problems problems, String arg1, String model) {
            HashSet<Integer> others = new HashSet<Integer>();
            JTextField[] relevant = new JTextField[]{DevicePropertiesPanel.this.httpPortTextField, DevicePropertiesPanel.this.proxy2cjcrePortTextField, DevicePropertiesPanel.this.proxy2idePortTextField, DevicePropertiesPanel.this.contactedPortTextField, DevicePropertiesPanel.this.contactlessPortTextField};
            for (int i = 0; i < relevant.length; ++i) {
                String s = relevant[i].getText().trim();
                if (arg1.equals(relevant[i].getName())) continue;
                try {
                    others.add(Integer.parseInt(s));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            String test = model.trim();
            try {
                boolean result;
                Integer i = Integer.parseInt(test);
                boolean bl = result = !others.contains(i);
                if (!result) {
                    problems.add(NbBundle.getMessage(DevicePropertiesPanel.class, (String)"ERR_PORT_USED_TWICE", (Object)i));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private class RemoteVsLocalhostMismatchValidator
    extends AbstractValidator<String> {
        RemoteVsLocalhostMismatchValidator() {
            super(String.class);
        }

        public void validate(Problems pblms, String compName, String value) {
            boolean mismatch;
            boolean setToLocal = !DevicePropertiesPanel.this.remoteCheckbox.isSelected();
            boolean bl = mismatch = (this.containsLocalhostReference(DevicePropertiesPanel.this.cardManagerUrlField.getText()) || this.containsLocalhostReference(DevicePropertiesPanel.this.serverUrlField.getText())) && !setToLocal;
            if (mismatch) {
                pblms.add(NbBundle.getMessage(RemoteVsLocalhostMismatchValidator.class, (String)"WARN_REMOTE_LOCAL_MISMATCH"), Severity.WARNING);
            }
        }

        private boolean containsLocalhostReference(String val) {
            return val.indexOf("127.0.0.1") >= 0 || val.indexOf("localhost") >= 0;
        }
    }

    private class PortMismatchValidator
    extends AbstractValidator<String> {
        PortMismatchValidator() {
            super(String.class);
        }

        public void validate(Problems p, String compName, String model) {
            int serverUrlPort;
            int cmPort;
            int portVal;
            String httpPortString = DevicePropertiesPanel.this.httpPortTextField.getText();
            try {
                portVal = Integer.parseInt(httpPortString.trim());
            }
            catch (NumberFormatException e) {
                return;
            }
            try {
                URL cmUrl = new URL(DevicePropertiesPanel.this.cardManagerUrlField.getText());
                URL servUrl = new URL(DevicePropertiesPanel.this.serverUrlField.getText());
                cmPort = cmUrl.getPort();
                serverUrlPort = servUrl.getPort();
            }
            catch (MalformedURLException e) {
                return;
            }
            if (cmPort != portVal || serverUrlPort != portVal) {
                p.add(new Problem(NbBundle.getMessage(DevicePropertiesPanel.class, (String)"MSG_SERVER_PORT_PROBLEM", (Object)compName, (Object)model), Severity.WARNING));
            }
        }
    }

    private class ComboEditor
    implements ComboBoxEditor,
    DocumentListener {
        private final JTextField field = new JTextField();
        private boolean inSetItem;

        ComboEditor() {
            this.field.getDocument().addDocumentListener(this);
        }

        @Override
        public Component getEditorComponent() {
            return this.field;
        }

        @Override
        public void setItem(final Object value) {
            if (this.inSetItem) {
                return;
            }
            this.inSetItem = true;
            try {
                DevicePropertiesPanel.this.group.runWithValidationSuspended(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ComboEditor.this.field.setText(value == null ? "" : value.toString());
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                    }
                });
            }
            finally {
                this.inSetItem = false;
            }
        }

        @Override
        public Object getItem() {
            return this.field.getText();
        }

        @Override
        public void selectAll() {
            this.field.selectAll();
        }

        @Override
        public void addActionListener(ActionListener l) {
        }

        @Override
        public void removeActionListener(ActionListener l) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            DevicePropertiesPanel.this.hostComboBox.setSelectedItem(this.field.getText());
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.insertUpdate(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.insertUpdate(e);
        }
    }
}

