/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.filecreation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.cnd.editor.filecreation.BrowseFolders;
import org.netbeans.modules.cnd.editor.filecreation.CndPanelGUI;
import org.netbeans.modules.cnd.editor.filecreation.NewQtFormPanel;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

class NewQtFormPanelGUI
extends CndPanelGUI
implements ActionListener {
    private static final String FORM_EXT = "ui";
    private String sourceExt;
    private String headerExt;
    private final NewQtFormPanel.FormType[] formTypes;
    private JPanel bottomPanelContainer;
    private JButton browseButton;
    private JCheckBox cbCreateClass;
    private JComboBox cbFormType;
    private JComboBox cbLocation;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JLabel lbClassFile;
    private JLabel lbFolder;
    private JLabel lbFormFile;
    private JLabel lbFormName;
    private JLabel lbHeaderFile;
    private JLabel lbLocation;
    private JLabel lbProject;
    private JSeparator targetSeparator;
    private JTextField tfClassFile;
    private JTextField tfFolder;
    private JTextField tfFormFile;
    private JTextField tfFormName;
    private JTextField tfHeaderFile;
    private JTextField tfProject;

    NewQtFormPanelGUI(Project project, SourceGroup[] folders, Component bottomPanel, NewQtFormPanel.FormType[] formTypes) {
        super(project, folders);
        this.formTypes = formTypes;
        this.initComponents();
        if (bottomPanel != null) {
            this.bottomPanelContainer.add(bottomPanel, "Center");
        }
        this.initValues(null, null, null);
        this.tfFormName.getDocument().addDocumentListener(this);
        this.tfFolder.getDocument().addDocumentListener(this);
        this.cbCreateClass.addActionListener(this);
        this.cbLocation.addActionListener(this);
        this.browseButton.addActionListener(this);
    }

    @Override
    public void initValues(FileObject template, FileObject preselectedFolder, String formName) {
        this.tfProject.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        Sources sources = ProjectUtils.getSources((Project)this.project);
        this.folders = sources.getSourceGroups("generic");
        if (this.folders.length < 2) {
            this.lbLocation.setVisible(false);
            this.cbLocation.setVisible(false);
        } else {
            this.lbLocation.setVisible(true);
            this.cbLocation.setVisible(true);
        }
        this.cbLocation.setModel(new DefaultComboBoxModel<SourceGroup>(this.folders));
        SourceGroup preselectedGroup = NewQtFormPanelGUI.getPreselectedGroup(this.folders, preselectedFolder);
        this.cbLocation.setSelectedItem(preselectedGroup);
        this.tfFolder.setText(this.getRelativeNativeName(preselectedGroup.getRootFolder(), preselectedFolder));
        String displayName = null;
        try {
            if (template != null) {
                DataObject templateDo = DataObject.find((FileObject)template);
                displayName = templateDo.getNodeDelegate().getDisplayName();
            }
        }
        catch (DataObjectNotFoundException ex) {
            displayName = template.getName();
        }
        this.putClientProperty("NewFileWizard_Title", displayName);
        this.sourceExt = MIMEExtensions.get((String)"text/x-c++").getDefaultExtension();
        this.headerExt = MIMEExtensions.get((String)"text/x-h").getDefaultExtension();
        if (template != null) {
            if (formName == null) {
                FileObject currentFolder;
                formName = NewQtFormPanelGUI.getMessage("NewFormSuggestedName");
                FileObject fileObject = currentFolder = preselectedFolder != null ? preselectedFolder : this.getTargetGroup().getRootFolder();
                if (currentFolder != null) {
                    formName = formName + NewQtFormPanelGUI.generateUniqueSuffix(currentFolder, NewQtFormPanelGUI.getFileName(formName), FORM_EXT, this.sourceExt, this.headerExt);
                }
            }
            this.tfFormName.setText(formName);
            this.tfFormName.selectAll();
        }
    }

    @Override
    public SourceGroup getTargetGroup() {
        Object selectedItem = this.cbLocation.getSelectedItem();
        if (selectedItem == null && (selectedItem = this.cbLocation.getItemAt(this.cbLocation.getSelectedIndex())) == null) {
            selectedItem = this.cbLocation.getItemAt(0);
        }
        return (SourceGroup)selectedItem;
    }

    @Override
    public String getTargetFolder() {
        String folderName = this.tfFolder.getText().trim();
        return folderName.replace(this.fileSeparatorChar, '/');
    }

    @Override
    public String getTargetName() {
        String formName = NewQtFormPanelGUI.getFileName(this.getFormName());
        if (formName.length() == 0 || formName.charAt(formName.length() - 1) == '.') {
            return null;
        }
        return formName;
    }

    @Override
    protected void updateCreatedFile() {
        FileObject root = this.getTargetGroup().getRootFolder();
        String folderName = this.tfFolder.getText().trim();
        String folderDisplayName = root.getPath() + (folderName.startsWith("/") || folderName.startsWith(this.fileSeparator) ? "" : "/") + folderName + (folderName.endsWith("/") || folderName.endsWith(this.fileSeparator) || folderName.length() == 0 ? "" : "/");
        folderDisplayName = folderDisplayName.replace('/', this.fileSeparatorChar);
        String formFileName = folderDisplayName + this.getFormFileName();
        this.tfFormFile.setText(formFileName);
        if (this.cbCreateClass.isSelected()) {
            String sourceFileName = folderDisplayName + this.getSourceFileName();
            this.tfClassFile.setText(sourceFileName);
            String headerFileName = folderDisplayName + this.getHeaderFileName();
            this.tfHeaderFile.setText(headerFileName);
        } else {
            this.tfClassFile.setText("");
            this.tfHeaderFile.setText("");
        }
        this.tfClassFile.setEnabled(this.cbCreateClass.isSelected());
        this.tfHeaderFile.setEnabled(this.cbCreateClass.isSelected());
        this.changeSupport.fireChange();
    }

    public String getFormFileName() {
        return NewQtFormPanelGUI.getFileName(this.getFormName()) + "." + FORM_EXT;
    }

    public String getSourceFileName() {
        return this.cbCreateClass.isSelected() ? NewQtFormPanelGUI.getFileName(this.getFormName()) + "." + this.sourceExt : null;
    }

    public String getHeaderFileName() {
        return this.cbCreateClass.isSelected() ? NewQtFormPanelGUI.getFileName(this.getFormName()) + "." + this.headerExt : null;
    }

    public NewQtFormPanel.FormType getFormType() {
        return (NewQtFormPanel.FormType)this.cbFormType.getSelectedItem();
    }

    private static String getFileName(String className) {
        return className;
    }

    public String getFormName() {
        return this.tfFormName.getText().trim();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.lbFormName = new JLabel();
        this.tfFormName = new JTextField();
        this.jLabel1 = new JLabel();
        this.cbFormType = new JComboBox();
        this.cbCreateClass = new JCheckBox();
        this.lbProject = new JLabel();
        this.tfProject = new JTextField();
        this.lbLocation = new JLabel();
        this.cbLocation = new JComboBox();
        this.lbFolder = new JLabel();
        this.tfFolder = new JTextField();
        this.browseButton = new JButton();
        this.lbFormFile = new JLabel();
        this.tfFormFile = new JTextField();
        this.lbClassFile = new JLabel();
        this.tfClassFile = new JTextField();
        this.lbHeaderFile = new JLabel();
        this.tfHeaderFile = new JTextField();
        this.targetSeparator = new JSeparator();
        this.bottomPanelContainer = new JPanel();
        this.setName(NbBundle.getMessage(NewQtFormPanelGUI.class, (String)"LBL_SimpleTargetChooserPanel_Name"));
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.lbFormName.setLabelFor(this.tfFormName);
        Mnemonics.setLocalizedText((JLabel)this.lbFormName, (String)NbBundle.getMessage(NewQtFormPanelGUI.class, (String)"LBL_TargetChooser_FormName_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.lbFormName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.tfFormName, gridBagConstraints);
        this.tfFormName.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewQtFormPanelGUI.class).getString("AD_documentNameTextField"));
        this.jLabel1.setLabelFor(this.cbFormType);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(NewQtFormPanelGUI.class, (String)"LBL_TargetChooser_FormType_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.cbFormType.setModel(new DefaultComboBoxModel<NewQtFormPanel.FormType>(this.formTypes));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.cbFormType, gridBagConstraints);
        this.cbCreateClass.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cbCreateClass, (String)NbBundle.getMessage(NewQtFormPanelGUI.class, (String)"LBL_TargetChooser_CreateWrapperClass"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.cbCreateClass, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 24, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.lbProject.setLabelFor(this.tfProject);
        Mnemonics.setLocalizedText((JLabel)this.lbProject, (String)NbBundle.getMessage(NewQtFormPanelGUI.class, (String)"LBL_TargetChooser_Project_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.lbProject, gridBagConstraints);
        this.tfProject.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.tfProject, gridBagConstraints);
        this.tfProject.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewQtFormPanelGUI.class).getString("AD_projectTextField"));
        this.lbLocation.setLabelFor(this.cbLocation);
        Mnemonics.setLocalizedText((JLabel)this.lbLocation, (String)NbBundle.getMessage(NewQtFormPanelGUI.class, (String)"LBL_TargetChooser_Location_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.lbLocation, gridBagConstraints);
        this.cbLocation.setRenderer(this.CELL_RENDERER);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 4, 0);
        this.add((Component)this.cbLocation, gridBagConstraints);
        this.cbLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewQtFormPanelGUI.class).getString("AD_locationComboBox"));
        this.lbFolder.setLabelFor(this.tfFolder);
        Mnemonics.setLocalizedText((JLabel)this.lbFolder, (String)NbBundle.getMessage(NewQtFormPanelGUI.class, (String)"LBL_TargetChooser_Folder_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.lbFolder, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.tfFolder, gridBagConstraints);
        this.tfFolder.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewQtFormPanelGUI.class).getString("AD_folderTextField"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(NewQtFormPanelGUI.class, (String)"LBL_TargetChooser_Browse_Button"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleName("");
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewQtFormPanelGUI.class).getString("AD_browseButton"));
        this.lbFormFile.setLabelFor(this.tfFormFile);
        Mnemonics.setLocalizedText((JLabel)this.lbFormFile, (String)NbBundle.getMessage(NewQtFormPanelGUI.class, (String)"LBL_TargetChooser_FormFile_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.lbFormFile, gridBagConstraints);
        this.tfFormFile.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.tfFormFile, gridBagConstraints);
        this.lbClassFile.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/editor/filecreation/Bundle").getString("LBL_TargetChooser_CreatedFile_Label_Mnemonic").charAt(0));
        this.lbClassFile.setLabelFor(this.tfClassFile);
        Mnemonics.setLocalizedText((JLabel)this.lbClassFile, (String)NbBundle.getMessage(NewQtFormPanelGUI.class, (String)"LBL_TargetChooser_ClassFile_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.lbClassFile, gridBagConstraints);
        this.tfClassFile.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.tfClassFile, gridBagConstraints);
        this.tfClassFile.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewQtFormPanelGUI.class).getString("AD_fileTextField"));
        this.lbHeaderFile.setLabelFor(this.tfHeaderFile);
        Mnemonics.setLocalizedText((JLabel)this.lbHeaderFile, (String)NbBundle.getMessage(NewQtFormPanelGUI.class, (String)"LBL_TargetChooser_HeaderFile_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.lbHeaderFile, gridBagConstraints);
        this.tfHeaderFile.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.tfHeaderFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.targetSeparator, gridBagConstraints);
        this.bottomPanelContainer.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.bottomPanelContainer, gridBagConstraints);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewQtFormPanelGUI.class).getString("AD_SimpleTargetChooserPanelGUI_1"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.browseButton == e.getSource()) {
            FileObject fo = null;
            SourceGroup group = this.getTargetGroup();
            fo = BrowseFolders.showDialog(new SourceGroup[]{group}, this.project, this.tfFolder.getText().replace(this.fileSeparatorChar, '/'));
            if (fo != null && fo.isFolder()) {
                String relPath = FileUtil.getRelativePath((FileObject)group.getRootFolder(), (FileObject)fo);
                this.tfFolder.setText(relPath.replace('/', this.fileSeparatorChar));
            }
        } else if (this.cbLocation == e.getSource()) {
            this.updateCreatedFile();
        } else if (this.cbCreateClass == e.getSource()) {
            this.updateCreatedFile();
        }
    }
}

