/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.jpa.model.ModelUtils;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScopes;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.util.WeakListeners;

public abstract class JPAProblemFinder {
    private boolean cancelled = false;
    private FileObject file = null;
    private Object cancellationLock = new Object();
    private JPAProblemContext context = null;
    private List<ErrorDescription> problemsFound = new ArrayList<ErrorDescription>();
    public static final Logger LOG = Logger.getLogger(JPAProblemFinder.class.getName());
    private static final String PERSISTENCE_SCOPES_LISTENER = "jpa.verification.scopes_listener";
    private static final Object singleInstanceLock = new Object();
    private static JPAProblemFinder runningInstance = null;
    private static boolean usgLogged;

    public JPAProblemFinder(FileObject file) {
        assert (file != null);
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(CompilationInfo info) throws Exception {
        if (!"text/x-java".equals(this.file.getMIMEType())) {
            return;
        }
        if (runningInstance != null) {
            runningInstance.cancel();
        }
        Object object = singleInstanceLock;
        synchronized (object) {
            runningInstance = this;
            this.cancelled = false;
            this.problemsFound.clear();
            this.createPersistenceScopesListener(this.file, info.getDocument());
            MetadataModel<EntityMappingsMetadata> emModel = ModelUtils.getModel(this.file);
            if (emModel == null) {
                return;
            }
            runningInstance = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        LOG.fine("Cancelling JPAProblemFinder task");
        this.cancelled = true;
        Object object = this.cancellationLock;
        synchronized (object) {
            if (this.context != null) {
                this.context.setCancelled(true);
            }
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public List<? extends ErrorDescription> getProblemsFound() {
        return this.problemsFound;
    }

    private void createPersistenceScopesListener(FileObject file, Document doc) {
        PersistenceScopes scopes;
        if (doc == null) {
            return;
        }
        LOG.fine("Creating PersistenceScopesListener on " + file.getName());
        Project project = FileOwnerQuery.getOwner((FileObject)file);
        if (project != null && (scopes = PersistenceScopes.getPersistenceScopes((Project)project)) != null) {
            PersistenceScopesListener listener = (PersistenceScopesListener)doc.getProperty(PERSISTENCE_SCOPES_LISTENER);
            if (listener == null) {
                listener = new PersistenceScopesListener(file);
                PropertyChangeListener weakListener = (PropertyChangeListener)WeakListeners.create(PropertyChangeListener.class, (EventListener)listener, null);
                scopes.addPropertyChangeListener(weakListener);
                doc.putProperty(PERSISTENCE_SCOPES_LISTENER, listener);
            }
            ArrayList<PersistenceXMLListener> pxmlListeners = new ArrayList<PersistenceXMLListener>();
            for (PersistenceScope scope : scopes.getPersistenceScopes()) {
                FileObject persistenceXML = scope.getPersistenceXml();
                if (persistenceXML == null) continue;
                PersistenceXMLListener pxmlListener = new PersistenceXMLListener(file);
                FileChangeListener weakPXMLListener = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)((Object)pxmlListener), null);
                persistenceXML.addFileChangeListener(weakPXMLListener);
                pxmlListeners.add(pxmlListener);
                LOG.fine("Added PersistenceXMLListener to " + persistenceXML.getName());
            }
            listener.setPXMLListeners(pxmlListeners);
        }
    }

    public static class ProblemFinderCompControl
    extends JPAProblemFinder
    implements CancellableTask<CompilationController> {
        public ProblemFinderCompControl(FileObject file) {
            super(file);
        }

        public void run(CompilationController controller) throws Exception {
            controller.toPhase(JavaSource.Phase.RESOLVED);
            super.run((CompilationInfo)controller);
        }
    }

    public static class ProblemFinderCompInfo
    extends JPAProblemFinder
    implements CancellableTask<CompilationInfo> {
        public ProblemFinderCompInfo(FileObject file) {
            super(file);
        }
    }

    private class PersistenceXMLListener
    extends RescanTrigger
    implements FileChangeListener {
        PersistenceXMLListener(FileObject file) {
            super(file);
        }

        public void fileChanged(FileEvent fe) {
            LOG.fine("Received a change event from persistence.xml");
            this.rescan();
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileDeleted(FileEvent fe) {
        }

        public void fileRenamed(FileRenameEvent fe) {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }

    private class PersistenceScopesListener
    extends RescanTrigger
    implements PropertyChangeListener {
        List<PersistenceXMLListener> pxmlListeners;

        PersistenceScopesListener(FileObject file) {
            super(file);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LOG.fine("Received a change event from PersistenceScopes");
            this.rescan();
        }

        void setPXMLListeners(List<PersistenceXMLListener> pxmlListeners) {
            this.pxmlListeners = pxmlListeners;
        }
    }

    private abstract class RescanTrigger {
        private FileObject file;

        RescanTrigger(FileObject file) {
            this.file = file;
        }

        void rescan() {
            JavaSource javaSrc = JavaSource.forFileObject((FileObject)this.file);
            if (javaSrc != null) {
                try {
                    javaSrc.runUserActionTask((Task)new ProblemFinderCompControl(this.file), true);
                }
                catch (IOException e) {
                    LOG.log(Level.FINE, e.getMessage(), e);
                }
            }
        }
    }
}

