/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.ui.networkneighbour;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.InvocationTargetException;
import org.netbeans.modules.cnd.remote.ui.networkneighbour.NeighbourHost;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

final class NeighbourHostNode
extends AbstractNode {
    public static final String PROP_ACCEPTS_SSH = "ACCEPTS_SSH";

    public NeighbourHostNode(NeighbourHost host) {
        super(Children.LEAF, Lookups.fixed((Object[])new Object[]{host}));
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put((Node.Property)new SSHIconProperty(this.getHost().acceptsSSH()));
        sheet.put(set);
        return sheet;
    }

    public Node.PropertySet[] getPropertySets() {
        return super.getPropertySets();
    }

    public Image getIcon(int type) {
        if (this.getHost().acceptsSSH()) {
            return ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/remote/resources/host_with_ssh.png");
        }
        return ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/remote/resources/host_no_ssh.png");
    }

    public Image getOpenedIcon(int type) {
        return super.getOpenedIcon(type);
    }

    public String getDisplayName() {
        return this.getHost().getName();
    }

    private NeighbourHost getHost() {
        return (NeighbourHost)this.getLookup().lookup(NeighbourHost.class);
    }

    private static final class SSHIconProperty
    extends PropertySupport.ReadOnly<Image> {
        private final Image image;
        private final boolean acceptsSSH;

        public SSHIconProperty(boolean acceptsSSH) {
            super(NeighbourHostNode.PROP_ACCEPTS_SSH, Image.class, "", "");
            this.acceptsSSH = acceptsSSH;
            this.image = acceptsSSH ? ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/remote/resources/sshOpen.gif") : ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/remote/resources/sshClosed.gif");
        }

        public Image getValue() throws IllegalAccessException, InvocationTargetException {
            return this.image;
        }

        public PropertyEditor getPropertyEditor() {
            return new PropertyEditorSupport(){

                @Override
                public String getAsText() {
                    return SSHIconProperty.this.acceptsSSH ? NbBundle.getMessage(NeighbourHostNode.class, (String)"NeighbourHostNode.HostAcceptsConnection") : NbBundle.getMessage(NeighbourHostNode.class, (String)"NeighbourHostNode.HostDoesNotAcceptConnection");
                }

                @Override
                public boolean isPaintable() {
                    return true;
                }

                @Override
                public void paintValue(Graphics g, Rectangle r) {
                    g.drawImage(SSHIconProperty.this.image, 1, 1, null);
                }
            };
        }
    }
}

