/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.compilers;

import java.io.BufferedReader;
import java.io.IOException;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.spi.utils.CndNotifier;
import org.netbeans.modules.cnd.toolchain.compilers.CCCCompiler;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

abstract class GNUCCCCompiler
extends CCCCompiler {
    public GNUCCCCompiler(ExecutionEnvironment env, CompilerFlavor flavor, ToolKind kind, String name, String displayName, String path) {
        super(env, flavor, kind, name, displayName, path);
    }

    protected String getCompilerStderrCommand() {
        ToolchainManager.CompilerDescriptor compiler = this.getDescriptor();
        if (compiler != null) {
            return " " + compiler.getIncludeFlags();
        }
        return "";
    }

    protected String getCompilerStdoutCommand() {
        ToolchainManager.CompilerDescriptor compiler = this.getDescriptor();
        if (compiler != null) {
            return " " + compiler.getMacroFlags();
        }
        return "";
    }

    @Override
    protected CCCCompiler.CompilerDefinitions getFreshCompilerDefinitions() {
        CCCCompiler.CompilerDefinitions res = new CCCCompiler.CompilerDefinitions();
        try {
            this.getSystemIncludesAndDefines(this.getCompilerStderrCommand(), false, res);
            this.getSystemIncludesAndDefines(this.getCompilerStdoutCommand(), true, res);
            this.completePredefinedMacros(res);
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
            System.err.println("IOException " + ioe);
            String errormsg = this.getExecutionEnvironment().isLocal() ? NbBundle.getMessage(this.getClass(), (String)"CANTFINDCOMPILER", (Object)this.getPath()) : NbBundle.getMessage(this.getClass(), (String)"CANT_FIND_REMOTE_COMPILER", (Object)this.getPath(), (Object)this.getExecutionEnvironment().getDisplayName());
            CndNotifier.getDefault().notifyErrorLater(errormsg);
        }
        this.checkModel(res, this.getCallable());
        return res;
    }

    @Override
    protected CCCCompiler.MyCallable<CCCCompiler.CompilerDefinitions> getCallable() {
        return new CCCCompiler.MyCallable<CCCCompiler.CompilerDefinitions>(){

            @Override
            public CCCCompiler.CompilerDefinitions call(String p) {
                CCCCompiler.CompilerDefinitions tmp = new CCCCompiler.CompilerDefinitions();
                try {
                    GNUCCCCompiler.this.getSystemIncludesAndDefines(GNUCCCCompiler.this.getCompilerStderrCommand() + " " + p, false, tmp);
                    GNUCCCCompiler.this.getSystemIncludesAndDefines(GNUCCCCompiler.this.getCompilerStdoutCommand() + " " + p, true, tmp);
                    GNUCCCCompiler.this.completePredefinedMacros(tmp);
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
                return tmp;
            }
        };
    }

    private boolean startsWithPath(String line) {
        if ((line = line.trim()).startsWith("/")) {
            return true;
        }
        return line.length() > 2 && Character.isLetter(line.charAt(0)) && line.charAt(1) == ':';
    }

    protected String cutIncludePrefix(String line) {
        ToolchainManager.CompilerDescriptor compiler = this.getDescriptor();
        if (compiler != null && compiler.getRemoveIncludeOutputPrefix() != null) {
            String remove = compiler.getRemoveIncludeOutputPrefix();
            String lline = line.toLowerCase();
            if (lline.startsWith(this.getIncludeFilePathPrefix().toLowerCase())) {
                line = line.substring(this.getIncludeFilePathPrefix().length());
            } else {
                String wpath = WindowsSupport.getInstance().convertToShellPath(this.getIncludeFilePathPrefix().toLowerCase());
                if (wpath != null && lline.startsWith(wpath)) {
                    line = line.substring(wpath.length());
                } else if (lline.startsWith(remove)) {
                    line = line.substring(remove.length());
                }
            }
        }
        return line;
    }

    @Override
    protected void parseCompilerOutput(BufferedReader reader, CCCCompiler.CompilerDefinitions pair) {
        try {
            String line;
            boolean startIncludes = false;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).contains("#include <...>")) {
                    startIncludes = true;
                    continue;
                }
                if (startIncludes) {
                    if (line.startsWith("End of search") || !this.startsWithPath(line)) {
                        startIncludes = false;
                        continue;
                    }
                    if (line.length() > 2 && line.charAt(1) == ':') {
                        GNUCCCCompiler.addUnique(pair.systemIncludeDirectoriesList, this.normalizePath(line));
                        continue;
                    }
                    if ((line = this.cutIncludePrefix(line)).endsWith(" (framework directory)")) {
                        line = line.substring(0, line.lastIndexOf(40)).trim() + "/{framework}";
                    }
                    GNUCCCCompiler.addUnique(pair.systemIncludeDirectoriesList, this.applyPathPrefix(line));
                    if (this.getDescriptor() == null || this.getDescriptor().getRemoveIncludePathPrefix() == null || !line.startsWith("/usr/lib")) continue;
                    GNUCCCCompiler.addUnique(pair.systemIncludeDirectoriesList, this.applyPathPrefix(line.substring(4)));
                    continue;
                }
                if (line.startsWith("#define ")) {
                    String[] macro = CCCCompiler.getMacro(line.substring(8).trim());
                    if (!CCCCompiler.isValidMacroName(macro[0])) continue;
                    String token = macro[1] != null ? macro[0] + "=" + macro[1] : macro[0];
                    GNUCCCCompiler.addUnique(pair.systemPreprocessorSymbolsList, token);
                    continue;
                }
                GNUCCCCompiler.parseUserMacros(line, pair.systemPreprocessorSymbolsList);
            }
            reader.close();
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(16, (Throwable)ioe);
        }
    }
}

