/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.lib.api.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.netbeans.modules.css.lib.api.properties.GrammarElement;
import org.netbeans.modules.css.lib.api.properties.GrammarParseTreeConvertor;
import org.netbeans.modules.css.lib.api.properties.GrammarResolverListener;
import org.netbeans.modules.css.lib.api.properties.GrammarResolverResult;
import org.netbeans.modules.css.lib.api.properties.GroupGrammarElement;
import org.netbeans.modules.css.lib.api.properties.Node;
import org.netbeans.modules.css.lib.api.properties.ResolvedToken;
import org.netbeans.modules.css.lib.api.properties.Token;
import org.netbeans.modules.css.lib.api.properties.Tokenizer;
import org.netbeans.modules.css.lib.api.properties.UnitGrammarElement;
import org.netbeans.modules.css.lib.api.properties.ValueGrammarElement;
import org.netbeans.modules.css.lib.properties.GrammarParseTreeBuilder;
import org.openide.util.Pair;

public class GrammarResolver {
    static final Map<Log, AtomicBoolean> LOGGERS = new EnumMap<Log, AtomicBoolean>(Log.class);
    private static boolean LOG;
    private static final Logger LOGGER;
    private List<ResolvedToken> resolvedTokens;
    private Tokenizer tokenizer;
    private Map<GrammarElement, Pair<InputState, Collection<ValueGrammarElement>>> resolvedSomething;
    private GrammarElement lastResolved;
    private final Collection<GrammarResolverListener> LISTENERS = new ArrayList<GrammarResolverListener>();
    private final GroupGrammarElement grammar;
    private final Map<Feature, Object> FEATURES = new EnumMap<Feature, Object>(Feature.class);

    public static void setLogging(Log log, boolean enable) {
        LOGGERS.get((Object)log).set(enable);
        LOG = false;
        for (Log l : Log.values()) {
            if (!GrammarResolver.isLoggingEnabled(l)) continue;
            LOG = true;
        }
    }

    private static boolean isLoggingEnabled(Log log) {
        return LOGGERS.get((Object)log).get();
    }

    public static GrammarResolverResult resolve(GroupGrammarElement grammar, CharSequence input) {
        return new GrammarResolver(grammar).resolve(input);
    }

    public GrammarResolver(GroupGrammarElement grammar) {
        this.grammar = grammar;
    }

    public synchronized GrammarResolverResult resolve(CharSequence input) {
        this.resolvedTokens = new ArrayList<ResolvedToken>();
        this.resolvedSomething = new LinkedHashMap<GrammarElement, Pair<InputState, Collection<ValueGrammarElement>>>();
        this.lastResolved = null;
        this.tokenizer = new Tokenizer(input);
        GrammarParseTreeBuilder parseTreeBuilder = new GrammarParseTreeBuilder();
        this.addGrammarResolverListener(parseTreeBuilder);
        this.fireStarting();
        this.groupMemberResolved(this.grammar, this.grammar, this.createInputState(), true);
        boolean inputResolved = this.resolve(this.grammar);
        if (this.tokenizer.moveNext()) {
            inputResolved = false;
        }
        this.resolvingFinished();
        this.fireFinished();
        this.removeGrammarResolverListener(parseTreeBuilder);
        boolean skipAnonymousElements = !this.isFeatureEnabled(Feature.keepAnonymousElementsInParseTree);
        Node rootNode = skipAnonymousElements ? GrammarParseTreeConvertor.createParseTreeWithOnlyNamedNodes(parseTreeBuilder.getParseTree()) : parseTreeBuilder.getParseTree();
        return new GrammarResolverResult(this.tokenizer, inputResolved, this.resolvedTokens, this.getAlternatives(), rootNode);
    }

    public void setFeature(Feature feature, Object value) {
        this.FEATURES.put(feature, value);
    }

    public void enableFeature(Feature feature) {
        this.FEATURES.put(feature, Boolean.TRUE);
    }

    public void disableFeture(Feature feature) {
        this.FEATURES.put(feature, null);
    }

    public Object getFeature(Feature name) {
        return this.FEATURES.get((Object)name);
    }

    private boolean isFeatureEnabled(Feature name) {
        return this.getFeature(name) != null;
    }

    public void addGrammarResolverListener(GrammarResolverListener listener) {
        this.LISTENERS.add(listener);
    }

    public void removeGrammarResolverListener(GrammarResolverListener listener) {
        this.LISTENERS.remove(listener);
    }

    private void fireEntering(GroupGrammarElement group) {
        for (GrammarResolverListener listener : this.LISTENERS) {
            listener.entering(group);
        }
    }

    private void fireEntering(ValueGrammarElement value) {
        for (GrammarResolverListener listener : this.LISTENERS) {
            listener.entering(value);
        }
    }

    private void fireExited(GroupGrammarElement group, boolean accepted) {
        for (GrammarResolverListener listener : this.LISTENERS) {
            if (accepted) {
                listener.accepted(group);
                continue;
            }
            listener.rejected(group);
        }
    }

    private void fireExited(ValueGrammarElement value, ResolvedToken rt) {
        for (GrammarResolverListener listener : this.LISTENERS) {
            if (rt == null) {
                listener.rejected(value);
                continue;
            }
            listener.accepted(value, rt);
        }
    }

    private void fireRuleChoosen(GroupGrammarElement base, GrammarElement value) {
        for (GrammarResolverListener listener : this.LISTENERS) {
            listener.ruleChoosen(base, value);
        }
    }

    private void fireStarting() {
        for (GrammarResolverListener listener : this.LISTENERS) {
            listener.starting();
        }
    }

    private void fireFinished() {
        for (GrammarResolverListener listener : this.LISTENERS) {
            listener.finished();
        }
    }

    private void resolvingFinished() {
        if (GrammarResolver.isLoggingEnabled(Log.DEFAULT)) {
            if (LOG) {
                this.log("\nResolved tokens:");
            }
            for (ResolvedToken rt : this.resolvedTokens) {
                if (!LOG) continue;
                this.log(rt.toString());
            }
        }
        if (GrammarResolver.isLoggingEnabled(Log.ALTERNATIVES)) {
            if (LOG) {
                this.log(Log.ALTERNATIVES, "\nAlternatives:");
            }
            for (ValueGrammarElement e : this.getAlternatives()) {
                if (!LOG) continue;
                this.log(Log.ALTERNATIVES, e.path());
            }
        }
    }

    private InputState createInputState() {
        return new InputState();
    }

    private boolean equalsToCurrentState(InputState state) {
        return this.tokenizer.tokenIndex() == state.tokenIndex && this.resolvedTokens.equals(state.consumed);
    }

    private void backupInputState(InputState state) {
        if (this.equalsToCurrentState(state)) {
            return;
        }
        this.tokenizer.move(state.tokenIndex);
        this.resolvedTokens = new ArrayList<ResolvedToken>(state.consumed);
        if (LOG) {
            this.log(String.format("  state backup to: %s", state));
        }
    }

    private boolean resolve(GrammarElement e) {
        boolean resolves;
        if (LOG) {
            this.log(String.format("+ entering %s, %s", e.path(), this.createInputState()));
        }
        if (e instanceof GroupGrammarElement) {
            GroupGrammarElement group = (GroupGrammarElement)e;
            this.fireEntering(group);
            resolves = this.processGroup(group);
            this.fireExited(group, resolves);
        } else if (e instanceof ValueGrammarElement) {
            ValueGrammarElement value = (ValueGrammarElement)e;
            this.fireEntering(value);
            resolves = this.processValue(value);
            this.fireExited(value, resolves ? this.resolvedTokens.get(this.resolvedTokens.size() - 1) : null);
        } else {
            throw new IllegalStateException();
        }
        if (LOG) {
            this.log(String.format("- leaving %s, resolved: %s, %s", e.path(), resolves, this.createInputState()));
        }
        return resolves;
    }

    private void valueNotAccepted(ValueGrammarElement valueGrammarElement) {
        if (this.resolvedTokens.size() < this.tokenizer.tokensCount()) {
            return;
        }
        if (LOG) {
            this.log(Log.ALTERNATIVES, String.format("value not accepted %s, %s", valueGrammarElement.path(), this.createInputState()));
        }
        Pair<InputState, Collection<ValueGrammarElement>> pair = this.resolvedSomething.get(this.lastResolved);
        ((Collection)pair.second()).add(valueGrammarElement);
    }

    private void groupMemberResolved(GrammarElement member, GroupGrammarElement group, InputState state, boolean root) {
        if (!root && state.consumed.size() < this.tokenizer.tokensCount()) {
            return;
        }
        if (LOG) {
            this.log(Log.ALTERNATIVES, String.format("input matched %s, %s", member.path(), state));
        }
        this.resolvedSomething.put(group, (Pair<InputState, Collection<ValueGrammarElement>>)Pair.of((Object)state, new LinkedList()));
        this.lastResolved = group;
    }

    private Set<ValueGrammarElement> getAlternatives() {
        HashSet<ValueGrammarElement> alternatives = new HashSet<ValueGrammarElement>();
        for (Pair<InputState, Collection<ValueGrammarElement>> tri : this.resolvedSomething.values()) {
            for (ValueGrammarElement value : (Collection)tri.second()) {
                alternatives.add(value);
            }
        }
        return alternatives;
    }

    private boolean processGroup(GroupGrammarElement group) {
        InputState successState = null;
        InputState enteringGroupState = this.createInputState();
        block23: for (int i = 0; i < group.getMaximumOccurances(); ++i) {
            InputState atMultiplicityLoopStartState = this.createInputState();
            if (LOG && i > 0) {
                this.log(String.format("  multiplicity loop %s, %s", i, atMultiplicityLoopStartState));
            }
            ArrayList<GrammarElement> grammarElementsToProcess = new ArrayList<GrammarElement>(group.elements());
            ArrayList<GrammarElement> branchAlternativesGrammarElementsToProcess = null;
            HashSet<GrammarElement> alreadyTriedAlternativeBranches = new HashSet<GrammarElement>();
            HashMap<GrammarElement, InputState> branchesResults = new HashMap<GrammarElement, InputState>();
            block24: while (true) {
                Object state2;
                InputState atCollectionLoopStartState = this.createInputState();
                Iterator membersIterator = grammarElementsToProcess.iterator();
                while (membersIterator.hasNext()) {
                    GrammarElement member = (GrammarElement)membersIterator.next();
                    boolean resolved = this.resolve(member);
                    if (LOG) {
                        this.log(String.format("  back in %s", group.path()));
                    }
                    if (!resolved && member instanceof ValueGrammarElement) {
                        this.valueNotAccepted((ValueGrammarElement)member);
                    }
                    if (resolved) {
                        InputState state2 = this.createInputState();
                        this.groupMemberResolved(member, group, state2, false);
                        switch (group.getType()) {
                            case SET: 
                            case COLLECTION: 
                            case ALL: {
                                if (LOG) {
                                    this.log(String.format("  added %s branch result: %s, %s", group.getType().name(), member.path(), state2));
                                }
                                branchesResults.put(member, state2);
                                this.backupInputState(enteringGroupState);
                                break;
                            }
                            case LIST: {
                                if (!membersIterator.hasNext()) {
                                    successState = state2;
                                    break block24;
                                } else {
                                    break;
                                }
                            }
                        }
                        continue;
                    }
                    if (member.isOptional()) {
                        state2 = this.createInputState();
                        if (LOG) {
                            this.log(String.format("  arbitrary member %s skipped", member.path()));
                        }
                        switch (group.getType()) {
                            case SET: 
                            case COLLECTION: 
                            case ALL: {
                                if (LOG) {
                                    this.log(String.format(" added %s branch result: %s, %s", group.getType().name(), member, state2));
                                }
                                branchesResults.put(member, (InputState)state2);
                                this.backupInputState(enteringGroupState);
                                break;
                            }
                            case LIST: {
                                if (!membersIterator.hasNext()) {
                                    successState = state2;
                                    break block24;
                                } else {
                                    break;
                                }
                            }
                        }
                        continue;
                    }
                    switch (group.getType()) {
                        case LIST: {
                            break block23;
                        }
                    }
                }
                switch (group.getType()) {
                    case SET: 
                    case COLLECTION: 
                    case ALL: {
                        int inputLenBeforeEnteringGroupElement;
                        if (branchesResults.isEmpty()) break;
                        int bestMatchConsumed = inputLenBeforeEnteringGroupElement = enteringGroupState.consumed.size();
                        for (Object state2 : branchesResults.values()) {
                            if (bestMatchConsumed >= ((InputState)state2).consumed.size()) continue;
                            bestMatchConsumed = ((InputState)state2).consumed.size();
                        }
                        if (LOG) {
                            this.log(String.format("  resolving best branch (consumed %s tokens)", bestMatchConsumed - inputLenBeforeEnteringGroupElement));
                        }
                        if (bestMatchConsumed == inputLenBeforeEnteringGroupElement) {
                            Map.Entry entry2 = branchesResults.entrySet().iterator().next();
                            successState = (InputState)entry2.getValue();
                            this.backupInputState(successState);
                            if (!LOG) break;
                            this.log(String.format("  zero tokens consumed, but decided to use arbitraty branch %s, %s", ((GrammarElement)entry2.getKey()).path(), successState));
                            break;
                        }
                        LinkedHashMap bestBranches = new LinkedHashMap();
                        state2 = group.elements().iterator();
                        while (state2.hasNext()) {
                            GrammarElement grammarElement = (GrammarElement)state2.next();
                            InputState state3 = (InputState)branchesResults.get(grammarElement);
                            if (state3 == null || state3.consumed.size() != bestMatchConsumed) continue;
                            bestBranches.put(grammarElement, state3);
                        }
                        for (int j = inputLenBeforeEnteringGroupElement; j < bestMatchConsumed; ++j) {
                            LinkedList linkedList = new LinkedList();
                            for (Map.Entry entry : bestBranches.entrySet()) {
                                ResolvedToken token = (ResolvedToken)((InputState)entry.getValue()).consumed.get(j);
                                if (!(token.getGrammarElement() instanceof UnitGrammarElement)) continue;
                                linkedList.add(entry.getKey());
                            }
                            if (linkedList.size() == bestBranches.size()) continue;
                            for (GrammarElement grammarElement : linkedList) {
                                bestBranches.remove(grammarElement);
                            }
                        }
                        assert (!bestBranches.isEmpty());
                        if (bestBranches.size() > 1) {
                            if (LOG) {
                                this.log(String.format("! more branches (%s) which consumed same input lenght found!", bestBranches.size()));
                            }
                            for (Map.Entry entry : bestBranches.entrySet()) {
                                if (LOG) {
                                    this.log(String.format("\t%s, %s %s", entry.getKey(), entry.getValue(), alreadyTriedAlternativeBranches.contains(entry.getKey()) ? "(tried)" : ""));
                                }
                                if (branchAlternativesGrammarElementsToProcess != null) continue;
                                if (LOG) {
                                    StringBuilder b = new StringBuilder();
                                    b.append("  saving grammar elements to process: ");
                                    for (GrammarElement e : grammarElementsToProcess) {
                                        b.append(e);
                                        b.append(',');
                                    }
                                    this.log(b.toString());
                                }
                                branchAlternativesGrammarElementsToProcess = new ArrayList<GrammarElement>(grammarElementsToProcess);
                            }
                        }
                        GrammarElement bestMatchElement = null;
                        for (GrammarElement alternative : bestBranches.keySet()) {
                            if (alreadyTriedAlternativeBranches.contains(alternative)) continue;
                            bestMatchElement = alternative;
                            break;
                        }
                        if (bestBranches.size() == 1) {
                            bestMatchElement = (GrammarElement)bestBranches.keySet().iterator().next();
                        }
                        if (bestMatchElement == null) {
                            if (!LOG) break;
                            this.log(String.format("! all %s alternative branches tried", bestBranches.size()));
                            break;
                        }
                        if (bestBranches.size() > 1 && branchAlternativesGrammarElementsToProcess != null) {
                            if (LOG) {
                                StringBuilder stringBuilder = new StringBuilder();
                                stringBuilder.append("  restoring grammar elements to process: ");
                                for (GrammarElement grammarElement : branchAlternativesGrammarElementsToProcess) {
                                    stringBuilder.append(grammarElement);
                                    stringBuilder.append(',');
                                }
                                this.log(stringBuilder.toString());
                            }
                            grammarElementsToProcess = new ArrayList<GrammarElement>(branchAlternativesGrammarElementsToProcess);
                        }
                        alreadyTriedAlternativeBranches.add(bestMatchElement);
                        successState = (InputState)branchesResults.get(bestMatchElement);
                        if (LOG) {
                            this.log(String.format("  decided to use best match %s, %s", bestMatchElement.path(), successState));
                        }
                        this.fireRuleChoosen(group, bestMatchElement);
                        this.backupInputState(successState);
                        switch (group.getType()) {
                            case COLLECTION: 
                            case ALL: {
                                grammarElementsToProcess.remove(bestMatchElement);
                            }
                        }
                    }
                }
                if (successState == null || successState.equals(atCollectionLoopStartState)) break;
                switch (group.getType()) {
                    case SET: 
                    case LIST: {
                        break block24;
                    }
                    default: {
                        continue block24;
                    }
                }
                break;
            }
            switch (group.getType()) {
                case ALL: {
                    for (GrammarElement e : grammarElementsToProcess) {
                        if (e.isOptional()) continue;
                        if (LOG) {
                            StringBuilder sb = new StringBuilder();
                            Iterator itr = grammarElementsToProcess.iterator();
                            while (itr.hasNext()) {
                                sb.append(((GrammarElement)itr.next()).path());
                                if (!itr.hasNext()) continue;
                                sb.append(", ");
                            }
                            this.log(String.format("  all group: exited collection_loop but there are some grammar element to process left: %s", sb.toString()));
                        }
                        this.backupInputState(atMultiplicityLoopStartState);
                        return false;
                    }
                    break;
                }
            }
            if (successState == null || successState.equals(atMultiplicityLoopStartState)) break;
        }
        if (successState == null) {
            this.backupInputState(enteringGroupState);
            return false;
        }
        this.backupInputState(successState);
        return true;
    }

    private boolean processValue(ValueGrammarElement ve) {
        if (!this.tokenizer.moveNext()) {
            return false;
        }
        Token token = this.tokenizer.token();
        if (ve.accepts(token)) {
            this.consumeValueGrammarElement(token, ve);
            if (LOG) {
                this.log(Log.VALUES, String.format("eaten unit %s", token));
            }
            return true;
        }
        this.tokenizer.movePrevious();
        return false;
    }

    private void consumeValueGrammarElement(Token token, ValueGrammarElement element) {
        this.resolvedTokens.add(new ResolvedToken(token, element));
    }

    private void log(String text) {
        this.log(Log.DEFAULT, text);
    }

    private void log(Log log, String text) {
        if (GrammarResolver.isLoggingEnabled(log)) {
            System.out.println(text);
        }
    }

    static {
        for (Log log : Log.values()) {
            LOGGERS.put(log, new AtomicBoolean(false));
        }
        LOG = false;
        LOGGER = Logger.getLogger(GrammarResolver.class.getName());
    }

    private class InputState {
        private int tokenIndex;
        private final List<ResolvedToken> consumed;

        public InputState() {
            this.tokenIndex = GrammarResolver.this.tokenizer.tokenIndex();
            this.consumed = new ArrayList<ResolvedToken>(GrammarResolver.this.resolvedTokens);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            Iterator<ResolvedToken> i = this.consumed.iterator();
            while (i.hasNext()) {
                ResolvedToken rt = i.next();
                sb.append(rt.token());
                if (!i.hasNext()) continue;
                sb.append(' ');
            }
            sb.append(']');
            sb.append(' ');
            List<Token> input = GrammarResolver.this.tokenizer.tokensList();
            for (int i2 = input.size() - 1; i2 >= 0; --i2) {
                sb.append(input.get(i2));
                if (i2 <= 0) continue;
                sb.append(' ');
            }
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InputState other = (InputState)obj;
            if (this.tokenIndex != other.tokenIndex) {
                return false;
            }
            return this.consumed == other.consumed || this.consumed != null && this.consumed.equals(other.consumed);
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + this.tokenIndex;
            hash = 79 * hash + (this.consumed != null ? this.consumed.hashCode() : 0);
            return hash;
        }
    }

    public static enum Feature {
        keepAnonymousElementsInParseTree;

    }

    public static enum Log {
        DEFAULT,
        VALUES,
        ALTERNATIVES;

    }
}

