/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.ui.api;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.io.CharConversionException;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.Status;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.ui.TestMethodNodeChildren;
import org.netbeans.modules.gsf.testrunner.ui.api.Bundle;
import org.netbeans.modules.gsf.testrunner.ui.api.DiffViewAction;
import org.netbeans.modules.gsf.testrunner.ui.api.TestsuiteNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.xml.XMLUtil;

public class TestMethodNode
extends AbstractNode {
    private static final boolean INLINE_RESULTS = Boolean.valueOf(System.getProperty("gsf.testrunner.inline_result", "true"));
    protected final Testcase testcase;
    private WeakReference<Project> project;
    private final URI projectURI;

    public TestMethodNode(Testcase testcase, Project project) {
        this(testcase, project, null);
    }

    protected TestMethodNode(Testcase testcase, Project project, Lookup lookup) {
        super((Children)(testcase.getTrouble() != null ? new TestMethodNodeChildren(testcase) : Children.LEAF), lookup);
        this.testcase = testcase;
        this.project = new WeakReference<Project>(project);
        this.projectURI = project.getProjectDirectory().toURI();
        this.setDisplayName();
        if (TestsuiteNode.DISPLAY_TOOLTIPS) {
            this.setShortDescription(TestsuiteNode.toTooltipText(testcase.getOutput()));
        }
    }

    public Testcase getTestcase() {
        return this.testcase;
    }

    private void setDisplayName() {
        int status;
        int n = this.testcase.getTrouble() == null ? 0 : (status = this.testcase.getTrouble().isError() ? 1 : 2);
        if (status == 0 && this.testcase.getTimeMillis() < 0L) {
            this.setDisplayName(this.testcase.getName());
            return;
        }
        if (this.testcase.getTimeMillis() < 0L) {
            if (status == 1) {
                this.setDisplayName(Bundle.MSG_TestMethodError(this.testcase.getName()));
            } else if (status == 2) {
                this.setDisplayName(Bundle.MSG_TestMethodFailed(this.testcase.getName()));
            }
        } else if (status == 0) {
            this.setDisplayName(Bundle.MSG_TestMethodPassed_time(this.testcase.getName(), Float.valueOf((float)this.testcase.getTimeMillis() / 1000.0f)));
        } else if (status == 1) {
            this.setDisplayName(Bundle.MSG_TestMethodError_time(this.testcase.getName(), Float.valueOf((float)this.testcase.getTimeMillis() / 1000.0f)));
        } else if (status == 2) {
            this.setDisplayName(Bundle.MSG_TestMethodFailed_time(this.testcase.getName(), Float.valueOf((float)this.testcase.getTimeMillis() / 1000.0f)));
        }
    }

    protected Project getProject() {
        Project prj = (Project)this.project.get();
        if (prj == null) {
            prj = FileOwnerQuery.getOwner((URI)this.projectURI);
            this.project = new WeakReference<Project>(prj);
        }
        return prj;
    }

    public String getHtmlDisplayName() {
        Status status = this.testcase.getStatus();
        StringBuffer buf = new StringBuffer(60);
        buf.append(this.testcase.getName());
        buf.append("&nbsp;&nbsp;");
        buf.append("<font color='#");
        buf.append(status.getHtmlDisplayColor() + "'>");
        String cause = null;
        if (INLINE_RESULTS && this.testcase.getTrouble() != null && this.testcase.getTrouble().getStackTrace() != null && this.testcase.getTrouble().getStackTrace().length > 0) {
            try {
                cause = XMLUtil.toElementContent((String)this.testcase.getTrouble().getStackTrace()[0]).replace("\n", "&nbsp;");
            }
            catch (CharConversionException ex) {
                cause = null;
            }
        }
        if (cause != null) {
            cause = TestsuiteNode.cutLine(cause, TestsuiteNode.MAX_MSG_LINE_LENGTH, true);
            buf.append(DisplayNameMapper.getCauseHTML(status, cause));
        } else {
            buf.append(this.testcase.getTimeMillis() < 0L ? DisplayNameMapper.getNoTimeHTML(status) : DisplayNameMapper.getTimeHTML(status, (float)this.testcase.getTimeMillis() / 1000.0f));
        }
        buf.append("</font>");
        return buf.toString();
    }

    public Action getPreferredAction() {
        return null;
    }

    public Action[] getActions(boolean context) {
        ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>();
        if (this.testcase.getTrouble() != null && this.testcase.getTrouble().getComparisonFailure() != null) {
            actions.add(new DiffViewAction(this.testcase));
        }
        if (this.testcase.getTrouble() != null && this.testcase.getTrouble().getStackTrace() != null) {
            StringBuilder callStack = new StringBuilder();
            for (String stack : this.testcase.getTrouble().getStackTrace()) {
                if (stack == null) continue;
                callStack.append(stack.concat("\n"));
            }
            if (callStack.length() > 0) {
                final String trace = callStack.toString();
                actions.add(new AbstractAction(Bundle.LBL_CopyStackTrace()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(trace), null);
                    }
                });
            }
        }
        return actions.toArray(new Action[actions.size()]);
    }

    public Image getIcon(int type) {
        switch (this.testcase.getStatus()) {
            case PASSED: {
                return ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/ok_16.png");
            }
            case PASSEDWITHERRORS: {
                return ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/ok_withErrors_16.png");
            }
            case FAILED: {
                return ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/warning_16.png");
            }
            case ERROR: {
                return ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/error_16.png");
            }
            case ABORTED: {
                return ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/aborted.png");
            }
            case SKIPPED: {
                return ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/skipped_16.png");
            }
        }
        return ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/warning2_16.png");
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public boolean failed() {
        return this.testcase.getStatus().equals((Object)Status.FAILED) || this.testcase.getStatus().equals((Object)Status.ERROR);
    }

    private static final class DisplayNameMapper {
        private static final Logger LOG = Logger.getLogger(TestMethodNode.class.getName());

        private DisplayNameMapper() {
        }

        static String getCauseHTML(Status status, String cause) {
            if (status == Status.PASSED) {
                return Bundle.MSG_TestMethodPassed_HTML_cause();
            }
            if (status == Status.PASSEDWITHERRORS) {
                return Bundle.MSG_TestMethodPassedWithErrors_HTML_cause();
            }
            if (status == Status.ERROR) {
                return Bundle.MSG_TestMethodError_HTML_cause(cause);
            }
            if (status == Status.FAILED) {
                return Bundle.MSG_TestMethodFailed_HTML_cause(cause);
            }
            if (status == Status.PENDING) {
                return Bundle.MSG_TestMethodPending_HTML_cause(cause);
            }
            if (status == Status.SKIPPED) {
                return Bundle.MSG_TestMethodSkipped_HTML_cause(cause);
            }
            if (status == Status.ABORTED) {
                return Bundle.MSG_TestMethodAborted_HTML_cause(cause);
            }
            if (status == Status.IGNORED) {
                return Bundle.MSG_TestMethodIgnored_HTML_cause(cause);
            }
            LOG.log(Level.INFO, "Unknown status: {0}", status);
            return "";
        }

        static String getNoTimeHTML(Status status) {
            if (status == Status.PASSED) {
                return Bundle.MSG_TestMethodPassed_HTML();
            }
            if (status == Status.PASSEDWITHERRORS) {
                return Bundle.MSG_TestMethodPassedWithErrors_HTML();
            }
            if (status == Status.ERROR) {
                return Bundle.MSG_TestMethodError_HTML();
            }
            if (status == Status.FAILED) {
                return Bundle.MSG_TestMethodFailed_HTML();
            }
            if (status == Status.PENDING) {
                return Bundle.MSG_TestMethodPending_HTML();
            }
            if (status == Status.SKIPPED) {
                return Bundle.MSG_TestMethodSkipped_HTML();
            }
            if (status == Status.ABORTED) {
                return Bundle.MSG_TestMethodAborted_HTML();
            }
            if (status == Status.IGNORED) {
                return Bundle.MSG_TestMethodIgnored_HTML();
            }
            LOG.log(Level.INFO, "Unknown status: {0}", status);
            return "";
        }

        static String getTimeHTML(Status status, float time) {
            if (status == Status.PASSED) {
                return Bundle.MSG_TestMethodPassed_HTML_time(Float.valueOf(time));
            }
            if (status == Status.PASSEDWITHERRORS) {
                return Bundle.MSG_TestMethodPassedWithErrors_HTML_time(Float.valueOf(time));
            }
            if (status == Status.ERROR) {
                return Bundle.MSG_TestMethodError_HTML_time(Float.valueOf(time));
            }
            if (status == Status.FAILED) {
                return Bundle.MSG_TestMethodFailed_HTML_time(Float.valueOf(time));
            }
            if (status == Status.PENDING) {
                return Bundle.MSG_TestMethodPending_HTML_time(Float.valueOf(time));
            }
            if (status == Status.SKIPPED) {
                return Bundle.MSG_TestMethodSkipped_HTML_time(Float.valueOf(time));
            }
            if (status == Status.ABORTED) {
                return Bundle.MSG_TestMethodAborted_HTML_time(Float.valueOf(time));
            }
            if (status == Status.IGNORED) {
                return Bundle.MSG_TestMethodIgnored_HTML_time(Float.valueOf(time));
            }
            LOG.log(Level.INFO, "Unknown status: {0}", status);
            return "";
        }
    }
}

