/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform.wizard;

import java.io.File;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.netbeans.spi.mobility.cldcplatform.CustomCLDCPlatformConfigurator;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public class WindowsRegistryReader {
    private static String vendorsList = "Sun|Nokia|Motorola|Siemens|Ericsson|Samsung|Vodafone|Sprint";
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    private static final int NATIVE_HANDLE = 0;
    private static final int ERROR_CODE = 1;
    private static final int SUBKEYS_NUMBER = 0;
    private static final int VALUES_NUMBER = 2;
    private static final int MAX_KEY_LENGTH = 3;
    private static final int MAX_VALUE_NAME_LENGTH = 4;
    private static final int KEY_QUERY_VALUE = 1;
    private static final int KEY_ENUMERATE_SUB_KEYS = 8;
    private static Class WindowsPreferences;
    private static boolean ok;
    private static Method WindowsRegOpenKey;
    private static Method WindowsRegCloseKey;
    private static Method WindowsRegQueryValueEx;
    private static Method WindowsRegQueryInfoKey;
    private static Method WindowsRegEnumKeyEx;
    private static Method WindowsRegEnumValue;

    public static Set<File> traverseRegistry() {
        HashSet<File> files = new HashSet<File>();
        if (ok && Utilities.isWindows()) {
            WindowsRegistryReader.traverseRegistry(-2147483646, files);
            WindowsRegistryReader.traverseRegistry(-2147483647, files);
        }
        return files;
    }

    private WindowsRegistryReader() {
    }

    private static void traverseRegistry(int hKey, Set<File> files) {
        block5: {
            StringBuffer sb = new StringBuffer(vendorsList);
            for (CustomCLDCPlatformConfigurator cfg : Lookup.getDefault().lookup(new Lookup.Template(CustomCLDCPlatformConfigurator.class)).allInstances()) {
                String vend = cfg.getRegistryProviderName();
                if (vend == null) continue;
                sb.append('|').append(vend);
            }
            Pattern vendors = Pattern.compile(sb.toString(), 2);
            try {
                String[] children = WindowsRegistryReader.getChildren(hKey, "Software");
                if (children != null) {
                    for (int i = 0; i < children.length; ++i) {
                        if (children[i] == null || !vendors.matcher(children[i]).find()) continue;
                        WindowsRegistryReader.traverseRegistry(hKey, "Software\\" + children[i], files);
                    }
                }
            }
            catch (Throwable t) {
                if (!(t instanceof ThreadDeath)) break block5;
                throw (ThreadDeath)t;
            }
        }
    }

    private static void traverseRegistry(int hKey, String key, Set<File> files) {
        if (key.length() > 256) {
            return;
        }
        try {
            String[] children;
            String[] keys = WindowsRegistryReader.getKeys(hKey, key);
            if (keys != null) {
                for (int i = 0; i < keys.length; ++i) {
                    if (keys[i] == null) continue;
                    try {
                        File f;
                        String value = WindowsRegistryReader.get(hKey, key, keys[i]);
                        if (value == null || value.length() <= 3 || !(f = new File(value)).isDirectory() || !f.isAbsolute()) continue;
                        files.add(f);
                        continue;
                    }
                    catch (Exception value) {
                        // empty catch block
                    }
                }
            }
            if ((children = WindowsRegistryReader.getChildren(hKey, key)) != null) {
                for (int i = 0; i < children.length; ++i) {
                    if (children[i] == null) continue;
                    WindowsRegistryReader.traverseRegistry(hKey, key + '\\' + children[i], files);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(int hKey, String subKey, String javaName) {
        int nativeHandle = WindowsRegistryReader.WindowsRegOpenKey(hKey, WindowsRegistryReader.toByteArray(subKey), 1)[0];
        if (nativeHandle == 0) {
            return null;
        }
        try {
            byte[] resultObject = WindowsRegistryReader.WindowsRegQueryValueEx(nativeHandle, WindowsRegistryReader.toByteArray(javaName));
            String string = resultObject == null ? null : WindowsRegistryReader.toJavaValueString(resultObject);
            return string;
        }
        finally {
            WindowsRegistryReader.WindowsRegCloseKey(nativeHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getKeys(int hKey, String subKey) {
        int nativeHandle = WindowsRegistryReader.WindowsRegOpenKey(hKey, WindowsRegistryReader.toByteArray(subKey), 1)[0];
        if (nativeHandle == 0) {
            return null;
        }
        try {
            int[] result = WindowsRegistryReader.WindowsRegQueryInfoKey(nativeHandle);
            if (result[1] != 0) {
                String[] stringArray = null;
                return stringArray;
            }
            int maxValueNameLength = result[4];
            int valuesNumber = result[2];
            if (valuesNumber == 0) {
                String[] stringArray = new String[]{};
                return stringArray;
            }
            String[] valueNames = new String[valuesNumber];
            for (int i = 0; i < valuesNumber; ++i) {
                valueNames[i] = WindowsRegistryReader.byteArrayToString(WindowsRegistryReader.WindowsRegEnumValue(nativeHandle, i, maxValueNameLength + 1));
            }
            String[] stringArray = valueNames;
            return stringArray;
        }
        finally {
            WindowsRegistryReader.WindowsRegCloseKey(nativeHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getChildren(int hKey, String subKey) {
        int nativeHandle = WindowsRegistryReader.WindowsRegOpenKey(hKey, WindowsRegistryReader.toByteArray(subKey), 9)[0];
        if (nativeHandle == 0) {
            return null;
        }
        try {
            int[] result = WindowsRegistryReader.WindowsRegQueryInfoKey(nativeHandle);
            if (result[1] != 0) {
                String[] stringArray = null;
                return stringArray;
            }
            int maxKeyLength = result[3];
            int subKeysNumber = result[0];
            if (subKeysNumber == 0) {
                String[] stringArray = new String[]{};
                return stringArray;
            }
            String[] children = new String[subKeysNumber];
            for (int i = 0; i < subKeysNumber; ++i) {
                children[i] = WindowsRegistryReader.byteArrayToString(WindowsRegistryReader.WindowsRegEnumKeyEx(nativeHandle, i, maxKeyLength + 1));
            }
            String[] stringArray = children;
            return stringArray;
        }
        finally {
            WindowsRegistryReader.WindowsRegCloseKey(nativeHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Method findMethod(String name, Class[] arguments) {
        if (ok) {
            try {
                String string = vendorsList;
                synchronized (string) {
                    if (WindowsPreferences == null) {
                        WindowsPreferences = Class.forName("java.util.prefs.WindowsPreferences");
                    }
                }
                Method m = WindowsPreferences.getDeclaredMethod(name, arguments);
                m.setAccessible(true);
                return m;
            }
            catch (Exception e) {
                ok = false;
            }
        }
        return null;
    }

    private static int[] WindowsRegOpenKey(int hKey, byte[] subKey, int securityMask) {
        try {
            return (int[])WindowsRegOpenKey.invoke(null, new Integer(hKey), subKey, new Integer(securityMask));
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e.getLocalizedMessage());
        }
    }

    private static int WindowsRegCloseKey(int hKey) {
        try {
            return (Integer)WindowsRegCloseKey.invoke(null, new Integer(hKey));
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e.getLocalizedMessage());
        }
    }

    private static byte[] WindowsRegQueryValueEx(int hKey, byte[] valueName) {
        try {
            return (byte[])WindowsRegQueryValueEx.invoke(null, new Integer(hKey), valueName);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e.getLocalizedMessage());
        }
    }

    private static int[] WindowsRegQueryInfoKey(int hKey) {
        try {
            return (int[])WindowsRegQueryInfoKey.invoke(null, new Integer(hKey));
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e.getLocalizedMessage());
        }
    }

    private static byte[] WindowsRegEnumKeyEx(int hKey, int subKeyIndex, int maxKeyLength) {
        try {
            return (byte[])WindowsRegEnumKeyEx.invoke(null, new Integer(hKey), new Integer(subKeyIndex), new Integer(maxKeyLength));
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e.getLocalizedMessage());
        }
    }

    private static byte[] WindowsRegEnumValue(int hKey, int valueIndex, int maxValueNameLength) {
        try {
            return (byte[])WindowsRegEnumValue.invoke(null, new Integer(hKey), new Integer(valueIndex), new Integer(maxValueNameLength));
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e.getLocalizedMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String toJavaValueString(byte[] windowsNameArray) {
        String windowsName = WindowsRegistryReader.byteArrayToString(windowsNameArray);
        StringBuffer javaName = new StringBuffer();
        int i = 0;
        while (i < windowsName.length()) {
            int ch;
            block8: {
                block6: {
                    int next;
                    block7: {
                        ch = windowsName.charAt(i);
                        if (ch != 47) break block6;
                        next = 32;
                        if (windowsName.length() <= i + 1) break block7;
                        char c = windowsName.charAt(i + 1);
                        next = c;
                        if (c != 'u') break block7;
                        if (windowsName.length() < i + 6) {
                            return javaName.toString();
                        }
                        ch = (char)Integer.parseInt(windowsName.substring(i + 2, i + 6), 16);
                        i += 5;
                        break block8;
                    }
                    if (windowsName.length() > i + 1 && windowsName.charAt(i + 1) >= 'A' && next <= 90) {
                        ch = next;
                        ++i;
                        break block8;
                    } else if (windowsName.length() > i + 1 && next == 47) {
                        ch = 92;
                        ++i;
                    }
                    break block8;
                }
                if (ch == 92) {
                    ch = 47;
                }
            }
            javaName.append((char)ch);
            ++i;
        }
        return javaName.toString();
    }

    private static byte[] toByteArray(String str) {
        byte[] result = new byte[str.length() + 1];
        for (int i = 0; i < str.length(); ++i) {
            result[i] = (byte)str.charAt(i);
        }
        result[str.length()] = 0;
        return result;
    }

    private static String byteArrayToString(byte[] array) {
        if (array == null) {
            return null;
        }
        return new String(array, 0, array.length - 1);
    }

    public static void main(String[] args) throws Exception {
        System.out.println(WindowsRegistryReader.traverseRegistry());
    }

    static {
        ok = true;
        WindowsRegOpenKey = WindowsRegistryReader.findMethod("WindowsRegOpenKey", new Class[]{Integer.TYPE, byte[].class, Integer.TYPE});
        WindowsRegCloseKey = WindowsRegistryReader.findMethod("WindowsRegCloseKey", new Class[]{Integer.TYPE});
        WindowsRegQueryValueEx = WindowsRegistryReader.findMethod("WindowsRegQueryValueEx", new Class[]{Integer.TYPE, byte[].class});
        WindowsRegQueryInfoKey = WindowsRegistryReader.findMethod("WindowsRegQueryInfoKey", new Class[]{Integer.TYPE});
        WindowsRegEnumKeyEx = WindowsRegistryReader.findMethod("WindowsRegEnumKeyEx", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE});
        WindowsRegEnumValue = WindowsRegistryReader.findMethod("WindowsRegEnumValue", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE});
    }
}

