/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTBuilder;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTTokenStreamBuilder;
import org.netbeans.modules.cnd.apt.utils.APTSerializeUtils;

public class APTDriverImpl {
    private final ConcurrentHashMap<CharSequence, APTSyncCreator> file2creator = new ConcurrentHashMap();
    private Map<CharSequence, Reference<APTFile>> file2ref2apt = new ConcurrentHashMap<CharSequence, Reference<APTFile>>();
    private Map<CharSequence, APTFile> file2apt = new ConcurrentHashMap<CharSequence, APTFile>();
    private final ConcurrentMap<CharSequence, FileTraceData> readFiles = new ConcurrentHashMap<CharSequence, FileTraceData>();

    public APTFile findAPT(APTFileBuffer buffer, boolean withTokens, String lang, String flavor) throws IOException {
        CharSequence path = buffer.getAbsolutePath();
        APTFile apt = this._getAPTFile(path, withTokens);
        if (apt == null) {
            APTSyncCreator old;
            APTSyncCreator creator = this.file2creator.get(path);
            if (creator == null && (old = this.file2creator.putIfAbsent(path, creator = new APTSyncCreator())) != null) {
                creator = old;
            }
            assert (creator != null);
            apt = creator.findAPT(buffer, withTokens, lang, flavor);
            this.file2creator.remove(path);
        }
        return apt;
    }

    public void invalidateAPT(APTFileBuffer buffer) {
        CharSequence path = buffer.getAbsolutePath();
        if (APTTraceFlags.APT_USE_SOFT_REFERENCE) {
            this.file2ref2apt.remove(path);
        } else {
            this.file2apt.remove(path);
        }
    }

    public void invalidateAll() {
        if (APTTraceFlags.APT_USE_SOFT_REFERENCE) {
            this.file2ref2apt.clear();
        } else {
            this.file2apt.clear();
        }
    }

    private APTFile _getAPTFile(CharSequence path, boolean withTokens) {
        Reference<APTFile> aptRef;
        if (withTokens) {
            return null;
        }
        APTFile apt = APTTraceFlags.APT_USE_SOFT_REFERENCE ? ((aptRef = this.file2ref2apt.get(path)) == null ? null : aptRef.get()) : this.file2apt.get(path);
        return apt;
    }

    private void _putAPTFile(CharSequence path, APTFile apt, boolean withTokens, APTFileBuffer.BufferType bufType) {
        if (withTokens) {
            return;
        }
        if (APTTraceFlags.APT_USE_SOFT_REFERENCE) {
            if (bufType == APTFileBuffer.BufferType.START_FILE) {
                this.file2ref2apt.put(path, new WeakReference<APTFile>(apt));
            } else {
                this.file2ref2apt.put(path, new SoftReference<APTFile>(apt));
            }
        } else {
            this.file2apt.put(path, apt);
        }
    }

    public void close() {
        this.invalidateAll();
    }

    public void traceActivity() {
        long totalReads = 0L;
        long fileSizes = 0L;
        int ligthNrReads = 0;
        int nrReads = 0;
        int noAPTLightFiles = 0;
        for (Map.Entry entry : this.readFiles.entrySet()) {
            FileTraceData data = (FileTraceData)entry.getValue();
            long readBytes = data.totalBytes();
            assert (data.totalLightReads() < data.totalReads()) : "strange params " + data + " " + entry.getKey();
            totalReads += readBytes;
            fileSizes += (long)data.getLength();
            int lightReads = data.totalLightReads();
            if (lightReads == 0) {
                ++noAPTLightFiles;
            }
            ligthNrReads += lightReads;
            nrReads += data.totalReads();
        }
        double ratio = fileSizes == 0L ? 0.0 : 1.0 * (double)totalReads / (double)fileSizes;
        System.err.printf("StreamBuilder has %d (%d no APTLight queries) entries, ratio is %f (%d reads where %d Light) [read %dKb from files of total size %dKb]%n", this.readFiles.size(), noAPTLightFiles, ratio, nrReads, ligthNrReads, totalReads /= 1024L, fileSizes /= 1024L);
        this.readFiles.clear();
    }

    private void trackActivity(CharSequence name, int len, boolean light) {
    }

    private static final class FileTraceData {
        private final int length;
        private final AtomicInteger nrLightReads = new AtomicInteger(0);
        private final AtomicInteger nrReads = new AtomicInteger(0);

        public FileTraceData(int length) {
            this.length = length;
        }

        public void add(int bytes, CharSequence name, boolean light) {
            assert (bytes == this.length);
            this.nrReads.incrementAndGet();
            if (light) {
                int lights = this.nrLightReads.incrementAndGet();
                assert (lights == 1) : "more that one APT Light created for " + name;
            }
        }

        public int totalBytes() {
            return this.nrReads.get() * this.length;
        }

        public int totalReads() {
            return this.nrReads.get();
        }

        public int totalLightReads() {
            return this.nrLightReads.get();
        }

        public int getLength() {
            return this.length;
        }

        public String toString() {
            return "Pair{length=" + this.length + ", nrLightReads=" + this.nrLightReads + ", nrReads=" + this.nrReads + '}';
        }
    }

    private class APTSyncCreator {
        private APTFile fullAPT = null;
        private APTFile lightAPT = null;

        private TokenStream getTokenStream(APTFileBuffer buffer, String lang, String flavor, boolean isLight) throws IOException {
            String bufName = buffer.getAbsolutePath().toString();
            char[] charBuffer = buffer.getCharBuffer();
            APTDriverImpl.this.trackActivity(bufName, charBuffer.length, isLight);
            if (isLight) {
                return APTTokenStreamBuilder.buildLightTokenStream(bufName, charBuffer, lang, flavor);
            }
            return APTTokenStreamBuilder.buildTokenStream(bufName, charBuffer, lang, flavor);
        }

        public synchronized APTFile findAPT(APTFileBuffer buffer, boolean withTokens, String lang, String flavor) throws IOException {
            CharSequence path = buffer.getAbsolutePath();
            if (withTokens && this.fullAPT != null) {
                return this.fullAPT;
            }
            if (!withTokens && this.lightAPT != null) {
                return this.lightAPT;
            }
            APTFile apt = APTDriverImpl.this._getAPTFile(path, withTokens);
            if (apt == null) {
                TokenStream ts = this.getTokenStream(buffer, lang, flavor, !withTokens);
                apt = APTBuilder.buildAPT(buffer.getFileSystem(), path, ts);
                APTFileBuffer.BufferType type = buffer.getType();
                if (!withTokens) {
                    this.fullAPT = null;
                    if (apt != null) {
                        if (APTTraceFlags.TEST_APT_SERIALIZATION) {
                            APTFile test = (APTFile)APTSerializeUtils.testAPTSerialization(buffer, apt);
                            if (test != null) {
                                apt = test;
                            } else {
                                System.err.println("error on serialization apt for file " + path);
                            }
                        }
                        this.lightAPT = apt;
                        APTDriverImpl.this._putAPTFile(path, this.lightAPT, false, type);
                    }
                } else {
                    this.fullAPT = apt;
                    if (apt != null) {
                        if (APTTraceFlags.TEST_APT_SERIALIZATION) {
                            APTFile test = (APTFile)APTSerializeUtils.testAPTSerialization(buffer, apt);
                            if (test != null) {
                                apt = test;
                            } else {
                                System.err.println("error on serialization apt for file " + path);
                            }
                        }
                        APTDriverImpl.this._putAPTFile(path, this.fullAPT, true, type);
                        this.lightAPT = (APTFile)APTBuilder.buildAPTLight(apt);
                        APTDriverImpl.this._putAPTFile(path, this.lightAPT, false, type);
                    }
                }
            }
            return apt;
        }
    }
}

