/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.impl.support.APTBaseMacroMap;
import org.netbeans.modules.cnd.apt.impl.support.APTFileMacroMap;
import org.netbeans.modules.cnd.apt.impl.support.APTIncludeHandlerImpl;
import org.netbeans.modules.cnd.apt.impl.support.APTMacroImpl;
import org.netbeans.modules.cnd.apt.impl.support.APTMacroMapSnapshot;
import org.netbeans.modules.cnd.apt.impl.support.APTPreprocHandlerImpl;
import org.netbeans.modules.cnd.apt.impl.support.clank.ClankFileMacroMap;
import org.netbeans.modules.cnd.apt.impl.support.clank.ClankIncludeHandlerImpl;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.support.APTMacroMap;
import org.netbeans.modules.cnd.apt.support.api.PPIncludeHandler;
import org.netbeans.modules.cnd.apt.support.api.PPMacroMap;
import org.netbeans.modules.cnd.apt.support.api.PreprocHandler;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

public class APTSerializeUtils {
    private static final short CHILD = 1;
    private static final short SIBLING = 2;
    private static final short END_APT = 3;
    private static int fileIndex = 0;
    private static final boolean TRACE = true;
    private static final short NULL_POINTER = -1;
    private static final short MACRO_MAP_STATE_IMPL = 1;
    private static final short CLANK_MACRO_MAP_FILE_STATE_IMPL = 2;
    private static final short MACRO_MAP_FILE_STATE_IMPL = 3;
    private static final short PREPROC_STATE_STATE_IMPL = 4;
    private static final short MACRO_MAP_SNAPSHOT = 5;
    private static final short UNDEFINED_MACRO = 6;
    private static final short MACRO_IMPL = 7;

    private APTSerializeUtils() {
    }

    public static void writeAPT(ObjectOutputStream out, APT apt) throws IOException {
        out.writeObject(apt);
        if (apt != null) {
            APTSerializeUtils.writeTree(out, apt);
        }
    }

    public static APT readAPT(ObjectInputStream in) throws IOException, ClassNotFoundException {
        APT apt = (APT)in.readObject();
        if (apt != null) {
            APTSerializeUtils.readTree(in, apt);
        }
        return apt;
    }

    private static void writeTree(ObjectOutputStream out, APT root) throws IOException {
        assert (root != null) : "there must be something to write";
        APT node = root;
        do {
            APT child;
            if ((child = node.getFirstChild()) != null) {
                out.writeShort(1);
                APTSerializeUtils.writeAPT(out, child);
            }
            if ((node = node.getNextSibling()) == null) continue;
            out.writeShort(2);
            out.writeObject(node);
        } while (node != null);
        out.writeShort(3);
    }

    private static void readTree(ObjectInputStream in, APT root) throws IOException, ClassNotFoundException {
        assert (root != null) : "there must be something to read";
        APT node = root;
        do {
            short kind = in.readShort();
            switch (kind) {
                case 3: {
                    return;
                }
                case 1: {
                    node.setFirstChild(APTSerializeUtils.readAPT(in));
                    break;
                }
                case 2: {
                    APT sibling = (APT)in.readObject();
                    node.setNextSibling(sibling);
                    node = sibling;
                    break;
                }
                default: {
                    assert (false);
                    {
                        break;
                    }
                }
            }
        } while (node != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"RV"})
    public static APT testAPTSerialization(APTFileBuffer buffer, APT apt) {
        FileObject file = CndFileUtils.toFileObject((FileSystem)buffer.getFileSystem(), (CharSequence)buffer.getAbsolutePath());
        APT aptRead = null;
        String prefix = "cnd_apt_" + fileIndex++;
        String suffix = file.getNameExt();
        try {
            File out = File.createTempFile(prefix, suffix);
            System.out.println("...saving APT of file " + file.getPath() + " into tmp file " + out);
            long astTime = System.currentTimeMillis();
            ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(out), APTTraceFlags.BUF_SIZE));
            try {
                APTSerializeUtils.writeAPT(oos, apt);
            }
            finally {
                oos.close();
            }
            long writeTime = System.currentTimeMillis() - astTime;
            System.out.println("saved APT of file " + file.getPath() + " withing " + writeTime + "ms");
            astTime = System.currentTimeMillis();
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(out), APTTraceFlags.BUF_SIZE));
            try {
                aptRead = APTSerializeUtils.readAPT(ois);
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace(System.err);
            }
            finally {
                ois.close();
            }
            long readTime = System.currentTimeMillis() - astTime;
            System.out.println("read APT of file " + file.getPath() + " withing " + readTime + "ms");
            out.delete();
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        return aptRead;
    }

    public static void writeSystemMacroMap(APTMacroMap macroMap, RepositoryDataOutput output) throws IOException {
    }

    public static APTMacroMap readSystemMacroMap(RepositoryDataInput input) throws IOException {
        return null;
    }

    public static void writeMacroMapState(PPMacroMap.State state, RepositoryDataOutput output) throws IOException {
        assert (state != null);
        if (state instanceof APTFileMacroMap.FileStateImpl) {
            output.writeShort(3);
            ((APTFileMacroMap.FileStateImpl)state).write(output);
        } else if (state instanceof ClankFileMacroMap.FileStateImpl) {
            output.writeShort(2);
            ((ClankFileMacroMap.FileStateImpl)state).write(output);
        } else {
            assert (!APTTraceFlags.USE_CLANK);
            assert (state instanceof APTBaseMacroMap.StateImpl);
            output.writeShort(1);
            ((APTBaseMacroMap.StateImpl)state).write(output);
        }
    }

    public static PPMacroMap.State readMacroMapState(RepositoryDataInput input) throws IOException {
        PPMacroMap.State state;
        short handler = input.readShort();
        if (handler == 3) {
            state = new APTFileMacroMap.FileStateImpl(input);
        } else if (handler == 2) {
            state = new ClankFileMacroMap.FileStateImpl(input);
        } else {
            assert (handler == 1);
            state = new APTBaseMacroMap.StateImpl(input);
        }
        return state;
    }

    public static void writeIncludeState(PPIncludeHandler.State state, RepositoryDataOutput output) throws IOException {
        assert (state != null);
        if (APTTraceFlags.USE_CLANK) {
            assert (state instanceof ClankIncludeHandlerImpl.StateImpl);
            ((ClankIncludeHandlerImpl.StateImpl)state).write(output);
        } else {
            assert (state instanceof APTIncludeHandlerImpl.StateImpl);
            ((APTIncludeHandlerImpl.StateImpl)state).write(output);
        }
    }

    public static PPIncludeHandler.State readIncludeState(RepositoryDataInput input) throws IOException {
        Persistent state = APTTraceFlags.USE_CLANK ? new ClankIncludeHandlerImpl.StateImpl(input) : new APTIncludeHandlerImpl.StateImpl(input);
        return state;
    }

    public static void writePreprocState(PreprocHandler.State state, RepositoryDataOutput output) throws IOException {
        assert (state != null);
        if (!(state instanceof APTPreprocHandlerImpl.StateImpl)) {
            throw new IllegalArgumentException("unknown preprocessor state" + state);
        }
        output.writeShort(4);
        ((APTPreprocHandlerImpl.StateImpl)state).write(output);
    }

    public static PreprocHandler.State readPreprocState(RepositoryDataInput input) throws IOException {
        APTPreprocHandlerImpl.StateImpl out;
        short handler = input.readShort();
        switch (handler) {
            case 4: {
                out = new APTPreprocHandlerImpl.StateImpl(input);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown preprocessor state handler" + handler);
            }
        }
        return out;
    }

    public static void writeSnapshot(APTMacroMapSnapshot snap, RepositoryDataOutput output) throws IOException {
        output.writeShort(-1);
    }

    public static APTMacroMapSnapshot readSnapshot(RepositoryDataInput input) throws IOException {
        short handler = input.readShort();
        APTMacroMapSnapshot snap = null;
        if (handler != -1) {
            assert (handler == 5);
            snap = new APTMacroMapSnapshot(input);
        }
        return snap;
    }

    public static void writeMacro(APTMacro macro, RepositoryDataOutput output) throws IOException {
        assert (macro != null);
        if (macro == APTMacroMapSnapshot.UNDEFINED_MACRO) {
            output.writeShort(6);
        } else if (macro instanceof APTMacroImpl) {
            output.writeShort(7);
            ((APTMacroImpl)macro).write(output);
        }
    }

    public static APTMacro readMacro(RepositoryDataInput input) throws IOException {
        APTMacro macro;
        short handler = input.readShort();
        if (handler == 6) {
            macro = APTMacroMapSnapshot.UNDEFINED_MACRO;
        } else {
            assert (handler == 7);
            macro = new APTMacroImpl(input);
        }
        return macro;
    }
}

