
package org.llvm.adt.aliases;

import java.util.Arrays;
import java.util.Iterator;
import org.clank.java.*;
import org.clank.support.*;
import org.clank.support.aliases.*;
import static org.clank.support.Casts.*;
import static org.clank.java.io.*;
import static org.clank.java.std.*;
import static org.llvm.adt.ADTAliases.*;
import static org.llvm.support.llvm.*;
import static org.clank.support.NativePointer.*;
import static org.clank.support.NativeType.*;
import static org.clank.support.Native.*;
import org.llvm.support.*;
import org.llvm.adt.*;
import org.llvm.adt.aliases.*;

/*template <typename KeyT, typename ValueT, typename KeyInfoT = ${DENSE_MAP_INFO}> TEMPLATE*/
//<editor-fold defaultstate="collapsed" desc="llvm::DenseMap">
@Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 532,
 cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMap")
//</editor-fold>
public class ${FILE_NAME}${CLASS_SUFFIX}  extends /*public*/ ${DENSE_MAP_BASE} implements assignable<${FILE_NAME}${CLASS_SUFFIX}>, Iterable<${PAIR_TYPE}>, Destructors.ClassWithDestructor {
  // Lift some types from the dependent base class into this class for
  // simplicity of referring to them.
  /*typedef DenseMapBase<${FILE_NAME}${CLASS_SUFFIX}, KeyT, ValueT, KeyInfoT> BaseT*/
  //public final class BaseT extends DenseMapBase<${FILE_NAME}${CLASS_SUFFIX}, KeyT, ValueT, KeyInfoT>{ };
  /*typedef typename BaseT::BucketT BucketT*/
  //public final class BucketT extends  BaseT.BucketT{ };
  /*friend  class DenseMapBase<${FILE_NAME}${CLASS_SUFFIX}, KeyT, ValueT, KeyInfoT>*/;
  private ${PAIR_TYPE}[] /*P*/ Buckets;
  private /*uint*/int NumEntries;
  private /*uint*/int NumTombstones;
  private /*uint*/int NumBuckets;
/*public:*/
  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMap::${FILE_NAME}${CLASS_SUFFIX}">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 549,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMap::${FILE_NAME}${CLASS_SUFFIX}")
  //</editor-fold>
  public /*explicit*/ ${FILE_NAME}(${DENSE_MAP_INFO} keyInfo, ${VALUE_TYPE} defaultValue) {
    this(keyInfo, 0, defaultValue);
  }
  public /*explicit*/ ${FILE_NAME}(${DENSE_MAP_INFO} keyInfo, /*uint*/int NumInitBuckets/*= 0*/, ${VALUE_TYPE} defaultValue) {
    super(keyInfo, defaultValue);
    init(NumInitBuckets);
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMap::${FILE_NAME}${CLASS_SUFFIX}">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 553,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMap::${FILE_NAME}${CLASS_SUFFIX}")
  //</editor-fold>
  public ${FILE_NAME}(/*const*/${FILE_NAME}${CLASS_SUFFIX} /*&*/ other) {
    /* : BaseT()*/ 
    //START JInit
    super(other.keyInfoT, other.defaultValue);
    //END JInit
    init(0);
    copyFrom(other);
  }

  /*template <typename InputIt> TEMPLATE*/
  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMap::${FILE_NAME}${CLASS_SUFFIX}">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 566,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMap::${FILE_NAME}${CLASS_SUFFIX}")
  //</editor-fold>
  public ${FILE_NAME}(${DENSE_MAP_INFO} keyInfo, /*const*/type$iterator<?, ${PAIR_TYPE}> /*&*/ I, /*const*/type$iterator<?, ${PAIR_TYPE}> /*&*/ E, ${VALUE_TYPE} defaultValue) {
    super(keyInfo, defaultValue);
    init(NextPowerOf2(std.distance(I, E)));
    this.insert(I, E);
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMap::~${FILE_NAME}${CLASS_SUFFIX}">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 571,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMap::~${FILE_NAME}${CLASS_SUFFIX}")
  //</editor-fold>
  public void $destroy() {
    //super.$destroy();
    this.destroyAll();
    //operator delete(Buckets);
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMap::swap">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 576,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMap::swap")
  //</editor-fold>
  public void swap(${FILE_NAME}${CLASS_SUFFIX} /*&*/ RHS) {
    ${PAIR_TYPE}[] BucketsOther = RHS.Buckets;
    RHS.Buckets = this.Buckets;
    this.Buckets = BucketsOther;
    int NumBucketsOther = RHS.NumBuckets;
    RHS.NumBuckets = this.NumBuckets;
    this.NumBuckets = NumBucketsOther;
    int NumEntriesOther = RHS.NumEntries;
    RHS.NumEntries = this.NumEntries;
    this.NumEntries = NumEntriesOther;
    int NumTombstonesOther = RHS.NumTombstones;
    RHS.NumTombstones = this.NumTombstones;
    this.NumTombstones = NumTombstonesOther; 
  }

  @Override
  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMap::operator=">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 583,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMap::operator=")
  //</editor-fold>
  public ${FILE_NAME}${CLASS_SUFFIX} /*&*/ $assign(/*const*/${FILE_NAME}${CLASS_SUFFIX} /*&*/ other) {
    copyFrom(other);
    return /*Deref*/this;
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMap::copyFrom">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 598,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMap::copyFrom")
  //</editor-fold>
  public void copyFrom(/*const*/${FILE_NAME}${CLASS_SUFFIX} /*&*/ other) {
    this.destroyAll();
    //operator delete(Buckets);
    if (allocateBuckets(other.NumBuckets)) {
      super.copyFrom(other);
    } else {
      NumEntries = 0;
      NumTombstones = 0;
    }
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMap::init">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 609,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMap::init")
  //</editor-fold>
  public void init(/*uint*/int InitBuckets) {
    if (allocateBuckets(InitBuckets)) {
      super.initEmpty();
    } else {
      NumEntries = 0;
      NumTombstones = 0;
    }
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMap::grow">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 618,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMap::grow")
  //</editor-fold>
  public void grow(/*uint*/int AtLeast) {
    /*uint*/int OldNumBuckets = NumBuckets;
    ${PAIR_TYPE}[] /*P*/ OldBuckets = Buckets;
    
    allocateBuckets(std.max(64, (/*static_cast*//*uint*/int)(NextPowerOf2(AtLeast - 1))));
    //((Buckets) ? (/*static_cast*/void)(0) : __assert_fail("Buckets", ${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", 623, __PRETTY_FUNCTION__));
    if (OldBuckets == null) {
      super.initEmpty();
      return;
    }
    
    this.moveFromOldBuckets(OldBuckets, OldNumBuckets);
    
    // Free the old table.
    //operator delete(OldBuckets);
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMap::shrink_and_clear">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 635,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMap::shrink_and_clear")
  //</editor-fold>
  public void shrink_and_clear() {
    /*uint*/int OldNumEntries = NumEntries;
    this.destroyAll();
    
    // Reduce the number of buckets.
    /*uint*/int NewNumBuckets = 0;
    if ((OldNumEntries != 0)) {
      NewNumBuckets = std.max(64, 1 << (Log2_32_Ceil(OldNumEntries) + 1));
    }
    if (NewNumBuckets == NumBuckets) {
      super.initEmpty();
      return;
    }
    
    //operator delete(Buckets);
    init(NewNumBuckets);
  }

/*private:*/
  @Override
  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMap::getNumEntries">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 653,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMap::getNumEntries")
  //</editor-fold>
  protected /*uint*/int getNumEntries() /*const*/ {
    return NumEntries;
  }

  @Override
  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMap::setNumEntries">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 656,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMap::setNumEntries")
  //</editor-fold>
  protected void setNumEntries(/*uint*/int Num) {
    NumEntries = Num;
  }

  @Override
  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMap::getNumTombstones">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 660,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMap::getNumTombstones")
  //</editor-fold>
  protected /*uint*/int getNumTombstones() /*const*/ {
    return NumTombstones;
  }

  @Override
  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMap::setNumTombstones">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 663,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMap::setNumTombstones")
  //</editor-fold>
  protected void setNumTombstones(/*uint*/int Num) {
    NumTombstones = Num;
  }

  @Override
  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMap::getBuckets">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 667,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMap::getBuckets")
  //</editor-fold>
  protected type$ptr<${PAIR_TYPE}> /*P*/ getBuckets() /*const*/ {
    return create_type$ptr(Buckets);
  }

  @Override
  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMap::getBuckets">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 667,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMap::getBuckets")
  //</editor-fold>
  protected ${PAIR_TYPE}[] /*P*/ $Buckets() /*const*/ {
    return Buckets;
  }

  @Override
  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMap::getNumBuckets">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 671,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMap::getNumBuckets")
  //</editor-fold>
  protected /*uint*/int getNumBuckets() /*const*/ {
    return NumBuckets;
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMap::allocateBuckets">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 675,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMap::allocateBuckets")
  //</editor-fold>
  private boolean allocateBuckets(/*uint*/int Num) {
    NumBuckets = (int)Num;
    if (NumBuckets == 0) {
      Buckets = ((${PAIR_TYPE}[])null);
      return false;
    }
    
    //    Buckets = (/*static_cast*/BucketT /*P*/ )(operator new(sizeof(BucketT) * NumBuckets));
    ${PAIR_TYPE} bucketsArray[] = new ${PAIR_NAME}[(int)NumBuckets];
    for (int i = 0; i < (int)NumBuckets; i++) {
      bucketsArray[i] = new ${PAIR_TYPE}();
    }
    Buckets = bucketsArray;
    
    return true;
  }

  @Override
  public Iterator<${PAIR_TYPE}> iterator() {
    return new JavaIterator<>(begin(), end());
  }

  @Override
  public String toString() {
    return "DenseMap{" + "Buckets=[\n" + Arrays.toString(Buckets) + "\n], NumEntries=" + NumEntries + ", NumTombstones=" + NumTombstones + ", NumBuckets=" + NumBuckets + '}';
  }  

}
