/*
* MyGoGrinder - a program to practice Go problems
* This class' code copyright (c): Ruediger Klehn (2015)
* Portions Copyright (c) 2004-2006 Tim Kington
*   timkington@users.sourceforge.net
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*
*/

/**
*@author Ruediger Klehn
*/
package GoGrinder;

import java.awt.Component;
import java.io.*;
import javax.swing.*; // JFileChooser, ConfirmDialog, MessageDialog, ...
import java.nio.channels.FileChannel;
import java.nio.charset.*;


import GoGrinder.Main;

// all file reading and writing is going to be done here
public class FileWReadWrite {
private static String NL = Main.NL;
private static String msg = "";
private static boolean moan = true; // usually moaning is ok, but there are cases, where we just work on

public FileWReadWrite() {/*NOTHING*/}
  
  public static String readFileLine(File pathToFileF){ // at the moment only used for the ".mygogrinder.ini"
    return readFileLine(pathToFileF.getPath(), Charset.defaultCharset().toString());
  } // no problem: Charset depends on the installation
 
   // CharsetWorks, GS, Main, (ProbData), (TagsExpImp)
  public static String readFileLine(String pathToFile){ // CharsetWorks, GS, Main, (ProbData), TagsExpImp
    return readFileLine(pathToFile, GS.getMyDefaultCharset());
  }

  public static String readFileLineDefaultCharset(String pathToFile){
    return readFileLine(pathToFile, Charset.defaultCharset().toString());
  }

  public static String readFileLineDefaultCharsetDontMoan(String pathToFile){
    moan = false;
    return readFileLine(pathToFile, Charset.defaultCharset().toString());
  }

  public static String readFileLine(String pathToFile, String useCharset){  // CHANGE TO UTF-8 (?)
    File pathToFileF = new File(pathToFile);
    String theReadLine = "";
      try {
        BufferedReader in = new BufferedReader(new InputStreamReader(
                                         new FileInputStream(pathToFile), useCharset)); // ###### useCharset
        in.mark(new Long(pathToFileF.length()).intValue() + 1);
        theReadLine = in.readLine(); // we read only one line
        if( theReadLine == null ){ // EOF, empty file
          theReadLine = "";
        }
        in.close();
      }
      catch(IOException e) { // file not found, not allowed to read etc.
        if(!moan){moan = true; return null;}
        String stackTop = NL + "Happened where (~): " + e.getStackTrace()[0];
        msg = "Problem with file \"" + pathToFile + "\"." + NL
                                          + e.getMessage() + NL
                                          + "Read " + Main.commonLogFilePath;
        if(Main.DEBUG6) msg = msg + stackTop;
        JOptionPane.showMessageDialog(null, msg);
        //Message: should be done by the caller
        Main.logSilent(e);
        theReadLine = "";
      }
    moan = true;
    return theReadLine;
  }
 
  public static String[] readFileLines(String readThisFile){ //######### UTF-8
     return readFileLines(readThisFile, GS.getMyDefaultCharset());
   }

  public static String[] readFileLines(File readThisFileF, String useCharset){ //######### UTF-8
     return readFileLines(readThisFileF.getPath(), useCharset);
   }
  
  // TagsExpImp, GS
  public static String[] readFileLines(String readThisFile, String useCharset){ // ? max line length ? // READY
    File readThisFileF = new File(readThisFile);
    String oneLineRead;
    String[] linesRead = null; //WORKING TRICK against "might not have been initialized"
    int lineCounter = 0;
    if (!readThisFileF.isFile() || !readThisFileF.canRead() || readThisFileF.length() == 0){
      String stackTop = NL + "Happened where (~): " + new Exception().getStackTrace()[0];
      msg = "File not found, not allowed to read file or file without content:" + NL
          + readThisFile;
      if(Main.DEBUG6) msg = msg + stackTop;
      JOptionPane.showMessageDialog(null, msg);
      linesRead = new String[1]; linesRead[0] = "";
      return linesRead;
    }
    else{
      try { // maybe there is a more elegant way to fill a string array from a file - I don't know that way
        BufferedReader inFromFile = new BufferedReader(new InputStreamReader(
                                         new FileInputStream(readThisFile), useCharset)); 
        inFromFile.mark(new Long(readThisFileF.length()).intValue() + 1); // mark wants int, length is long
        while (true){ // first count lines in file
          oneLineRead = inFromFile.readLine();
          if( oneLineRead == null ){
            break;
          }
          lineCounter++;
        }
        linesRead = new String[lineCounter]; // set array length
        inFromFile.reset(); // jump back to begin of file (previously marked)
        for (int i = 0; i < lineCounter ; i++){
          linesRead[i] = inFromFile.readLine(); // read lines from file into array
        }
        inFromFile.close();
      }
      catch(IOException e) {
        String stackTop = NL + "Happened where (~): " + e.getStackTrace()[0];
        msg = "Problem with reading file \"" + readThisFile + "\". " + NL
                                          + e.getMessage() + NL
                                          + "Read " + Main.commonLogFilePath;
        if(Main.DEBUG6) msg = msg + stackTop;
        JOptionPane.showMessageDialog(null, msg);
        Main.logSilent(e);
      }
    }
    return linesRead;
  }
  
// REWORK THIS!
  public static String readFileStrCharset(String pathToFile, String useCharset){ // ChangeCharacterSet, Probdata
    return new String(readFileStrBuffCharset(pathToFile, useCharset));
  }



  public static String readFileStrCharset(File pathToFileF, String useCharset){ // READY
    return new String(readFileStrBuffCharset(pathToFileF.toString(), useCharset));
  }
  
  public static StringBuffer readFileStrBuffCharset(File pathToFileF, String useCharset){
    return readFileStrBuffCharset(pathToFileF.toString(), useCharset);
  }
  
  // a unicode capable reader - and we can switch encoding
  public static StringBuffer readFileStrBuffCharset(String pathToFile, String useCharset){    //STUB
    File pathToFileF = new File(pathToFile);
    String msg = "";
    try {
      BufferedReader in = new BufferedReader(new InputStreamReader(
                        new FileInputStream(pathToFileF), useCharset));
      int len = (int)pathToFileF.length(); // File.length() is type "long" - converted ~on-the-fly to "int"
      StringBuffer giveBack = new StringBuffer(len);
      String line;
      while((line = in.readLine()) != null) {
        giveBack.append(line + NL); // "\n" "\r\n" is for e.g. comments of the sgf
      }
      in.close();
      return giveBack;
    } // would be nice to catch all exceptions in one and handle them in an extra class FileExceptions or similar
    catch(FileNotFoundException e) {
      String stackTop = NL + "Happened where (~): " + e.getStackTrace()[0];
      msg = "File not found:" + NL
           + pathToFileF.getAbsolutePath();
      if(Main.DEBUG6) msg = msg + stackTop;
      JOptionPane.showMessageDialog(null, msg);
      msg = "In FileWReadWrite.readFileStrCharset: " + msg;
      Main.logSilent(msg);
    }
    catch(UnsupportedEncodingException uee){
      String stackTop = NL + "Happened where (~): " + uee.getStackTrace()[0];
      msg = "Read file, unsupported encoding exception: >" + useCharset + "<" + NL
          + "File is:" + NL
          + pathToFileF.getPath(); // this shouldn't happen, as we test the charset string (-> CharsetWorks)
                                   // or we got it from Java itself
      if(Main.DEBUG6) msg = msg + stackTop;
      JOptionPane.showMessageDialog(null, msg);
      msg = "In FileWReadWrite.readFileStrCharset: " + msg;
      Main.logSilent(uee, msg); // in the log this will give an irritating msg
    }
    catch(IOException e) {
      String stackTop = NL + "Happened where (~): " + e.getStackTrace()[0];
      msg = "IOException while trying to read:" + NL
            + pathToFileF.getAbsolutePath();
      if(Main.DEBUG6) msg = msg + stackTop;
      JOptionPane.showMessageDialog(null, msg); 
      Main.logSilent(new Exception("In FileWReadWrite.readFileStrCharset: " + msg));
                          
    }
    return new StringBuffer(""); // we only pass here, if there were errors while reading; and in the calling class we decide, what to do with this
  }
  
  
  
// ################################# WRITE #####################################
    // read and write file in Java uses usually the OS's default decoding (and in Windows this is seldom UTF-8) 
    // warnOverwrite etc should be done by the caller

  // for writing the log file(s) // writeFileAddStrBuff !!
  public static boolean writeFileAddStringBufferUTF8(String pathToFile, StringBuffer addThis){  // CHANGE TO UTF-8 only sgflog
    try {
      FileOutputStream stream = new FileOutputStream(pathToFile, true); // true = append
      stream.write(addThis.toString().getBytes("UTF-8"));
      stream.close();
//    BufferedWriter out = new BufferedWriter(new OutputStreamWriter(
//        new FileOutputStream(pathToFile),Charset.forName("UTF-8").newEncoder()));
//    out.append(addThis);
//      PrintWriter out = new PrintWriter(new FileWriter(pathToFile, true)); // true = append
//      out.print(addThis); // up to here it works nearly good, but ... (Unicode etc.)
     // before writing, we need to test the StringBuffer for unicode characters and 
     // if found, we need to create or convert to a Unicode text file (?? java.nio...??)
//      out.close();  
    }
    catch(UnsupportedEncodingException uee){
      String stackTop = NL + "Happened where (~): " + uee.getStackTrace()[0];
      msg = "Unsupported encoding exception: " + "UTF-8" + NL
          + "File is: " + pathToFile;
      if(Main.DEBUG6) msg = msg + stackTop;
      JOptionPane.showMessageDialog(null, msg);
      Main.logSilent(uee, msg); // in the log this will give an irritating msg
      return false;
    }
    catch(IOException e) {
      String stackTop = NL + "Happened where (~): " + e.getStackTrace()[0];
      String msg = "Error saving to \" " + pathToFile + "\"" + NL
                  + "Please check the path and a possibly existing file "
                  + "(read only, folder rights, ...) " + NL 
                  + e.getMessage() + NL;
      if(Main.DEBUG6) msg = msg + stackTop;
      JOptionPane.showMessageDialog(null, msg + "Read " + Main.commonLogFilePath);
      ExceptionHandler.logFileWriteProblem(e, msg);
      return false;
    }
    //catch (FileNotFoundException fnfe){/*HERE SHOULD HAPPEN SOMETHING*/ d.b.g("FILE MISSING (addStrBuff)");}
//    finally {try{stream.close();}catch (Exception e){/*HERE SHOULD HAPPEN SOMETHING*/ d.b.g("FILE MISSING (addStrBuff)");}
    //finally {out.close();}
    return true;
  }
 
  // for writing the log file(s)   // CHANGE TO UTF-8 // nur in sgflog
  public static boolean writeFileAddStringUTF8(String pathToFile, String addThis){ // FileWriter(String fileName, boolean append)
                                                           //  , String useCharset
  // but needs append=true
    try {
      FileOutputStream stream = new FileOutputStream(pathToFile, true); // true = append
      stream.write(addThis.getBytes("UTF-8")); // toString().getBytes()
      stream.close();
//      BufferedWriter out = new BufferedWriter(new OutputStreamWriter(
//        new FileOutputStream(pathToFile),Charset.forName("UTF-8").newEncoder()));
//      out.append(addThis);

//      PrintWriter out = new PrintWriter(new FileWriter(pathToFile, true)); // true = append
//      out.println(addThis); // up to here it works nearly good, but ... (Unicode)
    }
    catch(UnsupportedEncodingException uee){
      String stackTop = NL + "Happened where (~): " + uee.getStackTrace()[0];
      msg = "Unsupported encoding exception: " + "UTF-8" + NL
          + "File is: " + pathToFile;
      if(Main.DEBUG6) msg = msg + stackTop;
      JOptionPane.showMessageDialog(null, msg);
      Main.logSilent(uee, msg); // in the log this will give an irritating msg
      return false;
    }
    catch(IOException e) {
      String stackTop = NL + "Happened where (~): " + e.getStackTrace()[0];
      msg = "Error saving to \" " + pathToFile + "\"" + NL
          + "Please check the path and a possibly existing file (read only, folder rights, ...) " + NL 
          + e.getMessage() + NL;
      if(Main.DEBUG6) msg = msg + stackTop;
      JOptionPane.showMessageDialog(null, msg + "Read grindlog.txt");
                                    // logErrorsPath 
      ExceptionHandler.logFileWriteProblem(e, msg);
      return false;
    }
   
    //finally {out.close();}
    return true;
  }

// CharsetWorks, Main, Messages, (ProbData), SettingsDialog (f. tmpSgf)
  public static boolean writeFileLine(String pathToFile, String myString){ // CHANGE TO UTF-8
    try {
      PrintWriter out = new PrintWriter(new FileWriter(pathToFile));
      
      out.println(myString); // up to here it works nearly good, but ... (Unicode)
      out.close(); 
    }
    catch(IOException e) {
      String stackTop = NL + "Happened where (~): " + e.getStackTrace()[0];
      JOptionPane.showMessageDialog(null, "Error saving to \"" + pathToFile + "\"" + NL
                                    + "Please check the path and a possibly existing file (read only, folder rights, ...) " + NL 
                                    + e.getMessage() + NL
                                    + "Read " + Main.commonLogFilePath);
      if(Main.DEBUG6) msg = msg + stackTop;
      return false;
    }
    //finally {out.close();}
    return true;
  }

  public static boolean writeFileLines(String pathToFile, String[] writeThisArray){ // NOT YET
    d.b.g("NOT YET");
    return true;
  }
  
  public static boolean writeFileStrBuff(String pathToFile, StringBuffer StrBuff){
    return writeFileStrBuff (pathToFile, StrBuff, GS.getMyDefaultCharset()); // Charset: if not set, this is just the OS's default
  }

  public static boolean writeFileStrBuff(File pathToFileF, StringBuffer StrBuff, String useCharset){
    return writeFileStrBuff(pathToFileF.toString(), StrBuff, useCharset);
  }
  
  public static boolean writeFileStrBuff(String pathToFile, StringBuffer StrBuff, String useCharset){
    boolean appendToFile = false; 
    return writeFileStrBuff(pathToFile, StrBuff, useCharset, appendToFile);
  }

// use this for string? string to stringbuffer?
  public static boolean writeFileStrBuff(String pathToFile, StringBuffer StrBuff, String useCharset, boolean appendToFile){ // GS, TagsExpImp, (sgflog? - then append = true)
    
    try { // warnOverwrite etc should be done by the caller
      PrintWriter out = new PrintWriter(new OutputStreamWriter(
                      new FileOutputStream(pathToFile), useCharset));
      
      out.print(StrBuff);
      out.close(); 
    }
    catch(UnsupportedEncodingException uee){
      String stackTop = NL + "Happened where (~): " + uee.getStackTrace()[0];
      msg = "Unsupported encoding exception: " + useCharset + NL
          + "File is: " + pathToFile;
      if(Main.DEBUG6) msg = msg + stackTop;
      JOptionPane.showMessageDialog(null, msg);
      Main.logSilent(uee, msg); // in the log this will give an irritating msg
      return false;
    }
    catch(IOException e) {
      String stackTop = NL + "Happened where (~): " + e.getStackTrace()[0];
      msg = "Error saving to \" " + pathToFile + "\"" + NL
          + "Please check the path and a possibly existing file "
          + "(read only, folder rights, ...) " + NL 
          + e.getMessage() + NL;
               // logErrorsPath
      if(Main.DEBUG6) msg = msg + stackTop;
      JOptionPane.showMessageDialog(null, msg + "Read " + Main.commonLogFilePath);
      ExceptionHandler.logFileWriteProblem(e, msg);
      return false;
    }
    catch(Exception e) {
      String stackTop = NL + "Happened where (~): " + e.getStackTrace()[0];
      msg = "Any other exception while trying to write file:"+ NL
           + pathToFile;
      if(Main.DEBUG6) msg = msg + stackTop;
      JOptionPane.showMessageDialog(null, msg + "Read " + Main.commonLogFilePath);
      ExceptionHandler.logFileWriteProblem(e, msg);
      return false;
    }
    //finally {out.close();} - needs try catch!
    return true;
  }
  
  public static boolean writeFileStrCharset(String pathToFile, String writeThis, String useCharset){
    return writeFileStrBuff(pathToFile, new StringBuffer(writeThis), useCharset);
  }
  
  public static boolean writeFileStrCharset(File pathToFileF, String writeThis, String useCharset){ // NOT USED
   return writeFileStrBuff(pathToFileF.toString(), new StringBuffer(writeThis), useCharset);
  }
  
// ################################## COPY #####################################
  public static boolean copyFile(String source, String target){
      // need check if exists, is not directory or cannot be opened for reading/writing file
    try{
      File sourceF = new File(source);
      if (!sourceF.exists() || sourceF.isDirectory() || !sourceF.canRead()) {
        String stackTop = NL + "Happened where (~): " + new Exception().getStackTrace()[0];
        msg = "Sorry (copy file, problem with source)." + NL + source;
        if(Main.DEBUG6) msg = msg + stackTop;
        JOptionPane.showMessageDialog(null, msg + "Read " + Main.commonLogFilePath);
        Main.logSilent(msg + source); // we should have the stacktop for the log file (and, with DEBUG, the full stacktrace)
        return false;
      }
      File targetF = new File(target);
      if (targetF.isDirectory() || !targetF.getParentFile().canWrite()){
        String stackTop = NL + "Happened where (~): " + new Exception().getStackTrace()[0];
        msg = "Sorry (copy file, problem with target)." + NL + target;
        if(Main.DEBUG6) msg = msg + stackTop;
        JOptionPane.showMessageDialog(null, msg + "Read " + Main.commonLogFilePath);
        Main.logSilent(msg + target); // we should have the stacktop for the log file (and, with DEBUG, the full stacktrace)
        return false;
      }

      FileInputStream sourceStr = new FileInputStream(source);
      FileOutputStream targetStr = new FileOutputStream(target);
      FileChannel inChan = sourceStr.getChannel();
      FileChannel outChan = targetStr.getChannel();

      inChan.transferTo(0, inChan.size(), outChan);

      outChan.close();
      inChan.close();
    }
    catch(Exception e){
      String stackTop = NL + "Happened where (~): " + e.getStackTrace()[0];
      msg = "Problem while trying to copy file. " + NL
                               + "From: " + source
                               + "To: " + target;
      if(Main.DEBUG6) msg = msg + stackTop;
      JOptionPane.showMessageDialog(null, msg + "Read " + Main.commonLogFilePath);
      Main.logSilent(e, msg); // msg: here used for filename
      // should be enough to have the stacktop for the log file (and, with DEBUG, the full stacktrace)
      return false;
    }
    return true;
  }
  
  //copy und move in FileWCpMv!! moveFile(String source, String target){} // File has method boolean rename()
  
}