/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.openwire.codec.v7;

import java.io.IOException;
import org.apache.activemq.apollo.openwire.codec.BaseDataStreamMarshaller;
import org.apache.activemq.apollo.openwire.codec.BooleanStream;
import org.apache.activemq.apollo.openwire.codec.OpenWireFormat;
import org.apache.activemq.apollo.openwire.command.BrokerId;
import org.apache.activemq.apollo.openwire.command.DataStructure;
import org.apache.activemq.apollo.openwire.command.NetworkBridgeFilter;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;

public class NetworkBridgeFilterMarshaller
extends BaseDataStreamMarshaller {
    public byte getDataStructureType() {
        return 91;
    }

    public DataStructure createObject() {
        return new NetworkBridgeFilter();
    }

    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataByteArrayInputStream dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        NetworkBridgeFilter info = (NetworkBridgeFilter)o;
        info.setNetworkTTL(dataIn.readInt());
        info.setNetworkBrokerId((BrokerId)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
    }

    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        NetworkBridgeFilter info = (NetworkBridgeFilter)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        return (rc += this.tightMarshalCachedObject1(wireFormat, info.getNetworkBrokerId(), bs)) + 4;
    }

    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataByteArrayOutputStream dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        NetworkBridgeFilter info = (NetworkBridgeFilter)o;
        dataOut.writeInt(info.getNetworkTTL());
        this.tightMarshalCachedObject2(wireFormat, info.getNetworkBrokerId(), dataOut, bs);
    }

    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataByteArrayInputStream dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        NetworkBridgeFilter info = (NetworkBridgeFilter)o;
        info.setNetworkTTL(dataIn.readInt());
        info.setNetworkBrokerId((BrokerId)this.looseUnmarsalCachedObject(wireFormat, dataIn));
    }

    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataByteArrayOutputStream dataOut) throws IOException {
        NetworkBridgeFilter info = (NetworkBridgeFilter)o;
        super.looseMarshal(wireFormat, o, dataOut);
        dataOut.writeInt(info.getNetworkTTL());
        this.looseMarshalCachedObject(wireFormat, info.getNetworkBrokerId(), dataOut);
    }
}

