package org.cdavies.applerecords.table;

import javax.swing.table.*;
import javax.swing.*;
import java.awt.*;

public class TrackListTableRenderer extends DefaultTableCellRenderer {
	
	public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
		
		JLabel _component = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
		
		if (isSelected) {
			
			_component.setBackground(table.getSelectionBackground());
			_component.setForeground(table.getSelectionForeground());
			
		}
		else if (row%2 == 0) {
			
			_component.setBackground(table.getBackground());
			_component.setForeground(table.getForeground());
			
		}
		else {
			
			_component.setBackground(new Color(232, 232, 255));
			_component.setForeground(table.getForeground());
			
		}
		
		if (value instanceof Integer)
			_component.setHorizontalAlignment(SwingConstants.RIGHT);
		
		return _component;
		
	}
	
}
