/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.hdf5lib.exceptions;

import ch.systemsx.cisd.hdf5.hdf5lib.H5General;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import org.apache.commons.io.FileUtils;

public class HDF5LibraryException
extends HDF5Exception {
    private static final int UNKNOWN = -1;
    private static final long serialVersionUID = 1L;
    private final int majorErrorNumber;
    private final int minorErrorNumber;
    private final String majorErrorMessage;
    private final String minorErrorMessage;
    private final String hdf5ErrorStackString;
    private final String hdf5ErrorStackLastElementString;

    public HDF5LibraryException(int majorErrorNumber, String majorErrorMessage, int minorErrorNumber, String minorErrorMessage) {
        super(String.valueOf(majorErrorMessage) + ":" + minorErrorMessage);
        try {
            H5General.H5open();
        }
        catch (Exception exception) {}
        this.majorErrorNumber = majorErrorNumber;
        this.majorErrorMessage = majorErrorMessage;
        this.minorErrorNumber = minorErrorNumber;
        this.minorErrorMessage = minorErrorMessage;
        this.hdf5ErrorStackString = this.retrieveHDF5ErrorStackAsString();
        this.hdf5ErrorStackLastElementString = HDF5LibraryException.getLastErrorStackElement(this.hdf5ErrorStackString);
    }

    private static String getLastErrorStackElement(String hdf5ErrorStackString) {
        int idx = hdf5ErrorStackString.length() - 3;
        int lastLineBreakIdx = hdf5ErrorStackString.length();
        while (--idx > 0) {
            if (hdf5ErrorStackString.charAt(idx) == '\n') {
                lastLineBreakIdx = idx;
            }
            if (!hdf5ErrorStackString.substring(idx - 1, idx + 3).equals("\n  #")) continue;
            idx += 3;
            while (idx < hdf5ErrorStackString.length() && hdf5ErrorStackString.charAt(idx) != ' ') {
                ++idx;
            }
            return hdf5ErrorStackString.substring(idx + 1, lastLineBreakIdx);
        }
        return null;
    }

    public HDF5LibraryException(String errorMessage) {
        super(errorMessage);
        try {
            H5General.H5open();
        }
        catch (Exception exception) {}
        this.majorErrorNumber = -1;
        this.majorErrorMessage = errorMessage;
        this.minorErrorNumber = -1;
        this.minorErrorMessage = "";
        this.hdf5ErrorStackString = "No error stack";
        this.hdf5ErrorStackLastElementString = null;
    }

    @Override
    public String getMessage() {
        if (this.hdf5ErrorStackLastElementString != null) {
            return String.valueOf(super.getMessage()) + " [\"" + this.hdf5ErrorStackLastElementString + "\"]";
        }
        return super.getMessage();
    }

    public int getMajorErrorNumber() {
        return this.majorErrorNumber;
    }

    public String getMajorError() {
        return this.majorErrorMessage;
    }

    public int getMinorErrorNumber() {
        return this.minorErrorNumber;
    }

    public String getMinorError() {
        return this.minorErrorMessage;
    }

    private String retrieveHDF5ErrorStackAsString() {
        String string;
        File tempFile = File.createTempFile("HDF5_error_stack", ".txt");
        try {
            this.printStackTrace0(tempFile.getPath());
            string = FileUtils.readFileToString(tempFile).trim();
            tempFile.delete();
        }
        catch (Throwable throwable) {
            try {
                tempFile.delete();
                throw throwable;
            }
            catch (IOException ex) {
                System.err.println("Cannot create error stack file.");
                ex.printStackTrace();
                return null;
            }
        }
        return string;
    }

    public String getHDF5ErrorStackAsString() {
        return this.hdf5ErrorStackString;
    }

    @Override
    public void printStackTrace() {
        System.err.println(this.getHDF5ErrorStackAsString());
        super.printStackTrace();
    }

    public void printStackTrace(File f) {
        if (f == null || !f.exists() || f.isDirectory() || !f.canWrite()) {
            this.printStackTrace();
        } else {
            try {
                FileOutputStream o = new FileOutputStream(f);
                PrintWriter p = new PrintWriter(o);
                p.println(this.getHDF5ErrorStackAsString());
                super.printStackTrace(p);
                p.close();
            }
            catch (Exception exception) {
                System.err.println(this);
            }
        }
    }

    private native void printStackTrace0(String var1);
}

