/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.util.barcode;

import it.unimi.dsi.lang.MutableString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.campagnelab.goby.util.barcode.BarcodeMatcher;
import org.campagnelab.goby.util.barcode.BarcodeMatcherResult;
import org.campagnelab.goby.util.barcode.OverlapResult;

public class PreBarcodeMatcher
extends BarcodeMatcher {
    private static final Log LOG = LogFactory.getLog(PreBarcodeMatcher.class);

    public PreBarcodeMatcher(String[] barcodesStrArray, int barcodeLength, int allowedMismatches) {
        this.init(barcodesStrArray, barcodeLength, allowedMismatches);
    }

    @Override
    BarcodeMatcherResult bestMatch(MutableString sequence, MutableString toFind, int barcodeIndex, int minMatchLength) {
        int overlapLength = Math.min(sequence.length(), toFind.length());
        int leastNumDiffs = Integer.MAX_VALUE;
        int leastNumDiffsMatchedBarcodeLength = 0;
        int pos = 0;
        int matchLength = overlapLength;
        while (matchLength >= minMatchLength) {
            int numDiffs = this.numDifferences(sequence, toFind, 0, 0, matchLength);
            if (numDiffs <= leastNumDiffs) {
                leastNumDiffs = numDiffs;
                leastNumDiffsMatchedBarcodeLength = matchLength;
                if (leastNumDiffs == 0) break;
            }
            --matchLength;
            ++pos;
        }
        int actualSequenceLength = sequence.length() - leastNumDiffsMatchedBarcodeLength;
        return new BarcodeMatcherResult(barcodeIndex, leastNumDiffs, leastNumDiffsMatchedBarcodeLength, actualSequenceLength, 0, leastNumDiffsMatchedBarcodeLength);
    }

    OverlapResult overlapPortion(MutableString sequence, MutableString toFind) {
        return new OverlapResult(0, Math.min(sequence.length(), toFind.length()));
    }
}

