#---------------------------------------------------------------
# (5) The keyboard
#---------------------------------------------------------------
# The keys, index NS means row N, shift status S (u=unshifted, s=shifted)
set keys(d1u) {` 1 2 3 4 5 6 7 8 9 0 =}
set keys(d1s) {~ ! @ # $ % ^ & * ( ) +}
set keys(d2u) {"" ' , . p y f g c r l /}
set keys(d2s) {"" \" < > P Y F G C R L ?}
set keys(d3u) {"" a o e u i d h t n s -}
set keys(d3s) {"" A O E U I D H T N S _}
set keys(d4u) {"" ; q j k x b m w v z ""}
set keys(d4s) {"" : Q J K X B M W V Z ""}
set keys(d5u) {\\ " " [ ]}
set keys(d5s) {| " " \{ \}}
set keys(q1u) {= 1 2 3 4 5 6 7 8 9 0 -}
set keys(q1s) {+ ! @ # $ % ^ & * ( ) _}
set keys(q2u) {"" q w e r t y u i o p \\}
set keys(q2s) {"" Q W E R T Y U I O P |}
set keys(q3u) {"" a s d f g h j k l ; '}
set keys(q3s) {"" A S D F G H J K L : \"}
set keys(q4u) {"" z x c v b n m , . / ""}
set keys(q4s) {"" Z X C V B N M < > ? ""}
set keys(q5u) {` " " [ ]}
set keys(q5s) {~ " " \{ \}}
# The list of keys, unshifted and shifted versions
set gap(d) {6 f d b " "} ;# the "gap" comes to the left of these keys
set gap(q) {6 y h n " "}
set homekeys(d) {[aoeuhtns]}
set homekeys(q) {[asdfjkl;]}

#---------------------------------------------------------------
# Precedure: ishomeposition {c}
#  Returns 1 if key is home position
#---------------------------------------------------------------
proc ishomeposition {c} {
    global homekeys
    if [regexp -nocase $homekeys([keyboardtype]) "$c"] {
	return 1
    } else {
	return 0
    }
}

#---------------------------------------------------------------
# Precedure: makekeyboard {}
#  Make physical keyboard
#---------------------------------------------------------------
proc makekeyboard {} {
    global keys keylistpu keylistps gap backgroundhome numkeys
    set type [physicalkeyboardtype]
    set p 0 ;# holds index to list
    set keylistpu {}
    set keylistps {}
    foreach i {1 2 3 4 5} {
	if {! [winfo exists .rowframe$i]} {
	    frame .rowframe$i -relief groove -bd 2
	}
	if [winfo exists .row$i] {
	    destroy [pack slaves .row$i]
	    destroy .row$i
	}
	frame .row$i
	pack .row$i -in .rowframe$i -pady 4 -anchor c
	set j 0
	foreach letter $keys(${type}${i}u) {
	    frame .frame$p -relief raised -borderwidth 4
	    if {$letter == " "} {
		label .key$p -width 20
	    } else {
		label .key$p -width 3
	    }
	    if {"$letter" != ""} {
		if [ishomeposition $letter] {
		    .key$p configure -background "$backgroundhome"
		}
		if {[lsearch $gap($type) "$letter"] != -1} {
		    frame .row$i.mid -width 8
		    pack .row$i.mid -side left
		}
	    }
	    pack .key$p -in .frame$p -pady 0
	    pack .frame$p -side left -padx 2 -ipadx 0 -in .row$i
	    lappend keylistpu $letter
	    lappend keylistps [lindex "$keys(${type}${i}s)" $j]
	    incr p
	    incr j
	}
	if {! [winfo ismapped .rowframe$i]} {
	    pack .rowframe$i -side top -fill x -padx 4
	}
    }
    set numkeys $p
}

makekeyboard
pack [frame .dummy -height 4] -side top

#---------------------------------------------------------------
# Procedure: remapkeys {# # #}
# Traces: keyboard
#  Remaps the keyboard
#---------------------------------------------------------------
proc remapkeys {name element op} {
    global keylistu keylists numkeys keys
    set keylistu {}
    set keylists {}
    set type [keyboardtype]
    foreach i {1 2 3 4 5} {
	set j 0
	foreach letter $keys(${type}${i}u) {
	    lappend keylistu $letter
	    lappend keylists [lindex "$keys(${type}${i}s)" $j]
	    incr j
	}
    }
    redrawkeys
}
trace variable keyboard w remapkeys

#---------------------------------------------------------------
# Procedure: redrawkeys
#  Redraws the keyboard
#---------------------------------------------------------------
proc redrawkeys {} {
    global keys foreground background backgroundhome prevnextindex
    set type [keyboardtype]
    set p 0
    foreach i {1 2 3 4 5} {
	foreach letter $keys(${type}${i}u) {
	    if [showkeytopp] {
		.key$p configure -text "$letter"
	    } else {
		.key$p configure -text ""
	    }
	    if [ishomeposition $letter] {
		.key$p configure -foreground "$foreground" \
			-background "$backgroundhome"
	    } else {
		.key$p configure -foreground "$foreground" \
			-background "$background"
	    }
	    .frame$p configure -relief raised
	    incr p
	}
    }
    set prevnextindex -1
    retag
}

#---------------------------------------------------------------
# Procedure: getrow {row}
#  Returns all letters in specified row
#---------------------------------------------------------------
proc getrow {row} {
    global keys
    regsub -all {[^A-Za-z0-9,.]} [join $keys([keyboardtype]${row}u) ""] "" tmp
    return "$tmp"
}

# don't need this for now
# set fp [open "| xmodmap -pk | grep 0x0041" r]
# regsub {^[ \t]*([0-9]+)[ \t].*} [gets $fp] {\1} keycodea
# puts $keycodea
# close $fp
