/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.commons;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.wiztools.commons.Charsets;
import org.wiztools.commons.HexEncodeUtil;

public final class DigestUtil {
    private DigestUtil() {
    }

    public static String digest(byte[] inBytes, String algo) {
        try {
            MessageDigest md = MessageDigest.getInstance(algo);
            md.reset();
            md.update(inBytes);
            byte[] outBytes = md.digest();
            return HexEncodeUtil.bytesToHex(outBytes);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String md5hex(String str) {
        return DigestUtil.digest(str.getBytes(Charsets.UTF_8), "MD5");
    }

    public static String md5hex(byte[] bytes) {
        return DigestUtil.digest(bytes, "MD5");
    }

    public static String sha1hex(String str) {
        return DigestUtil.digest(str.getBytes(Charsets.UTF_8), "SHA-1");
    }

    public static String sha1hex(byte[] bytes) {
        return DigestUtil.digest(bytes, "SHA-1");
    }

    public static String sha256hex(String str) {
        return DigestUtil.digest(str.getBytes(Charsets.UTF_8), "SHA-256");
    }

    public static String sha256hex(byte[] bytes) {
        return DigestUtil.digest(bytes, "SHA-256");
    }

    public static String sha512hex(String str) {
        return DigestUtil.digest(str.getBytes(Charsets.UTF_8), "SHA-512");
    }

    public static String sha512hex(byte[] bytes) {
        return DigestUtil.digest(bytes, "SHA-512");
    }
}

