# -*- encoding: utf8 -*-

require File.dirname(__FILE__) + '/helper.rb'

class TestNamedRGB < Test::Unit::TestCase

  ColorName = Color::RGB::JP::Base::ColorName
  NamedRGB = Color::RGB::JP::Base::NamedRGB

  def setup
    @name = ColorName.new("SakuraIro", "桜色", "さくらいろ", "サクライロ", "sakura-iro")
    @rgb = Color::RGB.from_html("abcABC")
    @named_rgb = NamedRGB.new(@name, @rgb)
  end

  def test_new_and_accessor
    assert_same(@name, @named_rgb.name)
    assert_same(@rgb, @named_rgb.rgb)
  end

  def test_to_s
    assert_equal("sakura-iro (#abcabc)", @named_rgb.to_s)
  end

end
