# This defines an ircII-like /lastlog command.
# Written by Dave Kamholz <davekam@sojourn.com> and
# Thomas Morgan <tmorgan@pobox.com>

$add_ons .= '+lastlog.pl' if $add_ons !~ /\+lastlog\.pl/;

$set{"LASTLOGLEN"} = 40;

sub hook_lastlog
{
  splice (@lastlog, 0, $#lastlog + 1 - $set{"LASTLOGLEN"})
      if $#lastlog + 1 >= $set{"LASTLOGLEN"};
  push (@lastlog, "$_[0]\n");
}
&addhook ("print", "lastlog");

sub cmd_lastlog
{
  print ("*\cbL\cb* Start of lastlog.\n");

  if ($args)
    {
      eval { print (grep (/$args/, @lastlog)); };
      chop ($@), &tell ("*\cbE\cb* $@") if $@ ne '';
    }
  else
    {
      print (join ('', @lastlog));
    }

  print ("*\cbL\cb* End of lastlog.\n");
}		      
&addcmd ("lastlog");

&addhelp ("lastlog", <<"EOF");
This prints the lastlog.  If there is an argument, it is a regular
expression which lines must match to be printed.
EOF

sub set_lastloglen
{
  splice (@lastlog, 0, ($#lastlog + 1) - $_[0])
      if $_[0] < $set{"LASTLOGLEN"};
  $set{"LASTLOGLEN"} = $_[0];
}
&addset ("lastloglen", "lastloglen");

&addhelp ("set lastloglen", <<"EOF");
This is the number of lines to be contained in the lastlog at the same
time.  It defaults to 40.
EOF
