/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dht;

import edu.emory.mathcs.jtransforms.dht.FloatDHT_1D;
import edu.emory.mathcs.jtransforms.dht.FloatDHT_2D;
import edu.emory.mathcs.jtransforms.dht.FloatDHT_3D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import edu.emory.mathcs.utils.IOUtils;

public class BenchmarkFloatDHT {
    private static int nthread = 2;
    private static int nsize = 6;
    private static int niter = 200;
    private static boolean doWarmup = true;
    private static int initialExponent1D = 17;
    private static int initialExponent2D = 7;
    private static int initialExponent3D = 2;
    private static boolean doScaling = false;

    private BenchmarkFloatDHT() {
    }

    public static void parseArguments(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println("args[" + i + "]:" + stringArray[i]);
        }
        if (stringArray == null || stringArray.length != 10) {
            System.out.println("Parameters: <number of threads> <THREADS_BEGIN_N_2D> <THREADS_BEGIN_N_3D> <number of iterations> <perform warm-up> <perform scaling> <number of sizes> <initial exponent for 1D transforms> <initial exponent for 2D transforms> <initial exponent for 3D transforms>");
            System.exit(-1);
        }
        nthread = Integer.parseInt(stringArray[0]);
        ConcurrencyUtils.setThreadsBeginN_2D(Integer.parseInt(stringArray[1]));
        ConcurrencyUtils.setThreadsBeginN_3D(Integer.parseInt(stringArray[2]));
        niter = Integer.parseInt(stringArray[3]);
        doWarmup = Boolean.parseBoolean(stringArray[4]);
        doScaling = Boolean.parseBoolean(stringArray[5]);
        nsize = Integer.parseInt(stringArray[6]);
        initialExponent1D = Integer.parseInt(stringArray[7]);
        initialExponent2D = Integer.parseInt(stringArray[8]);
        initialExponent3D = Integer.parseInt(stringArray[9]);
        ConcurrencyUtils.setNumberOfProcessors(nthread);
    }

    public static void benchmarkForward_1D(int n) {
        int[] nArray = new int[nsize];
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            int n2;
            int n3 = n + i;
            nArray[i] = n2 = (int)Math.pow(2.0, n3);
            System.out.println("Forward DHT 1D of size 2^" + n3);
            FloatDHT_1D floatDHT_1D = new FloatDHT_1D(n2);
            float[] fArray = new float[n2];
            if (doWarmup) {
                IOUtils.fillMatrix_1D(n2, fArray);
                floatDHT_1D.forward(fArray);
                IOUtils.fillMatrix_1D(n2, fArray);
                floatDHT_1D.forward(fArray);
            }
            float f = 0.0f;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_1D(n2, fArray);
                l = System.nanoTime();
                floatDHT_1D.forward(fArray);
                l = System.nanoTime() - l;
                f += (float)l;
            }
            dArray[i] = (double)f / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", (double)f / 1000000.0 / (double)niter) + " msec");
            fArray = null;
            floatDHT_1D = null;
            System.gc();
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatForwardDHT_1D.txt", nthread, niter, doWarmup, doScaling, nArray, dArray);
    }

    public static void benchmarkForward_2D_input_1D(int n) {
        int[] nArray = new int[nsize];
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            int n2;
            int n3 = n + i;
            nArray[i] = n2 = (int)Math.pow(2.0, n3);
            System.out.println("Forward DHT 2D (input 1D) of size 2^" + n3 + " x 2^" + n3);
            FloatDHT_2D floatDHT_2D = new FloatDHT_2D(n2, n2);
            float[] fArray = new float[n2 * n2];
            if (doWarmup) {
                IOUtils.fillMatrix_2D(n2, n2, fArray);
                floatDHT_2D.forward(fArray);
                IOUtils.fillMatrix_2D(n2, n2, fArray);
                floatDHT_2D.forward(fArray);
            }
            float f = 0.0f;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_2D(n2, n2, fArray);
                l = System.nanoTime();
                floatDHT_2D.forward(fArray);
                l = System.nanoTime() - l;
                f += (float)l;
            }
            dArray[i] = (double)f / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", (double)f / 1000000.0 / (double)niter) + " msec");
            fArray = null;
            floatDHT_2D = null;
            System.gc();
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatForwardDHT_2D_input_1D.txt", nthread, niter, doWarmup, doScaling, nArray, dArray);
    }

    public static void benchmarkForward_2D_input_2D(int n) {
        int[] nArray = new int[nsize];
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            int n2;
            int n3 = n + i;
            nArray[i] = n2 = (int)Math.pow(2.0, n3);
            System.out.println("Forward DHT 2D (input 2D) of size 2^" + n3 + " x 2^" + n3);
            FloatDHT_2D floatDHT_2D = new FloatDHT_2D(n2, n2);
            float[][] fArray = new float[n2][n2];
            if (doWarmup) {
                IOUtils.fillMatrix_2D(n2, n2, fArray);
                floatDHT_2D.forward(fArray);
                IOUtils.fillMatrix_2D(n2, n2, fArray);
                floatDHT_2D.forward(fArray);
            }
            float f = 0.0f;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_2D(n2, n2, fArray);
                l = System.nanoTime();
                floatDHT_2D.forward(fArray);
                l = System.nanoTime() - l;
                f += (float)l;
            }
            dArray[i] = (double)f / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", (double)f / 1000000.0 / (double)niter) + " msec");
            fArray = null;
            floatDHT_2D = null;
            System.gc();
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatForwardDHT_2D_input_2D.txt", nthread, niter, doWarmup, doScaling, nArray, dArray);
    }

    public static void benchmarkForward_3D_input_1D(int n) {
        int[] nArray = new int[nsize];
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            int n2;
            int n3 = n + i;
            nArray[i] = n2 = (int)Math.pow(2.0, n3);
            System.out.println("Forward DHT 3D (input 1D) of size 2^" + n3 + " x 2^" + n3 + " x 2^" + n3);
            FloatDHT_3D floatDHT_3D = new FloatDHT_3D(n2, n2, n2);
            float[] fArray = new float[n2 * n2 * n2];
            if (doWarmup) {
                IOUtils.fillMatrix_3D(n2, n2, n2, fArray);
                floatDHT_3D.forward(fArray);
                IOUtils.fillMatrix_3D(n2, n2, n2, fArray);
                floatDHT_3D.forward(fArray);
            }
            float f = 0.0f;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_3D(n2, n2, n2, fArray);
                l = System.nanoTime();
                floatDHT_3D.forward(fArray);
                l = System.nanoTime() - l;
                f += (float)l;
            }
            dArray[i] = (double)f / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", (double)f / 1000000.0 / (double)niter) + " msec");
            fArray = null;
            floatDHT_3D = null;
            System.gc();
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatForwardDHT_3D_input_1D.txt", nthread, niter, doWarmup, doScaling, nArray, dArray);
    }

    public static void benchmarkForward_3D_input_3D(int n) {
        int[] nArray = new int[nsize];
        double[] dArray = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            int n2;
            int n3 = n + i;
            nArray[i] = n2 = (int)Math.pow(2.0, n3);
            System.out.println("Forward DHT 3D (input 3D) of size 2^" + n3 + " x 2^" + n3 + " x 2^" + n3);
            FloatDHT_3D floatDHT_3D = new FloatDHT_3D(n2, n2, n2);
            float[][][] fArray = new float[n2][n2][n2];
            if (doWarmup) {
                IOUtils.fillMatrix_3D(n2, n2, n2, fArray);
                floatDHT_3D.forward(fArray);
                IOUtils.fillMatrix_3D(n2, n2, n2, fArray);
                floatDHT_3D.forward(fArray);
            }
            float f = 0.0f;
            long l = 0L;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_3D(n2, n2, n2, fArray);
                l = System.nanoTime();
                floatDHT_3D.forward(fArray);
                l = System.nanoTime() - l;
                f += (float)l;
            }
            dArray[i] = (double)f / 1000000.0 / (double)niter;
            System.out.println("Average execution time: " + String.format("%.2f", (double)f / 1000000.0 / (double)niter) + " msec");
            fArray = null;
            floatDHT_3D = null;
            System.gc();
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatForwardDHT_3D_input_3D.txt", nthread, niter, doWarmup, doScaling, nArray, dArray);
    }

    public static void main(String[] stringArray) {
        BenchmarkFloatDHT.parseArguments(stringArray);
        BenchmarkFloatDHT.benchmarkForward_1D(initialExponent1D);
        BenchmarkFloatDHT.benchmarkForward_2D_input_1D(initialExponent2D);
        BenchmarkFloatDHT.benchmarkForward_2D_input_2D(initialExponent2D);
        BenchmarkFloatDHT.benchmarkForward_3D_input_1D(initialExponent3D);
        BenchmarkFloatDHT.benchmarkForward_3D_input_3D(initialExponent3D);
        System.exit(0);
    }
}

