/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.der;

import gnu.java.security.der.DER;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERWriter;
import gnu.java.security.x509.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DERValue
implements DER {
    private final int tagClass;
    private final boolean constructed;
    private final int tag;
    private int length;
    private final Object value;
    private byte[] encoded;

    public int getExternalTag() {
        return this.tagClass | this.tag | (this.constructed ? 32 : 0);
    }

    public int getTag() {
        return this.tag;
    }

    public int getTagClass() {
        return this.tagClass;
    }

    public boolean isConstructed() {
        return this.constructed;
    }

    public int getLength() {
        if (this.encoded == null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                this.length = DERWriter.write(byteArrayOutputStream, this);
                this.encoded = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                illegalArgumentException.initCause(iOException);
                throw illegalArgumentException;
            }
        }
        return this.length;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getValueAs(int n) throws IOException {
        byte[] byArray = this.getEncoded();
        byArray[0] = (byte)n;
        return DERReader.read(byArray).getValue();
    }

    public byte[] getEncoded() {
        if (this.encoded == null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                this.length = DERWriter.write(byteArrayOutputStream, this);
                this.encoded = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                illegalArgumentException.initCause(iOException);
                throw illegalArgumentException;
            }
        }
        return (byte[])this.encoded.clone();
    }

    public int getEncodedLength() {
        if (this.encoded == null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                this.length = DERWriter.write(byteArrayOutputStream, this);
                this.encoded = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                illegalArgumentException.initCause(iOException);
                throw illegalArgumentException;
            }
        }
        return this.encoded.length;
    }

    public String toString() {
        String string = "DERValue ( [";
        if (this.tagClass == 0) {
            string = string + "UNIVERSAL ";
        } else if (this.tagClass == 192) {
            string = string + "PRIVATE ";
        } else if (this.tagClass == 64) {
            string = string + "APPLICATION ";
        }
        string = string + this.tag + "] constructed=" + this.constructed + ", value=";
        string = this.constructed ? string + '\n' + Util.hexDump(this.getEncoded(), "\t") : string + this.value;
        return string + " )";
    }

    public DERValue(int n, int n2, Object object, byte[] byArray) {
        this.tagClass = n & 0xC0;
        this.tag = n & 0x1F;
        boolean bl = false;
        if ((n & 0x20) == 32) {
            bl = true;
        }
        this.constructed = bl;
        this.length = n2;
        this.value = object;
        if (byArray != null) {
            this.encoded = (byte[])byArray.clone();
        }
    }

    public DERValue(int n, Object object) {
        this(n, 0, object, null);
    }
}

