/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class BooleanType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{4, 6};
    static final Set VALUE_SPACE = new TreeSet(Arrays.asList(new String[]{"true", "false", "1", "0"}));

    public final int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public final void checkValid(String string, ValidationContext validationContext) throws DatatypeException {
        super.checkValid(string, validationContext);
        if (!VALUE_SPACE.contains(string)) {
            throw new DatatypeException("invalid boolean value");
        }
    }

    public final Object createValue(String string, ValidationContext validationContext) {
        return "1".equals(string) || "true".equals(string) ? Boolean.TRUE : Boolean.FALSE;
    }

    BooleanType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "boolean"), TypeLibrary.ANY_SIMPLE_TYPE);
    }
}

