package TDS::Tdf::Command::WARNING;
# $Id: WARNING.pm,v 1.2.4.1 2001/02/13 00:48:12 tom Exp $
################################################################
use Template;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	    $CountName $OmittableEnd $NoParse
	    $ShowOnlyAuthor);

@ISA = qw(TDS::Tdf::Command::_Inline);
#@AllowCommands = (@{$TDS::Tdf::Command::Entities{'inline'}});
@AllowCommands = ('%Inline');
$Template = qq(<strong>) unless defined $Template;
$EndTemplate = qq(</strong>\n) unless defined $EndTemplate;

$ShowOnlyAuthor = 0 unless defined $ShowOnlyAuthor;

sub AsHTML($$)
{
    my ($self, $params) = @_;

    my $html = $self->SUPER::AsHTML($params);

    if ($ShowOnlyAuthor){
	if (TDS::Mode::IsStatic()){     # static: output to stderr
	    my $date_template = qq(%y/%m/%d-%new: );
	    print STDERR Expand($date_template, $params), $html;
	    return undef;
	} else {                        # dynamic: on secret
	    if ($TDS::Status->is_author){
		$self->{secret} = 1;
		return $html;
	    } else {
		return undef;
	    }
	}
    } else {                          # show to everyone
	return $html;
    }
}

1;
