/*
 * Copyright (C) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
 * SPDX-License-Identifier: MIT
 */

#ifndef VATOMIC_AWAIT_PTR_H
#define VATOMIC_AWAIT_PTR_H
/*******************************************************************************
 * @file await_ptr.h
 * @brief Atomic await functions for vatomicptr_t variables.
 *
 * This file declares and documents the atomic await functions operating on
 * vatomicptr_t variables.
 *
 * Please do not include this file directly, instead use:
 * ```c
 * #include <vsync/atomic/await.h>
 * ```
 ******************************************************************************/
/* !!!Warning: File generated by tmplr; DO NOT EDIT.!!! */
#include <vsync/atomic/internal/types.h>

#ifndef VATOMIC_AWAIT_H
    #error "File included directly. Include <vsync/atomic/await.h> instead!"
#endif

/**
 * Politely awaits the value pointed by a to be different than v.
 *
 * The return value is the first read value that satisfies the condition, as if
 * read with vatomicptr_read(a).
 *
 * @param a atomic variable
 * @param v value to compare
 * @return value satisfying conditon
 * @memord seq_cst
 */
static inline void *vatomicptr_await_neq(const vatomicptr_t *a, void *v);
/**
 * Politely awaits the value pointed by a to be different than v.
 *
 * The return value is the first read value that satisfies the condition, as if
 * read with vatomicptr_read(a).
 *
 * @param a atomic variable
 * @param v value to compare
 * @return value satisfying conditon
 * @memord acquire
 */
static inline void *vatomicptr_await_neq_acq(const vatomicptr_t *a, void *v);
/**
 * Politely awaits the value pointed by a to be different than v.
 *
 * The return value is the first read value that satisfies the condition, as if
 * read with vatomicptr_read(a).
 *
 * @param a atomic variable
 * @param v value to compare
 * @return value satisfying conditon
 * @memord relaxed
 */
static inline void *vatomicptr_await_neq_rlx(const vatomicptr_t *a, void *v);
/**
 * Politely awaits the value pointed by a to be equal to v.
 *
 * The return value is the first read value that satisfies the condition, as if
 * read with vatomicptr_read(a).
 *
 * @param a atomic variable
 * @param v value to compare
 * @return last value before satisfying condition
 * @memord seq_cst
 */
static inline void *vatomicptr_await_eq(const vatomicptr_t *a, void *v);
/**
 * Politely awaits the value pointed by a to be equal to v.
 *
 * The return value is the first read value that satisfies the condition, as if
 * read with vatomicptr_read(a).
 *
 * @param a atomic variable
 * @param v value to compare
 * @return last value before satisfying condition
 * @memord acquire
 */
static inline void *vatomicptr_await_eq_acq(const vatomicptr_t *a, void *v);
/**
 * Politely awaits the value pointed by a to be equal to v.
 *
 * The return value is the first read value that satisfies the condition, as if
 * read with vatomicptr_read(a).
 *
 * @param a atomic variable
 * @param v value to compare
 * @return last value before satisfying condition
 * @memord relaxed
 */
static inline void *vatomicptr_await_eq_rlx(const vatomicptr_t *a, void *v);

/**
 * Politely awaits the value pointed by a to be equal to c, setting v to a once
 * the condition is satisfied.
 *
 * @param a atomic variable
 * @param c value to compare
 * @param v value to apply the operation
 * @return old value
 * @memord seq_cst
 */
static inline void *vatomicptr_await_eq_set(vatomicptr_t *a, void *c, void *v);
/**
 * Politely awaits the value pointed by a to be equal to c, setting v to a once
 * the condition is satisfied.
 *
 * @param a atomic variable
 * @param c value to compare
 * @param v value to apply the operation
 * @return old value
 * @memord acquire
 */
static inline void *vatomicptr_await_eq_set_acq(vatomicptr_t *a, void *c,
                                                void *v);
/**
 * Politely awaits the value pointed by a to be equal to c, setting v to a once
 * the condition is satisfied.
 *
 * @param a atomic variable
 * @param c value to compare
 * @param v value to apply the operation
 * @return old value
 * @memord release
 */
static inline void *vatomicptr_await_eq_set_rel(vatomicptr_t *a, void *c,
                                                void *v);
/**
 * Politely awaits the value pointed by a to be equal to c, setting v to a once
 * the condition is satisfied.
 *
 * @param a atomic variable
 * @param c value to compare
 * @param v value to apply the operation
 * @return old value
 * @memord relaxed
 */
static inline void *vatomicptr_await_eq_set_rlx(vatomicptr_t *a, void *c,
                                                void *v);
/**
 * Politely awaits the value pointed by a to be different than c, setting v to a
 * once the condition is satisfied.
 *
 * @param a atomic variable
 * @param c value to compare
 * @param v value to apply the operation
 * @return old value
 * @memord seq_cst
 */
static inline void *vatomicptr_await_neq_set(vatomicptr_t *a, void *c, void *v);
/**
 * Politely awaits the value pointed by a to be different than c, setting v to a
 * once the condition is satisfied.
 *
 * @param a atomic variable
 * @param c value to compare
 * @param v value to apply the operation
 * @return old value
 * @memord acquire
 */
static inline void *vatomicptr_await_neq_set_acq(vatomicptr_t *a, void *c,
                                                 void *v);
/**
 * Politely awaits the value pointed by a to be different than c, setting v to a
 * once the condition is satisfied.
 *
 * @param a atomic variable
 * @param c value to compare
 * @param v value to apply the operation
 * @return old value
 * @memord release
 */
static inline void *vatomicptr_await_neq_set_rel(vatomicptr_t *a, void *c,
                                                 void *v);
/**
 * Politely awaits the value pointed by a to be different than c, setting v to a
 * once the condition is satisfied.
 *
 * @param a atomic variable
 * @param c value to compare
 * @param v value to apply the operation
 * @return old value
 * @memord relaxed
 */
static inline void *vatomicptr_await_neq_set_rlx(vatomicptr_t *a, void *c,
                                                 void *v);

#endif /* VATOMIC_AWAIT_TY_H */
