/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecodecvssnap;

import gnu.bytecodecvssnap.ObjectType;
import gnu.bytecodecvssnap.Type;

public class ArrayType
extends ObjectType {
    public Type elements;

    public Type getImplementationType() {
        Type type = this.elements.getImplementationType();
        return this.elements == type ? this : ArrayType.make(type);
    }

    static ArrayType make(String string) {
        Type type = Type.getType(string.substring(0, string.length() - 2));
        ArrayType arrayType = type.array_type;
        if (arrayType == null) {
            type.array_type = arrayType = new ArrayType(type, string);
        }
        return arrayType;
    }

    public static ArrayType make(Type type) {
        ArrayType arrayType = type.array_type;
        if (arrayType == null) {
            type.array_type = arrayType = new ArrayType(type, type.getName() + "[]");
        }
        return arrayType;
    }

    public Type getComponentType() {
        return this.elements;
    }

    public String getInternalName() {
        return this.getSignature();
    }

    public int compare(Type type) {
        if (type == nullType) {
            return 1;
        }
        if (type instanceof ArrayType) {
            return this.elements.compare(((ArrayType)type).elements);
        }
        if (type.getName().equals("java.lang.Object") || type == tostring_type) {
            return -1;
        }
        return -3;
    }

    public ArrayType(Type type) {
        this(type, type.getName() + "[]");
    }

    ArrayType(Type type, String string) {
        this.this_name = string;
        this.setSignature("[" + type.getSignature());
        this.elements = type;
    }
}

