/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.assembly;

import gnu.javax.crypto.assembly.Direction;
import gnu.javax.crypto.assembly.Stage;
import gnu.javax.crypto.mode.IMode;
import java.security.InvalidKeyException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class ModeStage
extends Stage {
    private IMode delegate;
    private transient Set cachedBlockSizes;

    public Set blockSizes() {
        if (this.cachedBlockSizes == null) {
            HashSet hashSet = new HashSet();
            Iterator iterator = this.delegate.blockSizes();
            while (iterator.hasNext()) {
                hashSet.add(iterator.next());
            }
            this.cachedBlockSizes = Collections.unmodifiableSet(hashSet);
        }
        return this.cachedBlockSizes;
    }

    void initDelegate(Map map) throws InvalidKeyException {
        Direction direction = (Direction)map.get("gnu.crypto.assembly.stage.direction");
        map.put("gnu.crypto.mode.state", new Integer(2 - direction.equals(this.forward)));
        this.delegate.init(map);
    }

    public int currentBlockSize() throws IllegalStateException {
        return this.delegate.currentBlockSize();
    }

    void resetDelegate() {
        this.delegate.reset();
    }

    void updateDelegate(byte[] byArray, int n, byte[] byArray2, int n2) {
        this.delegate.update(byArray, n, byArray2, n2);
    }

    public boolean selfTest() {
        return this.delegate.selfTest();
    }

    ModeStage(IMode iMode, Direction direction) {
        super(direction);
        this.delegate = iMode;
        this.cachedBlockSizes = null;
    }
}

