/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.util.ArrayList;
import java.util.List;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.RRset;

public class SetResponse {
    static final int UNKNOWN = 0;
    static final int NXDOMAIN = 1;
    static final int NXRRSET = 2;
    static final int DELEGATION = 3;
    static final int CNAME = 4;
    static final int DNAME = 5;
    static final int SUCCESSFUL = 6;
    private static final SetResponse unknown = new SetResponse(0);
    private static final SetResponse nxdomain = new SetResponse(1);
    private static final SetResponse nxrrset = new SetResponse(2);
    private int type;
    private Object data;

    static SetResponse ofType(int n) {
        switch (n) {
            case 0: {
                return unknown;
            }
            case 1: {
                return nxdomain;
            }
            case 2: {
                return nxrrset;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                SetResponse setResponse = new SetResponse();
                setResponse.type = n;
                setResponse.data = null;
                return setResponse;
            }
        }
        throw new IllegalArgumentException("invalid type");
    }

    void addRRset(RRset rRset) {
        if (this.data == null) {
            this.data = new ArrayList();
        }
        List list2 = (List)this.data;
        list2.add(rRset);
    }

    public boolean isUnknown() {
        boolean bl = false;
        if (this.type == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isNXDOMAIN() {
        boolean bl = false;
        if (this.type == 1) {
            bl = true;
        }
        return bl;
    }

    public boolean isNXRRSET() {
        boolean bl = false;
        if (this.type == 2) {
            bl = true;
        }
        return bl;
    }

    public boolean isDelegation() {
        boolean bl = false;
        if (this.type == 3) {
            bl = true;
        }
        return bl;
    }

    public boolean isCNAME() {
        boolean bl = false;
        if (this.type == 4) {
            bl = true;
        }
        return bl;
    }

    public boolean isDNAME() {
        boolean bl = false;
        if (this.type == 5) {
            bl = true;
        }
        return bl;
    }

    public boolean isSuccessful() {
        boolean bl = false;
        if (this.type == 6) {
            bl = true;
        }
        return bl;
    }

    public RRset[] answers() {
        if (this.type != 6) {
            return null;
        }
        List list2 = (List)this.data;
        return (RRset[])list2.toArray(new RRset[list2.size()]);
    }

    public CNAMERecord getCNAME() {
        return (CNAMERecord)((RRset)this.data).first();
    }

    public DNAMERecord getDNAME() {
        return (DNAMERecord)((RRset)this.data).first();
    }

    public RRset getNS() {
        return (RRset)this.data;
    }

    public String toString() {
        switch (this.type) {
            case 0: {
                return "unknown";
            }
            case 1: {
                return "NXDOMAIN";
            }
            case 2: {
                return "NXRRSET";
            }
            case 3: {
                return "delegation: " + this.data;
            }
            case 4: {
                return "CNAME: " + this.data;
            }
            case 5: {
                return "DNAME: " + this.data;
            }
            case 6: {
                return "successful";
            }
        }
        return null;
    }

    private SetResponse() {
    }

    SetResponse(int n, RRset rRset) {
        if (n < 0 || n > 6) {
            throw new IllegalArgumentException("invalid type");
        }
        this.type = n;
        this.data = rRset;
    }

    SetResponse(int n) {
        if (n < 0 || n > 6) {
            throw new IllegalArgumentException("invalid type");
        }
        this.type = n;
        this.data = null;
    }
}

