#
# @(#)mstream.pm.pl,v 1.10 2008/11/22 07:44:50 kim Exp
#
#
# Copyright (c) 2004 Kimmo Suominen
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer
#    in the documentation and/or other materials provided with the
#    distribution.
# 3. The name of the author may not be used to endorse or promote
#    products derived from this software without specific prior
#    written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
# OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
# DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
# GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
# IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
# OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
# IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#
# IceS playlist handler for mserv-ices
# 20040418  Kimmo Suominen

my $askmserv = 0;

sub ices_init {
    print "Writing PID file...\n";
    if (open(PIDFILE, ">.ices.pid")) {
	print PIDFILE $$, "\n";
	close(PIDFILE);
	print "Writing PID file... done!\n";
	return 1;
    }
    print "Could not write PID file!\n";
    return 0;
}

sub ices_shutdown {
    print "Removing PID file...\n";
    if (unlink(".ices.pid")) {
	print "Removing PID file... done!\n";
	return 1;
    }
    print "Could not remove PID file!\n";
    return 0;
}

sub ices_get_next {
    my $gw = ".icesgw";
    if (-p $gw && open(GW, "+<", $gw)) {
	$line = <GW>;
	close(GW);
	chomp($line);
	$askmserv = 1;
	return $line;
    } else {
	$askmserv = 0;
	return "/usr/pkg/share/mstream/silence.mp3";
    }
}

sub ices_get_metadata {
    my $metadata = "Oops, is this silence?";
    if ($askmserv) {
	$askmserv = 0;
	if (open(MSERV, "/usr/pkg/bin/mservcmd info|")) {
	    my @ret = split("\t", <MSERV>, 2);
	    if ($ret[0] == 246) {
		my @ti = split("\t", <MSERV>);
		#
		#  0: album number
		#  1: track number
		#  2: album author
		#  3: album name
		#  4: track author
		#  5: track name
		#  6: track year
		#  7: ???
		#  8: last played
		#  9: random probability
		# 10: temporal probability
		# 11: rating
		# 12: genre
		# 13: filter status
		# 14: length
		# 15: bitrate
		#
		# I would really prefer to see the song name first, but this
		# seems to have become some sort of an Internet standard.
		# Scripts parsing the stream title assume the artist first.
		#
		$metadata = $ti[4] . " - " . $ti[5];
		#
		# Remove any strings in parenthesis: these are usually
		# different versions, e.g. "(Album Version)" or "(Night Mix)",
		# or other "extra" info, e.g. "(feat. Gwen Stefani)".
		#
		#$metadata =~ s/\([^)]+\)//g;
		#
		# Append year and duration.
		#
		#$metadata .= ' [' . $ti[6] . ']';
		#($duration = $ti[14]) =~ s/\.\d+$//;
		#$metadata .= ' (' . $duration . ')';
		#
		# Remove any extra whitespace.
		#
		$metadata =~ s/\s+/ /g;
		$metadata =~ s/^\s+//g;
		$metadata =~ s/\s+$//g;
		#
		# Sometimes the title shows up on the server status page, but
		# no clients get it (they get an empty title).  This happens
		# with titles of length 18 and 34 at least.  We make the title
		# length always an odd number of bytes by padding with a space.
		# This seems to work around the problem.
		#
		if (length($metadata) % 2) {
		    $metadata .= " ";
		}
	    }
	    close(MSERV);
	}
    } else {
	my @messages = (
	    "Stay tuned...",
	    "Just a moment...",
	    "Don't touch that dial...",
	    "We'll be back shortly...",
	);
	$metadata = $messages[time() % ($#messages + 1)];
    }
    return $metadata;
}

sub ices_get_lineno {
    return 1;
}

1;
