/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Adjustable;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ScrollBarUI;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JScrollBar
extends JComponent
implements Adjustable,
Accessible {
    private static final long serialVersionUID = -8195169869225066566L;
    protected int blockIncrement;
    protected BoundedRangeModel model;
    protected int orientation;
    protected int unitIncrement;
    static /* synthetic */ Class class$java$awt$event$AdjustmentListener;

    public void setUI(ScrollBarUI ui) {
        super.setUI(ui);
    }

    public ScrollBarUI getUI() {
        return (ScrollBarUI)this.ui;
    }

    public void updateUI() {
        this.setUI((ScrollBarUI)UIManager.getUI(this));
        this.invalidate();
        this.repaint();
    }

    public String getUIClassID() {
        return "ScrollBarUI";
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("orientation must be one of HORIZONTAL or VERTICAL");
        }
        if (orientation != this.orientation) {
            int oldOrientation = this.orientation;
            this.orientation = orientation;
            this.firePropertyChange("orientation", oldOrientation, this.orientation);
        }
    }

    public BoundedRangeModel getModel() {
        return this.model;
    }

    public void setModel(BoundedRangeModel newModel) {
        if (this.model != newModel) {
            BoundedRangeModel oldModel = this.model;
            this.model = newModel;
            this.firePropertyChange("model", oldModel, this.model);
        }
    }

    public int getUnitIncrement(int direction) {
        return direction * this.unitIncrement;
    }

    public void setUnitIncrement(int unitIncrement) {
        if (unitIncrement != this.unitIncrement) {
            int oldInc = this.unitIncrement;
            this.unitIncrement = unitIncrement;
            this.firePropertyChange("unitIncrement", oldInc, this.unitIncrement);
        }
    }

    public int getBlockIncrement(int direction) {
        return direction * this.blockIncrement;
    }

    public void setBlockIncrement(int blockIncrement) {
        if (blockIncrement != this.blockIncrement) {
            int oldInc = this.blockIncrement;
            this.blockIncrement = blockIncrement;
            this.firePropertyChange("blockIncrement", oldInc, this.blockIncrement);
        }
    }

    public int getUnitIncrement() {
        return this.unitIncrement;
    }

    public int getBlockIncrement() {
        return this.blockIncrement;
    }

    public int getValue() {
        return this.model.getValue();
    }

    public void setValue(int value) {
        if (this.isEnabled() && value != this.getValue()) {
            this.model.setValue(value);
            this.fireAdjustmentValueChanged(601, 5, value);
        }
    }

    public int getVisibleAmount() {
        return this.model.getExtent();
    }

    public void setVisibleAmount(int extent) {
        if (extent != this.getVisibleAmount()) {
            this.model.setExtent(extent);
            this.fireAdjustmentValueChanged(601, 5, extent);
        }
    }

    public int getMinimum() {
        return this.model.getMinimum();
    }

    public void setMinimum(int minimum) {
        if (minimum != this.getMinimum()) {
            this.model.setMinimum(minimum);
            this.fireAdjustmentValueChanged(601, 5, minimum);
        }
    }

    public int getMaximum() {
        return this.model.getMaximum();
    }

    public void setMaximum(int maximum) {
        if (maximum != this.getMaximum()) {
            this.model.setMaximum(maximum);
            this.fireAdjustmentValueChanged(601, 5, maximum);
        }
    }

    public boolean getValueIsAdjusting() {
        return this.model.getValueIsAdjusting();
    }

    public void setValueIsAdjusting(boolean b) {
        this.model.setValueIsAdjusting(b);
    }

    public void setValues(int newValue, int newExtent, int newMin, int newMax) {
        if (!this.isEnabled()) {
            newValue = this.model.getValue();
        }
        if (newValue != this.getValue() || newExtent != this.getVisibleAmount() || newMin != this.getMinimum() || newMax != this.getMaximum()) {
            this.model.setRangeProperties(newValue, newExtent, newMin, newMax, this.model.getValueIsAdjusting());
            this.fireAdjustmentValueChanged(601, 5, newValue);
        }
    }

    public void addAdjustmentListener(AdjustmentListener listener) {
        Class clazz = class$java$awt$event$AdjustmentListener;
        if (clazz == null) {
            clazz = class$java$awt$event$AdjustmentListener = JScrollBar.class("[Ljava.awt.event.AdjustmentListener;", false);
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeAdjustmentListener(AdjustmentListener listener) {
        Class clazz = class$java$awt$event$AdjustmentListener;
        if (clazz == null) {
            clazz = class$java$awt$event$AdjustmentListener = JScrollBar.class("[Ljava.awt.event.AdjustmentListener;", false);
        }
        this.listenerList.remove(clazz, listener);
    }

    public AdjustmentListener[] getAdjustmentListeners() {
        Class clazz = class$java$awt$event$AdjustmentListener;
        if (clazz == null) {
            clazz = class$java$awt$event$AdjustmentListener = JScrollBar.class("[Ljava.awt.event.AdjustmentListener;", false);
        }
        return (AdjustmentListener[])this.listenerList.getListeners(clazz);
    }

    protected void fireAdjustmentValueChanged(int id, int type, int value) {
        Object[] adjustmentListeners = this.listenerList.getListenerList();
        AdjustmentEvent adjustmentEvent = new AdjustmentEvent(this, 601, 5, value);
        int i = adjustmentListeners.length - 2;
        while (i >= 0) {
            Object object = adjustmentListeners[i];
            Class clazz = class$java$awt$event$AdjustmentListener;
            if (clazz == null) {
                clazz = JScrollBar.class("[Ljava.awt.event.AdjustmentListener;", false);
            }
            if (object == clazz) {
                ((AdjustmentListener)adjustmentListeners[i + 1]).adjustmentValueChanged(adjustmentEvent);
            }
            i -= 2;
        }
    }

    public Dimension getMinimumSize() {
        return this.ui.getMinimumSize(this);
    }

    public Dimension getMaximumSize() {
        return this.ui.getMaximumSize(this);
    }

    public void setEnabled(boolean x) {
        super.setEnabled(x);
    }

    protected String paramString() {
        return "JScrollBar";
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJScrollBar();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.blockIncrement = 10;
        this.orientation = 1;
        this.unitIncrement = 1;
    }

    public JScrollBar() {
        this(1, 0, 10, 0, 100);
    }

    public JScrollBar(int orientation) {
        this(orientation, 0, 10, 0, 100);
    }

    public JScrollBar(int orientation, int value, int extent, int min, int max) {
        this.this();
        this.model = new DefaultBoundedRangeModel(value, extent, min, max);
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException(orientation + " is not a legal orientation");
        }
        this.orientation = orientation;
        this.updateUI();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleJScrollBar
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        private static final long serialVersionUID = -7758162392045586663L;

        public AccessibleStateSet getAccessibleStateSet() {
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return null;
        }

        public AccessibleValue getAccessibleValue() {
            return null;
        }

        public Number getCurrentAccessibleValue() {
            return null;
        }

        public boolean setCurrentAccessibleValue(Number value0) {
            return false;
        }

        public Number getMinimumAccessibleValue() {
            return null;
        }

        public Number getMaximumAccessibleValue() {
            return null;
        }

        protected AccessibleJScrollBar() {
        }
    }
}

