/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.TableUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class BasicTableUI
extends TableUI {
    protected FocusListener focusListener;
    protected KeyListener keyListener;
    protected MouseInputListener mouseInputListener;
    protected CellRendererPane rendererPane;
    protected JTable table;
    Border cellBorder;
    TableAction action;
    private PropertyChangeListener propertyChangeListener;

    public static ComponentUI createUI(JComponent comp) {
        return new BasicTableUI();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    protected KeyListener createKeyListener() {
        return new KeyHandler();
    }

    public Dimension getMaximumSize(JComponent comp) {
        int maxTotalColumnWidth = 0;
        int i = 0;
        while (i < this.table.getColumnCount()) {
            maxTotalColumnWidth += this.table.getColumnModel().getColumn(i).getMaxWidth();
            ++i;
        }
        if (maxTotalColumnWidth == 0 || this.table.getRowCount() == 0) {
            return null;
        }
        return new Dimension(maxTotalColumnWidth, this.table.getRowCount() * this.table.getRowHeight());
    }

    public Dimension getMinimumSize(JComponent comp) {
        int minTotalColumnWidth = 0;
        int i = 0;
        while (i < this.table.getColumnCount()) {
            minTotalColumnWidth += this.table.getColumnModel().getColumn(i).getMinWidth();
            ++i;
        }
        if (minTotalColumnWidth == 0 || this.table.getRowCount() == 0) {
            return null;
        }
        return new Dimension(minTotalColumnWidth, this.table.getRowCount() * this.table.getRowHeight());
    }

    public Dimension getPreferredSize(JComponent comp) {
        int width = this.table.getColumnModel().getTotalColumnWidth();
        int height = this.table.getRowCount() * this.table.getRowHeight();
        return new Dimension(width, height);
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.table, "Table.background", "Table.foreground", "Table.font");
        this.table.setGridColor(UIManager.getColor("Table.gridColor"));
        this.table.setSelectionForeground(UIManager.getColor("Table.selectionForeground"));
        this.table.setSelectionBackground(UIManager.getColor("Table.selectionBackground"));
        this.table.setOpaque(true);
        this.rendererPane = new CellRendererPane();
    }

    protected void installKeyboardActions() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        InputMap ancestorMap = (InputMap)defaults.get("Table.ancestorInputMap");
        InputMapUIResource parentInputMap = new InputMapUIResource();
        ActionMap parentActionMap = new ActionMap();
        this.action = new TableAction();
        KeyStroke[] keys = ancestorMap.allKeys();
        int i = 0;
        while (i < keys.length) {
            KeyStroke stroke = keys[i];
            String actionString = (String)ancestorMap.get(stroke);
            parentInputMap.put(KeyStroke.getKeyStroke(stroke.getKeyCode(), stroke.getModifiers()), actionString);
            parentActionMap.put(actionString, new ActionListenerProxy(this.action, actionString));
            ++i;
        }
        parentInputMap.setParent(this.table.getInputMap(1).getParent());
        parentActionMap.setParent(this.table.getActionMap().getParent());
        this.table.getInputMap(1).setParent(parentInputMap);
        this.table.getActionMap().setParent(parentActionMap);
    }

    protected void installListeners() {
        if (this.focusListener == null) {
            this.focusListener = this.createFocusListener();
        }
        this.table.addFocusListener(this.focusListener);
        if (this.keyListener == null) {
            this.keyListener = this.createKeyListener();
        }
        this.table.addKeyListener(this.keyListener);
        if (this.mouseInputListener == null) {
            this.mouseInputListener = this.createMouseInputListener();
        }
        this.table.addMouseListener(this.mouseInputListener);
        this.table.addMouseMotionListener(this.mouseInputListener);
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = new PropertyChangeHandler();
        }
        this.table.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallKeyboardActions() {
    }

    protected void uninstallListeners() {
        this.table.removeFocusListener(this.focusListener);
        this.table.removeKeyListener(this.keyListener);
        this.table.removeMouseListener(this.mouseInputListener);
        this.table.removeMouseMotionListener(this.mouseInputListener);
        this.table.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    public void installUI(JComponent comp) {
        this.table = (JTable)comp;
        this.installDefaults();
        this.installKeyboardActions();
        this.installListeners();
    }

    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.uninstallDefaults();
    }

    void paintCell(Graphics g, int row, int col, Rectangle bounds, TableCellRenderer rend, TableModel data, int rowLead, int colLead) {
        boolean rowSelAllowed = this.table.getRowSelectionAllowed();
        boolean colSelAllowed = this.table.getColumnSelectionAllowed();
        boolean isSel = false;
        if (rowSelAllowed && colSelAllowed || !rowSelAllowed && !colSelAllowed) {
            isSel = this.table.isCellSelected(row, col);
        } else {
            boolean bl = false;
            if (this.table.isRowSelected(row) && this.table.getRowSelectionAllowed() || this.table.isColumnSelected(col) && this.table.getColumnSelectionAllowed()) {
                bl = true;
            }
            isSel = bl;
        }
        ListSelectionModel rowSel = this.table.getSelectionModel();
        ListSelectionModel colSel = this.table.getColumnModel().getSelectionModel();
        boolean bl = false;
        if (this.table.hasFocus() && this.table.isEnabled() && rowSel.getLeadSelectionIndex() == row && colSel.getLeadSelectionIndex() == col) {
            bl = true;
        }
        boolean hasFocus = bl;
        Component comp = rend.getTableCellRendererComponent(this.table, data.getValueAt(row, col), isSel, hasFocus, row, col);
        this.rendererPane.paintComponent(g, comp, this.table, bounds);
        if (comp instanceof JTextField) {
            Rectangle oldClip = g.getClipBounds();
            g.translate(bounds.x, bounds.y);
            g.clipRect(0, 0, bounds.width, bounds.height);
            ((JTextField)comp).getCaret().paint(g);
            g.translate(-bounds.x, -bounds.y);
            g.setClip(oldClip);
        }
    }

    public void paint(Graphics gfx, JComponent ignored) {
        boolean paintedLine;
        Color save;
        int ncols = this.table.getColumnCount();
        int nrows = this.table.getRowCount();
        if (nrows == 0 || ncols == 0) {
            return;
        }
        Rectangle clip = gfx.getClipBounds();
        TableColumnModel cols = this.table.getColumnModel();
        int height = this.table.getRowHeight();
        int x0 = 0;
        int y0 = 0;
        int x = x0;
        int y = y0;
        Dimension gap = this.table.getIntercellSpacing();
        int ymax = clip.y + clip.height;
        int xmax = clip.x + clip.width;
        int c = 0;
        while (c < ncols && x < xmax) {
            y = y0;
            TableColumn col = cols.getColumn(c);
            int width = col.getWidth();
            int halfGapWidth = gap.width / 2;
            int halfGapHeight = gap.height / 2;
            int r = 0;
            while (r < nrows && y < ymax) {
                Rectangle bounds = new Rectangle(x + halfGapWidth, y + halfGapHeight + 1, width - gap.width + 1, height - gap.height);
                if (bounds.intersects(clip)) {
                    this.paintCell(gfx, r, c, bounds, this.table.getCellRenderer(r, c), this.table.getModel(), this.table.getSelectionModel().getLeadSelectionIndex(), this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex());
                }
                y += height;
                ++r;
            }
            x += width;
            ++c;
        }
        ymax = y;
        xmax = x;
        Color grid = this.table.getGridColor();
        if (grid != null && this.table.getShowVerticalLines()) {
            x = x0;
            save = gfx.getColor();
            gfx.setColor(grid);
            paintedLine = false;
            int c2 = 0;
            while (c2 < ncols && x < xmax) {
                gfx.drawLine(x += cols.getColumn(c2).getWidth(), y0, x, ymax);
                paintedLine = true;
                ++c2;
            }
            gfx.setColor(save);
        }
        if (grid != null && this.table.getShowHorizontalLines()) {
            y = y0;
            save = gfx.getColor();
            gfx.setColor(grid);
            paintedLine = false;
            int r = 0;
            while (r < nrows && y < ymax) {
                gfx.drawLine(x0, y += height, xmax, y);
                paintedLine = true;
                ++r;
            }
            gfx.setColor(save);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class FocusHandler
    implements FocusListener {
        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class MouseInputHandler
    implements MouseInputListener {
        Point begin;
        Point curr;

        private final void updateSelection(boolean controlPressed) {
            int lo_row = BasicTableUI.this.table.rowAtPoint(this.begin);
            int hi_row = BasicTableUI.this.table.rowAtPoint(this.curr);
            ListSelectionModel rowModel = BasicTableUI.this.table.getSelectionModel();
            if (lo_row != -1 && hi_row != -1) {
                if (controlPressed && rowModel.getSelectionMode() != 0) {
                    rowModel.addSelectionInterval(lo_row, hi_row);
                } else {
                    rowModel.setSelectionInterval(lo_row, hi_row);
                }
            }
            int lo_col = BasicTableUI.this.table.columnAtPoint(this.begin);
            int hi_col = BasicTableUI.this.table.columnAtPoint(this.curr);
            ListSelectionModel colModel = BasicTableUI.this.table.getColumnModel().getSelectionModel();
            if (lo_col != -1 && hi_col != -1) {
                if (controlPressed && colModel.getSelectionMode() != 0) {
                    colModel.addSelectionInterval(lo_col, hi_col);
                } else {
                    colModel.setSelectionInterval(lo_col, hi_col);
                }
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            if (BasicTableUI.this.table.isEnabled()) {
                this.curr = new Point(e.getX(), e.getY());
                this.updateSelection(e.isControlDown());
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (BasicTableUI.this.table.isEnabled()) {
                ListSelectionModel rowModel = BasicTableUI.this.table.getSelectionModel();
                ListSelectionModel colModel = BasicTableUI.this.table.getColumnModel().getSelectionModel();
                int rowLead = rowModel.getLeadSelectionIndex();
                int colLead = colModel.getLeadSelectionIndex();
                this.begin = new Point(e.getX(), e.getY());
                this.curr = new Point(e.getX(), e.getY());
                if (e.isControlDown() && BasicTableUI.this.table.isCellSelected(BasicTableUI.this.table.rowAtPoint(this.begin), BasicTableUI.this.table.columnAtPoint(this.begin))) {
                    BasicTableUI.this.table.getSelectionModel().removeSelectionInterval(BasicTableUI.this.table.rowAtPoint(this.begin), BasicTableUI.this.table.rowAtPoint(this.begin));
                    BasicTableUI.this.table.getColumnModel().getSelectionModel().removeSelectionInterval(BasicTableUI.this.table.columnAtPoint(this.begin), BasicTableUI.this.table.columnAtPoint(this.begin));
                } else {
                    this.updateSelection(e.isControlDown());
                }
                if ((rowLead != rowModel.getLeadSelectionIndex() || colLead != colModel.getLeadSelectionIndex()) && BasicTableUI.this.table.isEditing()) {
                    BasicTableUI.this.table.editingStopped(new ChangeEvent(e));
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (BasicTableUI.this.table.isEnabled()) {
                this.begin = null;
                this.curr = null;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class KeyHandler
    implements KeyListener {
        public void keyTyped(KeyEvent event) {
        }

        public void keyPressed(KeyEvent event) {
        }

        public void keyReleased(KeyEvent event) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class TableAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            DefaultListSelectionModel rowModel = (DefaultListSelectionModel)BasicTableUI.this.table.getSelectionModel();
            DefaultListSelectionModel colModel = (DefaultListSelectionModel)BasicTableUI.this.table.getColumnModel().getSelectionModel();
            int rowLead = rowModel.getLeadSelectionIndex();
            int rowMax = BasicTableUI.this.table.getModel().getRowCount() - 1;
            int colLead = colModel.getLeadSelectionIndex();
            int colMax = BasicTableUI.this.table.getModel().getColumnCount() - 1;
            String command = e.getActionCommand();
            if (command.equals("selectPreviousRowExtendSelection")) {
                rowModel.setLeadSelectionIndex(Math.max(rowLead - 1, 0));
                colModel.setLeadSelectionIndex(colLead);
            } else if (command.equals("selectLastColumn")) {
                rowModel.setSelectionInterval(rowLead, rowLead);
                colModel.setSelectionInterval(colMax, colMax);
            } else if (command.equals("startEditing")) {
                if (BasicTableUI.this.table.isCellEditable(rowLead, colLead)) {
                    BasicTableUI.this.table.editCellAt(rowLead, colLead);
                }
            } else if (command.equals("selectFirstRowExtendSelection")) {
                rowModel.setLeadSelectionIndex(0);
                colModel.setLeadSelectionIndex(colLead);
            } else if (command.equals("selectFirstColumn")) {
                rowModel.setSelectionInterval(rowLead, rowLead);
                colModel.setSelectionInterval(0, 0);
            } else if (command.equals("selectFirstColumnExtendSelection")) {
                colModel.setLeadSelectionIndex(0);
                rowModel.setLeadSelectionIndex(rowLead);
            } else if (command.equals("selectLastRow")) {
                rowModel.setSelectionInterval(rowMax, rowMax);
                colModel.setSelectionInterval(colLead, colLead);
            } else if (command.equals("selectNextRowExtendSelection")) {
                rowModel.setLeadSelectionIndex(Math.min(rowLead + 1, rowMax));
                colModel.setLeadSelectionIndex(colLead);
            } else if (command.equals("selectFirstRow")) {
                rowModel.setSelectionInterval(0, 0);
                colModel.setSelectionInterval(colLead, colLead);
            } else if (command.equals("selectNextColumnExtendSelection")) {
                colModel.setLeadSelectionIndex(Math.min(colLead + 1, colMax));
                rowModel.setLeadSelectionIndex(rowLead);
            } else if (command.equals("selectLastColumnExtendSelection")) {
                colModel.setLeadSelectionIndex(colMax);
                rowModel.setLeadSelectionIndex(rowLead);
            } else if (command.equals("selectPreviousColumnExtendSelection")) {
                colModel.setLeadSelectionIndex(Math.max(colLead - 1, 0));
                rowModel.setLeadSelectionIndex(rowLead);
            } else if (command.equals("selectNextRow")) {
                rowModel.setSelectionInterval(Math.min(rowLead + 1, rowMax), Math.min(rowLead + 1, rowMax));
                colModel.setSelectionInterval(colLead, colLead);
            } else if (command.equals("scrollUpExtendSelection")) {
                int target = rowLead == this.getFirstVisibleRowIndex() ? Math.max(0, rowLead - (this.getLastVisibleRowIndex() - this.getFirstVisibleRowIndex() + 1)) : this.getFirstVisibleRowIndex();
                rowModel.setLeadSelectionIndex(target);
                colModel.setLeadSelectionIndex(colLead);
            } else if (command.equals("selectPreviousRow")) {
                rowModel.setSelectionInterval(Math.max(rowLead - 1, 0), Math.max(rowLead - 1, 0));
                colModel.setSelectionInterval(colLead, colLead);
            } else if (command.equals("scrollRightChangeSelection")) {
                int target = colLead == this.getLastVisibleColumnIndex() ? Math.min(colMax, colLead + (this.getLastVisibleColumnIndex() - this.getFirstVisibleColumnIndex() + 1)) : this.getLastVisibleColumnIndex();
                colModel.setSelectionInterval(target, target);
                rowModel.setSelectionInterval(rowLead, rowLead);
            } else if (command.equals("selectPreviousColumn")) {
                rowModel.setSelectionInterval(rowLead, rowLead);
                colModel.setSelectionInterval(Math.max(colLead - 1, 0), Math.max(colLead - 1, 0));
            } else if (command.equals("scrollLeftChangeSelection")) {
                int target = colLead == this.getFirstVisibleColumnIndex() ? Math.max(0, colLead - (this.getLastVisibleColumnIndex() - this.getFirstVisibleColumnIndex() + 1)) : this.getFirstVisibleColumnIndex();
                colModel.setSelectionInterval(target, target);
                rowModel.setSelectionInterval(rowLead, rowLead);
            } else if (command.equals("clearSelection")) {
                BasicTableUI.this.table.clearSelection();
            } else if (command.equals("cancel")) {
                if (BasicTableUI.this.table.isEditing()) {
                    BasicTableUI.this.table.editingCanceled(new ChangeEvent("cancel"));
                }
            } else if (command.equals("selectNextRowCell") || command.equals("selectPreviousRowCell") || command.equals("selectNextColumnCell") || command.equals("selectPreviousColumnCell")) {
                int colMinSelected;
                boolean multColsSelected;
                if (BasicTableUI.this.table.getSelectedRowCount() == 0 && BasicTableUI.this.table.getSelectedColumnCount() == 0) {
                    rowModel.setSelectionInterval(0, 0);
                    colModel.setSelectionInterval(0, 0);
                    return;
                }
                if (!BasicTableUI.this.table.isCellSelected(rowLead, colLead)) {
                    rowModel.addSelectionInterval(rowModel.getMinSelectionIndex(), rowModel.getMinSelectionIndex());
                    colModel.addSelectionInterval(colModel.getMinSelectionIndex(), colModel.getMinSelectionIndex());
                    return;
                }
                boolean bl = false;
                if (BasicTableUI.this.table.getSelectedRowCount() > 1 && BasicTableUI.this.table.getRowSelectionAllowed()) {
                    bl = true;
                }
                boolean multRowsSelected = bl;
                boolean bl2 = false;
                if (BasicTableUI.this.table.getSelectedColumnCount() > 1 && BasicTableUI.this.table.getColumnSelectionAllowed()) {
                    bl2 = true;
                }
                if (!(multColsSelected = bl2) && !multRowsSelected) {
                    if (command.indexOf("Column") != -1) {
                        this.advanceSingleSelection(colModel, colMax, rowModel, rowMax, command.equals("selectPreviousColumnCell"));
                    } else {
                        this.advanceSingleSelection(rowModel, rowMax, colModel, colMax, command.equals("selectPreviousRowCell"));
                    }
                    return;
                }
                int rowMaxSelected = BasicTableUI.this.table.getRowSelectionAllowed() ? rowModel.getMaxSelectionIndex() : BasicTableUI.this.table.getModel().getRowCount() - 1;
                int n = 0;
                if (BasicTableUI.this.table.getRowSelectionAllowed()) {
                    n = rowModel.getMinSelectionIndex();
                }
                int rowMinSelected = n;
                int colMaxSelected = BasicTableUI.this.table.getColumnSelectionAllowed() ? colModel.getMaxSelectionIndex() : BasicTableUI.this.table.getModel().getColumnCount() - 1;
                int n2 = 0;
                if (BasicTableUI.this.table.getColumnSelectionAllowed()) {
                    n2 = colMinSelected = colModel.getMinSelectionIndex();
                }
                if (command.indexOf("Column") != -1) {
                    this.advanceMultipleSelection(colModel, colMinSelected, colMaxSelected, rowModel, rowMinSelected, rowMaxSelected, command.equals("selectPreviousColumnCell"), true);
                } else {
                    this.advanceMultipleSelection(rowModel, rowMinSelected, rowMaxSelected, colModel, colMinSelected, colMaxSelected, command.equals("selectPreviousRowCell"), false);
                }
            } else if (command.equals("selectNextColumn")) {
                rowModel.setSelectionInterval(rowLead, rowLead);
                colModel.setSelectionInterval(Math.min(colLead + 1, colMax), Math.min(colLead + 1, colMax));
            } else if (command.equals("scrollLeftExtendSelection")) {
                int target = colLead == this.getFirstVisibleColumnIndex() ? Math.max(0, colLead - (this.getLastVisibleColumnIndex() - this.getFirstVisibleColumnIndex() + 1)) : this.getFirstVisibleColumnIndex();
                colModel.setLeadSelectionIndex(target);
                rowModel.setLeadSelectionIndex(rowLead);
            } else if (command.equals("scrollDownChangeSelection")) {
                int target = rowLead == this.getLastVisibleRowIndex() ? Math.min(rowMax, rowLead + (this.getLastVisibleRowIndex() - this.getFirstVisibleRowIndex() + 1)) : this.getLastVisibleRowIndex();
                rowModel.setSelectionInterval(target, target);
                colModel.setSelectionInterval(colLead, colLead);
            } else if (command.equals("scrollRightExtendSelection")) {
                int target = colLead == this.getLastVisibleColumnIndex() ? Math.min(colMax, colLead + (this.getLastVisibleColumnIndex() - this.getFirstVisibleColumnIndex() + 1)) : this.getLastVisibleColumnIndex();
                colModel.setLeadSelectionIndex(target);
                rowModel.setLeadSelectionIndex(rowLead);
            } else if (command.equals("selectAll")) {
                BasicTableUI.this.table.selectAll();
            } else if (command.equals("selectLastRowExtendSelection")) {
                rowModel.setLeadSelectionIndex(rowMax);
                colModel.setLeadSelectionIndex(colLead);
            } else if (command.equals("scrollDownExtendSelection")) {
                int target = rowLead == this.getLastVisibleRowIndex() ? Math.min(rowMax, rowLead + (this.getLastVisibleRowIndex() - this.getFirstVisibleRowIndex() + 1)) : this.getLastVisibleRowIndex();
                rowModel.setLeadSelectionIndex(target);
                colModel.setLeadSelectionIndex(colLead);
            } else if (command.equals("scrollUpChangeSelection")) {
                int target = rowLead == this.getFirstVisibleRowIndex() ? Math.max(0, rowLead - (this.getLastVisibleRowIndex() - this.getFirstVisibleRowIndex() + 1)) : this.getFirstVisibleRowIndex();
                rowModel.setSelectionInterval(target, target);
                colModel.setSelectionInterval(colLead, colLead);
            } else if (command.equals("selectNextRowChangeLead")) {
                if (rowModel.getSelectionMode() != 2) {
                    rowModel.setSelectionInterval(Math.min(rowLead + 1, rowMax), Math.min(rowLead + 1, rowMax));
                    colModel.setSelectionInterval(colLead, colLead);
                } else {
                    rowModel.moveLeadSelectionIndex(Math.min(rowLead + 1, rowMax));
                }
            } else if (command.equals("selectPreviousRowChangeLead")) {
                if (rowModel.getSelectionMode() != 2) {
                    rowModel.setSelectionInterval(Math.max(rowLead - 1, 0), Math.min(rowLead - 1, 0));
                    colModel.setSelectionInterval(colLead, colLead);
                } else {
                    rowModel.moveLeadSelectionIndex(Math.max(rowLead - 1, 0));
                }
            } else if (command.equals("selectNextColumnChangeLead")) {
                if (colModel.getSelectionMode() != 2) {
                    rowModel.setSelectionInterval(rowLead, rowLead);
                    colModel.setSelectionInterval(Math.min(colLead + 1, colMax), Math.min(colLead + 1, colMax));
                } else {
                    colModel.moveLeadSelectionIndex(Math.min(colLead + 1, colMax));
                }
            } else if (command.equals("selectPreviousColumnChangeLead")) {
                if (colModel.getSelectionMode() != 2) {
                    rowModel.setSelectionInterval(rowLead, rowLead);
                    colModel.setSelectionInterval(Math.max(colLead - 1, 0), Math.max(colLead - 1, 0));
                } else {
                    colModel.moveLeadSelectionIndex(Math.max(colLead - 1, 0));
                }
            } else if (command.equals("addToSelection")) {
                if (!BasicTableUI.this.table.isEditing()) {
                    int oldRowAnchor = rowModel.getAnchorSelectionIndex();
                    int oldColAnchor = colModel.getAnchorSelectionIndex();
                    rowModel.addSelectionInterval(rowLead, rowLead);
                    colModel.addSelectionInterval(colLead, colLead);
                    rowModel.setAnchorSelectionIndex(oldRowAnchor);
                    colModel.setAnchorSelectionIndex(oldColAnchor);
                }
            } else if (command.equals("extendTo")) {
                rowModel.setSelectionInterval(rowModel.getAnchorSelectionIndex(), rowLead);
                colModel.setSelectionInterval(colModel.getAnchorSelectionIndex(), colLead);
            } else if (command.equals("toggleAndAnchor")) {
                if (rowModel.isSelectedIndex(rowLead)) {
                    rowModel.removeSelectionInterval(rowLead, rowLead);
                } else {
                    rowModel.addSelectionInterval(rowLead, rowLead);
                }
                if (colModel.isSelectedIndex(colLead)) {
                    colModel.removeSelectionInterval(colLead, colLead);
                } else {
                    colModel.addSelectionInterval(colLead, colLead);
                }
                rowModel.setAnchorSelectionIndex(rowLead);
                colModel.setAnchorSelectionIndex(colLead);
            }
            if (BasicTableUI.this.table.isEditing() && command != "startEditing" && command != "addToSelection") {
                BasicTableUI.this.table.editingStopped(new ChangeEvent("update"));
            }
            BasicTableUI.this.table.scrollRectToVisible(BasicTableUI.this.table.getCellRect(rowModel.getLeadSelectionIndex(), colModel.getLeadSelectionIndex(), false));
            BasicTableUI.this.table.repaint();
        }

        int getFirstVisibleColumnIndex() {
            ComponentOrientation or = BasicTableUI.this.table.getComponentOrientation();
            Rectangle r = BasicTableUI.this.table.getVisibleRect();
            if (!or.isLeftToRight()) {
                r.translate((int)r.getWidth() - 1, 0);
            }
            return BasicTableUI.this.table.columnAtPoint(r.getLocation());
        }

        int getLastVisibleColumnIndex() {
            ComponentOrientation or = BasicTableUI.this.table.getComponentOrientation();
            Rectangle r = BasicTableUI.this.table.getVisibleRect();
            if (or.isLeftToRight()) {
                r.translate((int)r.getWidth() - 1, 0);
            }
            return BasicTableUI.this.table.columnAtPoint(r.getLocation());
        }

        int getFirstVisibleRowIndex() {
            ComponentOrientation or = BasicTableUI.this.table.getComponentOrientation();
            Rectangle r = BasicTableUI.this.table.getVisibleRect();
            if (!or.isLeftToRight()) {
                r.translate((int)r.getWidth() - 1, 0);
            }
            return BasicTableUI.this.table.rowAtPoint(r.getLocation());
        }

        int getLastVisibleRowIndex() {
            ComponentOrientation or = BasicTableUI.this.table.getComponentOrientation();
            Rectangle r = BasicTableUI.this.table.getVisibleRect();
            r.translate(0, (int)r.getHeight() - 1);
            if (or.isLeftToRight()) {
                r.translate((int)r.getWidth() - 1, 0);
            }
            if (BasicTableUI.this.table.rowAtPoint(r.getLocation()) == -1) {
                if (this.getFirstVisibleRowIndex() == -1) {
                    return -1;
                }
                return BasicTableUI.this.table.getModel().getRowCount() - 1;
            }
            return BasicTableUI.this.table.rowAtPoint(r.getLocation());
        }

        /*
         * Unable to fully structure code
         */
        void advanceMultipleSelection(ListSelectionModel firstModel, int firstMin, int firstMax, ListSelectionModel secondModel, int secondMin, int secondMax, boolean reverse, boolean eventIsTab) {
            block14: {
                block16: {
                    block12: {
                        block15: {
                            block13: {
                                firstLead = firstModel.getLeadSelectionIndex();
                                secondLead = secondModel.getLeadSelectionIndex();
                                numFirsts = eventIsTab != false ? BasicTableUI.this.table.getModel().getColumnCount() : BasicTableUI.this.table.getModel().getRowCount();
                                v0 = numSeconds = eventIsTab != false ? BasicTableUI.this.table.getModel().getRowCount() : BasicTableUI.this.table.getModel().getColumnCount();
                                if ((firstLead != firstMax || reverse) && (!reverse || firstLead != firstMin)) break block12;
                                firstModel.addSelectionInterval(reverse != false ? firstMax : firstMin, reverse != false ? firstMax : firstMin);
                                if ((secondLead != secondMax || reverse) && (!reverse || secondLead != secondMin)) break block13;
                                secondModel.addSelectionInterval(reverse != false ? secondMax : secondMin, reverse != false ? secondMax : secondMin);
                                break block14;
                            }
                            if (eventIsTab && BasicTableUI.this.table.getRowSelectionAllowed() || !eventIsTab && BasicTableUI.this.table.getColumnSelectionAllowed()) {
                                secondsSelected = eventIsTab != false ? BasicTableUI.this.table.getSelectedRows() : BasicTableUI.this.table.getSelectedColumns();
                            } else {
                                secondsSelected = new int[numSeconds];
                                i = 0;
                                while (i < numSeconds) {
                                    secondsSelected[i] = i;
                                    ++i;
                                }
                            }
                            v1 = 0;
                            if (reverse) {
                                v1 = secondIndex = secondsSelected.length - 1;
                            }
                            if (reverse) ** GOTO lbl29
                            while (secondsSelected[secondIndex] <= secondLead) {
                                ++secondIndex;
                            }
                            break block15;
lbl-1000:
                            // 1 sources

                            {
                                --secondIndex;
lbl29:
                                // 2 sources

                                ** while (secondsSelected[secondIndex] >= secondLead)
                            }
                        }
                        secondModel.addSelectionInterval(secondsSelected[secondIndex], secondsSelected[secondIndex]);
                        break block14;
                    }
                    if (eventIsTab && BasicTableUI.this.table.getColumnSelectionAllowed() || !eventIsTab && BasicTableUI.this.table.getRowSelectionAllowed()) {
                        firstsSelected = eventIsTab != false ? BasicTableUI.this.table.getSelectedColumns() : BasicTableUI.this.table.getSelectedRows();
                    } else {
                        firstsSelected = new int[numFirsts];
                        i = 0;
                        while (i < numFirsts) {
                            firstsSelected[i] = i;
                            ++i;
                        }
                    }
                    v2 = 0;
                    if (reverse) {
                        v2 = firstIndex = firstsSelected.length - 1;
                    }
                    if (reverse) ** GOTO lbl52
                    while (firstsSelected[firstIndex] <= firstLead) {
                        ++firstIndex;
                    }
                    break block16;
lbl-1000:
                    // 1 sources

                    {
                        --firstIndex;
lbl52:
                        // 2 sources

                        ** while (firstsSelected[firstIndex] >= firstLead)
                    }
                }
                firstModel.addSelectionInterval(firstsSelected[firstIndex], firstsSelected[firstIndex]);
                secondModel.addSelectionInterval(secondLead, secondLead);
            }
        }

        void advanceSingleSelection(ListSelectionModel firstModel, int firstMax, ListSelectionModel secondModel, int secondMax, boolean reverse) {
            int firstLead = firstModel.getLeadSelectionIndex();
            int secondLead = secondModel.getLeadSelectionIndex();
            if (reverse && firstLead == 0) {
                if (secondLead == 0) {
                    secondLead += secondMax + 1;
                }
                secondLead -= 2;
            }
            if (reverse && firstLead == 0 || !reverse && firstLead == firstMax) {
                secondModel.setSelectionInterval((secondLead + 1) % (secondMax + 1), (secondLead + 1) % (secondMax + 1));
            } else {
                secondModel.setSelectionInterval(secondLead, secondLead);
            }
            if (reverse) {
                if (firstLead == 0) {
                    firstLead += firstMax + 1;
                }
                firstLead -= 2;
            }
            firstModel.setSelectionInterval((firstLead + 1) % (firstMax + 1), (firstLead + 1) % (firstMax + 1));
        }

        TableAction() {
        }
    }

    private static class ActionListenerProxy
    extends AbstractAction {
        ActionListener target;
        String bindingCommandName;

        public void actionPerformed(ActionEvent e) {
            ActionEvent derivedEvent = new ActionEvent(e.getSource(), e.getID(), this.bindingCommandName, e.getModifiers());
            this.target.actionPerformed(derivedEvent);
        }

        public ActionListenerProxy(ActionListener li, String cmd) {
            this.target = li;
            this.bindingCommandName = cmd;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent ev) {
            String propName = ev.getPropertyName();
            if (propName.equals("model")) {
                ListSelectionModel rowSel = BasicTableUI.this.table.getSelectionModel();
                rowSel.clearSelection();
                ListSelectionModel colSel = BasicTableUI.this.table.getColumnModel().getSelectionModel();
                colSel.clearSelection();
                TableModel model = BasicTableUI.this.table.getModel();
                if (model.getRowCount() > 0) {
                    rowSel.setAnchorSelectionIndex(0);
                    rowSel.setLeadSelectionIndex(0);
                } else {
                    rowSel.setAnchorSelectionIndex(-1);
                    rowSel.setLeadSelectionIndex(-1);
                }
                if (model.getColumnCount() > 0) {
                    colSel.setAnchorSelectionIndex(0);
                    colSel.setLeadSelectionIndex(0);
                } else {
                    colSel.setAnchorSelectionIndex(-1);
                    colSel.setLeadSelectionIndex(-1);
                }
            }
        }

        private PropertyChangeHandler() {
        }
    }
}

