package TDS::ID_Map;
# $Id: ID_Map.pm,v 1.4 2001/01/03 08:20:40 tom Exp $
################################################################

=head1 NAME

TDS::ID_Map - id ̾Υޥå

=head1 SYNOPSIS

 use TDS::ID_Map;

 $i = new TDS::ID_Map;
 $i->Map($id, $name);
 print $i->Map($id);

=head1 DESCRIPTION

tie ѿ

=cut


################################################################


use strict;
use ObjectTemplate;
use vars qw(@ISA);
use SimpleDB::Hash;
use TDS::AccessLog::DirInfo;

@ISA = qw(ObjectTemplate);


attributes qw(filename data);

=head1 MEMBER FUNCTIONS

=cut

sub initialize($)
{
    my $self = shift;

    $self->filename(GetLogDir() . "/id_map.dat") unless $self->filename;
    $self->data({});
    tie %{$self->data->{'map'}}, 'SimpleDB::Hash', $self->filename;

    $self->SUPER::initialize;
}

=head2 $i->Map($id, $name);

$id  $name åȡ

=head2 $i->Map($id);

$id б̾

=cut

sub Map($$;$)
{
    my ($self, $id, $name) = @_;

    if (defined $name){        # set
	return $self->data->{'map'}{$id} = $name;
    } else {                    # get
	return $self->data->{'map'}{$id};
    }
}
# not used
sub Name2ID($$)
{
    my ($self, $search_name) = @_;

    my ($id, $name);
    for (($id, $name) =  each %{$self->data->{map}}){
	if ($name eq $search_name){
	    return $id;
	}
    }
    return '';
}
sub All_ID
{
    my $self = shift;

    return keys %{$self->data->{'map'}};
}
1;

