/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.util;

import com.google.common.base.Charsets;
import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import com.martiansoftware.jsap.stringparsers.IntSizeStringParser;
import it.unimi.dsi.fastutil.bytes.ByteArrayFrontCodedList;
import it.unimi.dsi.fastutil.chars.CharArrayFrontCodedList;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectList;
import it.unimi.dsi.fastutil.objects.AbstractObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.LineIterator;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.logging.ProgressLogger;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.RandomAccess;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrontCodedStringList
extends AbstractObjectList<MutableString>
implements RandomAccess,
Serializable {
    public static final long serialVersionUID = 1L;
    protected final ByteArrayFrontCodedList byteFrontCodedList;
    protected final CharArrayFrontCodedList charFrontCodedList;
    protected final boolean utf8;

    public FrontCodedStringList(final Iterator<? extends CharSequence> words, int ratio, boolean utf8) {
        this.utf8 = utf8;
        if (utf8) {
            this.byteFrontCodedList = new ByteArrayFrontCodedList((Iterator)new AbstractObjectIterator<byte[]>(){

                public boolean hasNext() {
                    return words.hasNext();
                }

                public byte[] next() {
                    return ((CharSequence)words.next()).toString().getBytes(Charsets.UTF_8);
                }
            }, ratio);
            this.charFrontCodedList = null;
        } else {
            this.charFrontCodedList = new CharArrayFrontCodedList((Iterator)new AbstractObjectIterator<char[]>(){

                public boolean hasNext() {
                    return words.hasNext();
                }

                public char[] next() {
                    CharSequence s = (CharSequence)words.next();
                    int i = s.length();
                    char[] a = new char[i];
                    while (i-- != 0) {
                        a[i] = s.charAt(i);
                    }
                    return a;
                }
            }, ratio);
            this.byteFrontCodedList = null;
        }
    }

    public FrontCodedStringList(Collection<? extends CharSequence> c, int ratio, boolean utf8) {
        this(c.iterator(), ratio, utf8);
    }

    public boolean utf8() {
        return this.utf8;
    }

    public int ratio() {
        return this.utf8 ? this.byteFrontCodedList.ratio() : this.charFrontCodedList.ratio();
    }

    public MutableString get(int index) {
        return MutableString.wrap(this.utf8 ? FrontCodedStringList.byte2Char(this.byteFrontCodedList.getArray(index), null) : this.charFrontCodedList.getArray(index));
    }

    public void get(int index, MutableString s) {
        if (this.utf8) {
            byte[] a = this.byteFrontCodedList.getArray(index);
            s.length(FrontCodedStringList.countUTF8Chars(a));
            FrontCodedStringList.byte2Char(a, s.array());
        } else {
            s.length(s.array().length);
            int res = this.charFrontCodedList.get(index, s.array());
            if (res < 0) {
                s.length(s.array().length - res);
                res = this.charFrontCodedList.get(index, s.array());
            } else {
                s.length(res);
            }
        }
    }

    protected static int countUTF8Chars(byte[] a) {
        int length = a.length;
        int result = 0;
        for (int i = 0; i < length; ++i) {
            int b = (a[i] & 0xFF) >> 4;
            if (b < 8) {
                ++result;
                continue;
            }
            if (b < 14) {
                ++result;
                ++i;
                continue;
            }
            if (b < 15) {
                ++result;
                i += 2;
                continue;
            }
            result += 2;
            i += 4;
        }
        return result;
    }

    protected static char[] byte2Char(byte[] a, char[] s) {
        int length = a.length;
        if (s == null) {
            s = new char[FrontCodedStringList.countUTF8Chars(a)];
        }
        int j = 0;
        for (int i = 0; i < length; ++i) {
            int c;
            int b = a[i] & 0xFF;
            int t = b >> 4;
            if (t < 8) {
                s[j++] = (char)b;
                continue;
            }
            if (t < 14) {
                if (((c = a[++i] & 0xFF) & 0xC0) != 128) {
                    throw new IllegalStateException("Malformed internal UTF-8 encoding");
                }
                s[j++] = (char)((b & 0x1F) << 6 | c & 0x3F);
                continue;
            }
            if (t < 15) {
                c = a[++i] & 0xFF;
                byte d = a[++i];
                if ((c & 0xC0) != 128 || (d & 0xC0) != 128) {
                    throw new IllegalStateException("Malformed internal UTF-8 encoding");
                }
                s[j++] = (char)((b & 0xF) << 12 | (c & 0x3F) << 6 | (d & 0x3F) << 0);
                continue;
            }
            String surrogatePair = new String(a, i, 4, Charsets.UTF_8);
            s[j++] = surrogatePair.charAt(0);
            s[j++] = surrogatePair.charAt(1);
            i += 3;
        }
        return s;
    }

    public ObjectListIterator<MutableString> listIterator(final int k) {
        return new AbstractObjectListIterator<MutableString>(){
            ObjectListIterator<?> i;
            {
                this.i = FrontCodedStringList.this.utf8 ? FrontCodedStringList.this.byteFrontCodedList.listIterator(k) : FrontCodedStringList.this.charFrontCodedList.listIterator(k);
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public boolean hasPrevious() {
                return this.i.hasPrevious();
            }

            public MutableString next() {
                return MutableString.wrap(FrontCodedStringList.this.utf8 ? FrontCodedStringList.byte2Char((byte[])this.i.next(), null) : (char[])this.i.next());
            }

            public MutableString previous() {
                return MutableString.wrap(FrontCodedStringList.this.utf8 ? FrontCodedStringList.byte2Char((byte[])this.i.previous(), null) : (char[])this.i.previous());
            }

            public int nextIndex() {
                return this.i.nextIndex();
            }

            public int previousIndex() {
                return this.i.previousIndex();
            }
        };
    }

    public int size() {
        return this.utf8 ? this.byteFrontCodedList.size() : this.charFrontCodedList.size();
    }

    public static void main(String[] arg) throws IOException, JSAPException, NoSuchMethodException {
        SimpleJSAP jsap = new SimpleJSAP(FrontCodedStringList.class.getName(), "Builds a front-coded string list reading from standard input a newline-separated ordered list of strings.", new Parameter[]{new FlaggedOption("bufferSize", (StringParser)IntSizeStringParser.getParser(), "64Ki", false, 'b', "buffer-size", "The size of the I/O buffer used to read strings."), new FlaggedOption("encoding", (StringParser)ForNameStringParser.getParser(Charset.class), "UTF-8", false, 'e', "encoding", "The file encoding."), new FlaggedOption("ratio", (StringParser)IntSizeStringParser.getParser(), "4", false, 'r', "ratio", "The compression ratio."), new Switch("utf8", 'u', "utf8", "Store the strings as UTF-8 byte arrays."), new Switch("zipped", 'z', "zipped", "The string list is compressed in gzip format."), new UnflaggedOption("frontCodedList", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised front-coded list.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        int bufferSize = jsapResult.getInt("bufferSize");
        int ratio = jsapResult.getInt("ratio");
        boolean utf8 = jsapResult.getBoolean("utf8");
        boolean zipped = jsapResult.getBoolean("zipped");
        String listName = jsapResult.getString("frontCodedList");
        Charset encoding = (Charset)jsapResult.getObject("encoding");
        Logger logger = LoggerFactory.getLogger(FrontCodedStringList.class);
        ProgressLogger pl = new ProgressLogger(logger);
        pl.displayFreeMemory = true;
        pl.displayLocalSpeed = true;
        pl.itemsName = "strings";
        pl.start("Reading strings...");
        FrontCodedStringList frontCodedStringList = new FrontCodedStringList((Iterator<? extends CharSequence>)((Object)new LineIterator(new FastBufferedReader((Reader)new InputStreamReader(zipped ? new GZIPInputStream(System.in) : System.in, encoding), bufferSize), pl)), ratio, utf8);
        pl.done();
        logger.info("Writing front-coded list to file...");
        BinIO.storeObject((Object)frontCodedStringList, (CharSequence)listName);
        logger.info("Completed.");
    }
}

