/*
 * Decompiled with CFR 0.152.
 */
package org.usadellab.trimmomatic.trim;

import org.usadellab.trimmomatic.fastq.FastqRecord;
import org.usadellab.trimmomatic.trim.AbstractSingleRecordTrimmer;

public class SlidingWindowTrimmer
extends AbstractSingleRecordTrimmer {
    private int windowLength;
    private float requiredQuality;
    private float totalRequiredQuality;

    public SlidingWindowTrimmer(String args) {
        String[] arg = args.split(":");
        this.windowLength = Integer.parseInt(arg[0]);
        this.requiredQuality = Float.parseFloat(arg[1]);
        this.totalRequiredQuality = this.requiredQuality * (float)this.windowLength;
    }

    public SlidingWindowTrimmer(int windowLength, float requiredQuality) {
        this.windowLength = windowLength;
        this.requiredQuality = requiredQuality;
        this.totalRequiredQuality = requiredQuality * (float)windowLength;
    }

    public FastqRecord processRecord(FastqRecord in) {
        int i;
        int[] quals = in.getQualityAsInteger(true);
        if (quals.length < this.windowLength) {
            return null;
        }
        int total = 0;
        for (int i2 = 0; i2 < this.windowLength; ++i2) {
            total += quals[i2];
        }
        if ((float)total < this.totalRequiredQuality) {
            return null;
        }
        int lengthToKeep = quals.length;
        for (i = 0; i < quals.length - this.windowLength; ++i) {
            if (!((float)(total = total - quals[i] + quals[i + this.windowLength]) < this.totalRequiredQuality)) continue;
            lengthToKeep = i + this.windowLength;
            break;
        }
        i = lengthToKeep;
        int lastBaseQuality = quals[i - 1];
        while ((float)lastBaseQuality < this.requiredQuality && i > 1) {
            lastBaseQuality = quals[--i - 1];
        }
        if (i < 1) {
            return null;
        }
        if (i < quals.length) {
            return new FastqRecord(in, 0, i);
        }
        return in;
    }
}

