/* build a house and look at it in 3-D perspective */
#include <stdio.h>
main()
{
  int time;
  float xp,yp,zp,xf,yf,zf,zoom;
  xf = .5;
  yf = .5;
  zf = .3;
  zoom = 2.;
  gopen();
  for (time = 0; time < 13; time++) {
    yp = -2 + time*time*time*time/2000.;
    zp = time*time/50.;
    xp = -5. + time;
    gclear();
    window(1,0.,15.,0.,10.);
    pview(1,xp,yp,zp,xf,yf,zf,zoom);
    house();
    gpause();
  }
  gclose();
}

house()
{
  static float x[5],y[5],z[5];
/* foundation */
  x[0] = x[3] = x[4] = 0.;
  x[1] = x[2] = 1.;
  y[0] = y[1] = y[4] = 0.;
  y[2] = y[3] = 1.;
  z[0] = z[1] = z[2] = z[3] = z[4] = 0.;
  pline(1,1,5,x,y,z);
/* front wall */
  x[0] = x[1] = 0.;
  x[2] = x[3] = 1.;
  z[0] = z[3] = 0.;
  z[1] = .5;
  z[2] = .8;
  y[0] = y[1] = y[2] = y[3] = 0.;
  pline(1,1,4,x,y,z);
/* back wall */
  y[0] = y[1] = y[2] = y[3] = 1.;
  pline(1,1,4,x,y,z);
/* roof */
  x[0] = x[1] = 0.;
  x[2] = x[3] = 1.;
  y[0] = y[3] = 0.;
  y[1] = y[2] = 1.;
  z[0] = z[1] = .5;
  z[2] = z[3] = .8;
  pline(1,1,4,x,y,z);
/* door */
  x[0] = x[1] = .6;
  x[2] = x[3] = .8;
  z[0] = z[3] = 0.;
  z[1] = z[2] = .4;
  y[0] = y[1] = y[2] = y[3] = 0.;
  pline(1,3,4,x,y,z);
/* labels */
  plabel(1,.5,.5,.2,"house");
  plabel(1,.5,-1.,0.,"west");
}
