/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap.stringparsers;

import com.martiansoftware.jsap.ParseException;
import com.martiansoftware.jsap.StringParser;
import java.awt.Color;
import java.util.StringTokenizer;

public class ColorStringParser
extends StringParser {
    private static final ColorStringParser INSTANCE = new ColorStringParser();

    public static ColorStringParser getParser() {
        return INSTANCE;
    }

    private ParseException colorException(String s) {
        return new ParseException("Unable to convert '" + s + "' to a Color.");
    }

    private Color parseHexColor(String hexString) throws ParseException {
        Color result = null;
        int hexLength = hexString.length();
        if (hexLength != 7 && hexLength != 9) {
            throw this.colorException(hexString);
        }
        try {
            int red = Integer.parseInt(hexString.substring(1, 3), 16);
            int green = Integer.parseInt(hexString.substring(3, 5), 16);
            int blue = Integer.parseInt(hexString.substring(5, 7), 16);
            if (hexLength == 7) {
                result = new Color(red, green, blue);
            } else {
                int alpha = Integer.parseInt(hexString.substring(7, 9), 16);
                result = new Color(red, green, blue, alpha);
            }
        }
        catch (NumberFormatException e) {
            throw this.colorException(hexString);
        }
        return result;
    }

    private Color parseFloatTuple(String floatString) throws ParseException {
        String[] tuple = this.tupleToArray(floatString);
        Color result = null;
        try {
            float red = Float.parseFloat(tuple[0]);
            float green = Float.parseFloat(tuple[1]);
            float blue = Float.parseFloat(tuple[2]);
            if (tuple.length == 3) {
                result = new Color(red, green, blue);
            } else {
                float alpha = Float.parseFloat(tuple[3]);
                result = new Color(red, green, blue, alpha);
            }
        }
        catch (NumberFormatException e) {
            throw this.colorException(floatString);
        }
        return result;
    }

    private Color parseIntTuple(String intString) throws ParseException {
        String[] tuple = this.tupleToArray(intString);
        Color result = null;
        try {
            int red = Integer.parseInt(tuple[0]);
            int green = Integer.parseInt(tuple[1]);
            int blue = Integer.parseInt(tuple[2]);
            if (tuple.length == 3) {
                result = new Color(red, green, blue);
            } else {
                int alpha = Integer.parseInt(tuple[3]);
                result = new Color(red, green, blue, alpha);
            }
        }
        catch (NumberFormatException e) {
            throw this.colorException(intString);
        }
        return result;
    }

    private Color parseColorName(String colorName) throws ParseException {
        Color result = null;
        if (colorName.equalsIgnoreCase("black")) {
            result = Color.black;
        } else if (colorName.equalsIgnoreCase("blue")) {
            result = Color.blue;
        } else if (colorName.equalsIgnoreCase("cyan")) {
            result = Color.cyan;
        } else if (colorName.equalsIgnoreCase("gray")) {
            result = Color.gray;
        } else if (colorName.equalsIgnoreCase("green")) {
            result = Color.green;
        } else if (colorName.equalsIgnoreCase("lightGray")) {
            result = Color.lightGray;
        } else if (colorName.equalsIgnoreCase("magenta")) {
            result = Color.magenta;
        } else if (colorName.equalsIgnoreCase("orange")) {
            result = Color.orange;
        } else if (colorName.equalsIgnoreCase("pink")) {
            result = Color.pink;
        } else if (colorName.equalsIgnoreCase("red")) {
            result = Color.red;
        } else if (colorName.equalsIgnoreCase("white")) {
            result = Color.white;
        } else if (colorName.equalsIgnoreCase("yellow")) {
            result = Color.yellow;
        } else {
            throw this.colorException(colorName);
        }
        return result;
    }

    private String[] tupleToArray(String s) throws ParseException {
        String[] result = null;
        StringTokenizer tokenizer = new StringTokenizer(s, ",", true);
        int tokenCount = tokenizer.countTokens();
        if (tokenCount == 5) {
            result = new String[3];
        } else if (tokenCount == 7) {
            result = new String[4];
        } else {
            throw this.colorException(s);
        }
        result[0] = tokenizer.nextToken();
        tokenizer.nextToken();
        result[1] = tokenizer.nextToken();
        tokenizer.nextToken();
        result[2] = tokenizer.nextToken();
        if (tokenCount == 7) {
            tokenizer.nextToken();
            result[3] = tokenizer.nextToken();
        }
        return result;
    }

    @Override
    public Object parse(String arg) throws ParseException {
        Color result = null;
        result = arg.charAt(0) == '#' ? this.parseHexColor(arg) : (arg.indexOf(".") >= 0 ? this.parseFloatTuple(arg) : (arg.indexOf(",") >= 0 ? this.parseIntTuple(arg) : this.parseColorName(arg)));
        return result;
    }
}

