/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.pipeline;

import gnu.xml.pipeline.EventConsumer;
import gnu.xml.pipeline.EventFilter;
import java.util.EmptyStackException;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class WellFormednessFilter
extends EventFilter {
    private boolean startedDoc;
    private Stack elementStack;
    private boolean startedCDATA;
    private String dtdState;

    public final void reset() {
        this.startedDoc = false;
        this.startedCDATA = false;
        this.elementStack.removeAllElements();
    }

    private final SAXParseException getException(String message) {
        Locator locator = this.getDocumentLocator();
        if (locator == null) {
            return new SAXParseException(message, null, null, -1, -1);
        }
        return new SAXParseException(message, locator);
    }

    private final void fatalError(String message) throws SAXException {
        SAXParseException e = this.getException(message);
        ErrorHandler handler = this.getErrorHandler();
        if (handler != null) {
            handler.fatalError(e);
        }
        throw e;
    }

    public final void setDocumentLocator(Locator locator) {
        if (this.startedDoc) {
            throw new IllegalStateException("setDocumentLocator called after startDocument");
        }
        super.setDocumentLocator(locator);
    }

    public final void startDocument() throws SAXException {
        if (this.startedDoc) {
            this.fatalError("startDocument called more than once");
        }
        this.startedDoc = true;
        this.startedCDATA = false;
        this.elementStack.removeAllElements();
        super.startDocument();
    }

    public final void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (!this.startedDoc) {
            this.fatalError("callback outside of document?");
        }
        if ("inside".equals(this.dtdState)) {
            this.fatalError("element inside DTD?");
        } else {
            this.dtdState = "after";
        }
        if (this.startedCDATA) {
            this.fatalError("element inside CDATA section");
        }
        if (qName == null || "".equals(qName)) {
            this.fatalError("startElement name missing");
        }
        this.elementStack.push(qName);
        super.startElement(uri, localName, qName, atts);
    }

    public final void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.startedDoc) {
            this.fatalError("callback outside of document?");
        }
        if (this.startedCDATA) {
            this.fatalError("element inside CDATA section");
        }
        if (qName == null || "".equals(qName)) {
            this.fatalError("endElement name missing");
        }
        try {
            String top = (String)this.elementStack.pop();
            if (!qName.equals(top)) {
                this.fatalError("<" + top + " ...>...</" + qName + '>');
            }
        }
        catch (EmptyStackException e) {
            this.fatalError("endElement without startElement:  </" + qName + '>');
        }
        super.endElement(uri, localName, qName);
    }

    public final void endDocument() throws SAXException {
        if (!this.startedDoc) {
            this.fatalError("callback outside of document?");
        }
        this.dtdState = "before";
        this.startedDoc = false;
        super.endDocument();
    }

    public final void startDTD(String root, String publicId, String systemId) throws SAXException {
        if (!this.startedDoc) {
            this.fatalError("callback outside of document?");
        }
        if ("before" != this.dtdState) {
            this.fatalError("two DTDs?");
        }
        if (!this.elementStack.empty()) {
            this.fatalError("DTD must precede root element");
        }
        this.dtdState = "inside";
        super.startDTD(root, publicId, systemId);
    }

    public final void notationDecl(String name, String publicId, String systemId) throws SAXException {
        if ("after" == this.dtdState) {
            this.fatalError("not inside DTD");
        }
        super.notationDecl(name, publicId, systemId);
    }

    public final void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        if ("after" == this.dtdState) {
            this.fatalError("not inside DTD");
        }
        super.unparsedEntityDecl(name, publicId, systemId, notationName);
    }

    public final void endDTD() throws SAXException {
        if (!this.startedDoc) {
            this.fatalError("callback outside of document?");
        }
        if ("inside" != this.dtdState) {
            this.fatalError("DTD ends without start?");
        }
        this.dtdState = "after";
        super.endDTD();
    }

    public final void characters(char[] ch, int start, int length) throws SAXException {
        int here = start;
        int end = start + length;
        if (this.elementStack.empty()) {
            this.fatalError("characters must be in an element");
        }
        while (here < end) {
            if (ch[here++] != ']' || here == end || ch[here++] != ']' || here == end || ch[here++] != '>') continue;
            this.fatalError("character data can't contain \"]]>\"");
        }
        super.characters(ch, start, length);
    }

    public final void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        int here = start;
        int end = start + length;
        if (this.elementStack.empty()) {
            this.fatalError("characters must be in an element");
        }
        while (here < end) {
            if (ch[here++] != '\r') continue;
            this.fatalError("whitespace can't contain CR");
        }
        super.ignorableWhitespace(ch, start, length);
    }

    public final void processingInstruction(String target, String data) throws SAXException {
        if (data.indexOf(13) > 0) {
            this.fatalError("PIs can't contain CR");
        }
        if (data.indexOf("?>") > 0) {
            this.fatalError("PIs can't contain \"?>\"");
        }
    }

    public final void comment(char[] ch, int start, int length) throws SAXException {
        if (!this.startedDoc) {
            this.fatalError("callback outside of document?");
        }
        if (this.startedCDATA) {
            this.fatalError("comments can't nest in CDATA");
        }
        int here = start;
        int end = start + length;
        while (here < end) {
            if (ch[here] == '\r') {
                this.fatalError("comments can't contain CR");
            }
            if (ch[here++] != '-') continue;
            if (here == end) {
                this.fatalError("comments can't end with \"--->\"");
            }
            if (ch[here++] != '-') continue;
            this.fatalError("comments can't contain \"--\"");
        }
        super.comment(ch, start, length);
    }

    public final void startCDATA() throws SAXException {
        if (!this.startedDoc) {
            this.fatalError("callback outside of document?");
        }
        if (this.startedCDATA) {
            this.fatalError("CDATA starts can't nest");
        }
        this.startedCDATA = true;
        super.startCDATA();
    }

    public final void endCDATA() throws SAXException {
        if (!this.startedDoc) {
            this.fatalError("callback outside of document?");
        }
        if (!this.startedCDATA) {
            this.fatalError("CDATA end without start?");
        }
        this.startedCDATA = false;
        super.endCDATA();
    }

    private final /* synthetic */ void this() {
        this.elementStack = new Stack();
        this.dtdState = "before";
    }

    public WellFormednessFilter() {
        this(null);
    }

    public WellFormednessFilter(EventConsumer consumer) {
        super(consumer);
        this.this();
        this.setContentHandler(this);
        this.setDTDHandler(this);
        try {
            this.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }
}

