require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_AMIGA_INTR_H_)) {
    eval 'sub _AMIGA_INTR_H_ () {1;}' unless defined(&_AMIGA_INTR_H_);
    require 'amiga/amiga/isr.ph';
    require 'm68k/psl.ph';
    eval 'sub IPL_NONE () {0;}' unless defined(&IPL_NONE);
    eval 'sub IPL_SOFTCLOCK () {1;}' unless defined(&IPL_SOFTCLOCK);
    eval 'sub IPL_SOFTBIO () {1;}' unless defined(&IPL_SOFTBIO);
    eval 'sub IPL_SOFTNET () {1;}' unless defined(&IPL_SOFTNET);
    eval 'sub IPL_SOFTSERIAL () {1;}' unless defined(&IPL_SOFTSERIAL);
    eval 'sub IPL_VM () {2;}' unless defined(&IPL_VM);
    eval 'sub IPL_SCHED () {3;}' unless defined(&IPL_SCHED);
    eval 'sub IPL_HIGH () {4;}' unless defined(&IPL_HIGH);
    eval 'sub _NIPL () {5;}' unless defined(&_NIPL);
    if(defined(&_KERNEL)) {
	eval 'sub makeiplcookie {
	    my($ipl) = @_;
    	    eval q({ ( &ipl_cookie_t){. &_ipl = $ipl}; });
	}' unless defined(&makeiplcookie);
	eval 'sub splraiseipl {
	    my($icookie) = @_;
    	    eval q({  &_splraise( $ipl2spl_table[ ($icookie->{_ipl})]); });
	}' unless defined(&splraiseipl);
	if(defined(&_KERNEL_OPT)) {
	    require './amiga/opt_lev6_defer.ph';
	}
	eval 'sub spl0 () {
	    eval q( &_spl0());
	}' unless defined(&spl0);
	eval 'sub splsoftclock () {
	    eval q( &splraise1());
	}' unless defined(&splsoftclock);
	eval 'sub splsoftnet () {
	    eval q( &splraise1());
	}' unless defined(&splsoftnet);
	eval 'sub splsoftserial () {
	    eval q( &splraise1());
	}' unless defined(&splsoftserial);
	eval 'sub splsoftbio () {
	    eval q( &splraise1());
	}' unless defined(&splsoftbio);
	eval 'sub splvm () {
	    eval q( &splraise4());
	}' unless defined(&splvm);
	unless(defined(&_MODULE)) {
	    unless(defined(&LEV6_DEFER)) {
		eval 'sub splsched () {
		    eval q( &splraise6());
		}' unless defined(&splsched);
		eval 'sub splhigh () {
		    eval q( &spl7());
		}' unless defined(&splhigh);
	    } else {
		eval 'sub splsched () {
		    eval q( &splraise4());
		}' unless defined(&splsched);
		eval 'sub splhigh () {
		    eval q( &splraise4());
		}' unless defined(&splhigh);
	    }
	} else {
	    eval 'sub splsched () {
	        eval q( &_spllkm6());
	    }' unless defined(&splsched);
	    eval 'sub splhigh () {
	        eval q( &_spllkm7());
	    }' unless defined(&splhigh);
	}
	eval 'sub splx {
	    my($s) = @_;
    	    eval q( &_spl($s));
	}' unless defined(&splx);
    }
}
1;
