require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_V7FS_H_)) {
    eval 'sub _V7FS_H_ () {1;}' unless defined(&_V7FS_H_);
    require 'sys/types.ph';
    unless(defined(&_KERNEL)) {
	require 'inttypes.ph';
    }
    eval 'sub V7FS_DADDR_MAX () {0xffffff;}' unless defined(&V7FS_DADDR_MAX);
    eval 'sub V7FS_INODE_MAX () {0xffff;}' unless defined(&V7FS_INODE_MAX);
    eval 'sub V7FS_BSIZE () {512;}' unless defined(&V7FS_BSIZE);
    eval 'sub V7FS_BSHIFT () {9;}' unless defined(&V7FS_BSHIFT);
    eval 'sub V7FS_ROUND_BSIZE {
        my($x) = @_;
	    eval q((((($x) + ( &V7FS_BSIZE - 1)) & ~( &V7FS_BSIZE - 1))));
    }' unless defined(&V7FS_ROUND_BSIZE);
    eval 'sub V7FS_TRUNC_BSIZE {
        my($x) = @_;
	    eval q((($x) & ~( &V7FS_BSIZE - 1)));
    }' unless defined(&V7FS_TRUNC_BSIZE);
    eval 'sub V7FS_RESIDUE_BSIZE {
        my($x) = @_;
	    eval q((($x) - (((($x) - 1) >>  &V7FS_BSHIFT) <<  &V7FS_BSHIFT)));
    }' unless defined(&V7FS_RESIDUE_BSIZE);
    eval 'sub V7FS_BOOTBLOCK_SECTOR () {0;}' unless defined(&V7FS_BOOTBLOCK_SECTOR);
    eval 'sub V7FS_SUPERBLOCK_SECTOR () {1;}' unless defined(&V7FS_SUPERBLOCK_SECTOR);
    eval 'sub V7FS_ILIST_SECTOR () {2;}' unless defined(&V7FS_ILIST_SECTOR);
    eval 'sub V7FS_MAX_FREEBLOCK () {50;}' unless defined(&V7FS_MAX_FREEBLOCK);
    eval 'sub V7FS_MAX_FREEINODE () {100;}' unless defined(&V7FS_MAX_FREEINODE);
    eval 'sub V7FS_NADDR () {13;}' unless defined(&V7FS_NADDR);
    eval 'sub V7FS_NADDR_DIRECT () {10;}' unless defined(&V7FS_NADDR_DIRECT);
    eval 'sub V7FS_NADDR_INDEX1 () {10;}' unless defined(&V7FS_NADDR_INDEX1);
    eval 'sub V7FS_NADDR_INDEX2 () {11;}' unless defined(&V7FS_NADDR_INDEX2);
    eval 'sub V7FS_NADDR_INDEX3 () {12;}' unless defined(&V7FS_NADDR_INDEX3);
    eval 'sub V7FS_DADDR_PER_BLOCK () {( &V7FS_BSIZE / $sizeof{ &v7fs_daddr_t});}' unless defined(&V7FS_DADDR_PER_BLOCK);
    eval 'sub V7FS_NAME_MAX () {14;}' unless defined(&V7FS_NAME_MAX);
    eval 'sub V7FS_PATH_MAX () { &PATH_MAX;}' unless defined(&V7FS_PATH_MAX);
    eval 'sub V7FS_LINK_MAX () { &LINK_MAX;}' unless defined(&V7FS_LINK_MAX);
    eval 'sub V7FS_BALBLK_INODE () {1;}' unless defined(&V7FS_BALBLK_INODE);
    eval 'sub V7FS_ROOT_INODE () {2;}' unless defined(&V7FS_ROOT_INODE);
    eval 'sub V7FS_MAX_INODE {
        my($s) = @_;
	    eval q(((($s)-> &datablock_start_sector -  &V7FS_ILIST_SECTOR) *  &V7FS_BSIZE / $sizeof{\'struct v7fs_inode_diskimage\'}));
    }' unless defined(&V7FS_MAX_INODE);
    eval 'sub V7FS_INODE_PER_BLOCK () {( &V7FS_BSIZE / $sizeof{\'struct v7fs_inode_diskimage\'});}' unless defined(&V7FS_INODE_PER_BLOCK);
    eval 'sub V7FS_ILISTBLK_MAX () {( &V7FS_INODE_MAX /  &V7FS_INODE_PER_BLOCK);}' unless defined(&V7FS_ILISTBLK_MAX);
    eval 'sub V7FS_DINODE_ADDR_LEN () {40;}' unless defined(&V7FS_DINODE_ADDR_LEN);
    eval 'sub V7FS_IFMT () {0170000;}' unless defined(&V7FS_IFMT);
    eval 'sub V7FS_IFCHR () {0020000;}' unless defined(&V7FS_IFCHR);
    eval 'sub V7FS_IFDIR () {0040000;}' unless defined(&V7FS_IFDIR);
    eval 'sub V7FS_IFBLK () {0060000;}' unless defined(&V7FS_IFBLK);
    eval 'sub V7FS_IFREG () {0100000;}' unless defined(&V7FS_IFREG);
    eval 'sub V7FS_IFMPC () {0030000;}' unless defined(&V7FS_IFMPC);
    eval 'sub V7FS_IFMPB () {0070000;}' unless defined(&V7FS_IFMPB);
    eval 'sub V7FSBSD_IFLNK () {0120000;}' unless defined(&V7FSBSD_IFLNK);
    eval 'sub V7FSBSD_IFSOCK () {0140000;}' unless defined(&V7FSBSD_IFSOCK);
    eval 'sub V7FSBSD_IFFIFO () {0010000;}' unless defined(&V7FSBSD_IFFIFO);
    eval 'sub V7FSBSD_MAXSYMLINKLEN () { &V7FS_BSIZE;}' unless defined(&V7FSBSD_MAXSYMLINKLEN);
}
1;
