/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.AbstractTool;
import java.awt.event.MouseEvent;

public class DragTracker
extends AbstractTool {
    private Figure fAnchorFigure;
    private int fLastX;
    private int fLastY;
    private boolean fMoved = false;

    public DragTracker(DrawingView drawingView, Figure figure) {
        super(drawingView);
        this.fAnchorFigure = figure;
    }

    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        super.mouseDown(mouseEvent, n, n2);
        this.fLastX = n;
        this.fLastY = n2;
        if (mouseEvent.isShiftDown()) {
            this.view().toggleSelection(this.fAnchorFigure);
            this.fAnchorFigure = null;
        } else if (!this.view().selection().contains(this.fAnchorFigure)) {
            this.view().clearSelection();
            this.view().addToSelection(this.fAnchorFigure);
        }
    }

    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
        super.mouseDrag(mouseEvent, n, n2);
        boolean bl = this.fMoved = Math.abs(n - this.fAnchorX) > 4 || Math.abs(n2 - this.fAnchorY) > 4;
        if (this.fMoved) {
            this.view().moveSelection(n - this.fLastX, n2 - this.fLastY);
        }
        this.fLastX = n;
        this.fLastY = n2;
    }
}

