/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.reference;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Lazy;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Supplier;

abstract class AbstractFastaSequenceFile
implements ReferenceSequenceFile {
    private final Path path;
    private final String source;
    private final Lazy<SAMSequenceDictionary> dictionary;

    AbstractFastaSequenceFile(File file) {
        this(IOUtil.toPath(file));
    }

    AbstractFastaSequenceFile(Path path) {
        this.path = path;
        this.source = path == null ? "unknown" : path.toAbsolutePath().toString();
        this.dictionary = new Lazy((Supplier<SAMSequenceDictionary> & Serializable)() -> this.findAndLoadSequenceDictionary(path));
    }

    AbstractFastaSequenceFile(Path path, String source, SAMSequenceDictionary sequenceDictionary) {
        this.path = path;
        this.source = source;
        this.dictionary = new Lazy((Supplier<SAMSequenceDictionary> & Serializable)() -> sequenceDictionary);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SAMSequenceDictionary findAndLoadSequenceDictionary(Path fasta) {
        Path dictPath = AbstractFastaSequenceFile.findSequenceDictionary(this.path);
        if (dictPath == null) {
            return null;
        }
        IOUtil.assertFileIsReadable(dictPath);
        try (InputStream dictionaryIn = IOUtil.openFileForReading(dictPath);){
            SAMSequenceDictionary sAMSequenceDictionary = ReferenceSequenceFileFactory.loadDictionary(dictionaryIn);
            return sAMSequenceDictionary;
        }
        catch (Exception e) {
            throw new SAMException("Could not open sequence dictionary file: " + dictPath, e);
        }
    }

    @Deprecated
    protected static File findSequenceDictionary(File file) {
        Path dict = AbstractFastaSequenceFile.findSequenceDictionary(file.toPath());
        return dict == null ? null : dict.toFile();
    }

    protected static Path findSequenceDictionary(Path fastaPath) {
        if (fastaPath == null) {
            return null;
        }
        Path dictionary = ReferenceSequenceFileFactory.getDefaultDictionaryForReferenceSequence(fastaPath);
        if (Files.exists(dictionary, new LinkOption[0])) {
            return dictionary;
        }
        Path dictionaryExt = fastaPath.resolveSibling(fastaPath.getFileName().toString() + ".dict");
        if (Files.exists(dictionaryExt, new LinkOption[0])) {
            return dictionaryExt;
        }
        return null;
    }

    protected Path getPath() {
        return this.path;
    }

    protected String getSource() {
        return this.source;
    }

    @Override
    public SAMSequenceDictionary getSequenceDictionary() {
        return this.dictionary.get();
    }

    protected String getAbsolutePath() {
        if (this.path == null) {
            return null;
        }
        return this.path.toAbsolutePath().toString();
    }

    @Override
    public String toString() {
        return this.source;
    }

    @Override
    public boolean isIndexed() {
        return false;
    }

    @Override
    public ReferenceSequence getSequence(String contig) {
        throw new UnsupportedOperationException("Index does not appear to exist for " + this.getSource() + ".  samtools faidx can be used to create an index");
    }

    @Override
    public ReferenceSequence getSubsequenceAt(String contig, long start, long stop) {
        throw new UnsupportedOperationException("Index does not appear to exist for " + this.getSource() + ".  samtools faidx can be used to create an index");
    }
}

