/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.counts;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import org.campagnelab.goby.counts.CountsWriterHelperI;
import org.campagnelab.goby.counts.CountsWriterI;

public class CountWriterHelper2
implements CountsWriterHelperI {
    private final CountsWriterI delegate;
    private int previousCount;
    private int previousPosition = -1;
    private final IntList counts;
    private final IntList positions;

    public CountWriterHelper2(CountsWriterI delegate) {
        this.delegate = delegate;
        this.previousCount = delegate.getInitialCount();
        this.counts = new IntArrayList();
        this.positions = new IntArrayList();
        this.positions.add(-1);
        this.counts.add(0);
    }

    @Override
    public void appendCountAtPosition(int count, int position) throws IOException {
        if (position != this.previousPosition + 1 && count != 0) {
            this.counts.add(0);
            this.positions.add(position - 1);
        }
        this.counts.add(count);
        this.positions.add(position);
        if (this.positions.size() >= 2) {
            int i = this.counts.size() - 2;
            int j = this.counts.size() - 1;
            if (this.counts.getInt(i) == this.counts.getInt(j)) {
                this.positions.removeElements(i, j);
                this.counts.removeElements(i, j);
            }
        }
        while (this.positions.size() > 2) {
            int diffPos = this.positions.getInt(1) - (this.positions.getInt(0) + 1);
            int aCount = this.counts.getInt(1);
            if (aCount < 0) {
                System.out.println(this.counts);
                System.out.println(this.positions);
                System.out.printf("Count can never be negative (found value=%d at position %d). Setting count to zero", aCount, this.positions.getInt(0));
                aCount = 0;
            }
            if (diffPos < 0) {
                System.out.printf("diffPos can never be negative (found value=%d at position[1]: %d positions[0]:%d). Setting diffPos to zero", diffPos, this.positions.getInt(1), this.positions.getInt(0));
                System.out.println(this.counts);
                System.out.println(this.positions);
                diffPos = 0;
            }
            this.delegate.appendCount(aCount, diffPos + 1);
            this.positions.removeElements(0, 1);
            this.counts.removeElements(0, 1);
            this.previousCount = count;
        }
        this.previousPosition = position;
    }

    @Override
    public void close() throws IOException {
        int n = this.counts.size() - 1;
        if ((Integer)this.counts.get(n) != 0) {
            this.counts.add(0);
            this.positions.add((Integer)this.positions.get(n) + 1);
        }
        int count = (Integer)this.counts.get(0);
        while (this.positions.size() >= 2) {
            int diffPos = this.positions.getInt(1) - (this.positions.getInt(0) + 1);
            int aCount = this.counts.getInt(1);
            if (aCount < 0) {
                System.out.printf("Count can never be negative (found value=%d at position %d). Setting count to zero", aCount, this.positions.getInt(0));
                aCount = 0;
            }
            this.delegate.appendCount(aCount, diffPos + 1);
            this.positions.removeElements(0, 1);
            this.counts.removeElements(0, 1);
            this.previousCount = count;
        }
        this.delegate.close();
    }
}

