require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&OPENSSL_TLS1_H)) {
    eval 'sub OPENSSL_TLS1_H () {1;}' unless defined(&OPENSSL_TLS1_H);
    require 'openssl/macros.ph';
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	eval 'sub HEADER_TLS1_H () {1;}' unless defined(&HEADER_TLS1_H);
    }
    require 'openssl/buffer.ph';
    require 'openssl/x509.ph';
    require 'openssl/prov_ssl.ph';
    if(defined(&__cplusplus)) {
    }
    unless(defined(&OPENSSL_TLS_SECURITY_LEVEL)) {
	eval 'sub OPENSSL_TLS_SECURITY_LEVEL () {2;}' unless defined(&OPENSSL_TLS_SECURITY_LEVEL);
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	eval 'sub TLS_MAX_VERSION () { &TLS1_3_VERSION;}' unless defined(&TLS_MAX_VERSION);
    }
    eval 'sub TLS_ANY_VERSION () {0x10000;}' unless defined(&TLS_ANY_VERSION);
    eval 'sub TLS1_VERSION_MAJOR () {0x3;}' unless defined(&TLS1_VERSION_MAJOR);
    eval 'sub TLS1_VERSION_MINOR () {0x1;}' unless defined(&TLS1_VERSION_MINOR);
    eval 'sub TLS1_1_VERSION_MAJOR () {0x3;}' unless defined(&TLS1_1_VERSION_MAJOR);
    eval 'sub TLS1_1_VERSION_MINOR () {0x2;}' unless defined(&TLS1_1_VERSION_MINOR);
    eval 'sub TLS1_2_VERSION_MAJOR () {0x3;}' unless defined(&TLS1_2_VERSION_MAJOR);
    eval 'sub TLS1_2_VERSION_MINOR () {0x3;}' unless defined(&TLS1_2_VERSION_MINOR);
    eval 'sub TLS1_get_version {
        my($s) = @_;
	    eval q((( &SSL_version($s) >> 8) ==  &TLS1_VERSION_MAJOR ?  &SSL_version($s) : 0));
    }' unless defined(&TLS1_get_version);
    eval 'sub TLS1_get_client_version {
        my($s) = @_;
	    eval q((( &SSL_client_version($s) >> 8) ==  &TLS1_VERSION_MAJOR ?  &SSL_client_version($s) : 0));
    }' unless defined(&TLS1_get_client_version);
    eval 'sub TLS1_AD_DECRYPTION_FAILED () {21;}' unless defined(&TLS1_AD_DECRYPTION_FAILED);
    eval 'sub TLS1_AD_RECORD_OVERFLOW () {22;}' unless defined(&TLS1_AD_RECORD_OVERFLOW);
    eval 'sub TLS1_AD_UNKNOWN_CA () {48;}' unless defined(&TLS1_AD_UNKNOWN_CA);
    eval 'sub TLS1_AD_ACCESS_DENIED () {49;}' unless defined(&TLS1_AD_ACCESS_DENIED);
    eval 'sub TLS1_AD_DECODE_ERROR () {50;}' unless defined(&TLS1_AD_DECODE_ERROR);
    eval 'sub TLS1_AD_DECRYPT_ERROR () {51;}' unless defined(&TLS1_AD_DECRYPT_ERROR);
    eval 'sub TLS1_AD_EXPORT_RESTRICTION () {60;}' unless defined(&TLS1_AD_EXPORT_RESTRICTION);
    eval 'sub TLS1_AD_PROTOCOL_VERSION () {70;}' unless defined(&TLS1_AD_PROTOCOL_VERSION);
    eval 'sub TLS1_AD_INSUFFICIENT_SECURITY () {71;}' unless defined(&TLS1_AD_INSUFFICIENT_SECURITY);
    eval 'sub TLS1_AD_INTERNAL_ERROR () {80;}' unless defined(&TLS1_AD_INTERNAL_ERROR);
    eval 'sub TLS1_AD_INAPPROPRIATE_FALLBACK () {86;}' unless defined(&TLS1_AD_INAPPROPRIATE_FALLBACK);
    eval 'sub TLS1_AD_USER_CANCELLED () {90;}' unless defined(&TLS1_AD_USER_CANCELLED);
    eval 'sub TLS1_AD_NO_RENEGOTIATION () {100;}' unless defined(&TLS1_AD_NO_RENEGOTIATION);
    eval 'sub TLS13_AD_MISSING_EXTENSION () {109;}' unless defined(&TLS13_AD_MISSING_EXTENSION);
    eval 'sub TLS13_AD_CERTIFICATE_REQUIRED () {116;}' unless defined(&TLS13_AD_CERTIFICATE_REQUIRED);
    eval 'sub TLS1_AD_UNSUPPORTED_EXTENSION () {110;}' unless defined(&TLS1_AD_UNSUPPORTED_EXTENSION);
    eval 'sub TLS1_AD_CERTIFICATE_UNOBTAINABLE () {111;}' unless defined(&TLS1_AD_CERTIFICATE_UNOBTAINABLE);
    eval 'sub TLS1_AD_UNRECOGNIZED_NAME () {112;}' unless defined(&TLS1_AD_UNRECOGNIZED_NAME);
    eval 'sub TLS1_AD_BAD_CERTIFICATE_STATUS_RESPONSE () {113;}' unless defined(&TLS1_AD_BAD_CERTIFICATE_STATUS_RESPONSE);
    eval 'sub TLS1_AD_BAD_CERTIFICATE_HASH_VALUE () {114;}' unless defined(&TLS1_AD_BAD_CERTIFICATE_HASH_VALUE);
    eval 'sub TLS1_AD_UNKNOWN_PSK_IDENTITY () {115;}' unless defined(&TLS1_AD_UNKNOWN_PSK_IDENTITY);
    eval 'sub TLS1_AD_NO_APPLICATION_PROTOCOL () {120;}' unless defined(&TLS1_AD_NO_APPLICATION_PROTOCOL);
    eval 'sub TLSEXT_TYPE_server_name () {0;}' unless defined(&TLSEXT_TYPE_server_name);
    eval 'sub TLSEXT_TYPE_max_fragment_length () {1;}' unless defined(&TLSEXT_TYPE_max_fragment_length);
    eval 'sub TLSEXT_TYPE_client_certificate_url () {2;}' unless defined(&TLSEXT_TYPE_client_certificate_url);
    eval 'sub TLSEXT_TYPE_trusted_ca_keys () {3;}' unless defined(&TLSEXT_TYPE_trusted_ca_keys);
    eval 'sub TLSEXT_TYPE_truncated_hmac () {4;}' unless defined(&TLSEXT_TYPE_truncated_hmac);
    eval 'sub TLSEXT_TYPE_status_request () {5;}' unless defined(&TLSEXT_TYPE_status_request);
    eval 'sub TLSEXT_TYPE_user_mapping () {6;}' unless defined(&TLSEXT_TYPE_user_mapping);
    eval 'sub TLSEXT_TYPE_client_authz () {7;}' unless defined(&TLSEXT_TYPE_client_authz);
    eval 'sub TLSEXT_TYPE_server_authz () {8;}' unless defined(&TLSEXT_TYPE_server_authz);
    eval 'sub TLSEXT_TYPE_cert_type () {9;}' unless defined(&TLSEXT_TYPE_cert_type);
    eval 'sub TLSEXT_TYPE_supported_groups () {10;}' unless defined(&TLSEXT_TYPE_supported_groups);
    eval 'sub TLSEXT_TYPE_elliptic_curves () { &TLSEXT_TYPE_supported_groups;}' unless defined(&TLSEXT_TYPE_elliptic_curves);
    eval 'sub TLSEXT_TYPE_ec_point_formats () {11;}' unless defined(&TLSEXT_TYPE_ec_point_formats);
    eval 'sub TLSEXT_TYPE_srp () {12;}' unless defined(&TLSEXT_TYPE_srp);
    eval 'sub TLSEXT_TYPE_signature_algorithms () {13;}' unless defined(&TLSEXT_TYPE_signature_algorithms);
    eval 'sub TLSEXT_TYPE_use_srtp () {14;}' unless defined(&TLSEXT_TYPE_use_srtp);
    eval 'sub TLSEXT_TYPE_application_layer_protocol_negotiation () {16;}' unless defined(&TLSEXT_TYPE_application_layer_protocol_negotiation);
    eval 'sub TLSEXT_TYPE_signed_certificate_timestamp () {18;}' unless defined(&TLSEXT_TYPE_signed_certificate_timestamp);
    eval 'sub TLSEXT_TYPE_client_cert_type () {19;}' unless defined(&TLSEXT_TYPE_client_cert_type);
    eval 'sub TLSEXT_TYPE_server_cert_type () {20;}' unless defined(&TLSEXT_TYPE_server_cert_type);
    eval 'sub TLSEXT_TYPE_padding () {21;}' unless defined(&TLSEXT_TYPE_padding);
    eval 'sub TLSEXT_TYPE_encrypt_then_mac () {22;}' unless defined(&TLSEXT_TYPE_encrypt_then_mac);
    eval 'sub TLSEXT_TYPE_extended_master_secret () {23;}' unless defined(&TLSEXT_TYPE_extended_master_secret);
    eval 'sub TLSEXT_TYPE_compress_certificate () {27;}' unless defined(&TLSEXT_TYPE_compress_certificate);
    eval 'sub TLSEXT_TYPE_session_ticket () {35;}' unless defined(&TLSEXT_TYPE_session_ticket);
    eval 'sub TLSEXT_TYPE_psk () {41;}' unless defined(&TLSEXT_TYPE_psk);
    eval 'sub TLSEXT_TYPE_early_data () {42;}' unless defined(&TLSEXT_TYPE_early_data);
    eval 'sub TLSEXT_TYPE_supported_versions () {43;}' unless defined(&TLSEXT_TYPE_supported_versions);
    eval 'sub TLSEXT_TYPE_cookie () {44;}' unless defined(&TLSEXT_TYPE_cookie);
    eval 'sub TLSEXT_TYPE_psk_kex_modes () {45;}' unless defined(&TLSEXT_TYPE_psk_kex_modes);
    eval 'sub TLSEXT_TYPE_certificate_authorities () {47;}' unless defined(&TLSEXT_TYPE_certificate_authorities);
    eval 'sub TLSEXT_TYPE_post_handshake_auth () {49;}' unless defined(&TLSEXT_TYPE_post_handshake_auth);
    eval 'sub TLSEXT_TYPE_signature_algorithms_cert () {50;}' unless defined(&TLSEXT_TYPE_signature_algorithms_cert);
    eval 'sub TLSEXT_TYPE_key_share () {51;}' unless defined(&TLSEXT_TYPE_key_share);
    eval 'sub TLSEXT_TYPE_quic_transport_parameters () {57;}' unless defined(&TLSEXT_TYPE_quic_transport_parameters);
    eval 'sub TLSEXT_TYPE_renegotiate () {0xff01;}' unless defined(&TLSEXT_TYPE_renegotiate);
    unless(defined(&OPENSSL_NO_NEXTPROTONEG)) {
	eval 'sub TLSEXT_TYPE_next_proto_neg () {13172;}' unless defined(&TLSEXT_TYPE_next_proto_neg);
    }
    eval 'sub TLSEXT_NAMETYPE_host_name () {0;}' unless defined(&TLSEXT_NAMETYPE_host_name);
    eval 'sub TLSEXT_STATUSTYPE_ocsp () {1;}' unless defined(&TLSEXT_STATUSTYPE_ocsp);
    eval 'sub TLSEXT_ECPOINTFORMAT_first () {0;}' unless defined(&TLSEXT_ECPOINTFORMAT_first);
    eval 'sub TLSEXT_ECPOINTFORMAT_uncompressed () {0;}' unless defined(&TLSEXT_ECPOINTFORMAT_uncompressed);
    eval 'sub TLSEXT_ECPOINTFORMAT_ansiX962_compressed_prime () {1;}' unless defined(&TLSEXT_ECPOINTFORMAT_ansiX962_compressed_prime);
    eval 'sub TLSEXT_ECPOINTFORMAT_ansiX962_compressed_char2 () {2;}' unless defined(&TLSEXT_ECPOINTFORMAT_ansiX962_compressed_char2);
    eval 'sub TLSEXT_ECPOINTFORMAT_last () {2;}' unless defined(&TLSEXT_ECPOINTFORMAT_last);
    eval 'sub TLSEXT_signature_anonymous () {0;}' unless defined(&TLSEXT_signature_anonymous);
    eval 'sub TLSEXT_signature_rsa () {1;}' unless defined(&TLSEXT_signature_rsa);
    eval 'sub TLSEXT_signature_dsa () {2;}' unless defined(&TLSEXT_signature_dsa);
    eval 'sub TLSEXT_signature_ecdsa () {3;}' unless defined(&TLSEXT_signature_ecdsa);
    eval 'sub TLSEXT_signature_gostr34102001 () {237;}' unless defined(&TLSEXT_signature_gostr34102001);
    eval 'sub TLSEXT_signature_gostr34102012_256 () {238;}' unless defined(&TLSEXT_signature_gostr34102012_256);
    eval 'sub TLSEXT_signature_gostr34102012_512 () {239;}' unless defined(&TLSEXT_signature_gostr34102012_512);
    eval 'sub TLSEXT_signature_num () {7;}' unless defined(&TLSEXT_signature_num);
    eval 'sub TLSEXT_hash_none () {0;}' unless defined(&TLSEXT_hash_none);
    eval 'sub TLSEXT_hash_md5 () {1;}' unless defined(&TLSEXT_hash_md5);
    eval 'sub TLSEXT_hash_sha1 () {2;}' unless defined(&TLSEXT_hash_sha1);
    eval 'sub TLSEXT_hash_sha224 () {3;}' unless defined(&TLSEXT_hash_sha224);
    eval 'sub TLSEXT_hash_sha256 () {4;}' unless defined(&TLSEXT_hash_sha256);
    eval 'sub TLSEXT_hash_sha384 () {5;}' unless defined(&TLSEXT_hash_sha384);
    eval 'sub TLSEXT_hash_sha512 () {6;}' unless defined(&TLSEXT_hash_sha512);
    eval 'sub TLSEXT_hash_gostr3411 () {237;}' unless defined(&TLSEXT_hash_gostr3411);
    eval 'sub TLSEXT_hash_gostr34112012_256 () {238;}' unless defined(&TLSEXT_hash_gostr34112012_256);
    eval 'sub TLSEXT_hash_gostr34112012_512 () {239;}' unless defined(&TLSEXT_hash_gostr34112012_512);
    eval 'sub TLSEXT_hash_num () {10;}' unless defined(&TLSEXT_hash_num);
    eval 'sub TLSEXT_comp_cert_none () {0;}' unless defined(&TLSEXT_comp_cert_none);
    eval 'sub TLSEXT_comp_cert_zlib () {1;}' unless defined(&TLSEXT_comp_cert_zlib);
    eval 'sub TLSEXT_comp_cert_brotli () {2;}' unless defined(&TLSEXT_comp_cert_brotli);
    eval 'sub TLSEXT_comp_cert_zstd () {3;}' unless defined(&TLSEXT_comp_cert_zstd);
    eval 'sub TLSEXT_comp_cert_limit () {4;}' unless defined(&TLSEXT_comp_cert_limit);
    eval 'sub TLSEXT_nid_unknown () {0x1000000;}' unless defined(&TLSEXT_nid_unknown);
    eval 'sub TLSEXT_curve_P_256 () {23;}' unless defined(&TLSEXT_curve_P_256);
    eval 'sub TLSEXT_curve_P_384 () {24;}' unless defined(&TLSEXT_curve_P_384);
    eval 'sub TLSEXT_max_fragment_length_DISABLED () {0;}' unless defined(&TLSEXT_max_fragment_length_DISABLED);
    eval 'sub TLSEXT_max_fragment_length_512 () {1;}' unless defined(&TLSEXT_max_fragment_length_512);
    eval 'sub TLSEXT_max_fragment_length_1024 () {2;}' unless defined(&TLSEXT_max_fragment_length_1024);
    eval 'sub TLSEXT_max_fragment_length_2048 () {3;}' unless defined(&TLSEXT_max_fragment_length_2048);
    eval 'sub TLSEXT_max_fragment_length_4096 () {4;}' unless defined(&TLSEXT_max_fragment_length_4096);
    eval 'sub TLSEXT_max_fragment_length_UNSPECIFIED () {255;}' unless defined(&TLSEXT_max_fragment_length_UNSPECIFIED);
    eval 'sub TLSEXT_cert_type_x509 () {0;}' unless defined(&TLSEXT_cert_type_x509);
    eval 'sub TLSEXT_cert_type_pgp () {1;}' unless defined(&TLSEXT_cert_type_pgp);
    eval 'sub TLSEXT_cert_type_rpk () {2;}' unless defined(&TLSEXT_cert_type_rpk);
    eval 'sub TLSEXT_cert_type_1609dot2 () {3;}' unless defined(&TLSEXT_cert_type_1609dot2);
    eval 'sub TLSEXT_MAXLEN_host_name () {255;}' unless defined(&TLSEXT_MAXLEN_host_name);
    eval 'sub SSL_set_tlsext_host_name {
        my($s,$name) = @_;
	    eval q( &SSL_ctrl($s, &SSL_CTRL_SET_TLSEXT_HOSTNAME, &TLSEXT_NAMETYPE_host_name, ( &void *)$name));
    }' unless defined(&SSL_set_tlsext_host_name);
    eval 'sub SSL_set_tlsext_debug_callback {
        my($ssl, $cb) = @_;
	    eval q( &SSL_callback_ctrl($ssl, &SSL_CTRL_SET_TLSEXT_DEBUG_CB, ( &void (*)( &void))$cb));
    }' unless defined(&SSL_set_tlsext_debug_callback);
    eval 'sub SSL_set_tlsext_debug_arg {
        my($ssl, $arg) = @_;
	    eval q( &SSL_ctrl($ssl, &SSL_CTRL_SET_TLSEXT_DEBUG_ARG,0,$arg));
    }' unless defined(&SSL_set_tlsext_debug_arg);
    eval 'sub SSL_get_tlsext_status_type {
        my($ssl) = @_;
	    eval q( &SSL_ctrl($ssl, &SSL_CTRL_GET_TLSEXT_STATUS_REQ_TYPE,0, &NULL));
    }' unless defined(&SSL_get_tlsext_status_type);
    eval 'sub SSL_set_tlsext_status_type {
        my($ssl, $type) = @_;
	    eval q( &SSL_ctrl($ssl, &SSL_CTRL_SET_TLSEXT_STATUS_REQ_TYPE,$type, &NULL));
    }' unless defined(&SSL_set_tlsext_status_type);
    eval 'sub SSL_get_tlsext_status_exts {
        my($ssl, $arg) = @_;
	    eval q( &SSL_ctrl($ssl, &SSL_CTRL_GET_TLSEXT_STATUS_REQ_EXTS,0,$arg));
    }' unless defined(&SSL_get_tlsext_status_exts);
    eval 'sub SSL_set_tlsext_status_exts {
        my($ssl, $arg) = @_;
	    eval q( &SSL_ctrl($ssl, &SSL_CTRL_SET_TLSEXT_STATUS_REQ_EXTS,0,$arg));
    }' unless defined(&SSL_set_tlsext_status_exts);
    eval 'sub SSL_get_tlsext_status_ids {
        my($ssl, $arg) = @_;
	    eval q( &SSL_ctrl($ssl, &SSL_CTRL_GET_TLSEXT_STATUS_REQ_IDS,0,$arg));
    }' unless defined(&SSL_get_tlsext_status_ids);
    eval 'sub SSL_set_tlsext_status_ids {
        my($ssl, $arg) = @_;
	    eval q( &SSL_ctrl($ssl, &SSL_CTRL_SET_TLSEXT_STATUS_REQ_IDS,0,$arg));
    }' unless defined(&SSL_set_tlsext_status_ids);
    eval 'sub SSL_get_tlsext_status_ocsp_resp {
        my($ssl, $arg) = @_;
	    eval q( &SSL_ctrl($ssl, &SSL_CTRL_GET_TLSEXT_STATUS_REQ_OCSP_RESP,0,$arg));
    }' unless defined(&SSL_get_tlsext_status_ocsp_resp);
    eval 'sub SSL_set_tlsext_status_ocsp_resp {
        my($ssl, $arg, $arglen) = @_;
	    eval q( &SSL_ctrl($ssl, &SSL_CTRL_SET_TLSEXT_STATUS_REQ_OCSP_RESP,$arglen,$arg));
    }' unless defined(&SSL_set_tlsext_status_ocsp_resp);
    eval 'sub SSL_CTX_set_tlsext_servername_callback {
        my($ctx, $cb) = @_;
	    eval q( &SSL_CTX_callback_ctrl($ctx, &SSL_CTRL_SET_TLSEXT_SERVERNAME_CB, ( &void (*)( &void))$cb));
    }' unless defined(&SSL_CTX_set_tlsext_servername_callback);
    eval 'sub SSL_TLSEXT_ERR_OK () {0;}' unless defined(&SSL_TLSEXT_ERR_OK);
    eval 'sub SSL_TLSEXT_ERR_ALERT_WARNING () {1;}' unless defined(&SSL_TLSEXT_ERR_ALERT_WARNING);
    eval 'sub SSL_TLSEXT_ERR_ALERT_FATAL () {2;}' unless defined(&SSL_TLSEXT_ERR_ALERT_FATAL);
    eval 'sub SSL_TLSEXT_ERR_NOACK () {3;}' unless defined(&SSL_TLSEXT_ERR_NOACK);
    eval 'sub SSL_CTX_set_tlsext_servername_arg {
        my($ctx, $arg) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SET_TLSEXT_SERVERNAME_ARG,0,$arg));
    }' unless defined(&SSL_CTX_set_tlsext_servername_arg);
    eval 'sub SSL_CTX_get_tlsext_ticket_keys {
        my($ctx, $keys, $keylen) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_GET_TLSEXT_TICKET_KEYS,$keylen,$keys));
    }' unless defined(&SSL_CTX_get_tlsext_ticket_keys);
    eval 'sub SSL_CTX_set_tlsext_ticket_keys {
        my($ctx, $keys, $keylen) = @_;
	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SET_TLSEXT_TICKET_KEYS,$keylen,$keys));
    }' unless defined(&SSL_CTX_set_tlsext_ticket_keys);
    eval 'sub SSL_CTX_get_tlsext_status_cb {
        my($ssl, $cb) = @_;
	    eval q( &SSL_CTX_ctrl($ssl, &SSL_CTRL_GET_TLSEXT_STATUS_REQ_CB,0,( &void *)$cb));
    }' unless defined(&SSL_CTX_get_tlsext_status_cb);
    eval 'sub SSL_CTX_set_tlsext_status_cb {
        my($ssl, $cb) = @_;
	    eval q( &SSL_CTX_callback_ctrl($ssl, &SSL_CTRL_SET_TLSEXT_STATUS_REQ_CB, ( &void (*)( &void))$cb));
    }' unless defined(&SSL_CTX_set_tlsext_status_cb);
    eval 'sub SSL_CTX_get_tlsext_status_arg {
        my($ssl, $arg) = @_;
	    eval q( &SSL_CTX_ctrl($ssl, &SSL_CTRL_GET_TLSEXT_STATUS_REQ_CB_ARG,0,$arg));
    }' unless defined(&SSL_CTX_get_tlsext_status_arg);
    eval 'sub SSL_CTX_set_tlsext_status_arg {
        my($ssl, $arg) = @_;
	    eval q( &SSL_CTX_ctrl($ssl, &SSL_CTRL_SET_TLSEXT_STATUS_REQ_CB_ARG,0,$arg));
    }' unless defined(&SSL_CTX_set_tlsext_status_arg);
    eval 'sub SSL_CTX_set_tlsext_status_type {
        my($ssl, $type) = @_;
	    eval q( &SSL_CTX_ctrl($ssl, &SSL_CTRL_SET_TLSEXT_STATUS_REQ_TYPE,$type, &NULL));
    }' unless defined(&SSL_CTX_set_tlsext_status_type);
    eval 'sub SSL_CTX_get_tlsext_status_type {
        my($ssl) = @_;
	    eval q( &SSL_CTX_ctrl($ssl, &SSL_CTRL_GET_TLSEXT_STATUS_REQ_TYPE,0, &NULL));
    }' unless defined(&SSL_CTX_get_tlsext_status_type);
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	eval 'sub SSL_CTX_set_tlsext_ticket_key_cb {
	    my($ssl, $cb) = @_;
    	    eval q( &SSL_CTX_callback_ctrl($ssl, &SSL_CTRL_SET_TLSEXT_TICKET_KEY_CB, ( &void (*)( &void))$cb));
	}' unless defined(&SSL_CTX_set_tlsext_ticket_key_cb);
    }
    eval 'sub TLS1_CK_PSK_WITH_RC4_128_SHA () {0x300008a;}' unless defined(&TLS1_CK_PSK_WITH_RC4_128_SHA);
    eval 'sub TLS1_CK_PSK_WITH_3DES_EDE_CBC_SHA () {0x300008b;}' unless defined(&TLS1_CK_PSK_WITH_3DES_EDE_CBC_SHA);
    eval 'sub TLS1_CK_PSK_WITH_AES_128_CBC_SHA () {0x300008c;}' unless defined(&TLS1_CK_PSK_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_CK_PSK_WITH_AES_256_CBC_SHA () {0x300008d;}' unless defined(&TLS1_CK_PSK_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_CK_DHE_PSK_WITH_RC4_128_SHA () {0x300008e;}' unless defined(&TLS1_CK_DHE_PSK_WITH_RC4_128_SHA);
    eval 'sub TLS1_CK_DHE_PSK_WITH_3DES_EDE_CBC_SHA () {0x300008f;}' unless defined(&TLS1_CK_DHE_PSK_WITH_3DES_EDE_CBC_SHA);
    eval 'sub TLS1_CK_DHE_PSK_WITH_AES_128_CBC_SHA () {0x3000090;}' unless defined(&TLS1_CK_DHE_PSK_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_CK_DHE_PSK_WITH_AES_256_CBC_SHA () {0x3000091;}' unless defined(&TLS1_CK_DHE_PSK_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_CK_RSA_PSK_WITH_RC4_128_SHA () {0x3000092;}' unless defined(&TLS1_CK_RSA_PSK_WITH_RC4_128_SHA);
    eval 'sub TLS1_CK_RSA_PSK_WITH_3DES_EDE_CBC_SHA () {0x3000093;}' unless defined(&TLS1_CK_RSA_PSK_WITH_3DES_EDE_CBC_SHA);
    eval 'sub TLS1_CK_RSA_PSK_WITH_AES_128_CBC_SHA () {0x3000094;}' unless defined(&TLS1_CK_RSA_PSK_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_CK_RSA_PSK_WITH_AES_256_CBC_SHA () {0x3000095;}' unless defined(&TLS1_CK_RSA_PSK_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_CK_PSK_WITH_AES_128_GCM_SHA256 () {0x30000a8;}' unless defined(&TLS1_CK_PSK_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_CK_PSK_WITH_AES_256_GCM_SHA384 () {0x30000a9;}' unless defined(&TLS1_CK_PSK_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_CK_DHE_PSK_WITH_AES_128_GCM_SHA256 () {0x30000aa;}' unless defined(&TLS1_CK_DHE_PSK_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_CK_DHE_PSK_WITH_AES_256_GCM_SHA384 () {0x30000ab;}' unless defined(&TLS1_CK_DHE_PSK_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_CK_RSA_PSK_WITH_AES_128_GCM_SHA256 () {0x30000ac;}' unless defined(&TLS1_CK_RSA_PSK_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_CK_RSA_PSK_WITH_AES_256_GCM_SHA384 () {0x30000ad;}' unless defined(&TLS1_CK_RSA_PSK_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_CK_PSK_WITH_AES_128_CBC_SHA256 () {0x30000ae;}' unless defined(&TLS1_CK_PSK_WITH_AES_128_CBC_SHA256);
    eval 'sub TLS1_CK_PSK_WITH_AES_256_CBC_SHA384 () {0x30000af;}' unless defined(&TLS1_CK_PSK_WITH_AES_256_CBC_SHA384);
    eval 'sub TLS1_CK_PSK_WITH_NULL_SHA256 () {0x30000b0;}' unless defined(&TLS1_CK_PSK_WITH_NULL_SHA256);
    eval 'sub TLS1_CK_PSK_WITH_NULL_SHA384 () {0x30000b1;}' unless defined(&TLS1_CK_PSK_WITH_NULL_SHA384);
    eval 'sub TLS1_CK_DHE_PSK_WITH_AES_128_CBC_SHA256 () {0x30000b2;}' unless defined(&TLS1_CK_DHE_PSK_WITH_AES_128_CBC_SHA256);
    eval 'sub TLS1_CK_DHE_PSK_WITH_AES_256_CBC_SHA384 () {0x30000b3;}' unless defined(&TLS1_CK_DHE_PSK_WITH_AES_256_CBC_SHA384);
    eval 'sub TLS1_CK_DHE_PSK_WITH_NULL_SHA256 () {0x30000b4;}' unless defined(&TLS1_CK_DHE_PSK_WITH_NULL_SHA256);
    eval 'sub TLS1_CK_DHE_PSK_WITH_NULL_SHA384 () {0x30000b5;}' unless defined(&TLS1_CK_DHE_PSK_WITH_NULL_SHA384);
    eval 'sub TLS1_CK_RSA_PSK_WITH_AES_128_CBC_SHA256 () {0x30000b6;}' unless defined(&TLS1_CK_RSA_PSK_WITH_AES_128_CBC_SHA256);
    eval 'sub TLS1_CK_RSA_PSK_WITH_AES_256_CBC_SHA384 () {0x30000b7;}' unless defined(&TLS1_CK_RSA_PSK_WITH_AES_256_CBC_SHA384);
    eval 'sub TLS1_CK_RSA_PSK_WITH_NULL_SHA256 () {0x30000b8;}' unless defined(&TLS1_CK_RSA_PSK_WITH_NULL_SHA256);
    eval 'sub TLS1_CK_RSA_PSK_WITH_NULL_SHA384 () {0x30000b9;}' unless defined(&TLS1_CK_RSA_PSK_WITH_NULL_SHA384);
    eval 'sub TLS1_CK_PSK_WITH_NULL_SHA () {0x300002c;}' unless defined(&TLS1_CK_PSK_WITH_NULL_SHA);
    eval 'sub TLS1_CK_DHE_PSK_WITH_NULL_SHA () {0x300002d;}' unless defined(&TLS1_CK_DHE_PSK_WITH_NULL_SHA);
    eval 'sub TLS1_CK_RSA_PSK_WITH_NULL_SHA () {0x300002e;}' unless defined(&TLS1_CK_RSA_PSK_WITH_NULL_SHA);
    eval 'sub TLS1_CK_RSA_WITH_AES_128_SHA () {0x300002f;}' unless defined(&TLS1_CK_RSA_WITH_AES_128_SHA);
    eval 'sub TLS1_CK_DH_DSS_WITH_AES_128_SHA () {0x3000030;}' unless defined(&TLS1_CK_DH_DSS_WITH_AES_128_SHA);
    eval 'sub TLS1_CK_DH_RSA_WITH_AES_128_SHA () {0x3000031;}' unless defined(&TLS1_CK_DH_RSA_WITH_AES_128_SHA);
    eval 'sub TLS1_CK_DHE_DSS_WITH_AES_128_SHA () {0x3000032;}' unless defined(&TLS1_CK_DHE_DSS_WITH_AES_128_SHA);
    eval 'sub TLS1_CK_DHE_RSA_WITH_AES_128_SHA () {0x3000033;}' unless defined(&TLS1_CK_DHE_RSA_WITH_AES_128_SHA);
    eval 'sub TLS1_CK_ADH_WITH_AES_128_SHA () {0x3000034;}' unless defined(&TLS1_CK_ADH_WITH_AES_128_SHA);
    eval 'sub TLS1_CK_RSA_WITH_AES_256_SHA () {0x3000035;}' unless defined(&TLS1_CK_RSA_WITH_AES_256_SHA);
    eval 'sub TLS1_CK_DH_DSS_WITH_AES_256_SHA () {0x3000036;}' unless defined(&TLS1_CK_DH_DSS_WITH_AES_256_SHA);
    eval 'sub TLS1_CK_DH_RSA_WITH_AES_256_SHA () {0x3000037;}' unless defined(&TLS1_CK_DH_RSA_WITH_AES_256_SHA);
    eval 'sub TLS1_CK_DHE_DSS_WITH_AES_256_SHA () {0x3000038;}' unless defined(&TLS1_CK_DHE_DSS_WITH_AES_256_SHA);
    eval 'sub TLS1_CK_DHE_RSA_WITH_AES_256_SHA () {0x3000039;}' unless defined(&TLS1_CK_DHE_RSA_WITH_AES_256_SHA);
    eval 'sub TLS1_CK_ADH_WITH_AES_256_SHA () {0x300003a;}' unless defined(&TLS1_CK_ADH_WITH_AES_256_SHA);
    eval 'sub TLS1_CK_RSA_WITH_NULL_SHA256 () {0x300003b;}' unless defined(&TLS1_CK_RSA_WITH_NULL_SHA256);
    eval 'sub TLS1_CK_RSA_WITH_AES_128_SHA256 () {0x300003c;}' unless defined(&TLS1_CK_RSA_WITH_AES_128_SHA256);
    eval 'sub TLS1_CK_RSA_WITH_AES_256_SHA256 () {0x300003d;}' unless defined(&TLS1_CK_RSA_WITH_AES_256_SHA256);
    eval 'sub TLS1_CK_DH_DSS_WITH_AES_128_SHA256 () {0x300003e;}' unless defined(&TLS1_CK_DH_DSS_WITH_AES_128_SHA256);
    eval 'sub TLS1_CK_DH_RSA_WITH_AES_128_SHA256 () {0x300003f;}' unless defined(&TLS1_CK_DH_RSA_WITH_AES_128_SHA256);
    eval 'sub TLS1_CK_DHE_DSS_WITH_AES_128_SHA256 () {0x3000040;}' unless defined(&TLS1_CK_DHE_DSS_WITH_AES_128_SHA256);
    eval 'sub TLS1_CK_RSA_WITH_CAMELLIA_128_CBC_SHA () {0x3000041;}' unless defined(&TLS1_CK_RSA_WITH_CAMELLIA_128_CBC_SHA);
    eval 'sub TLS1_CK_DH_DSS_WITH_CAMELLIA_128_CBC_SHA () {0x3000042;}' unless defined(&TLS1_CK_DH_DSS_WITH_CAMELLIA_128_CBC_SHA);
    eval 'sub TLS1_CK_DH_RSA_WITH_CAMELLIA_128_CBC_SHA () {0x3000043;}' unless defined(&TLS1_CK_DH_RSA_WITH_CAMELLIA_128_CBC_SHA);
    eval 'sub TLS1_CK_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA () {0x3000044;}' unless defined(&TLS1_CK_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA);
    eval 'sub TLS1_CK_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA () {0x3000045;}' unless defined(&TLS1_CK_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA);
    eval 'sub TLS1_CK_ADH_WITH_CAMELLIA_128_CBC_SHA () {0x3000046;}' unless defined(&TLS1_CK_ADH_WITH_CAMELLIA_128_CBC_SHA);
    eval 'sub TLS1_CK_DHE_RSA_WITH_AES_128_SHA256 () {0x3000067;}' unless defined(&TLS1_CK_DHE_RSA_WITH_AES_128_SHA256);
    eval 'sub TLS1_CK_DH_DSS_WITH_AES_256_SHA256 () {0x3000068;}' unless defined(&TLS1_CK_DH_DSS_WITH_AES_256_SHA256);
    eval 'sub TLS1_CK_DH_RSA_WITH_AES_256_SHA256 () {0x3000069;}' unless defined(&TLS1_CK_DH_RSA_WITH_AES_256_SHA256);
    eval 'sub TLS1_CK_DHE_DSS_WITH_AES_256_SHA256 () {0x300006a;}' unless defined(&TLS1_CK_DHE_DSS_WITH_AES_256_SHA256);
    eval 'sub TLS1_CK_DHE_RSA_WITH_AES_256_SHA256 () {0x300006b;}' unless defined(&TLS1_CK_DHE_RSA_WITH_AES_256_SHA256);
    eval 'sub TLS1_CK_ADH_WITH_AES_128_SHA256 () {0x300006c;}' unless defined(&TLS1_CK_ADH_WITH_AES_128_SHA256);
    eval 'sub TLS1_CK_ADH_WITH_AES_256_SHA256 () {0x300006d;}' unless defined(&TLS1_CK_ADH_WITH_AES_256_SHA256);
    eval 'sub TLS1_CK_RSA_WITH_CAMELLIA_256_CBC_SHA () {0x3000084;}' unless defined(&TLS1_CK_RSA_WITH_CAMELLIA_256_CBC_SHA);
    eval 'sub TLS1_CK_DH_DSS_WITH_CAMELLIA_256_CBC_SHA () {0x3000085;}' unless defined(&TLS1_CK_DH_DSS_WITH_CAMELLIA_256_CBC_SHA);
    eval 'sub TLS1_CK_DH_RSA_WITH_CAMELLIA_256_CBC_SHA () {0x3000086;}' unless defined(&TLS1_CK_DH_RSA_WITH_CAMELLIA_256_CBC_SHA);
    eval 'sub TLS1_CK_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA () {0x3000087;}' unless defined(&TLS1_CK_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA);
    eval 'sub TLS1_CK_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA () {0x3000088;}' unless defined(&TLS1_CK_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA);
    eval 'sub TLS1_CK_ADH_WITH_CAMELLIA_256_CBC_SHA () {0x3000089;}' unless defined(&TLS1_CK_ADH_WITH_CAMELLIA_256_CBC_SHA);
    eval 'sub TLS1_CK_RSA_WITH_SEED_SHA () {0x3000096;}' unless defined(&TLS1_CK_RSA_WITH_SEED_SHA);
    eval 'sub TLS1_CK_DH_DSS_WITH_SEED_SHA () {0x3000097;}' unless defined(&TLS1_CK_DH_DSS_WITH_SEED_SHA);
    eval 'sub TLS1_CK_DH_RSA_WITH_SEED_SHA () {0x3000098;}' unless defined(&TLS1_CK_DH_RSA_WITH_SEED_SHA);
    eval 'sub TLS1_CK_DHE_DSS_WITH_SEED_SHA () {0x3000099;}' unless defined(&TLS1_CK_DHE_DSS_WITH_SEED_SHA);
    eval 'sub TLS1_CK_DHE_RSA_WITH_SEED_SHA () {0x300009a;}' unless defined(&TLS1_CK_DHE_RSA_WITH_SEED_SHA);
    eval 'sub TLS1_CK_ADH_WITH_SEED_SHA () {0x300009b;}' unless defined(&TLS1_CK_ADH_WITH_SEED_SHA);
    eval 'sub TLS1_CK_RSA_WITH_AES_128_GCM_SHA256 () {0x300009c;}' unless defined(&TLS1_CK_RSA_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_CK_RSA_WITH_AES_256_GCM_SHA384 () {0x300009d;}' unless defined(&TLS1_CK_RSA_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_CK_DHE_RSA_WITH_AES_128_GCM_SHA256 () {0x300009e;}' unless defined(&TLS1_CK_DHE_RSA_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_CK_DHE_RSA_WITH_AES_256_GCM_SHA384 () {0x300009f;}' unless defined(&TLS1_CK_DHE_RSA_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_CK_DH_RSA_WITH_AES_128_GCM_SHA256 () {0x30000a0;}' unless defined(&TLS1_CK_DH_RSA_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_CK_DH_RSA_WITH_AES_256_GCM_SHA384 () {0x30000a1;}' unless defined(&TLS1_CK_DH_RSA_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_CK_DHE_DSS_WITH_AES_128_GCM_SHA256 () {0x30000a2;}' unless defined(&TLS1_CK_DHE_DSS_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_CK_DHE_DSS_WITH_AES_256_GCM_SHA384 () {0x30000a3;}' unless defined(&TLS1_CK_DHE_DSS_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_CK_DH_DSS_WITH_AES_128_GCM_SHA256 () {0x30000a4;}' unless defined(&TLS1_CK_DH_DSS_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_CK_DH_DSS_WITH_AES_256_GCM_SHA384 () {0x30000a5;}' unless defined(&TLS1_CK_DH_DSS_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_CK_ADH_WITH_AES_128_GCM_SHA256 () {0x30000a6;}' unless defined(&TLS1_CK_ADH_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_CK_ADH_WITH_AES_256_GCM_SHA384 () {0x30000a7;}' unless defined(&TLS1_CK_ADH_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_CK_RSA_WITH_AES_128_CCM () {0x300c09c;}' unless defined(&TLS1_CK_RSA_WITH_AES_128_CCM);
    eval 'sub TLS1_CK_RSA_WITH_AES_256_CCM () {0x300c09d;}' unless defined(&TLS1_CK_RSA_WITH_AES_256_CCM);
    eval 'sub TLS1_CK_DHE_RSA_WITH_AES_128_CCM () {0x300c09e;}' unless defined(&TLS1_CK_DHE_RSA_WITH_AES_128_CCM);
    eval 'sub TLS1_CK_DHE_RSA_WITH_AES_256_CCM () {0x300c09f;}' unless defined(&TLS1_CK_DHE_RSA_WITH_AES_256_CCM);
    eval 'sub TLS1_CK_RSA_WITH_AES_128_CCM_8 () {0x300c0a0;}' unless defined(&TLS1_CK_RSA_WITH_AES_128_CCM_8);
    eval 'sub TLS1_CK_RSA_WITH_AES_256_CCM_8 () {0x300c0a1;}' unless defined(&TLS1_CK_RSA_WITH_AES_256_CCM_8);
    eval 'sub TLS1_CK_DHE_RSA_WITH_AES_128_CCM_8 () {0x300c0a2;}' unless defined(&TLS1_CK_DHE_RSA_WITH_AES_128_CCM_8);
    eval 'sub TLS1_CK_DHE_RSA_WITH_AES_256_CCM_8 () {0x300c0a3;}' unless defined(&TLS1_CK_DHE_RSA_WITH_AES_256_CCM_8);
    eval 'sub TLS1_CK_PSK_WITH_AES_128_CCM () {0x300c0a4;}' unless defined(&TLS1_CK_PSK_WITH_AES_128_CCM);
    eval 'sub TLS1_CK_PSK_WITH_AES_256_CCM () {0x300c0a5;}' unless defined(&TLS1_CK_PSK_WITH_AES_256_CCM);
    eval 'sub TLS1_CK_DHE_PSK_WITH_AES_128_CCM () {0x300c0a6;}' unless defined(&TLS1_CK_DHE_PSK_WITH_AES_128_CCM);
    eval 'sub TLS1_CK_DHE_PSK_WITH_AES_256_CCM () {0x300c0a7;}' unless defined(&TLS1_CK_DHE_PSK_WITH_AES_256_CCM);
    eval 'sub TLS1_CK_PSK_WITH_AES_128_CCM_8 () {0x300c0a8;}' unless defined(&TLS1_CK_PSK_WITH_AES_128_CCM_8);
    eval 'sub TLS1_CK_PSK_WITH_AES_256_CCM_8 () {0x300c0a9;}' unless defined(&TLS1_CK_PSK_WITH_AES_256_CCM_8);
    eval 'sub TLS1_CK_DHE_PSK_WITH_AES_128_CCM_8 () {0x300c0aa;}' unless defined(&TLS1_CK_DHE_PSK_WITH_AES_128_CCM_8);
    eval 'sub TLS1_CK_DHE_PSK_WITH_AES_256_CCM_8 () {0x300c0ab;}' unless defined(&TLS1_CK_DHE_PSK_WITH_AES_256_CCM_8);
    eval 'sub TLS1_CK_ECDHE_ECDSA_WITH_AES_128_CCM () {0x300c0ac;}' unless defined(&TLS1_CK_ECDHE_ECDSA_WITH_AES_128_CCM);
    eval 'sub TLS1_CK_ECDHE_ECDSA_WITH_AES_256_CCM () {0x300c0ad;}' unless defined(&TLS1_CK_ECDHE_ECDSA_WITH_AES_256_CCM);
    eval 'sub TLS1_CK_ECDHE_ECDSA_WITH_AES_128_CCM_8 () {0x300c0ae;}' unless defined(&TLS1_CK_ECDHE_ECDSA_WITH_AES_128_CCM_8);
    eval 'sub TLS1_CK_ECDHE_ECDSA_WITH_AES_256_CCM_8 () {0x300c0af;}' unless defined(&TLS1_CK_ECDHE_ECDSA_WITH_AES_256_CCM_8);
    eval 'sub TLS1_CK_RSA_WITH_CAMELLIA_128_CBC_SHA256 () {0x30000ba;}' unless defined(&TLS1_CK_RSA_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_CK_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256 () {0x30000bb;}' unless defined(&TLS1_CK_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_CK_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256 () {0x30000bc;}' unless defined(&TLS1_CK_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_CK_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256 () {0x30000bd;}' unless defined(&TLS1_CK_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_CK_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 () {0x30000be;}' unless defined(&TLS1_CK_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_CK_ADH_WITH_CAMELLIA_128_CBC_SHA256 () {0x30000bf;}' unless defined(&TLS1_CK_ADH_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_CK_RSA_WITH_CAMELLIA_256_CBC_SHA256 () {0x30000c0;}' unless defined(&TLS1_CK_RSA_WITH_CAMELLIA_256_CBC_SHA256);
    eval 'sub TLS1_CK_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256 () {0x30000c1;}' unless defined(&TLS1_CK_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256);
    eval 'sub TLS1_CK_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256 () {0x30000c2;}' unless defined(&TLS1_CK_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256);
    eval 'sub TLS1_CK_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256 () {0x30000c3;}' unless defined(&TLS1_CK_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256);
    eval 'sub TLS1_CK_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256 () {0x30000c4;}' unless defined(&TLS1_CK_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256);
    eval 'sub TLS1_CK_ADH_WITH_CAMELLIA_256_CBC_SHA256 () {0x30000c5;}' unless defined(&TLS1_CK_ADH_WITH_CAMELLIA_256_CBC_SHA256);
    eval 'sub TLS1_CK_ECDH_ECDSA_WITH_NULL_SHA () {0x300c001;}' unless defined(&TLS1_CK_ECDH_ECDSA_WITH_NULL_SHA);
    eval 'sub TLS1_CK_ECDH_ECDSA_WITH_RC4_128_SHA () {0x300c002;}' unless defined(&TLS1_CK_ECDH_ECDSA_WITH_RC4_128_SHA);
    eval 'sub TLS1_CK_ECDH_ECDSA_WITH_DES_192_CBC3_SHA () {0x300c003;}' unless defined(&TLS1_CK_ECDH_ECDSA_WITH_DES_192_CBC3_SHA);
    eval 'sub TLS1_CK_ECDH_ECDSA_WITH_AES_128_CBC_SHA () {0x300c004;}' unless defined(&TLS1_CK_ECDH_ECDSA_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_CK_ECDH_ECDSA_WITH_AES_256_CBC_SHA () {0x300c005;}' unless defined(&TLS1_CK_ECDH_ECDSA_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_CK_ECDHE_ECDSA_WITH_NULL_SHA () {0x300c006;}' unless defined(&TLS1_CK_ECDHE_ECDSA_WITH_NULL_SHA);
    eval 'sub TLS1_CK_ECDHE_ECDSA_WITH_RC4_128_SHA () {0x300c007;}' unless defined(&TLS1_CK_ECDHE_ECDSA_WITH_RC4_128_SHA);
    eval 'sub TLS1_CK_ECDHE_ECDSA_WITH_DES_192_CBC3_SHA () {0x300c008;}' unless defined(&TLS1_CK_ECDHE_ECDSA_WITH_DES_192_CBC3_SHA);
    eval 'sub TLS1_CK_ECDHE_ECDSA_WITH_AES_128_CBC_SHA () {0x300c009;}' unless defined(&TLS1_CK_ECDHE_ECDSA_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_CK_ECDHE_ECDSA_WITH_AES_256_CBC_SHA () {0x300c00a;}' unless defined(&TLS1_CK_ECDHE_ECDSA_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_CK_ECDH_RSA_WITH_NULL_SHA () {0x300c00b;}' unless defined(&TLS1_CK_ECDH_RSA_WITH_NULL_SHA);
    eval 'sub TLS1_CK_ECDH_RSA_WITH_RC4_128_SHA () {0x300c00c;}' unless defined(&TLS1_CK_ECDH_RSA_WITH_RC4_128_SHA);
    eval 'sub TLS1_CK_ECDH_RSA_WITH_DES_192_CBC3_SHA () {0x300c00d;}' unless defined(&TLS1_CK_ECDH_RSA_WITH_DES_192_CBC3_SHA);
    eval 'sub TLS1_CK_ECDH_RSA_WITH_AES_128_CBC_SHA () {0x300c00e;}' unless defined(&TLS1_CK_ECDH_RSA_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_CK_ECDH_RSA_WITH_AES_256_CBC_SHA () {0x300c00f;}' unless defined(&TLS1_CK_ECDH_RSA_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_CK_ECDHE_RSA_WITH_NULL_SHA () {0x300c010;}' unless defined(&TLS1_CK_ECDHE_RSA_WITH_NULL_SHA);
    eval 'sub TLS1_CK_ECDHE_RSA_WITH_RC4_128_SHA () {0x300c011;}' unless defined(&TLS1_CK_ECDHE_RSA_WITH_RC4_128_SHA);
    eval 'sub TLS1_CK_ECDHE_RSA_WITH_DES_192_CBC3_SHA () {0x300c012;}' unless defined(&TLS1_CK_ECDHE_RSA_WITH_DES_192_CBC3_SHA);
    eval 'sub TLS1_CK_ECDHE_RSA_WITH_AES_128_CBC_SHA () {0x300c013;}' unless defined(&TLS1_CK_ECDHE_RSA_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_CK_ECDHE_RSA_WITH_AES_256_CBC_SHA () {0x300c014;}' unless defined(&TLS1_CK_ECDHE_RSA_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_CK_ECDH_anon_WITH_NULL_SHA () {0x300c015;}' unless defined(&TLS1_CK_ECDH_anon_WITH_NULL_SHA);
    eval 'sub TLS1_CK_ECDH_anon_WITH_RC4_128_SHA () {0x300c016;}' unless defined(&TLS1_CK_ECDH_anon_WITH_RC4_128_SHA);
    eval 'sub TLS1_CK_ECDH_anon_WITH_DES_192_CBC3_SHA () {0x300c017;}' unless defined(&TLS1_CK_ECDH_anon_WITH_DES_192_CBC3_SHA);
    eval 'sub TLS1_CK_ECDH_anon_WITH_AES_128_CBC_SHA () {0x300c018;}' unless defined(&TLS1_CK_ECDH_anon_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_CK_ECDH_anon_WITH_AES_256_CBC_SHA () {0x300c019;}' unless defined(&TLS1_CK_ECDH_anon_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_CK_SRP_SHA_WITH_3DES_EDE_CBC_SHA () {0x300c01a;}' unless defined(&TLS1_CK_SRP_SHA_WITH_3DES_EDE_CBC_SHA);
    eval 'sub TLS1_CK_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA () {0x300c01b;}' unless defined(&TLS1_CK_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA);
    eval 'sub TLS1_CK_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA () {0x300c01c;}' unless defined(&TLS1_CK_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA);
    eval 'sub TLS1_CK_SRP_SHA_WITH_AES_128_CBC_SHA () {0x300c01d;}' unless defined(&TLS1_CK_SRP_SHA_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_CK_SRP_SHA_RSA_WITH_AES_128_CBC_SHA () {0x300c01e;}' unless defined(&TLS1_CK_SRP_SHA_RSA_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_CK_SRP_SHA_DSS_WITH_AES_128_CBC_SHA () {0x300c01f;}' unless defined(&TLS1_CK_SRP_SHA_DSS_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_CK_SRP_SHA_WITH_AES_256_CBC_SHA () {0x300c020;}' unless defined(&TLS1_CK_SRP_SHA_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_CK_SRP_SHA_RSA_WITH_AES_256_CBC_SHA () {0x300c021;}' unless defined(&TLS1_CK_SRP_SHA_RSA_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_CK_SRP_SHA_DSS_WITH_AES_256_CBC_SHA () {0x300c022;}' unless defined(&TLS1_CK_SRP_SHA_DSS_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_CK_ECDHE_ECDSA_WITH_AES_128_SHA256 () {0x300c023;}' unless defined(&TLS1_CK_ECDHE_ECDSA_WITH_AES_128_SHA256);
    eval 'sub TLS1_CK_ECDHE_ECDSA_WITH_AES_256_SHA384 () {0x300c024;}' unless defined(&TLS1_CK_ECDHE_ECDSA_WITH_AES_256_SHA384);
    eval 'sub TLS1_CK_ECDH_ECDSA_WITH_AES_128_SHA256 () {0x300c025;}' unless defined(&TLS1_CK_ECDH_ECDSA_WITH_AES_128_SHA256);
    eval 'sub TLS1_CK_ECDH_ECDSA_WITH_AES_256_SHA384 () {0x300c026;}' unless defined(&TLS1_CK_ECDH_ECDSA_WITH_AES_256_SHA384);
    eval 'sub TLS1_CK_ECDHE_RSA_WITH_AES_128_SHA256 () {0x300c027;}' unless defined(&TLS1_CK_ECDHE_RSA_WITH_AES_128_SHA256);
    eval 'sub TLS1_CK_ECDHE_RSA_WITH_AES_256_SHA384 () {0x300c028;}' unless defined(&TLS1_CK_ECDHE_RSA_WITH_AES_256_SHA384);
    eval 'sub TLS1_CK_ECDH_RSA_WITH_AES_128_SHA256 () {0x300c029;}' unless defined(&TLS1_CK_ECDH_RSA_WITH_AES_128_SHA256);
    eval 'sub TLS1_CK_ECDH_RSA_WITH_AES_256_SHA384 () {0x300c02a;}' unless defined(&TLS1_CK_ECDH_RSA_WITH_AES_256_SHA384);
    eval 'sub TLS1_CK_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256 () {0x300c02b;}' unless defined(&TLS1_CK_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_CK_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384 () {0x300c02c;}' unless defined(&TLS1_CK_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_CK_ECDH_ECDSA_WITH_AES_128_GCM_SHA256 () {0x300c02d;}' unless defined(&TLS1_CK_ECDH_ECDSA_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_CK_ECDH_ECDSA_WITH_AES_256_GCM_SHA384 () {0x300c02e;}' unless defined(&TLS1_CK_ECDH_ECDSA_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_CK_ECDHE_RSA_WITH_AES_128_GCM_SHA256 () {0x300c02f;}' unless defined(&TLS1_CK_ECDHE_RSA_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_CK_ECDHE_RSA_WITH_AES_256_GCM_SHA384 () {0x300c030;}' unless defined(&TLS1_CK_ECDHE_RSA_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_CK_ECDH_RSA_WITH_AES_128_GCM_SHA256 () {0x300c031;}' unless defined(&TLS1_CK_ECDH_RSA_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_CK_ECDH_RSA_WITH_AES_256_GCM_SHA384 () {0x300c032;}' unless defined(&TLS1_CK_ECDH_RSA_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_CK_ECDHE_PSK_WITH_RC4_128_SHA () {0x300c033;}' unless defined(&TLS1_CK_ECDHE_PSK_WITH_RC4_128_SHA);
    eval 'sub TLS1_CK_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA () {0x300c034;}' unless defined(&TLS1_CK_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA);
    eval 'sub TLS1_CK_ECDHE_PSK_WITH_AES_128_CBC_SHA () {0x300c035;}' unless defined(&TLS1_CK_ECDHE_PSK_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_CK_ECDHE_PSK_WITH_AES_256_CBC_SHA () {0x300c036;}' unless defined(&TLS1_CK_ECDHE_PSK_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_CK_ECDHE_PSK_WITH_AES_128_CBC_SHA256 () {0x300c037;}' unless defined(&TLS1_CK_ECDHE_PSK_WITH_AES_128_CBC_SHA256);
    eval 'sub TLS1_CK_ECDHE_PSK_WITH_AES_256_CBC_SHA384 () {0x300c038;}' unless defined(&TLS1_CK_ECDHE_PSK_WITH_AES_256_CBC_SHA384);
    eval 'sub TLS1_CK_ECDHE_PSK_WITH_NULL_SHA () {0x300c039;}' unless defined(&TLS1_CK_ECDHE_PSK_WITH_NULL_SHA);
    eval 'sub TLS1_CK_ECDHE_PSK_WITH_NULL_SHA256 () {0x300c03a;}' unless defined(&TLS1_CK_ECDHE_PSK_WITH_NULL_SHA256);
    eval 'sub TLS1_CK_ECDHE_PSK_WITH_NULL_SHA384 () {0x300c03b;}' unless defined(&TLS1_CK_ECDHE_PSK_WITH_NULL_SHA384);
    eval 'sub TLS1_CK_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256 () {0x300c072;}' unless defined(&TLS1_CK_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_CK_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384 () {0x300c073;}' unless defined(&TLS1_CK_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384);
    eval 'sub TLS1_CK_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256 () {0x300c074;}' unless defined(&TLS1_CK_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_CK_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384 () {0x300c075;}' unless defined(&TLS1_CK_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384);
    eval 'sub TLS1_CK_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 () {0x300c076;}' unless defined(&TLS1_CK_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_CK_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384 () {0x300c077;}' unless defined(&TLS1_CK_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384);
    eval 'sub TLS1_CK_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256 () {0x300c078;}' unless defined(&TLS1_CK_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_CK_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384 () {0x300c079;}' unless defined(&TLS1_CK_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384);
    eval 'sub TLS1_CK_PSK_WITH_CAMELLIA_128_CBC_SHA256 () {0x300c094;}' unless defined(&TLS1_CK_PSK_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_CK_PSK_WITH_CAMELLIA_256_CBC_SHA384 () {0x300c095;}' unless defined(&TLS1_CK_PSK_WITH_CAMELLIA_256_CBC_SHA384);
    eval 'sub TLS1_CK_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 () {0x300c096;}' unless defined(&TLS1_CK_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_CK_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 () {0x300c097;}' unless defined(&TLS1_CK_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384);
    eval 'sub TLS1_CK_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256 () {0x300c098;}' unless defined(&TLS1_CK_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_CK_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384 () {0x300c099;}' unless defined(&TLS1_CK_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384);
    eval 'sub TLS1_CK_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 () {0x300c09a;}' unless defined(&TLS1_CK_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_CK_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 () {0x300c09b;}' unless defined(&TLS1_CK_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384);
    eval 'sub TLS1_CK_ECDHE_RSA_WITH_CHACHA20_POLY1305 () {0x300cca8;}' unless defined(&TLS1_CK_ECDHE_RSA_WITH_CHACHA20_POLY1305);
    eval 'sub TLS1_CK_ECDHE_ECDSA_WITH_CHACHA20_POLY1305 () {0x300cca9;}' unless defined(&TLS1_CK_ECDHE_ECDSA_WITH_CHACHA20_POLY1305);
    eval 'sub TLS1_CK_DHE_RSA_WITH_CHACHA20_POLY1305 () {0x300ccaa;}' unless defined(&TLS1_CK_DHE_RSA_WITH_CHACHA20_POLY1305);
    eval 'sub TLS1_CK_PSK_WITH_CHACHA20_POLY1305 () {0x300ccab;}' unless defined(&TLS1_CK_PSK_WITH_CHACHA20_POLY1305);
    eval 'sub TLS1_CK_ECDHE_PSK_WITH_CHACHA20_POLY1305 () {0x300ccac;}' unless defined(&TLS1_CK_ECDHE_PSK_WITH_CHACHA20_POLY1305);
    eval 'sub TLS1_CK_DHE_PSK_WITH_CHACHA20_POLY1305 () {0x300ccad;}' unless defined(&TLS1_CK_DHE_PSK_WITH_CHACHA20_POLY1305);
    eval 'sub TLS1_CK_RSA_PSK_WITH_CHACHA20_POLY1305 () {0x300ccae;}' unless defined(&TLS1_CK_RSA_PSK_WITH_CHACHA20_POLY1305);
    eval 'sub TLS1_3_CK_AES_128_GCM_SHA256 () {0x3001301;}' unless defined(&TLS1_3_CK_AES_128_GCM_SHA256);
    eval 'sub TLS1_3_CK_AES_256_GCM_SHA384 () {0x3001302;}' unless defined(&TLS1_3_CK_AES_256_GCM_SHA384);
    eval 'sub TLS1_3_CK_CHACHA20_POLY1305_SHA256 () {0x3001303;}' unless defined(&TLS1_3_CK_CHACHA20_POLY1305_SHA256);
    eval 'sub TLS1_3_CK_AES_128_CCM_SHA256 () {0x3001304;}' unless defined(&TLS1_3_CK_AES_128_CCM_SHA256);
    eval 'sub TLS1_3_CK_AES_128_CCM_8_SHA256 () {0x3001305;}' unless defined(&TLS1_3_CK_AES_128_CCM_8_SHA256);
    eval 'sub TLS1_3_CK_SHA256_SHA256 () {0x300c0b4;}' unless defined(&TLS1_3_CK_SHA256_SHA256);
    eval 'sub TLS1_3_CK_SHA384_SHA384 () {0x300c0b5;}' unless defined(&TLS1_3_CK_SHA384_SHA384);
    eval 'sub TLS1_CK_RSA_WITH_ARIA_128_GCM_SHA256 () {0x300c050;}' unless defined(&TLS1_CK_RSA_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_CK_RSA_WITH_ARIA_256_GCM_SHA384 () {0x300c051;}' unless defined(&TLS1_CK_RSA_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_CK_DHE_RSA_WITH_ARIA_128_GCM_SHA256 () {0x300c052;}' unless defined(&TLS1_CK_DHE_RSA_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_CK_DHE_RSA_WITH_ARIA_256_GCM_SHA384 () {0x300c053;}' unless defined(&TLS1_CK_DHE_RSA_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_CK_DH_RSA_WITH_ARIA_128_GCM_SHA256 () {0x300c054;}' unless defined(&TLS1_CK_DH_RSA_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_CK_DH_RSA_WITH_ARIA_256_GCM_SHA384 () {0x300c055;}' unless defined(&TLS1_CK_DH_RSA_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_CK_DHE_DSS_WITH_ARIA_128_GCM_SHA256 () {0x300c056;}' unless defined(&TLS1_CK_DHE_DSS_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_CK_DHE_DSS_WITH_ARIA_256_GCM_SHA384 () {0x300c057;}' unless defined(&TLS1_CK_DHE_DSS_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_CK_DH_DSS_WITH_ARIA_128_GCM_SHA256 () {0x300c058;}' unless defined(&TLS1_CK_DH_DSS_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_CK_DH_DSS_WITH_ARIA_256_GCM_SHA384 () {0x300c059;}' unless defined(&TLS1_CK_DH_DSS_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_CK_DH_anon_WITH_ARIA_128_GCM_SHA256 () {0x300c05a;}' unless defined(&TLS1_CK_DH_anon_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_CK_DH_anon_WITH_ARIA_256_GCM_SHA384 () {0x300c05b;}' unless defined(&TLS1_CK_DH_anon_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_CK_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256 () {0x300c05c;}' unless defined(&TLS1_CK_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_CK_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384 () {0x300c05d;}' unless defined(&TLS1_CK_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_CK_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256 () {0x300c05e;}' unless defined(&TLS1_CK_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_CK_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384 () {0x300c05f;}' unless defined(&TLS1_CK_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_CK_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256 () {0x300c060;}' unless defined(&TLS1_CK_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_CK_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384 () {0x300c061;}' unless defined(&TLS1_CK_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_CK_ECDH_RSA_WITH_ARIA_128_GCM_SHA256 () {0x300c062;}' unless defined(&TLS1_CK_ECDH_RSA_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_CK_ECDH_RSA_WITH_ARIA_256_GCM_SHA384 () {0x300c063;}' unless defined(&TLS1_CK_ECDH_RSA_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_CK_PSK_WITH_ARIA_128_GCM_SHA256 () {0x300c06a;}' unless defined(&TLS1_CK_PSK_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_CK_PSK_WITH_ARIA_256_GCM_SHA384 () {0x300c06b;}' unless defined(&TLS1_CK_PSK_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_CK_DHE_PSK_WITH_ARIA_128_GCM_SHA256 () {0x300c06c;}' unless defined(&TLS1_CK_DHE_PSK_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_CK_DHE_PSK_WITH_ARIA_256_GCM_SHA384 () {0x300c06d;}' unless defined(&TLS1_CK_DHE_PSK_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_CK_RSA_PSK_WITH_ARIA_128_GCM_SHA256 () {0x300c06e;}' unless defined(&TLS1_CK_RSA_PSK_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_CK_RSA_PSK_WITH_ARIA_256_GCM_SHA384 () {0x300c06f;}' unless defined(&TLS1_CK_RSA_PSK_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_RFC_RSA_WITH_AES_128_SHA () {"TLS_RSA_WITH_AES_128_CBC_SHA";}' unless defined(&TLS1_RFC_RSA_WITH_AES_128_SHA);
    eval 'sub TLS1_RFC_DHE_DSS_WITH_AES_128_SHA () {"TLS_DHE_DSS_WITH_AES_128_CBC_SHA";}' unless defined(&TLS1_RFC_DHE_DSS_WITH_AES_128_SHA);
    eval 'sub TLS1_RFC_DHE_RSA_WITH_AES_128_SHA () {"TLS_DHE_RSA_WITH_AES_128_CBC_SHA";}' unless defined(&TLS1_RFC_DHE_RSA_WITH_AES_128_SHA);
    eval 'sub TLS1_RFC_ADH_WITH_AES_128_SHA () {"TLS_DH_anon_WITH_AES_128_CBC_SHA";}' unless defined(&TLS1_RFC_ADH_WITH_AES_128_SHA);
    eval 'sub TLS1_RFC_RSA_WITH_AES_256_SHA () {"TLS_RSA_WITH_AES_256_CBC_SHA";}' unless defined(&TLS1_RFC_RSA_WITH_AES_256_SHA);
    eval 'sub TLS1_RFC_DHE_DSS_WITH_AES_256_SHA () {"TLS_DHE_DSS_WITH_AES_256_CBC_SHA";}' unless defined(&TLS1_RFC_DHE_DSS_WITH_AES_256_SHA);
    eval 'sub TLS1_RFC_DHE_RSA_WITH_AES_256_SHA () {"TLS_DHE_RSA_WITH_AES_256_CBC_SHA";}' unless defined(&TLS1_RFC_DHE_RSA_WITH_AES_256_SHA);
    eval 'sub TLS1_RFC_ADH_WITH_AES_256_SHA () {"TLS_DH_anon_WITH_AES_256_CBC_SHA";}' unless defined(&TLS1_RFC_ADH_WITH_AES_256_SHA);
    eval 'sub TLS1_RFC_RSA_WITH_NULL_SHA256 () {"TLS_RSA_WITH_NULL_SHA256";}' unless defined(&TLS1_RFC_RSA_WITH_NULL_SHA256);
    eval 'sub TLS1_RFC_RSA_WITH_AES_128_SHA256 () {"TLS_RSA_WITH_AES_128_CBC_SHA256";}' unless defined(&TLS1_RFC_RSA_WITH_AES_128_SHA256);
    eval 'sub TLS1_RFC_RSA_WITH_AES_256_SHA256 () {"TLS_RSA_WITH_AES_256_CBC_SHA256";}' unless defined(&TLS1_RFC_RSA_WITH_AES_256_SHA256);
    eval 'sub TLS1_RFC_DHE_DSS_WITH_AES_128_SHA256 () {"TLS_DHE_DSS_WITH_AES_128_CBC_SHA256";}' unless defined(&TLS1_RFC_DHE_DSS_WITH_AES_128_SHA256);
    eval 'sub TLS1_RFC_DHE_RSA_WITH_AES_128_SHA256 () {"TLS_DHE_RSA_WITH_AES_128_CBC_SHA256";}' unless defined(&TLS1_RFC_DHE_RSA_WITH_AES_128_SHA256);
    eval 'sub TLS1_RFC_DHE_DSS_WITH_AES_256_SHA256 () {"TLS_DHE_DSS_WITH_AES_256_CBC_SHA256";}' unless defined(&TLS1_RFC_DHE_DSS_WITH_AES_256_SHA256);
    eval 'sub TLS1_RFC_DHE_RSA_WITH_AES_256_SHA256 () {"TLS_DHE_RSA_WITH_AES_256_CBC_SHA256";}' unless defined(&TLS1_RFC_DHE_RSA_WITH_AES_256_SHA256);
    eval 'sub TLS1_RFC_ADH_WITH_AES_128_SHA256 () {"TLS_DH_anon_WITH_AES_128_CBC_SHA256";}' unless defined(&TLS1_RFC_ADH_WITH_AES_128_SHA256);
    eval 'sub TLS1_RFC_ADH_WITH_AES_256_SHA256 () {"TLS_DH_anon_WITH_AES_256_CBC_SHA256";}' unless defined(&TLS1_RFC_ADH_WITH_AES_256_SHA256);
    eval 'sub TLS1_RFC_RSA_WITH_AES_128_GCM_SHA256 () {"TLS_RSA_WITH_AES_128_GCM_SHA256";}' unless defined(&TLS1_RFC_RSA_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_RFC_RSA_WITH_AES_256_GCM_SHA384 () {"TLS_RSA_WITH_AES_256_GCM_SHA384";}' unless defined(&TLS1_RFC_RSA_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_RFC_DHE_RSA_WITH_AES_128_GCM_SHA256 () {"TLS_DHE_RSA_WITH_AES_128_GCM_SHA256";}' unless defined(&TLS1_RFC_DHE_RSA_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_RFC_DHE_RSA_WITH_AES_256_GCM_SHA384 () {"TLS_DHE_RSA_WITH_AES_256_GCM_SHA384";}' unless defined(&TLS1_RFC_DHE_RSA_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_RFC_DHE_DSS_WITH_AES_128_GCM_SHA256 () {"TLS_DHE_DSS_WITH_AES_128_GCM_SHA256";}' unless defined(&TLS1_RFC_DHE_DSS_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_RFC_DHE_DSS_WITH_AES_256_GCM_SHA384 () {"TLS_DHE_DSS_WITH_AES_256_GCM_SHA384";}' unless defined(&TLS1_RFC_DHE_DSS_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_RFC_ADH_WITH_AES_128_GCM_SHA256 () {"TLS_DH_anon_WITH_AES_128_GCM_SHA256";}' unless defined(&TLS1_RFC_ADH_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_RFC_ADH_WITH_AES_256_GCM_SHA384 () {"TLS_DH_anon_WITH_AES_256_GCM_SHA384";}' unless defined(&TLS1_RFC_ADH_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_RFC_RSA_WITH_AES_128_CCM () {"TLS_RSA_WITH_AES_128_CCM";}' unless defined(&TLS1_RFC_RSA_WITH_AES_128_CCM);
    eval 'sub TLS1_RFC_RSA_WITH_AES_256_CCM () {"TLS_RSA_WITH_AES_256_CCM";}' unless defined(&TLS1_RFC_RSA_WITH_AES_256_CCM);
    eval 'sub TLS1_RFC_DHE_RSA_WITH_AES_128_CCM () {"TLS_DHE_RSA_WITH_AES_128_CCM";}' unless defined(&TLS1_RFC_DHE_RSA_WITH_AES_128_CCM);
    eval 'sub TLS1_RFC_DHE_RSA_WITH_AES_256_CCM () {"TLS_DHE_RSA_WITH_AES_256_CCM";}' unless defined(&TLS1_RFC_DHE_RSA_WITH_AES_256_CCM);
    eval 'sub TLS1_RFC_RSA_WITH_AES_128_CCM_8 () {"TLS_RSA_WITH_AES_128_CCM_8";}' unless defined(&TLS1_RFC_RSA_WITH_AES_128_CCM_8);
    eval 'sub TLS1_RFC_RSA_WITH_AES_256_CCM_8 () {"TLS_RSA_WITH_AES_256_CCM_8";}' unless defined(&TLS1_RFC_RSA_WITH_AES_256_CCM_8);
    eval 'sub TLS1_RFC_DHE_RSA_WITH_AES_128_CCM_8 () {"TLS_DHE_RSA_WITH_AES_128_CCM_8";}' unless defined(&TLS1_RFC_DHE_RSA_WITH_AES_128_CCM_8);
    eval 'sub TLS1_RFC_DHE_RSA_WITH_AES_256_CCM_8 () {"TLS_DHE_RSA_WITH_AES_256_CCM_8";}' unless defined(&TLS1_RFC_DHE_RSA_WITH_AES_256_CCM_8);
    eval 'sub TLS1_RFC_PSK_WITH_AES_128_CCM () {"TLS_PSK_WITH_AES_128_CCM";}' unless defined(&TLS1_RFC_PSK_WITH_AES_128_CCM);
    eval 'sub TLS1_RFC_PSK_WITH_AES_256_CCM () {"TLS_PSK_WITH_AES_256_CCM";}' unless defined(&TLS1_RFC_PSK_WITH_AES_256_CCM);
    eval 'sub TLS1_RFC_DHE_PSK_WITH_AES_128_CCM () {"TLS_DHE_PSK_WITH_AES_128_CCM";}' unless defined(&TLS1_RFC_DHE_PSK_WITH_AES_128_CCM);
    eval 'sub TLS1_RFC_DHE_PSK_WITH_AES_256_CCM () {"TLS_DHE_PSK_WITH_AES_256_CCM";}' unless defined(&TLS1_RFC_DHE_PSK_WITH_AES_256_CCM);
    eval 'sub TLS1_RFC_PSK_WITH_AES_128_CCM_8 () {"TLS_PSK_WITH_AES_128_CCM_8";}' unless defined(&TLS1_RFC_PSK_WITH_AES_128_CCM_8);
    eval 'sub TLS1_RFC_PSK_WITH_AES_256_CCM_8 () {"TLS_PSK_WITH_AES_256_CCM_8";}' unless defined(&TLS1_RFC_PSK_WITH_AES_256_CCM_8);
    eval 'sub TLS1_RFC_DHE_PSK_WITH_AES_128_CCM_8 () {"TLS_PSK_DHE_WITH_AES_128_CCM_8";}' unless defined(&TLS1_RFC_DHE_PSK_WITH_AES_128_CCM_8);
    eval 'sub TLS1_RFC_DHE_PSK_WITH_AES_256_CCM_8 () {"TLS_PSK_DHE_WITH_AES_256_CCM_8";}' unless defined(&TLS1_RFC_DHE_PSK_WITH_AES_256_CCM_8);
    eval 'sub TLS1_RFC_ECDHE_ECDSA_WITH_AES_128_CCM () {"TLS_ECDHE_ECDSA_WITH_AES_128_CCM";}' unless defined(&TLS1_RFC_ECDHE_ECDSA_WITH_AES_128_CCM);
    eval 'sub TLS1_RFC_ECDHE_ECDSA_WITH_AES_256_CCM () {"TLS_ECDHE_ECDSA_WITH_AES_256_CCM";}' unless defined(&TLS1_RFC_ECDHE_ECDSA_WITH_AES_256_CCM);
    eval 'sub TLS1_RFC_ECDHE_ECDSA_WITH_AES_128_CCM_8 () {"TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8";}' unless defined(&TLS1_RFC_ECDHE_ECDSA_WITH_AES_128_CCM_8);
    eval 'sub TLS1_RFC_ECDHE_ECDSA_WITH_AES_256_CCM_8 () {"TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8";}' unless defined(&TLS1_RFC_ECDHE_ECDSA_WITH_AES_256_CCM_8);
    eval 'sub TLS1_3_RFC_AES_128_GCM_SHA256 () {"TLS_AES_128_GCM_SHA256";}' unless defined(&TLS1_3_RFC_AES_128_GCM_SHA256);
    eval 'sub TLS1_3_RFC_AES_256_GCM_SHA384 () {"TLS_AES_256_GCM_SHA384";}' unless defined(&TLS1_3_RFC_AES_256_GCM_SHA384);
    eval 'sub TLS1_3_RFC_CHACHA20_POLY1305_SHA256 () {"TLS_CHACHA20_POLY1305_SHA256";}' unless defined(&TLS1_3_RFC_CHACHA20_POLY1305_SHA256);
    eval 'sub TLS1_3_RFC_SHA256_SHA256 () {"TLS_SHA256_SHA256";}' unless defined(&TLS1_3_RFC_SHA256_SHA256);
    eval 'sub TLS1_3_RFC_SHA384_SHA384 () {"TLS_SHA384_SHA384";}' unless defined(&TLS1_3_RFC_SHA384_SHA384);
    eval 'sub TLS1_3_RFC_AES_128_CCM_SHA256 () {"TLS_AES_128_CCM_SHA256";}' unless defined(&TLS1_3_RFC_AES_128_CCM_SHA256);
    eval 'sub TLS1_3_RFC_AES_128_CCM_8_SHA256 () {"TLS_AES_128_CCM_8_SHA256";}' unless defined(&TLS1_3_RFC_AES_128_CCM_8_SHA256);
    eval 'sub TLS1_RFC_ECDHE_ECDSA_WITH_NULL_SHA () {"TLS_ECDHE_ECDSA_WITH_NULL_SHA";}' unless defined(&TLS1_RFC_ECDHE_ECDSA_WITH_NULL_SHA);
    eval 'sub TLS1_RFC_ECDHE_ECDSA_WITH_DES_192_CBC3_SHA () {"TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA";}' unless defined(&TLS1_RFC_ECDHE_ECDSA_WITH_DES_192_CBC3_SHA);
    eval 'sub TLS1_RFC_ECDHE_ECDSA_WITH_AES_128_CBC_SHA () {"TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA";}' unless defined(&TLS1_RFC_ECDHE_ECDSA_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_RFC_ECDHE_ECDSA_WITH_AES_256_CBC_SHA () {"TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA";}' unless defined(&TLS1_RFC_ECDHE_ECDSA_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_RFC_ECDHE_RSA_WITH_NULL_SHA () {"TLS_ECDHE_RSA_WITH_NULL_SHA";}' unless defined(&TLS1_RFC_ECDHE_RSA_WITH_NULL_SHA);
    eval 'sub TLS1_RFC_ECDHE_RSA_WITH_DES_192_CBC3_SHA () {"TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA";}' unless defined(&TLS1_RFC_ECDHE_RSA_WITH_DES_192_CBC3_SHA);
    eval 'sub TLS1_RFC_ECDHE_RSA_WITH_AES_128_CBC_SHA () {"TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA";}' unless defined(&TLS1_RFC_ECDHE_RSA_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_RFC_ECDHE_RSA_WITH_AES_256_CBC_SHA () {"TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA";}' unless defined(&TLS1_RFC_ECDHE_RSA_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_RFC_ECDH_anon_WITH_NULL_SHA () {"TLS_ECDH_anon_WITH_NULL_SHA";}' unless defined(&TLS1_RFC_ECDH_anon_WITH_NULL_SHA);
    eval 'sub TLS1_RFC_ECDH_anon_WITH_DES_192_CBC3_SHA () {"TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA";}' unless defined(&TLS1_RFC_ECDH_anon_WITH_DES_192_CBC3_SHA);
    eval 'sub TLS1_RFC_ECDH_anon_WITH_AES_128_CBC_SHA () {"TLS_ECDH_anon_WITH_AES_128_CBC_SHA";}' unless defined(&TLS1_RFC_ECDH_anon_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_RFC_ECDH_anon_WITH_AES_256_CBC_SHA () {"TLS_ECDH_anon_WITH_AES_256_CBC_SHA";}' unless defined(&TLS1_RFC_ECDH_anon_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_RFC_ECDHE_ECDSA_WITH_AES_128_SHA256 () {"TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256";}' unless defined(&TLS1_RFC_ECDHE_ECDSA_WITH_AES_128_SHA256);
    eval 'sub TLS1_RFC_ECDHE_ECDSA_WITH_AES_256_SHA384 () {"TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384";}' unless defined(&TLS1_RFC_ECDHE_ECDSA_WITH_AES_256_SHA384);
    eval 'sub TLS1_RFC_ECDHE_RSA_WITH_AES_128_SHA256 () {"TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256";}' unless defined(&TLS1_RFC_ECDHE_RSA_WITH_AES_128_SHA256);
    eval 'sub TLS1_RFC_ECDHE_RSA_WITH_AES_256_SHA384 () {"TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384";}' unless defined(&TLS1_RFC_ECDHE_RSA_WITH_AES_256_SHA384);
    eval 'sub TLS1_RFC_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256 () {"TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256";}' unless defined(&TLS1_RFC_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_RFC_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384 () {"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384";}' unless defined(&TLS1_RFC_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_RFC_ECDHE_RSA_WITH_AES_128_GCM_SHA256 () {"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256";}' unless defined(&TLS1_RFC_ECDHE_RSA_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_RFC_ECDHE_RSA_WITH_AES_256_GCM_SHA384 () {"TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384";}' unless defined(&TLS1_RFC_ECDHE_RSA_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_RFC_PSK_WITH_NULL_SHA () {"TLS_PSK_WITH_NULL_SHA";}' unless defined(&TLS1_RFC_PSK_WITH_NULL_SHA);
    eval 'sub TLS1_RFC_DHE_PSK_WITH_NULL_SHA () {"TLS_DHE_PSK_WITH_NULL_SHA";}' unless defined(&TLS1_RFC_DHE_PSK_WITH_NULL_SHA);
    eval 'sub TLS1_RFC_RSA_PSK_WITH_NULL_SHA () {"TLS_RSA_PSK_WITH_NULL_SHA";}' unless defined(&TLS1_RFC_RSA_PSK_WITH_NULL_SHA);
    eval 'sub TLS1_RFC_PSK_WITH_3DES_EDE_CBC_SHA () {"TLS_PSK_WITH_3DES_EDE_CBC_SHA";}' unless defined(&TLS1_RFC_PSK_WITH_3DES_EDE_CBC_SHA);
    eval 'sub TLS1_RFC_PSK_WITH_AES_128_CBC_SHA () {"TLS_PSK_WITH_AES_128_CBC_SHA";}' unless defined(&TLS1_RFC_PSK_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_RFC_PSK_WITH_AES_256_CBC_SHA () {"TLS_PSK_WITH_AES_256_CBC_SHA";}' unless defined(&TLS1_RFC_PSK_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_RFC_DHE_PSK_WITH_3DES_EDE_CBC_SHA () {"TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA";}' unless defined(&TLS1_RFC_DHE_PSK_WITH_3DES_EDE_CBC_SHA);
    eval 'sub TLS1_RFC_DHE_PSK_WITH_AES_128_CBC_SHA () {"TLS_DHE_PSK_WITH_AES_128_CBC_SHA";}' unless defined(&TLS1_RFC_DHE_PSK_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_RFC_DHE_PSK_WITH_AES_256_CBC_SHA () {"TLS_DHE_PSK_WITH_AES_256_CBC_SHA";}' unless defined(&TLS1_RFC_DHE_PSK_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_RFC_RSA_PSK_WITH_3DES_EDE_CBC_SHA () {"TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA";}' unless defined(&TLS1_RFC_RSA_PSK_WITH_3DES_EDE_CBC_SHA);
    eval 'sub TLS1_RFC_RSA_PSK_WITH_AES_128_CBC_SHA () {"TLS_RSA_PSK_WITH_AES_128_CBC_SHA";}' unless defined(&TLS1_RFC_RSA_PSK_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_RFC_RSA_PSK_WITH_AES_256_CBC_SHA () {"TLS_RSA_PSK_WITH_AES_256_CBC_SHA";}' unless defined(&TLS1_RFC_RSA_PSK_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_RFC_PSK_WITH_AES_128_GCM_SHA256 () {"TLS_PSK_WITH_AES_128_GCM_SHA256";}' unless defined(&TLS1_RFC_PSK_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_RFC_PSK_WITH_AES_256_GCM_SHA384 () {"TLS_PSK_WITH_AES_256_GCM_SHA384";}' unless defined(&TLS1_RFC_PSK_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_RFC_DHE_PSK_WITH_AES_128_GCM_SHA256 () {"TLS_DHE_PSK_WITH_AES_128_GCM_SHA256";}' unless defined(&TLS1_RFC_DHE_PSK_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_RFC_DHE_PSK_WITH_AES_256_GCM_SHA384 () {"TLS_DHE_PSK_WITH_AES_256_GCM_SHA384";}' unless defined(&TLS1_RFC_DHE_PSK_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_RFC_RSA_PSK_WITH_AES_128_GCM_SHA256 () {"TLS_RSA_PSK_WITH_AES_128_GCM_SHA256";}' unless defined(&TLS1_RFC_RSA_PSK_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_RFC_RSA_PSK_WITH_AES_256_GCM_SHA384 () {"TLS_RSA_PSK_WITH_AES_256_GCM_SHA384";}' unless defined(&TLS1_RFC_RSA_PSK_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_RFC_PSK_WITH_AES_128_CBC_SHA256 () {"TLS_PSK_WITH_AES_128_CBC_SHA256";}' unless defined(&TLS1_RFC_PSK_WITH_AES_128_CBC_SHA256);
    eval 'sub TLS1_RFC_PSK_WITH_AES_256_CBC_SHA384 () {"TLS_PSK_WITH_AES_256_CBC_SHA384";}' unless defined(&TLS1_RFC_PSK_WITH_AES_256_CBC_SHA384);
    eval 'sub TLS1_RFC_PSK_WITH_NULL_SHA256 () {"TLS_PSK_WITH_NULL_SHA256";}' unless defined(&TLS1_RFC_PSK_WITH_NULL_SHA256);
    eval 'sub TLS1_RFC_PSK_WITH_NULL_SHA384 () {"TLS_PSK_WITH_NULL_SHA384";}' unless defined(&TLS1_RFC_PSK_WITH_NULL_SHA384);
    eval 'sub TLS1_RFC_DHE_PSK_WITH_AES_128_CBC_SHA256 () {"TLS_DHE_PSK_WITH_AES_128_CBC_SHA256";}' unless defined(&TLS1_RFC_DHE_PSK_WITH_AES_128_CBC_SHA256);
    eval 'sub TLS1_RFC_DHE_PSK_WITH_AES_256_CBC_SHA384 () {"TLS_DHE_PSK_WITH_AES_256_CBC_SHA384";}' unless defined(&TLS1_RFC_DHE_PSK_WITH_AES_256_CBC_SHA384);
    eval 'sub TLS1_RFC_DHE_PSK_WITH_NULL_SHA256 () {"TLS_DHE_PSK_WITH_NULL_SHA256";}' unless defined(&TLS1_RFC_DHE_PSK_WITH_NULL_SHA256);
    eval 'sub TLS1_RFC_DHE_PSK_WITH_NULL_SHA384 () {"TLS_DHE_PSK_WITH_NULL_SHA384";}' unless defined(&TLS1_RFC_DHE_PSK_WITH_NULL_SHA384);
    eval 'sub TLS1_RFC_RSA_PSK_WITH_AES_128_CBC_SHA256 () {"TLS_RSA_PSK_WITH_AES_128_CBC_SHA256";}' unless defined(&TLS1_RFC_RSA_PSK_WITH_AES_128_CBC_SHA256);
    eval 'sub TLS1_RFC_RSA_PSK_WITH_AES_256_CBC_SHA384 () {"TLS_RSA_PSK_WITH_AES_256_CBC_SHA384";}' unless defined(&TLS1_RFC_RSA_PSK_WITH_AES_256_CBC_SHA384);
    eval 'sub TLS1_RFC_RSA_PSK_WITH_NULL_SHA256 () {"TLS_RSA_PSK_WITH_NULL_SHA256";}' unless defined(&TLS1_RFC_RSA_PSK_WITH_NULL_SHA256);
    eval 'sub TLS1_RFC_RSA_PSK_WITH_NULL_SHA384 () {"TLS_RSA_PSK_WITH_NULL_SHA384";}' unless defined(&TLS1_RFC_RSA_PSK_WITH_NULL_SHA384);
    eval 'sub TLS1_RFC_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA () {"TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA";}' unless defined(&TLS1_RFC_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA);
    eval 'sub TLS1_RFC_ECDHE_PSK_WITH_AES_128_CBC_SHA () {"TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA";}' unless defined(&TLS1_RFC_ECDHE_PSK_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_RFC_ECDHE_PSK_WITH_AES_256_CBC_SHA () {"TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA";}' unless defined(&TLS1_RFC_ECDHE_PSK_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_RFC_ECDHE_PSK_WITH_AES_128_CBC_SHA256 () {"TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256";}' unless defined(&TLS1_RFC_ECDHE_PSK_WITH_AES_128_CBC_SHA256);
    eval 'sub TLS1_RFC_ECDHE_PSK_WITH_AES_256_CBC_SHA384 () {"TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384";}' unless defined(&TLS1_RFC_ECDHE_PSK_WITH_AES_256_CBC_SHA384);
    eval 'sub TLS1_RFC_ECDHE_PSK_WITH_NULL_SHA () {"TLS_ECDHE_PSK_WITH_NULL_SHA";}' unless defined(&TLS1_RFC_ECDHE_PSK_WITH_NULL_SHA);
    eval 'sub TLS1_RFC_ECDHE_PSK_WITH_NULL_SHA256 () {"TLS_ECDHE_PSK_WITH_NULL_SHA256";}' unless defined(&TLS1_RFC_ECDHE_PSK_WITH_NULL_SHA256);
    eval 'sub TLS1_RFC_ECDHE_PSK_WITH_NULL_SHA384 () {"TLS_ECDHE_PSK_WITH_NULL_SHA384";}' unless defined(&TLS1_RFC_ECDHE_PSK_WITH_NULL_SHA384);
    eval 'sub TLS1_RFC_SRP_SHA_WITH_3DES_EDE_CBC_SHA () {"TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA";}' unless defined(&TLS1_RFC_SRP_SHA_WITH_3DES_EDE_CBC_SHA);
    eval 'sub TLS1_RFC_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA () {"TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA";}' unless defined(&TLS1_RFC_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA);
    eval 'sub TLS1_RFC_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA () {"TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA";}' unless defined(&TLS1_RFC_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA);
    eval 'sub TLS1_RFC_SRP_SHA_WITH_AES_128_CBC_SHA () {"TLS_SRP_SHA_WITH_AES_128_CBC_SHA";}' unless defined(&TLS1_RFC_SRP_SHA_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_RFC_SRP_SHA_RSA_WITH_AES_128_CBC_SHA () {"TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA";}' unless defined(&TLS1_RFC_SRP_SHA_RSA_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_RFC_SRP_SHA_DSS_WITH_AES_128_CBC_SHA () {"TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA";}' unless defined(&TLS1_RFC_SRP_SHA_DSS_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_RFC_SRP_SHA_WITH_AES_256_CBC_SHA () {"TLS_SRP_SHA_WITH_AES_256_CBC_SHA";}' unless defined(&TLS1_RFC_SRP_SHA_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_RFC_SRP_SHA_RSA_WITH_AES_256_CBC_SHA () {"TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA";}' unless defined(&TLS1_RFC_SRP_SHA_RSA_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_RFC_SRP_SHA_DSS_WITH_AES_256_CBC_SHA () {"TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA";}' unless defined(&TLS1_RFC_SRP_SHA_DSS_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_RFC_DHE_RSA_WITH_CHACHA20_POLY1305 () {"TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256";}' unless defined(&TLS1_RFC_DHE_RSA_WITH_CHACHA20_POLY1305);
    eval 'sub TLS1_RFC_ECDHE_RSA_WITH_CHACHA20_POLY1305 () {"TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256";}' unless defined(&TLS1_RFC_ECDHE_RSA_WITH_CHACHA20_POLY1305);
    eval 'sub TLS1_RFC_ECDHE_ECDSA_WITH_CHACHA20_POLY1305 () {"TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256";}' unless defined(&TLS1_RFC_ECDHE_ECDSA_WITH_CHACHA20_POLY1305);
    eval 'sub TLS1_RFC_PSK_WITH_CHACHA20_POLY1305 () {"TLS_PSK_WITH_CHACHA20_POLY1305_SHA256";}' unless defined(&TLS1_RFC_PSK_WITH_CHACHA20_POLY1305);
    eval 'sub TLS1_RFC_ECDHE_PSK_WITH_CHACHA20_POLY1305 () {"TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256";}' unless defined(&TLS1_RFC_ECDHE_PSK_WITH_CHACHA20_POLY1305);
    eval 'sub TLS1_RFC_DHE_PSK_WITH_CHACHA20_POLY1305 () {"TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256";}' unless defined(&TLS1_RFC_DHE_PSK_WITH_CHACHA20_POLY1305);
    eval 'sub TLS1_RFC_RSA_PSK_WITH_CHACHA20_POLY1305 () {"TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256";}' unless defined(&TLS1_RFC_RSA_PSK_WITH_CHACHA20_POLY1305);
    eval 'sub TLS1_RFC_RSA_WITH_CAMELLIA_128_CBC_SHA256 () {"TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256";}' unless defined(&TLS1_RFC_RSA_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_RFC_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256 () {"TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256";}' unless defined(&TLS1_RFC_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_RFC_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 () {"TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256";}' unless defined(&TLS1_RFC_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_RFC_ADH_WITH_CAMELLIA_128_CBC_SHA256 () {"TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256";}' unless defined(&TLS1_RFC_ADH_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_RFC_RSA_WITH_CAMELLIA_256_CBC_SHA256 () {"TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256";}' unless defined(&TLS1_RFC_RSA_WITH_CAMELLIA_256_CBC_SHA256);
    eval 'sub TLS1_RFC_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256 () {"TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256";}' unless defined(&TLS1_RFC_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256);
    eval 'sub TLS1_RFC_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256 () {"TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256";}' unless defined(&TLS1_RFC_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256);
    eval 'sub TLS1_RFC_ADH_WITH_CAMELLIA_256_CBC_SHA256 () {"TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256";}' unless defined(&TLS1_RFC_ADH_WITH_CAMELLIA_256_CBC_SHA256);
    eval 'sub TLS1_RFC_RSA_WITH_CAMELLIA_256_CBC_SHA () {"TLS_RSA_WITH_CAMELLIA_256_CBC_SHA";}' unless defined(&TLS1_RFC_RSA_WITH_CAMELLIA_256_CBC_SHA);
    eval 'sub TLS1_RFC_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA () {"TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA";}' unless defined(&TLS1_RFC_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA);
    eval 'sub TLS1_RFC_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA () {"TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA";}' unless defined(&TLS1_RFC_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA);
    eval 'sub TLS1_RFC_ADH_WITH_CAMELLIA_256_CBC_SHA () {"TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA";}' unless defined(&TLS1_RFC_ADH_WITH_CAMELLIA_256_CBC_SHA);
    eval 'sub TLS1_RFC_RSA_WITH_CAMELLIA_128_CBC_SHA () {"TLS_RSA_WITH_CAMELLIA_128_CBC_SHA";}' unless defined(&TLS1_RFC_RSA_WITH_CAMELLIA_128_CBC_SHA);
    eval 'sub TLS1_RFC_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA () {"TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA";}' unless defined(&TLS1_RFC_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA);
    eval 'sub TLS1_RFC_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA () {"TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA";}' unless defined(&TLS1_RFC_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA);
    eval 'sub TLS1_RFC_ADH_WITH_CAMELLIA_128_CBC_SHA () {"TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA";}' unless defined(&TLS1_RFC_ADH_WITH_CAMELLIA_128_CBC_SHA);
    eval 'sub TLS1_RFC_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256 () {"TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256";}' unless defined(&TLS1_RFC_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_RFC_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384 () {"TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384";}' unless defined(&TLS1_RFC_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384);
    eval 'sub TLS1_RFC_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 () {"TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256";}' unless defined(&TLS1_RFC_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_RFC_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384 () {"TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384";}' unless defined(&TLS1_RFC_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384);
    eval 'sub TLS1_RFC_PSK_WITH_CAMELLIA_128_CBC_SHA256 () {"TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256";}' unless defined(&TLS1_RFC_PSK_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_RFC_PSK_WITH_CAMELLIA_256_CBC_SHA384 () {"TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384";}' unless defined(&TLS1_RFC_PSK_WITH_CAMELLIA_256_CBC_SHA384);
    eval 'sub TLS1_RFC_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 () {"TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256";}' unless defined(&TLS1_RFC_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_RFC_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 () {"TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384";}' unless defined(&TLS1_RFC_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384);
    eval 'sub TLS1_RFC_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256 () {"TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256";}' unless defined(&TLS1_RFC_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_RFC_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384 () {"TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384";}' unless defined(&TLS1_RFC_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384);
    eval 'sub TLS1_RFC_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 () {"TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256";}' unless defined(&TLS1_RFC_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_RFC_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 () {"TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384";}' unless defined(&TLS1_RFC_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384);
    eval 'sub TLS1_RFC_RSA_WITH_SEED_SHA () {"TLS_RSA_WITH_SEED_CBC_SHA";}' unless defined(&TLS1_RFC_RSA_WITH_SEED_SHA);
    eval 'sub TLS1_RFC_DHE_DSS_WITH_SEED_SHA () {"TLS_DHE_DSS_WITH_SEED_CBC_SHA";}' unless defined(&TLS1_RFC_DHE_DSS_WITH_SEED_SHA);
    eval 'sub TLS1_RFC_DHE_RSA_WITH_SEED_SHA () {"TLS_DHE_RSA_WITH_SEED_CBC_SHA";}' unless defined(&TLS1_RFC_DHE_RSA_WITH_SEED_SHA);
    eval 'sub TLS1_RFC_ADH_WITH_SEED_SHA () {"TLS_DH_anon_WITH_SEED_CBC_SHA";}' unless defined(&TLS1_RFC_ADH_WITH_SEED_SHA);
    eval 'sub TLS1_RFC_ECDHE_PSK_WITH_RC4_128_SHA () {"TLS_ECDHE_PSK_WITH_RC4_128_SHA";}' unless defined(&TLS1_RFC_ECDHE_PSK_WITH_RC4_128_SHA);
    eval 'sub TLS1_RFC_ECDH_anon_WITH_RC4_128_SHA () {"TLS_ECDH_anon_WITH_RC4_128_SHA";}' unless defined(&TLS1_RFC_ECDH_anon_WITH_RC4_128_SHA);
    eval 'sub TLS1_RFC_ECDHE_ECDSA_WITH_RC4_128_SHA () {"TLS_ECDHE_ECDSA_WITH_RC4_128_SHA";}' unless defined(&TLS1_RFC_ECDHE_ECDSA_WITH_RC4_128_SHA);
    eval 'sub TLS1_RFC_ECDHE_RSA_WITH_RC4_128_SHA () {"TLS_ECDHE_RSA_WITH_RC4_128_SHA";}' unless defined(&TLS1_RFC_ECDHE_RSA_WITH_RC4_128_SHA);
    eval 'sub TLS1_RFC_PSK_WITH_RC4_128_SHA () {"TLS_PSK_WITH_RC4_128_SHA";}' unless defined(&TLS1_RFC_PSK_WITH_RC4_128_SHA);
    eval 'sub TLS1_RFC_RSA_PSK_WITH_RC4_128_SHA () {"TLS_RSA_PSK_WITH_RC4_128_SHA";}' unless defined(&TLS1_RFC_RSA_PSK_WITH_RC4_128_SHA);
    eval 'sub TLS1_RFC_DHE_PSK_WITH_RC4_128_SHA () {"TLS_DHE_PSK_WITH_RC4_128_SHA";}' unless defined(&TLS1_RFC_DHE_PSK_WITH_RC4_128_SHA);
    eval 'sub TLS1_RFC_RSA_WITH_ARIA_128_GCM_SHA256 () {"TLS_RSA_WITH_ARIA_128_GCM_SHA256";}' unless defined(&TLS1_RFC_RSA_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_RFC_RSA_WITH_ARIA_256_GCM_SHA384 () {"TLS_RSA_WITH_ARIA_256_GCM_SHA384";}' unless defined(&TLS1_RFC_RSA_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_RFC_DHE_RSA_WITH_ARIA_128_GCM_SHA256 () {"TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256";}' unless defined(&TLS1_RFC_DHE_RSA_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_RFC_DHE_RSA_WITH_ARIA_256_GCM_SHA384 () {"TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384";}' unless defined(&TLS1_RFC_DHE_RSA_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_RFC_DH_RSA_WITH_ARIA_128_GCM_SHA256 () {"TLS_DH_RSA_WITH_ARIA_128_GCM_SHA256";}' unless defined(&TLS1_RFC_DH_RSA_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_RFC_DH_RSA_WITH_ARIA_256_GCM_SHA384 () {"TLS_DH_RSA_WITH_ARIA_256_GCM_SHA384";}' unless defined(&TLS1_RFC_DH_RSA_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_RFC_DHE_DSS_WITH_ARIA_128_GCM_SHA256 () {"TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256";}' unless defined(&TLS1_RFC_DHE_DSS_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_RFC_DHE_DSS_WITH_ARIA_256_GCM_SHA384 () {"TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384";}' unless defined(&TLS1_RFC_DHE_DSS_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_RFC_DH_DSS_WITH_ARIA_128_GCM_SHA256 () {"TLS_DH_DSS_WITH_ARIA_128_GCM_SHA256";}' unless defined(&TLS1_RFC_DH_DSS_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_RFC_DH_DSS_WITH_ARIA_256_GCM_SHA384 () {"TLS_DH_DSS_WITH_ARIA_256_GCM_SHA384";}' unless defined(&TLS1_RFC_DH_DSS_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_RFC_DH_anon_WITH_ARIA_128_GCM_SHA256 () {"TLS_DH_anon_WITH_ARIA_128_GCM_SHA256";}' unless defined(&TLS1_RFC_DH_anon_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_RFC_DH_anon_WITH_ARIA_256_GCM_SHA384 () {"TLS_DH_anon_WITH_ARIA_256_GCM_SHA384";}' unless defined(&TLS1_RFC_DH_anon_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_RFC_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256 () {"TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256";}' unless defined(&TLS1_RFC_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_RFC_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384 () {"TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384";}' unless defined(&TLS1_RFC_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_RFC_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256 () {"TLS_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256";}' unless defined(&TLS1_RFC_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_RFC_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384 () {"TLS_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384";}' unless defined(&TLS1_RFC_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_RFC_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256 () {"TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256";}' unless defined(&TLS1_RFC_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_RFC_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384 () {"TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384";}' unless defined(&TLS1_RFC_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_RFC_ECDH_RSA_WITH_ARIA_128_GCM_SHA256 () {"TLS_ECDH_RSA_WITH_ARIA_128_GCM_SHA256";}' unless defined(&TLS1_RFC_ECDH_RSA_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_RFC_ECDH_RSA_WITH_ARIA_256_GCM_SHA384 () {"TLS_ECDH_RSA_WITH_ARIA_256_GCM_SHA384";}' unless defined(&TLS1_RFC_ECDH_RSA_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_RFC_PSK_WITH_ARIA_128_GCM_SHA256 () {"TLS_PSK_WITH_ARIA_128_GCM_SHA256";}' unless defined(&TLS1_RFC_PSK_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_RFC_PSK_WITH_ARIA_256_GCM_SHA384 () {"TLS_PSK_WITH_ARIA_256_GCM_SHA384";}' unless defined(&TLS1_RFC_PSK_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_RFC_DHE_PSK_WITH_ARIA_128_GCM_SHA256 () {"TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256";}' unless defined(&TLS1_RFC_DHE_PSK_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_RFC_DHE_PSK_WITH_ARIA_256_GCM_SHA384 () {"TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384";}' unless defined(&TLS1_RFC_DHE_PSK_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_RFC_RSA_PSK_WITH_ARIA_128_GCM_SHA256 () {"TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256";}' unless defined(&TLS1_RFC_RSA_PSK_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_RFC_RSA_PSK_WITH_ARIA_256_GCM_SHA384 () {"TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384";}' unless defined(&TLS1_RFC_RSA_PSK_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_TXT_DHE_DSS_WITH_RC4_128_SHA () {"DHE-DSS-RC4-SHA";}' unless defined(&TLS1_TXT_DHE_DSS_WITH_RC4_128_SHA);
    eval 'sub TLS1_TXT_PSK_WITH_NULL_SHA () {"PSK-NULL-SHA";}' unless defined(&TLS1_TXT_PSK_WITH_NULL_SHA);
    eval 'sub TLS1_TXT_DHE_PSK_WITH_NULL_SHA () {"DHE-PSK-NULL-SHA";}' unless defined(&TLS1_TXT_DHE_PSK_WITH_NULL_SHA);
    eval 'sub TLS1_TXT_RSA_PSK_WITH_NULL_SHA () {"RSA-PSK-NULL-SHA";}' unless defined(&TLS1_TXT_RSA_PSK_WITH_NULL_SHA);
    eval 'sub TLS1_TXT_RSA_WITH_AES_128_SHA () {"AES128-SHA";}' unless defined(&TLS1_TXT_RSA_WITH_AES_128_SHA);
    eval 'sub TLS1_TXT_DH_DSS_WITH_AES_128_SHA () {"DH-DSS-AES128-SHA";}' unless defined(&TLS1_TXT_DH_DSS_WITH_AES_128_SHA);
    eval 'sub TLS1_TXT_DH_RSA_WITH_AES_128_SHA () {"DH-RSA-AES128-SHA";}' unless defined(&TLS1_TXT_DH_RSA_WITH_AES_128_SHA);
    eval 'sub TLS1_TXT_DHE_DSS_WITH_AES_128_SHA () {"DHE-DSS-AES128-SHA";}' unless defined(&TLS1_TXT_DHE_DSS_WITH_AES_128_SHA);
    eval 'sub TLS1_TXT_DHE_RSA_WITH_AES_128_SHA () {"DHE-RSA-AES128-SHA";}' unless defined(&TLS1_TXT_DHE_RSA_WITH_AES_128_SHA);
    eval 'sub TLS1_TXT_ADH_WITH_AES_128_SHA () {"ADH-AES128-SHA";}' unless defined(&TLS1_TXT_ADH_WITH_AES_128_SHA);
    eval 'sub TLS1_TXT_RSA_WITH_AES_256_SHA () {"AES256-SHA";}' unless defined(&TLS1_TXT_RSA_WITH_AES_256_SHA);
    eval 'sub TLS1_TXT_DH_DSS_WITH_AES_256_SHA () {"DH-DSS-AES256-SHA";}' unless defined(&TLS1_TXT_DH_DSS_WITH_AES_256_SHA);
    eval 'sub TLS1_TXT_DH_RSA_WITH_AES_256_SHA () {"DH-RSA-AES256-SHA";}' unless defined(&TLS1_TXT_DH_RSA_WITH_AES_256_SHA);
    eval 'sub TLS1_TXT_DHE_DSS_WITH_AES_256_SHA () {"DHE-DSS-AES256-SHA";}' unless defined(&TLS1_TXT_DHE_DSS_WITH_AES_256_SHA);
    eval 'sub TLS1_TXT_DHE_RSA_WITH_AES_256_SHA () {"DHE-RSA-AES256-SHA";}' unless defined(&TLS1_TXT_DHE_RSA_WITH_AES_256_SHA);
    eval 'sub TLS1_TXT_ADH_WITH_AES_256_SHA () {"ADH-AES256-SHA";}' unless defined(&TLS1_TXT_ADH_WITH_AES_256_SHA);
    eval 'sub TLS1_TXT_ECDH_ECDSA_WITH_NULL_SHA () {"ECDH-ECDSA-NULL-SHA";}' unless defined(&TLS1_TXT_ECDH_ECDSA_WITH_NULL_SHA);
    eval 'sub TLS1_TXT_ECDH_ECDSA_WITH_RC4_128_SHA () {"ECDH-ECDSA-RC4-SHA";}' unless defined(&TLS1_TXT_ECDH_ECDSA_WITH_RC4_128_SHA);
    eval 'sub TLS1_TXT_ECDH_ECDSA_WITH_DES_192_CBC3_SHA () {"ECDH-ECDSA-DES-CBC3-SHA";}' unless defined(&TLS1_TXT_ECDH_ECDSA_WITH_DES_192_CBC3_SHA);
    eval 'sub TLS1_TXT_ECDH_ECDSA_WITH_AES_128_CBC_SHA () {"ECDH-ECDSA-AES128-SHA";}' unless defined(&TLS1_TXT_ECDH_ECDSA_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_TXT_ECDH_ECDSA_WITH_AES_256_CBC_SHA () {"ECDH-ECDSA-AES256-SHA";}' unless defined(&TLS1_TXT_ECDH_ECDSA_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_TXT_ECDHE_ECDSA_WITH_NULL_SHA () {"ECDHE-ECDSA-NULL-SHA";}' unless defined(&TLS1_TXT_ECDHE_ECDSA_WITH_NULL_SHA);
    eval 'sub TLS1_TXT_ECDHE_ECDSA_WITH_RC4_128_SHA () {"ECDHE-ECDSA-RC4-SHA";}' unless defined(&TLS1_TXT_ECDHE_ECDSA_WITH_RC4_128_SHA);
    eval 'sub TLS1_TXT_ECDHE_ECDSA_WITH_DES_192_CBC3_SHA () {"ECDHE-ECDSA-DES-CBC3-SHA";}' unless defined(&TLS1_TXT_ECDHE_ECDSA_WITH_DES_192_CBC3_SHA);
    eval 'sub TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_CBC_SHA () {"ECDHE-ECDSA-AES128-SHA";}' unless defined(&TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_CBC_SHA () {"ECDHE-ECDSA-AES256-SHA";}' unless defined(&TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_TXT_ECDH_RSA_WITH_NULL_SHA () {"ECDH-RSA-NULL-SHA";}' unless defined(&TLS1_TXT_ECDH_RSA_WITH_NULL_SHA);
    eval 'sub TLS1_TXT_ECDH_RSA_WITH_RC4_128_SHA () {"ECDH-RSA-RC4-SHA";}' unless defined(&TLS1_TXT_ECDH_RSA_WITH_RC4_128_SHA);
    eval 'sub TLS1_TXT_ECDH_RSA_WITH_DES_192_CBC3_SHA () {"ECDH-RSA-DES-CBC3-SHA";}' unless defined(&TLS1_TXT_ECDH_RSA_WITH_DES_192_CBC3_SHA);
    eval 'sub TLS1_TXT_ECDH_RSA_WITH_AES_128_CBC_SHA () {"ECDH-RSA-AES128-SHA";}' unless defined(&TLS1_TXT_ECDH_RSA_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_TXT_ECDH_RSA_WITH_AES_256_CBC_SHA () {"ECDH-RSA-AES256-SHA";}' unless defined(&TLS1_TXT_ECDH_RSA_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_TXT_ECDHE_RSA_WITH_NULL_SHA () {"ECDHE-RSA-NULL-SHA";}' unless defined(&TLS1_TXT_ECDHE_RSA_WITH_NULL_SHA);
    eval 'sub TLS1_TXT_ECDHE_RSA_WITH_RC4_128_SHA () {"ECDHE-RSA-RC4-SHA";}' unless defined(&TLS1_TXT_ECDHE_RSA_WITH_RC4_128_SHA);
    eval 'sub TLS1_TXT_ECDHE_RSA_WITH_DES_192_CBC3_SHA () {"ECDHE-RSA-DES-CBC3-SHA";}' unless defined(&TLS1_TXT_ECDHE_RSA_WITH_DES_192_CBC3_SHA);
    eval 'sub TLS1_TXT_ECDHE_RSA_WITH_AES_128_CBC_SHA () {"ECDHE-RSA-AES128-SHA";}' unless defined(&TLS1_TXT_ECDHE_RSA_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_TXT_ECDHE_RSA_WITH_AES_256_CBC_SHA () {"ECDHE-RSA-AES256-SHA";}' unless defined(&TLS1_TXT_ECDHE_RSA_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_TXT_ECDH_anon_WITH_NULL_SHA () {"AECDH-NULL-SHA";}' unless defined(&TLS1_TXT_ECDH_anon_WITH_NULL_SHA);
    eval 'sub TLS1_TXT_ECDH_anon_WITH_RC4_128_SHA () {"AECDH-RC4-SHA";}' unless defined(&TLS1_TXT_ECDH_anon_WITH_RC4_128_SHA);
    eval 'sub TLS1_TXT_ECDH_anon_WITH_DES_192_CBC3_SHA () {"AECDH-DES-CBC3-SHA";}' unless defined(&TLS1_TXT_ECDH_anon_WITH_DES_192_CBC3_SHA);
    eval 'sub TLS1_TXT_ECDH_anon_WITH_AES_128_CBC_SHA () {"AECDH-AES128-SHA";}' unless defined(&TLS1_TXT_ECDH_anon_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_TXT_ECDH_anon_WITH_AES_256_CBC_SHA () {"AECDH-AES256-SHA";}' unless defined(&TLS1_TXT_ECDH_anon_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_TXT_PSK_WITH_RC4_128_SHA () {"PSK-RC4-SHA";}' unless defined(&TLS1_TXT_PSK_WITH_RC4_128_SHA);
    eval 'sub TLS1_TXT_PSK_WITH_3DES_EDE_CBC_SHA () {"PSK-3DES-EDE-CBC-SHA";}' unless defined(&TLS1_TXT_PSK_WITH_3DES_EDE_CBC_SHA);
    eval 'sub TLS1_TXT_PSK_WITH_AES_128_CBC_SHA () {"PSK-AES128-CBC-SHA";}' unless defined(&TLS1_TXT_PSK_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_TXT_PSK_WITH_AES_256_CBC_SHA () {"PSK-AES256-CBC-SHA";}' unless defined(&TLS1_TXT_PSK_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_TXT_DHE_PSK_WITH_RC4_128_SHA () {"DHE-PSK-RC4-SHA";}' unless defined(&TLS1_TXT_DHE_PSK_WITH_RC4_128_SHA);
    eval 'sub TLS1_TXT_DHE_PSK_WITH_3DES_EDE_CBC_SHA () {"DHE-PSK-3DES-EDE-CBC-SHA";}' unless defined(&TLS1_TXT_DHE_PSK_WITH_3DES_EDE_CBC_SHA);
    eval 'sub TLS1_TXT_DHE_PSK_WITH_AES_128_CBC_SHA () {"DHE-PSK-AES128-CBC-SHA";}' unless defined(&TLS1_TXT_DHE_PSK_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_TXT_DHE_PSK_WITH_AES_256_CBC_SHA () {"DHE-PSK-AES256-CBC-SHA";}' unless defined(&TLS1_TXT_DHE_PSK_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_TXT_RSA_PSK_WITH_RC4_128_SHA () {"RSA-PSK-RC4-SHA";}' unless defined(&TLS1_TXT_RSA_PSK_WITH_RC4_128_SHA);
    eval 'sub TLS1_TXT_RSA_PSK_WITH_3DES_EDE_CBC_SHA () {"RSA-PSK-3DES-EDE-CBC-SHA";}' unless defined(&TLS1_TXT_RSA_PSK_WITH_3DES_EDE_CBC_SHA);
    eval 'sub TLS1_TXT_RSA_PSK_WITH_AES_128_CBC_SHA () {"RSA-PSK-AES128-CBC-SHA";}' unless defined(&TLS1_TXT_RSA_PSK_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_TXT_RSA_PSK_WITH_AES_256_CBC_SHA () {"RSA-PSK-AES256-CBC-SHA";}' unless defined(&TLS1_TXT_RSA_PSK_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_TXT_PSK_WITH_AES_128_GCM_SHA256 () {"PSK-AES128-GCM-SHA256";}' unless defined(&TLS1_TXT_PSK_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_TXT_PSK_WITH_AES_256_GCM_SHA384 () {"PSK-AES256-GCM-SHA384";}' unless defined(&TLS1_TXT_PSK_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_TXT_DHE_PSK_WITH_AES_128_GCM_SHA256 () {"DHE-PSK-AES128-GCM-SHA256";}' unless defined(&TLS1_TXT_DHE_PSK_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_TXT_DHE_PSK_WITH_AES_256_GCM_SHA384 () {"DHE-PSK-AES256-GCM-SHA384";}' unless defined(&TLS1_TXT_DHE_PSK_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_TXT_RSA_PSK_WITH_AES_128_GCM_SHA256 () {"RSA-PSK-AES128-GCM-SHA256";}' unless defined(&TLS1_TXT_RSA_PSK_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_TXT_RSA_PSK_WITH_AES_256_GCM_SHA384 () {"RSA-PSK-AES256-GCM-SHA384";}' unless defined(&TLS1_TXT_RSA_PSK_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_TXT_PSK_WITH_AES_128_CBC_SHA256 () {"PSK-AES128-CBC-SHA256";}' unless defined(&TLS1_TXT_PSK_WITH_AES_128_CBC_SHA256);
    eval 'sub TLS1_TXT_PSK_WITH_AES_256_CBC_SHA384 () {"PSK-AES256-CBC-SHA384";}' unless defined(&TLS1_TXT_PSK_WITH_AES_256_CBC_SHA384);
    eval 'sub TLS1_TXT_PSK_WITH_NULL_SHA256 () {"PSK-NULL-SHA256";}' unless defined(&TLS1_TXT_PSK_WITH_NULL_SHA256);
    eval 'sub TLS1_TXT_PSK_WITH_NULL_SHA384 () {"PSK-NULL-SHA384";}' unless defined(&TLS1_TXT_PSK_WITH_NULL_SHA384);
    eval 'sub TLS1_TXT_DHE_PSK_WITH_AES_128_CBC_SHA256 () {"DHE-PSK-AES128-CBC-SHA256";}' unless defined(&TLS1_TXT_DHE_PSK_WITH_AES_128_CBC_SHA256);
    eval 'sub TLS1_TXT_DHE_PSK_WITH_AES_256_CBC_SHA384 () {"DHE-PSK-AES256-CBC-SHA384";}' unless defined(&TLS1_TXT_DHE_PSK_WITH_AES_256_CBC_SHA384);
    eval 'sub TLS1_TXT_DHE_PSK_WITH_NULL_SHA256 () {"DHE-PSK-NULL-SHA256";}' unless defined(&TLS1_TXT_DHE_PSK_WITH_NULL_SHA256);
    eval 'sub TLS1_TXT_DHE_PSK_WITH_NULL_SHA384 () {"DHE-PSK-NULL-SHA384";}' unless defined(&TLS1_TXT_DHE_PSK_WITH_NULL_SHA384);
    eval 'sub TLS1_TXT_RSA_PSK_WITH_AES_128_CBC_SHA256 () {"RSA-PSK-AES128-CBC-SHA256";}' unless defined(&TLS1_TXT_RSA_PSK_WITH_AES_128_CBC_SHA256);
    eval 'sub TLS1_TXT_RSA_PSK_WITH_AES_256_CBC_SHA384 () {"RSA-PSK-AES256-CBC-SHA384";}' unless defined(&TLS1_TXT_RSA_PSK_WITH_AES_256_CBC_SHA384);
    eval 'sub TLS1_TXT_RSA_PSK_WITH_NULL_SHA256 () {"RSA-PSK-NULL-SHA256";}' unless defined(&TLS1_TXT_RSA_PSK_WITH_NULL_SHA256);
    eval 'sub TLS1_TXT_RSA_PSK_WITH_NULL_SHA384 () {"RSA-PSK-NULL-SHA384";}' unless defined(&TLS1_TXT_RSA_PSK_WITH_NULL_SHA384);
    eval 'sub TLS1_TXT_SRP_SHA_WITH_3DES_EDE_CBC_SHA () {"SRP-3DES-EDE-CBC-SHA";}' unless defined(&TLS1_TXT_SRP_SHA_WITH_3DES_EDE_CBC_SHA);
    eval 'sub TLS1_TXT_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA () {"SRP-RSA-3DES-EDE-CBC-SHA";}' unless defined(&TLS1_TXT_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA);
    eval 'sub TLS1_TXT_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA () {"SRP-DSS-3DES-EDE-CBC-SHA";}' unless defined(&TLS1_TXT_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA);
    eval 'sub TLS1_TXT_SRP_SHA_WITH_AES_128_CBC_SHA () {"SRP-AES-128-CBC-SHA";}' unless defined(&TLS1_TXT_SRP_SHA_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_TXT_SRP_SHA_RSA_WITH_AES_128_CBC_SHA () {"SRP-RSA-AES-128-CBC-SHA";}' unless defined(&TLS1_TXT_SRP_SHA_RSA_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_TXT_SRP_SHA_DSS_WITH_AES_128_CBC_SHA () {"SRP-DSS-AES-128-CBC-SHA";}' unless defined(&TLS1_TXT_SRP_SHA_DSS_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_TXT_SRP_SHA_WITH_AES_256_CBC_SHA () {"SRP-AES-256-CBC-SHA";}' unless defined(&TLS1_TXT_SRP_SHA_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_TXT_SRP_SHA_RSA_WITH_AES_256_CBC_SHA () {"SRP-RSA-AES-256-CBC-SHA";}' unless defined(&TLS1_TXT_SRP_SHA_RSA_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_TXT_SRP_SHA_DSS_WITH_AES_256_CBC_SHA () {"SRP-DSS-AES-256-CBC-SHA";}' unless defined(&TLS1_TXT_SRP_SHA_DSS_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_TXT_RSA_WITH_CAMELLIA_128_CBC_SHA () {"CAMELLIA128-SHA";}' unless defined(&TLS1_TXT_RSA_WITH_CAMELLIA_128_CBC_SHA);
    eval 'sub TLS1_TXT_DH_DSS_WITH_CAMELLIA_128_CBC_SHA () {"DH-DSS-CAMELLIA128-SHA";}' unless defined(&TLS1_TXT_DH_DSS_WITH_CAMELLIA_128_CBC_SHA);
    eval 'sub TLS1_TXT_DH_RSA_WITH_CAMELLIA_128_CBC_SHA () {"DH-RSA-CAMELLIA128-SHA";}' unless defined(&TLS1_TXT_DH_RSA_WITH_CAMELLIA_128_CBC_SHA);
    eval 'sub TLS1_TXT_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA () {"DHE-DSS-CAMELLIA128-SHA";}' unless defined(&TLS1_TXT_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA);
    eval 'sub TLS1_TXT_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA () {"DHE-RSA-CAMELLIA128-SHA";}' unless defined(&TLS1_TXT_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA);
    eval 'sub TLS1_TXT_ADH_WITH_CAMELLIA_128_CBC_SHA () {"ADH-CAMELLIA128-SHA";}' unless defined(&TLS1_TXT_ADH_WITH_CAMELLIA_128_CBC_SHA);
    eval 'sub TLS1_TXT_RSA_WITH_CAMELLIA_256_CBC_SHA () {"CAMELLIA256-SHA";}' unless defined(&TLS1_TXT_RSA_WITH_CAMELLIA_256_CBC_SHA);
    eval 'sub TLS1_TXT_DH_DSS_WITH_CAMELLIA_256_CBC_SHA () {"DH-DSS-CAMELLIA256-SHA";}' unless defined(&TLS1_TXT_DH_DSS_WITH_CAMELLIA_256_CBC_SHA);
    eval 'sub TLS1_TXT_DH_RSA_WITH_CAMELLIA_256_CBC_SHA () {"DH-RSA-CAMELLIA256-SHA";}' unless defined(&TLS1_TXT_DH_RSA_WITH_CAMELLIA_256_CBC_SHA);
    eval 'sub TLS1_TXT_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA () {"DHE-DSS-CAMELLIA256-SHA";}' unless defined(&TLS1_TXT_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA);
    eval 'sub TLS1_TXT_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA () {"DHE-RSA-CAMELLIA256-SHA";}' unless defined(&TLS1_TXT_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA);
    eval 'sub TLS1_TXT_ADH_WITH_CAMELLIA_256_CBC_SHA () {"ADH-CAMELLIA256-SHA";}' unless defined(&TLS1_TXT_ADH_WITH_CAMELLIA_256_CBC_SHA);
    eval 'sub TLS1_TXT_RSA_WITH_CAMELLIA_128_CBC_SHA256 () {"CAMELLIA128-SHA256";}' unless defined(&TLS1_TXT_RSA_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_TXT_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256 () {"DH-DSS-CAMELLIA128-SHA256";}' unless defined(&TLS1_TXT_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_TXT_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256 () {"DH-RSA-CAMELLIA128-SHA256";}' unless defined(&TLS1_TXT_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_TXT_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256 () {"DHE-DSS-CAMELLIA128-SHA256";}' unless defined(&TLS1_TXT_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_TXT_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 () {"DHE-RSA-CAMELLIA128-SHA256";}' unless defined(&TLS1_TXT_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_TXT_ADH_WITH_CAMELLIA_128_CBC_SHA256 () {"ADH-CAMELLIA128-SHA256";}' unless defined(&TLS1_TXT_ADH_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_TXT_RSA_WITH_CAMELLIA_256_CBC_SHA256 () {"CAMELLIA256-SHA256";}' unless defined(&TLS1_TXT_RSA_WITH_CAMELLIA_256_CBC_SHA256);
    eval 'sub TLS1_TXT_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256 () {"DH-DSS-CAMELLIA256-SHA256";}' unless defined(&TLS1_TXT_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256);
    eval 'sub TLS1_TXT_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256 () {"DH-RSA-CAMELLIA256-SHA256";}' unless defined(&TLS1_TXT_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256);
    eval 'sub TLS1_TXT_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256 () {"DHE-DSS-CAMELLIA256-SHA256";}' unless defined(&TLS1_TXT_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256);
    eval 'sub TLS1_TXT_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256 () {"DHE-RSA-CAMELLIA256-SHA256";}' unless defined(&TLS1_TXT_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256);
    eval 'sub TLS1_TXT_ADH_WITH_CAMELLIA_256_CBC_SHA256 () {"ADH-CAMELLIA256-SHA256";}' unless defined(&TLS1_TXT_ADH_WITH_CAMELLIA_256_CBC_SHA256);
    eval 'sub TLS1_TXT_PSK_WITH_CAMELLIA_128_CBC_SHA256 () {"PSK-CAMELLIA128-SHA256";}' unless defined(&TLS1_TXT_PSK_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_TXT_PSK_WITH_CAMELLIA_256_CBC_SHA384 () {"PSK-CAMELLIA256-SHA384";}' unless defined(&TLS1_TXT_PSK_WITH_CAMELLIA_256_CBC_SHA384);
    eval 'sub TLS1_TXT_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 () {"DHE-PSK-CAMELLIA128-SHA256";}' unless defined(&TLS1_TXT_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_TXT_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 () {"DHE-PSK-CAMELLIA256-SHA384";}' unless defined(&TLS1_TXT_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384);
    eval 'sub TLS1_TXT_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256 () {"RSA-PSK-CAMELLIA128-SHA256";}' unless defined(&TLS1_TXT_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_TXT_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384 () {"RSA-PSK-CAMELLIA256-SHA384";}' unless defined(&TLS1_TXT_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384);
    eval 'sub TLS1_TXT_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 () {"ECDHE-PSK-CAMELLIA128-SHA256";}' unless defined(&TLS1_TXT_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_TXT_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 () {"ECDHE-PSK-CAMELLIA256-SHA384";}' unless defined(&TLS1_TXT_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384);
    eval 'sub TLS1_TXT_RSA_WITH_SEED_SHA () {"SEED-SHA";}' unless defined(&TLS1_TXT_RSA_WITH_SEED_SHA);
    eval 'sub TLS1_TXT_DH_DSS_WITH_SEED_SHA () {"DH-DSS-SEED-SHA";}' unless defined(&TLS1_TXT_DH_DSS_WITH_SEED_SHA);
    eval 'sub TLS1_TXT_DH_RSA_WITH_SEED_SHA () {"DH-RSA-SEED-SHA";}' unless defined(&TLS1_TXT_DH_RSA_WITH_SEED_SHA);
    eval 'sub TLS1_TXT_DHE_DSS_WITH_SEED_SHA () {"DHE-DSS-SEED-SHA";}' unless defined(&TLS1_TXT_DHE_DSS_WITH_SEED_SHA);
    eval 'sub TLS1_TXT_DHE_RSA_WITH_SEED_SHA () {"DHE-RSA-SEED-SHA";}' unless defined(&TLS1_TXT_DHE_RSA_WITH_SEED_SHA);
    eval 'sub TLS1_TXT_ADH_WITH_SEED_SHA () {"ADH-SEED-SHA";}' unless defined(&TLS1_TXT_ADH_WITH_SEED_SHA);
    eval 'sub TLS1_TXT_RSA_WITH_NULL_SHA256 () {"NULL-SHA256";}' unless defined(&TLS1_TXT_RSA_WITH_NULL_SHA256);
    eval 'sub TLS1_TXT_RSA_WITH_AES_128_SHA256 () {"AES128-SHA256";}' unless defined(&TLS1_TXT_RSA_WITH_AES_128_SHA256);
    eval 'sub TLS1_TXT_RSA_WITH_AES_256_SHA256 () {"AES256-SHA256";}' unless defined(&TLS1_TXT_RSA_WITH_AES_256_SHA256);
    eval 'sub TLS1_TXT_DH_DSS_WITH_AES_128_SHA256 () {"DH-DSS-AES128-SHA256";}' unless defined(&TLS1_TXT_DH_DSS_WITH_AES_128_SHA256);
    eval 'sub TLS1_TXT_DH_RSA_WITH_AES_128_SHA256 () {"DH-RSA-AES128-SHA256";}' unless defined(&TLS1_TXT_DH_RSA_WITH_AES_128_SHA256);
    eval 'sub TLS1_TXT_DHE_DSS_WITH_AES_128_SHA256 () {"DHE-DSS-AES128-SHA256";}' unless defined(&TLS1_TXT_DHE_DSS_WITH_AES_128_SHA256);
    eval 'sub TLS1_TXT_DHE_RSA_WITH_AES_128_SHA256 () {"DHE-RSA-AES128-SHA256";}' unless defined(&TLS1_TXT_DHE_RSA_WITH_AES_128_SHA256);
    eval 'sub TLS1_TXT_DH_DSS_WITH_AES_256_SHA256 () {"DH-DSS-AES256-SHA256";}' unless defined(&TLS1_TXT_DH_DSS_WITH_AES_256_SHA256);
    eval 'sub TLS1_TXT_DH_RSA_WITH_AES_256_SHA256 () {"DH-RSA-AES256-SHA256";}' unless defined(&TLS1_TXT_DH_RSA_WITH_AES_256_SHA256);
    eval 'sub TLS1_TXT_DHE_DSS_WITH_AES_256_SHA256 () {"DHE-DSS-AES256-SHA256";}' unless defined(&TLS1_TXT_DHE_DSS_WITH_AES_256_SHA256);
    eval 'sub TLS1_TXT_DHE_RSA_WITH_AES_256_SHA256 () {"DHE-RSA-AES256-SHA256";}' unless defined(&TLS1_TXT_DHE_RSA_WITH_AES_256_SHA256);
    eval 'sub TLS1_TXT_ADH_WITH_AES_128_SHA256 () {"ADH-AES128-SHA256";}' unless defined(&TLS1_TXT_ADH_WITH_AES_128_SHA256);
    eval 'sub TLS1_TXT_ADH_WITH_AES_256_SHA256 () {"ADH-AES256-SHA256";}' unless defined(&TLS1_TXT_ADH_WITH_AES_256_SHA256);
    eval 'sub TLS1_TXT_RSA_WITH_AES_128_GCM_SHA256 () {"AES128-GCM-SHA256";}' unless defined(&TLS1_TXT_RSA_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_TXT_RSA_WITH_AES_256_GCM_SHA384 () {"AES256-GCM-SHA384";}' unless defined(&TLS1_TXT_RSA_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_TXT_DHE_RSA_WITH_AES_128_GCM_SHA256 () {"DHE-RSA-AES128-GCM-SHA256";}' unless defined(&TLS1_TXT_DHE_RSA_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_TXT_DHE_RSA_WITH_AES_256_GCM_SHA384 () {"DHE-RSA-AES256-GCM-SHA384";}' unless defined(&TLS1_TXT_DHE_RSA_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_TXT_DH_RSA_WITH_AES_128_GCM_SHA256 () {"DH-RSA-AES128-GCM-SHA256";}' unless defined(&TLS1_TXT_DH_RSA_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_TXT_DH_RSA_WITH_AES_256_GCM_SHA384 () {"DH-RSA-AES256-GCM-SHA384";}' unless defined(&TLS1_TXT_DH_RSA_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_TXT_DHE_DSS_WITH_AES_128_GCM_SHA256 () {"DHE-DSS-AES128-GCM-SHA256";}' unless defined(&TLS1_TXT_DHE_DSS_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_TXT_DHE_DSS_WITH_AES_256_GCM_SHA384 () {"DHE-DSS-AES256-GCM-SHA384";}' unless defined(&TLS1_TXT_DHE_DSS_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_TXT_DH_DSS_WITH_AES_128_GCM_SHA256 () {"DH-DSS-AES128-GCM-SHA256";}' unless defined(&TLS1_TXT_DH_DSS_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_TXT_DH_DSS_WITH_AES_256_GCM_SHA384 () {"DH-DSS-AES256-GCM-SHA384";}' unless defined(&TLS1_TXT_DH_DSS_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_TXT_ADH_WITH_AES_128_GCM_SHA256 () {"ADH-AES128-GCM-SHA256";}' unless defined(&TLS1_TXT_ADH_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_TXT_ADH_WITH_AES_256_GCM_SHA384 () {"ADH-AES256-GCM-SHA384";}' unless defined(&TLS1_TXT_ADH_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_TXT_RSA_WITH_AES_128_CCM () {"AES128-CCM";}' unless defined(&TLS1_TXT_RSA_WITH_AES_128_CCM);
    eval 'sub TLS1_TXT_RSA_WITH_AES_256_CCM () {"AES256-CCM";}' unless defined(&TLS1_TXT_RSA_WITH_AES_256_CCM);
    eval 'sub TLS1_TXT_DHE_RSA_WITH_AES_128_CCM () {"DHE-RSA-AES128-CCM";}' unless defined(&TLS1_TXT_DHE_RSA_WITH_AES_128_CCM);
    eval 'sub TLS1_TXT_DHE_RSA_WITH_AES_256_CCM () {"DHE-RSA-AES256-CCM";}' unless defined(&TLS1_TXT_DHE_RSA_WITH_AES_256_CCM);
    eval 'sub TLS1_TXT_RSA_WITH_AES_128_CCM_8 () {"AES128-CCM8";}' unless defined(&TLS1_TXT_RSA_WITH_AES_128_CCM_8);
    eval 'sub TLS1_TXT_RSA_WITH_AES_256_CCM_8 () {"AES256-CCM8";}' unless defined(&TLS1_TXT_RSA_WITH_AES_256_CCM_8);
    eval 'sub TLS1_TXT_DHE_RSA_WITH_AES_128_CCM_8 () {"DHE-RSA-AES128-CCM8";}' unless defined(&TLS1_TXT_DHE_RSA_WITH_AES_128_CCM_8);
    eval 'sub TLS1_TXT_DHE_RSA_WITH_AES_256_CCM_8 () {"DHE-RSA-AES256-CCM8";}' unless defined(&TLS1_TXT_DHE_RSA_WITH_AES_256_CCM_8);
    eval 'sub TLS1_TXT_PSK_WITH_AES_128_CCM () {"PSK-AES128-CCM";}' unless defined(&TLS1_TXT_PSK_WITH_AES_128_CCM);
    eval 'sub TLS1_TXT_PSK_WITH_AES_256_CCM () {"PSK-AES256-CCM";}' unless defined(&TLS1_TXT_PSK_WITH_AES_256_CCM);
    eval 'sub TLS1_TXT_DHE_PSK_WITH_AES_128_CCM () {"DHE-PSK-AES128-CCM";}' unless defined(&TLS1_TXT_DHE_PSK_WITH_AES_128_CCM);
    eval 'sub TLS1_TXT_DHE_PSK_WITH_AES_256_CCM () {"DHE-PSK-AES256-CCM";}' unless defined(&TLS1_TXT_DHE_PSK_WITH_AES_256_CCM);
    eval 'sub TLS1_TXT_PSK_WITH_AES_128_CCM_8 () {"PSK-AES128-CCM8";}' unless defined(&TLS1_TXT_PSK_WITH_AES_128_CCM_8);
    eval 'sub TLS1_TXT_PSK_WITH_AES_256_CCM_8 () {"PSK-AES256-CCM8";}' unless defined(&TLS1_TXT_PSK_WITH_AES_256_CCM_8);
    eval 'sub TLS1_TXT_DHE_PSK_WITH_AES_128_CCM_8 () {"DHE-PSK-AES128-CCM8";}' unless defined(&TLS1_TXT_DHE_PSK_WITH_AES_128_CCM_8);
    eval 'sub TLS1_TXT_DHE_PSK_WITH_AES_256_CCM_8 () {"DHE-PSK-AES256-CCM8";}' unless defined(&TLS1_TXT_DHE_PSK_WITH_AES_256_CCM_8);
    eval 'sub TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_CCM () {"ECDHE-ECDSA-AES128-CCM";}' unless defined(&TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_CCM);
    eval 'sub TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_CCM () {"ECDHE-ECDSA-AES256-CCM";}' unless defined(&TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_CCM);
    eval 'sub TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_CCM_8 () {"ECDHE-ECDSA-AES128-CCM8";}' unless defined(&TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_CCM_8);
    eval 'sub TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_CCM_8 () {"ECDHE-ECDSA-AES256-CCM8";}' unless defined(&TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_CCM_8);
    eval 'sub TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_SHA256 () {"ECDHE-ECDSA-AES128-SHA256";}' unless defined(&TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_SHA256);
    eval 'sub TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_SHA384 () {"ECDHE-ECDSA-AES256-SHA384";}' unless defined(&TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_SHA384);
    eval 'sub TLS1_TXT_ECDH_ECDSA_WITH_AES_128_SHA256 () {"ECDH-ECDSA-AES128-SHA256";}' unless defined(&TLS1_TXT_ECDH_ECDSA_WITH_AES_128_SHA256);
    eval 'sub TLS1_TXT_ECDH_ECDSA_WITH_AES_256_SHA384 () {"ECDH-ECDSA-AES256-SHA384";}' unless defined(&TLS1_TXT_ECDH_ECDSA_WITH_AES_256_SHA384);
    eval 'sub TLS1_TXT_ECDHE_RSA_WITH_AES_128_SHA256 () {"ECDHE-RSA-AES128-SHA256";}' unless defined(&TLS1_TXT_ECDHE_RSA_WITH_AES_128_SHA256);
    eval 'sub TLS1_TXT_ECDHE_RSA_WITH_AES_256_SHA384 () {"ECDHE-RSA-AES256-SHA384";}' unless defined(&TLS1_TXT_ECDHE_RSA_WITH_AES_256_SHA384);
    eval 'sub TLS1_TXT_ECDH_RSA_WITH_AES_128_SHA256 () {"ECDH-RSA-AES128-SHA256";}' unless defined(&TLS1_TXT_ECDH_RSA_WITH_AES_128_SHA256);
    eval 'sub TLS1_TXT_ECDH_RSA_WITH_AES_256_SHA384 () {"ECDH-RSA-AES256-SHA384";}' unless defined(&TLS1_TXT_ECDH_RSA_WITH_AES_256_SHA384);
    eval 'sub TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256 () {"ECDHE-ECDSA-AES128-GCM-SHA256";}' unless defined(&TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384 () {"ECDHE-ECDSA-AES256-GCM-SHA384";}' unless defined(&TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_TXT_ECDH_ECDSA_WITH_AES_128_GCM_SHA256 () {"ECDH-ECDSA-AES128-GCM-SHA256";}' unless defined(&TLS1_TXT_ECDH_ECDSA_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_TXT_ECDH_ECDSA_WITH_AES_256_GCM_SHA384 () {"ECDH-ECDSA-AES256-GCM-SHA384";}' unless defined(&TLS1_TXT_ECDH_ECDSA_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_TXT_ECDHE_RSA_WITH_AES_128_GCM_SHA256 () {"ECDHE-RSA-AES128-GCM-SHA256";}' unless defined(&TLS1_TXT_ECDHE_RSA_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_TXT_ECDHE_RSA_WITH_AES_256_GCM_SHA384 () {"ECDHE-RSA-AES256-GCM-SHA384";}' unless defined(&TLS1_TXT_ECDHE_RSA_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_TXT_ECDH_RSA_WITH_AES_128_GCM_SHA256 () {"ECDH-RSA-AES128-GCM-SHA256";}' unless defined(&TLS1_TXT_ECDH_RSA_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_TXT_ECDH_RSA_WITH_AES_256_GCM_SHA384 () {"ECDH-RSA-AES256-GCM-SHA384";}' unless defined(&TLS1_TXT_ECDH_RSA_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_TXT_PSK_WITH_AES_128_GCM_SHA256 () {"PSK-AES128-GCM-SHA256";}' unless defined(&TLS1_TXT_PSK_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_TXT_PSK_WITH_AES_256_GCM_SHA384 () {"PSK-AES256-GCM-SHA384";}' unless defined(&TLS1_TXT_PSK_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_TXT_ECDHE_PSK_WITH_RC4_128_SHA () {"ECDHE-PSK-RC4-SHA";}' unless defined(&TLS1_TXT_ECDHE_PSK_WITH_RC4_128_SHA);
    eval 'sub TLS1_TXT_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA () {"ECDHE-PSK-3DES-EDE-CBC-SHA";}' unless defined(&TLS1_TXT_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA);
    eval 'sub TLS1_TXT_ECDHE_PSK_WITH_AES_128_CBC_SHA () {"ECDHE-PSK-AES128-CBC-SHA";}' unless defined(&TLS1_TXT_ECDHE_PSK_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_TXT_ECDHE_PSK_WITH_AES_256_CBC_SHA () {"ECDHE-PSK-AES256-CBC-SHA";}' unless defined(&TLS1_TXT_ECDHE_PSK_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_TXT_ECDHE_PSK_WITH_AES_128_CBC_SHA256 () {"ECDHE-PSK-AES128-CBC-SHA256";}' unless defined(&TLS1_TXT_ECDHE_PSK_WITH_AES_128_CBC_SHA256);
    eval 'sub TLS1_TXT_ECDHE_PSK_WITH_AES_256_CBC_SHA384 () {"ECDHE-PSK-AES256-CBC-SHA384";}' unless defined(&TLS1_TXT_ECDHE_PSK_WITH_AES_256_CBC_SHA384);
    eval 'sub TLS1_TXT_ECDHE_PSK_WITH_NULL_SHA () {"ECDHE-PSK-NULL-SHA";}' unless defined(&TLS1_TXT_ECDHE_PSK_WITH_NULL_SHA);
    eval 'sub TLS1_TXT_ECDHE_PSK_WITH_NULL_SHA256 () {"ECDHE-PSK-NULL-SHA256";}' unless defined(&TLS1_TXT_ECDHE_PSK_WITH_NULL_SHA256);
    eval 'sub TLS1_TXT_ECDHE_PSK_WITH_NULL_SHA384 () {"ECDHE-PSK-NULL-SHA384";}' unless defined(&TLS1_TXT_ECDHE_PSK_WITH_NULL_SHA384);
    eval 'sub TLS1_TXT_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256 () {"ECDHE-ECDSA-CAMELLIA128-SHA256";}' unless defined(&TLS1_TXT_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_TXT_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384 () {"ECDHE-ECDSA-CAMELLIA256-SHA384";}' unless defined(&TLS1_TXT_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384);
    eval 'sub TLS1_TXT_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256 () {"ECDH-ECDSA-CAMELLIA128-SHA256";}' unless defined(&TLS1_TXT_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_TXT_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384 () {"ECDH-ECDSA-CAMELLIA256-SHA384";}' unless defined(&TLS1_TXT_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384);
    eval 'sub TLS1_TXT_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 () {"ECDHE-RSA-CAMELLIA128-SHA256";}' unless defined(&TLS1_TXT_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_TXT_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384 () {"ECDHE-RSA-CAMELLIA256-SHA384";}' unless defined(&TLS1_TXT_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384);
    eval 'sub TLS1_TXT_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256 () {"ECDH-RSA-CAMELLIA128-SHA256";}' unless defined(&TLS1_TXT_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256);
    eval 'sub TLS1_TXT_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384 () {"ECDH-RSA-CAMELLIA256-SHA384";}' unless defined(&TLS1_TXT_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384);
    eval 'sub TLS1_TXT_ECDHE_RSA_WITH_CHACHA20_POLY1305 () {"ECDHE-RSA-CHACHA20-POLY1305";}' unless defined(&TLS1_TXT_ECDHE_RSA_WITH_CHACHA20_POLY1305);
    eval 'sub TLS1_TXT_ECDHE_ECDSA_WITH_CHACHA20_POLY1305 () {"ECDHE-ECDSA-CHACHA20-POLY1305";}' unless defined(&TLS1_TXT_ECDHE_ECDSA_WITH_CHACHA20_POLY1305);
    eval 'sub TLS1_TXT_DHE_RSA_WITH_CHACHA20_POLY1305 () {"DHE-RSA-CHACHA20-POLY1305";}' unless defined(&TLS1_TXT_DHE_RSA_WITH_CHACHA20_POLY1305);
    eval 'sub TLS1_TXT_PSK_WITH_CHACHA20_POLY1305 () {"PSK-CHACHA20-POLY1305";}' unless defined(&TLS1_TXT_PSK_WITH_CHACHA20_POLY1305);
    eval 'sub TLS1_TXT_ECDHE_PSK_WITH_CHACHA20_POLY1305 () {"ECDHE-PSK-CHACHA20-POLY1305";}' unless defined(&TLS1_TXT_ECDHE_PSK_WITH_CHACHA20_POLY1305);
    eval 'sub TLS1_TXT_DHE_PSK_WITH_CHACHA20_POLY1305 () {"DHE-PSK-CHACHA20-POLY1305";}' unless defined(&TLS1_TXT_DHE_PSK_WITH_CHACHA20_POLY1305);
    eval 'sub TLS1_TXT_RSA_PSK_WITH_CHACHA20_POLY1305 () {"RSA-PSK-CHACHA20-POLY1305";}' unless defined(&TLS1_TXT_RSA_PSK_WITH_CHACHA20_POLY1305);
    eval 'sub TLS1_TXT_RSA_WITH_ARIA_128_GCM_SHA256 () {"ARIA128-GCM-SHA256";}' unless defined(&TLS1_TXT_RSA_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_TXT_RSA_WITH_ARIA_256_GCM_SHA384 () {"ARIA256-GCM-SHA384";}' unless defined(&TLS1_TXT_RSA_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_TXT_DHE_RSA_WITH_ARIA_128_GCM_SHA256 () {"DHE-RSA-ARIA128-GCM-SHA256";}' unless defined(&TLS1_TXT_DHE_RSA_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_TXT_DHE_RSA_WITH_ARIA_256_GCM_SHA384 () {"DHE-RSA-ARIA256-GCM-SHA384";}' unless defined(&TLS1_TXT_DHE_RSA_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_TXT_DH_RSA_WITH_ARIA_128_GCM_SHA256 () {"DH-RSA-ARIA128-GCM-SHA256";}' unless defined(&TLS1_TXT_DH_RSA_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_TXT_DH_RSA_WITH_ARIA_256_GCM_SHA384 () {"DH-RSA-ARIA256-GCM-SHA384";}' unless defined(&TLS1_TXT_DH_RSA_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_TXT_DHE_DSS_WITH_ARIA_128_GCM_SHA256 () {"DHE-DSS-ARIA128-GCM-SHA256";}' unless defined(&TLS1_TXT_DHE_DSS_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_TXT_DHE_DSS_WITH_ARIA_256_GCM_SHA384 () {"DHE-DSS-ARIA256-GCM-SHA384";}' unless defined(&TLS1_TXT_DHE_DSS_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_TXT_DH_DSS_WITH_ARIA_128_GCM_SHA256 () {"DH-DSS-ARIA128-GCM-SHA256";}' unless defined(&TLS1_TXT_DH_DSS_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_TXT_DH_DSS_WITH_ARIA_256_GCM_SHA384 () {"DH-DSS-ARIA256-GCM-SHA384";}' unless defined(&TLS1_TXT_DH_DSS_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_TXT_DH_anon_WITH_ARIA_128_GCM_SHA256 () {"ADH-ARIA128-GCM-SHA256";}' unless defined(&TLS1_TXT_DH_anon_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_TXT_DH_anon_WITH_ARIA_256_GCM_SHA384 () {"ADH-ARIA256-GCM-SHA384";}' unless defined(&TLS1_TXT_DH_anon_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_TXT_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256 () {"ECDHE-ECDSA-ARIA128-GCM-SHA256";}' unless defined(&TLS1_TXT_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_TXT_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384 () {"ECDHE-ECDSA-ARIA256-GCM-SHA384";}' unless defined(&TLS1_TXT_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_TXT_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256 () {"ECDH-ECDSA-ARIA128-GCM-SHA256";}' unless defined(&TLS1_TXT_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_TXT_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384 () {"ECDH-ECDSA-ARIA256-GCM-SHA384";}' unless defined(&TLS1_TXT_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_TXT_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256 () {"ECDHE-ARIA128-GCM-SHA256";}' unless defined(&TLS1_TXT_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_TXT_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384 () {"ECDHE-ARIA256-GCM-SHA384";}' unless defined(&TLS1_TXT_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_TXT_ECDH_RSA_WITH_ARIA_128_GCM_SHA256 () {"ECDH-ARIA128-GCM-SHA256";}' unless defined(&TLS1_TXT_ECDH_RSA_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_TXT_ECDH_RSA_WITH_ARIA_256_GCM_SHA384 () {"ECDH-ARIA256-GCM-SHA384";}' unless defined(&TLS1_TXT_ECDH_RSA_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_TXT_PSK_WITH_ARIA_128_GCM_SHA256 () {"PSK-ARIA128-GCM-SHA256";}' unless defined(&TLS1_TXT_PSK_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_TXT_PSK_WITH_ARIA_256_GCM_SHA384 () {"PSK-ARIA256-GCM-SHA384";}' unless defined(&TLS1_TXT_PSK_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_TXT_DHE_PSK_WITH_ARIA_128_GCM_SHA256 () {"DHE-PSK-ARIA128-GCM-SHA256";}' unless defined(&TLS1_TXT_DHE_PSK_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_TXT_DHE_PSK_WITH_ARIA_256_GCM_SHA384 () {"DHE-PSK-ARIA256-GCM-SHA384";}' unless defined(&TLS1_TXT_DHE_PSK_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS1_TXT_RSA_PSK_WITH_ARIA_128_GCM_SHA256 () {"RSA-PSK-ARIA128-GCM-SHA256";}' unless defined(&TLS1_TXT_RSA_PSK_WITH_ARIA_128_GCM_SHA256);
    eval 'sub TLS1_TXT_RSA_PSK_WITH_ARIA_256_GCM_SHA384 () {"RSA-PSK-ARIA256-GCM-SHA384";}' unless defined(&TLS1_TXT_RSA_PSK_WITH_ARIA_256_GCM_SHA384);
    eval 'sub TLS_CT_RSA_SIGN () {1;}' unless defined(&TLS_CT_RSA_SIGN);
    eval 'sub TLS_CT_DSS_SIGN () {2;}' unless defined(&TLS_CT_DSS_SIGN);
    eval 'sub TLS_CT_RSA_FIXED_DH () {3;}' unless defined(&TLS_CT_RSA_FIXED_DH);
    eval 'sub TLS_CT_DSS_FIXED_DH () {4;}' unless defined(&TLS_CT_DSS_FIXED_DH);
    eval 'sub TLS_CT_ECDSA_SIGN () {64;}' unless defined(&TLS_CT_ECDSA_SIGN);
    eval 'sub TLS_CT_RSA_FIXED_ECDH () {65;}' unless defined(&TLS_CT_RSA_FIXED_ECDH);
    eval 'sub TLS_CT_ECDSA_FIXED_ECDH () {66;}' unless defined(&TLS_CT_ECDSA_FIXED_ECDH);
    eval 'sub TLS_CT_GOST01_SIGN () {22;}' unless defined(&TLS_CT_GOST01_SIGN);
    eval 'sub TLS_CT_GOST12_IANA_SIGN () {67;}' unless defined(&TLS_CT_GOST12_IANA_SIGN);
    eval 'sub TLS_CT_GOST12_IANA_512_SIGN () {68;}' unless defined(&TLS_CT_GOST12_IANA_512_SIGN);
    eval 'sub TLS_CT_GOST12_LEGACY_SIGN () {238;}' unless defined(&TLS_CT_GOST12_LEGACY_SIGN);
    eval 'sub TLS_CT_GOST12_LEGACY_512_SIGN () {239;}' unless defined(&TLS_CT_GOST12_LEGACY_512_SIGN);
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	eval 'sub TLS_CT_GOST12_SIGN () { &TLS_CT_GOST12_LEGACY_SIGN;}' unless defined(&TLS_CT_GOST12_SIGN);
	eval 'sub TLS_CT_GOST12_512_SIGN () { &TLS_CT_GOST12_LEGACY_512_SIGN;}' unless defined(&TLS_CT_GOST12_512_SIGN);
    }
    eval 'sub TLS_CT_NUMBER () {12;}' unless defined(&TLS_CT_NUMBER);
    if(defined(&SSL3_CT_NUMBER)) {
	if((defined(&TLS_CT_NUMBER) ? &TLS_CT_NUMBER : undef) != (defined(&SSL3_CT_NUMBER) ? &SSL3_CT_NUMBER : undef)) {
	    die("SSL/TLS CT_NUMBER values do not match");
	}
    }
    eval 'sub TLS1_FINISH_MAC_LENGTH () {12;}' unless defined(&TLS1_FINISH_MAC_LENGTH);
    eval 'sub TLS_MD_MAX_CONST_SIZE () {22;}' unless defined(&TLS_MD_MAX_CONST_SIZE);
    eval 'sub TLS_MD_CLIENT_FINISH_CONST () {"\\x63\\x6c\\x69\\x65\\x6e\\x74\\x20\\x66\\x69\\x6e\\x69\\x73\\x68\\x65\\x64";}' unless defined(&TLS_MD_CLIENT_FINISH_CONST);
    eval 'sub TLS_MD_CLIENT_FINISH_CONST_SIZE () {15;}' unless defined(&TLS_MD_CLIENT_FINISH_CONST_SIZE);
    eval 'sub TLS_MD_SERVER_FINISH_CONST () {"\\x73\\x65\\x72\\x76\\x65\\x72\\x20\\x66\\x69\\x6e\\x69\\x73\\x68\\x65\\x64";}' unless defined(&TLS_MD_SERVER_FINISH_CONST);
    eval 'sub TLS_MD_SERVER_FINISH_CONST_SIZE () {15;}' unless defined(&TLS_MD_SERVER_FINISH_CONST_SIZE);
    eval 'sub TLS_MD_SERVER_WRITE_KEY_CONST () {"\\x73\\x65\\x72\\x76\\x65\\x72\\x20\\x77\\x72\\x69\\x74\\x65\\x20\\x6b\\x65\\x79";}' unless defined(&TLS_MD_SERVER_WRITE_KEY_CONST);
    eval 'sub TLS_MD_SERVER_WRITE_KEY_CONST_SIZE () {16;}' unless defined(&TLS_MD_SERVER_WRITE_KEY_CONST_SIZE);
    eval 'sub TLS_MD_KEY_EXPANSION_CONST () {"\\x6b\\x65\\x79\\x20\\x65\\x78\\x70\\x61\\x6e\\x73\\x69\\x6f\\x6e";}' unless defined(&TLS_MD_KEY_EXPANSION_CONST);
    eval 'sub TLS_MD_KEY_EXPANSION_CONST_SIZE () {13;}' unless defined(&TLS_MD_KEY_EXPANSION_CONST_SIZE);
    eval 'sub TLS_MD_CLIENT_WRITE_KEY_CONST () {"\\x63\\x6c\\x69\\x65\\x6e\\x74\\x20\\x77\\x72\\x69\\x74\\x65\\x20\\x6b\\x65\\x79";}' unless defined(&TLS_MD_CLIENT_WRITE_KEY_CONST);
    eval 'sub TLS_MD_CLIENT_WRITE_KEY_CONST_SIZE () {16;}' unless defined(&TLS_MD_CLIENT_WRITE_KEY_CONST_SIZE);
    eval 'sub TLS_MD_SERVER_WRITE_KEY_CONST () {"\\x73\\x65\\x72\\x76\\x65\\x72\\x20\\x77\\x72\\x69\\x74\\x65\\x20\\x6b\\x65\\x79";}' unless defined(&TLS_MD_SERVER_WRITE_KEY_CONST);
    eval 'sub TLS_MD_SERVER_WRITE_KEY_CONST_SIZE () {16;}' unless defined(&TLS_MD_SERVER_WRITE_KEY_CONST_SIZE);
    eval 'sub TLS_MD_IV_BLOCK_CONST () {"\\x49\\x56\\x20\\x62\\x6c\\x6f\\x63\\x6b";}' unless defined(&TLS_MD_IV_BLOCK_CONST);
    eval 'sub TLS_MD_IV_BLOCK_CONST_SIZE () {8;}' unless defined(&TLS_MD_IV_BLOCK_CONST_SIZE);
    eval 'sub TLS_MD_MASTER_SECRET_CONST () {"\\x6d\\x61\\x73\\x74\\x65\\x72\\x20\\x73\\x65\\x63\\x72\\x65\\x74";}' unless defined(&TLS_MD_MASTER_SECRET_CONST);
    eval 'sub TLS_MD_MASTER_SECRET_CONST_SIZE () {13;}' unless defined(&TLS_MD_MASTER_SECRET_CONST_SIZE);
    eval 'sub TLS_MD_EXTENDED_MASTER_SECRET_CONST () {"\\x65\\x78\\x74\\x65\\x6e\\x64\\x65\\x64\\x20\\x6d\\x61\\x73\\x74\\x65\\x72\\x20\\x73\\x65\\x63\\x72\\x65\\x74";}' unless defined(&TLS_MD_EXTENDED_MASTER_SECRET_CONST);
    eval 'sub TLS_MD_EXTENDED_MASTER_SECRET_CONST_SIZE () {22;}' unless defined(&TLS_MD_EXTENDED_MASTER_SECRET_CONST_SIZE);
    if(defined(&__cplusplus)) {
    }
}
1;
