require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_SYSCTL_H_)) {
    eval 'sub _SYS_SYSCTL_H_ () {1;}' unless defined(&_SYS_SYSCTL_H_);
    require 'sys/param.ph';
    require 'sys/proc.ph';
    require 'uvm/uvm_param.ph';
    if(defined(&_KERNEL) || defined(&_KMEMUSER)) {
	require 'sys/time.ph';
	require 'sys/ucred.ph';
	require 'sys/ucontext.ph';
	require 'sys/mallocvar.ph';
	require 'uvm/uvm_extern.ph';
    }
    if(defined(&_KERNEL) || defined(&_STANDALONE)) {
	require 'sys/systm.ph';
    } else {
	require 'stddef.ph';
	require 'stdbool.ph';
    }
    eval 'sub CTL_MAXNAME () {12;}' unless defined(&CTL_MAXNAME);
    eval 'sub SYSCTL_NAMELEN () {32;}' unless defined(&SYSCTL_NAMELEN);
    eval 'sub CREATE_BASE () {(1024);}' unless defined(&CREATE_BASE);
    eval 'sub SYSCTL_DEFSIZE () {8;}' unless defined(&SYSCTL_DEFSIZE);
    eval 'sub CTLTYPE_NODE () {1;}' unless defined(&CTLTYPE_NODE);
    eval 'sub CTLTYPE_INT () {2;}' unless defined(&CTLTYPE_INT);
    eval 'sub CTLTYPE_STRING () {3;}' unless defined(&CTLTYPE_STRING);
    eval 'sub CTLTYPE_QUAD () {4;}' unless defined(&CTLTYPE_QUAD);
    eval 'sub CTLTYPE_STRUCT () {5;}' unless defined(&CTLTYPE_STRUCT);
    eval 'sub CTLTYPE_BOOL () {6;}' unless defined(&CTLTYPE_BOOL);
    if(defined(&_LP64)) {
	eval 'sub CTLTYPE_LONG () { &CTLTYPE_QUAD;}' unless defined(&CTLTYPE_LONG);
    } else {
	eval 'sub CTLTYPE_LONG () { &CTLTYPE_INT;}' unless defined(&CTLTYPE_LONG);
    }
    eval 'sub CTLFLAG_READONLY () {0x;}' unless defined(&CTLFLAG_READONLY);
    eval 'sub CTLFLAG_READWRITE () {0x70;}' unless defined(&CTLFLAG_READWRITE);
    eval 'sub CTLFLAG_ANYWRITE () {0x80;}' unless defined(&CTLFLAG_ANYWRITE);
    eval 'sub CTLFLAG_PRIVATE () {0x100;}' unless defined(&CTLFLAG_PRIVATE);
    eval 'sub CTLFLAG_PERMANENT () {0x200;}' unless defined(&CTLFLAG_PERMANENT);
    eval 'sub CTLFLAG_OWNDATA () {0x400;}' unless defined(&CTLFLAG_OWNDATA);
    eval 'sub CTLFLAG_IMMEDIATE () {0x800;}' unless defined(&CTLFLAG_IMMEDIATE);
    eval 'sub CTLFLAG_HEX () {0x1000;}' unless defined(&CTLFLAG_HEX);
    eval 'sub CTLFLAG_ROOT () {0x2000;}' unless defined(&CTLFLAG_ROOT);
    eval 'sub CTLFLAG_ANYNUMBER () {0x4000;}' unless defined(&CTLFLAG_ANYNUMBER);
    eval 'sub CTLFLAG_HIDDEN () {0x8000;}' unless defined(&CTLFLAG_HIDDEN);
    eval 'sub CTLFLAG_ALIAS () {0x10000;}' unless defined(&CTLFLAG_ALIAS);
    eval 'sub CTLFLAG_MMAP () {0x20000;}' unless defined(&CTLFLAG_MMAP);
    eval 'sub CTLFLAG_OWNDESC () {0x40000;}' unless defined(&CTLFLAG_OWNDESC);
    eval 'sub CTLFLAG_UNSIGNED () {0x80000;}' unless defined(&CTLFLAG_UNSIGNED);
    eval 'sub SYSCTL_VERS_MASK () {0xff000000;}' unless defined(&SYSCTL_VERS_MASK);
    eval 'sub SYSCTL_VERS_0 () {0x;}' unless defined(&SYSCTL_VERS_0);
    eval 'sub SYSCTL_VERS_1 () {0x1000000;}' unless defined(&SYSCTL_VERS_1);
    eval 'sub SYSCTL_VERSION () { &SYSCTL_VERS_1;}' unless defined(&SYSCTL_VERSION);
    eval 'sub SYSCTL_VERS {
        my($f) = @_;
	    eval q((($f) &  &SYSCTL_VERS_MASK));
    }' unless defined(&SYSCTL_VERS);
    eval 'sub SYSCTL_USERFLAGS () {( &CTLFLAG_READWRITE|  &CTLFLAG_ANYWRITE|  &CTLFLAG_PRIVATE|  &CTLFLAG_OWNDATA|  &CTLFLAG_IMMEDIATE|  &CTLFLAG_HEX|  &CTLFLAG_HIDDEN);}' unless defined(&SYSCTL_USERFLAGS);
    eval 'sub SYSCTL_TYPEMASK () {0xf;}' unless defined(&SYSCTL_TYPEMASK);
    eval 'sub SYSCTL_TYPE {
        my($x) = @_;
	    eval q((($x) &  &SYSCTL_TYPEMASK));
    }' unless defined(&SYSCTL_TYPE);
    eval 'sub SYSCTL_FLAGMASK () {0xfffff0;}' unless defined(&SYSCTL_FLAGMASK);
    eval 'sub SYSCTL_FLAGS {
        my($x) = @_;
	    eval q((($x) &  &SYSCTL_FLAGMASK));
    }' unless defined(&SYSCTL_FLAGS);
    eval 'sub CTL_EOL () {(-1);}' unless defined(&CTL_EOL);
    eval 'sub CTL_QUERY () {(-2);}' unless defined(&CTL_QUERY);
    eval 'sub CTL_CREATE () {(-3);}' unless defined(&CTL_CREATE);
    eval 'sub CTL_CREATESYM () {(-4);}' unless defined(&CTL_CREATESYM);
    eval 'sub CTL_DESTROY () {(-5);}' unless defined(&CTL_DESTROY);
    eval 'sub CTL_MMAP () {(-6);}' unless defined(&CTL_MMAP);
    eval 'sub CTL_DESCRIBE () {(-7);}' unless defined(&CTL_DESCRIBE);
    eval 'sub CTL_UNSPEC () {0;}' unless defined(&CTL_UNSPEC);
    eval 'sub CTL_KERN () {1;}' unless defined(&CTL_KERN);
    eval 'sub CTL_VM () {2;}' unless defined(&CTL_VM);
    eval 'sub CTL_VFS () {3;}' unless defined(&CTL_VFS);
    eval 'sub CTL_NET () {4;}' unless defined(&CTL_NET);
    eval 'sub CTL_DEBUG () {5;}' unless defined(&CTL_DEBUG);
    eval 'sub CTL_HW () {6;}' unless defined(&CTL_HW);
    eval 'sub CTL_MACHDEP () {7;}' unless defined(&CTL_MACHDEP);
    eval 'sub CTL_USER () {8;}' unless defined(&CTL_USER);
    eval 'sub CTL_DDB () {9;}' unless defined(&CTL_DDB);
    eval 'sub CTL_PROC () {10;}' unless defined(&CTL_PROC);
    eval 'sub CTL_VENDOR () {11;}' unless defined(&CTL_VENDOR);
    eval 'sub CTL_EMUL () {12;}' unless defined(&CTL_EMUL);
    eval 'sub CTL_SECURITY () {13;}' unless defined(&CTL_SECURITY);
    eval 'sub KERN_OSTYPE () {1;}' unless defined(&KERN_OSTYPE);
    eval 'sub KERN_OSRELEASE () {2;}' unless defined(&KERN_OSRELEASE);
    eval 'sub KERN_OSREV () {3;}' unless defined(&KERN_OSREV);
    eval 'sub KERN_VERSION () {4;}' unless defined(&KERN_VERSION);
    eval 'sub KERN_MAXVNODES () {5;}' unless defined(&KERN_MAXVNODES);
    eval 'sub KERN_MAXPROC () {6;}' unless defined(&KERN_MAXPROC);
    eval 'sub KERN_MAXFILES () {7;}' unless defined(&KERN_MAXFILES);
    eval 'sub KERN_ARGMAX () {8;}' unless defined(&KERN_ARGMAX);
    eval 'sub KERN_SECURELVL () {9;}' unless defined(&KERN_SECURELVL);
    eval 'sub KERN_HOSTNAME () {10;}' unless defined(&KERN_HOSTNAME);
    eval 'sub KERN_HOSTID () {11;}' unless defined(&KERN_HOSTID);
    eval 'sub KERN_CLOCKRATE () {12;}' unless defined(&KERN_CLOCKRATE);
    eval 'sub KERN_VNODE () {13;}' unless defined(&KERN_VNODE);
    eval 'sub KERN_PROC () {14;}' unless defined(&KERN_PROC);
    eval 'sub KERN_FILE () {15;}' unless defined(&KERN_FILE);
    eval 'sub KERN_PROF () {16;}' unless defined(&KERN_PROF);
    eval 'sub KERN_POSIX1 () {17;}' unless defined(&KERN_POSIX1);
    eval 'sub KERN_NGROUPS () {18;}' unless defined(&KERN_NGROUPS);
    eval 'sub KERN_JOB_CONTROL () {19;}' unless defined(&KERN_JOB_CONTROL);
    eval 'sub KERN_SAVED_IDS () {20;}' unless defined(&KERN_SAVED_IDS);
    eval 'sub KERN_OBOOTTIME () {21;}' unless defined(&KERN_OBOOTTIME);
    eval 'sub KERN_DOMAINNAME () {22;}' unless defined(&KERN_DOMAINNAME);
    eval 'sub KERN_MAXPARTITIONS () {23;}' unless defined(&KERN_MAXPARTITIONS);
    eval 'sub KERN_RAWPARTITION () {24;}' unless defined(&KERN_RAWPARTITION);
    eval 'sub KERN_NTPTIME () {25;}' unless defined(&KERN_NTPTIME);
    eval 'sub KERN_TIMEX () {26;}' unless defined(&KERN_TIMEX);
    eval 'sub KERN_AUTONICETIME () {27;}' unless defined(&KERN_AUTONICETIME);
    eval 'sub KERN_AUTONICEVAL () {28;}' unless defined(&KERN_AUTONICEVAL);
    eval 'sub KERN_RTC_OFFSET () {29;}' unless defined(&KERN_RTC_OFFSET);
    eval 'sub KERN_ROOT_DEVICE () {30;}' unless defined(&KERN_ROOT_DEVICE);
    eval 'sub KERN_MSGBUFSIZE () {31;}' unless defined(&KERN_MSGBUFSIZE);
    eval 'sub KERN_FSYNC () {32;}' unless defined(&KERN_FSYNC);
    eval 'sub KERN_OLDSYSVMSG () {33;}' unless defined(&KERN_OLDSYSVMSG);
    eval 'sub KERN_OLDSYSVSEM () {34;}' unless defined(&KERN_OLDSYSVSEM);
    eval 'sub KERN_OLDSYSVSHM () {35;}' unless defined(&KERN_OLDSYSVSHM);
    eval 'sub KERN_OLDSHORTCORENAME () {36;}' unless defined(&KERN_OLDSHORTCORENAME);
    eval 'sub KERN_SYNCHRONIZED_IO () {37;}' unless defined(&KERN_SYNCHRONIZED_IO);
    eval 'sub KERN_IOV_MAX () {38;}' unless defined(&KERN_IOV_MAX);
    eval 'sub KERN_MBUF () {39;}' unless defined(&KERN_MBUF);
    eval 'sub KERN_MAPPED_FILES () {40;}' unless defined(&KERN_MAPPED_FILES);
    eval 'sub KERN_MEMLOCK () {41;}' unless defined(&KERN_MEMLOCK);
    eval 'sub KERN_MEMLOCK_RANGE () {42;}' unless defined(&KERN_MEMLOCK_RANGE);
    eval 'sub KERN_MEMORY_PROTECTION () {43;}' unless defined(&KERN_MEMORY_PROTECTION);
    eval 'sub KERN_LOGIN_NAME_MAX () {44;}' unless defined(&KERN_LOGIN_NAME_MAX);
    eval 'sub KERN_DEFCORENAME () {45;}' unless defined(&KERN_DEFCORENAME);
    eval 'sub KERN_LOGSIGEXIT () {46;}' unless defined(&KERN_LOGSIGEXIT);
    eval 'sub KERN_PROC2 () {47;}' unless defined(&KERN_PROC2);
    eval 'sub KERN_PROC_ARGS () {48;}' unless defined(&KERN_PROC_ARGS);
    eval 'sub KERN_FSCALE () {49;}' unless defined(&KERN_FSCALE);
    eval 'sub KERN_CCPU () {50;}' unless defined(&KERN_CCPU);
    eval 'sub KERN_CP_TIME () {51;}' unless defined(&KERN_CP_TIME);
    eval 'sub KERN_OLDSYSVIPC_INFO () {52;}' unless defined(&KERN_OLDSYSVIPC_INFO);
    eval 'sub KERN_MSGBUF () {53;}' unless defined(&KERN_MSGBUF);
    eval 'sub KERN_CONSDEV () {54;}' unless defined(&KERN_CONSDEV);
    eval 'sub KERN_MAXPTYS () {55;}' unless defined(&KERN_MAXPTYS);
    eval 'sub KERN_PIPE () {56;}' unless defined(&KERN_PIPE);
    eval 'sub KERN_MAXPHYS () {57;}' unless defined(&KERN_MAXPHYS);
    eval 'sub KERN_SBMAX () {58;}' unless defined(&KERN_SBMAX);
    eval 'sub KERN_TKSTAT () {59;}' unless defined(&KERN_TKSTAT);
    eval 'sub KERN_MONOTONIC_CLOCK () {60;}' unless defined(&KERN_MONOTONIC_CLOCK);
    eval 'sub KERN_URND () {61;}' unless defined(&KERN_URND);
    eval 'sub KERN_LABELSECTOR () {62;}' unless defined(&KERN_LABELSECTOR);
    eval 'sub KERN_LABELOFFSET () {63;}' unless defined(&KERN_LABELOFFSET);
    eval 'sub KERN_LWP () {64;}' unless defined(&KERN_LWP);
    eval 'sub KERN_FORKFSLEEP () {65;}' unless defined(&KERN_FORKFSLEEP);
    eval 'sub KERN_POSIX_THREADS () {66;}' unless defined(&KERN_POSIX_THREADS);
    eval 'sub KERN_POSIX_SEMAPHORES () {67;}' unless defined(&KERN_POSIX_SEMAPHORES);
    eval 'sub KERN_POSIX_BARRIERS () {68;}' unless defined(&KERN_POSIX_BARRIERS);
    eval 'sub KERN_POSIX_TIMERS () {69;}' unless defined(&KERN_POSIX_TIMERS);
    eval 'sub KERN_POSIX_SPIN_LOCKS () {70;}' unless defined(&KERN_POSIX_SPIN_LOCKS);
    eval 'sub KERN_POSIX_READER_WRITER_LOCKS () {71;}' unless defined(&KERN_POSIX_READER_WRITER_LOCKS);
    eval 'sub KERN_DUMP_ON_PANIC () {72;}' unless defined(&KERN_DUMP_ON_PANIC);
    eval 'sub KERN_SOMAXKVA () {73;}' unless defined(&KERN_SOMAXKVA);
    eval 'sub KERN_ROOT_PARTITION () {74;}' unless defined(&KERN_ROOT_PARTITION);
    eval 'sub KERN_DRIVERS () {75;}' unless defined(&KERN_DRIVERS);
    eval 'sub KERN_BUF () {76;}' unless defined(&KERN_BUF);
    eval 'sub KERN_FILE2 () {77;}' unless defined(&KERN_FILE2);
    eval 'sub KERN_VERIEXEC () {78;}' unless defined(&KERN_VERIEXEC);
    eval 'sub KERN_CP_ID () {79;}' unless defined(&KERN_CP_ID);
    eval 'sub KERN_HARDCLOCK_TICKS () {80;}' unless defined(&KERN_HARDCLOCK_TICKS);
    eval 'sub KERN_ARND () {81;}' unless defined(&KERN_ARND);
    eval 'sub KERN_SYSVIPC () {82;}' unless defined(&KERN_SYSVIPC);
    eval 'sub KERN_BOOTTIME () {83;}' unless defined(&KERN_BOOTTIME);
    eval 'sub KERN_EVCNT () {84;}' unless defined(&KERN_EVCNT);
    eval 'sub KERN_SOFIXEDBUF () {85;}' unless defined(&KERN_SOFIXEDBUF);
    eval 'sub KERN_ENTROPY () {86;}' unless defined(&KERN_ENTROPY);
    eval 'sub KERN_PROC_ALL () {0;}' unless defined(&KERN_PROC_ALL);
    eval 'sub KERN_PROC_PID () {1;}' unless defined(&KERN_PROC_PID);
    eval 'sub KERN_PROC_PGRP () {2;}' unless defined(&KERN_PROC_PGRP);
    eval 'sub KERN_PROC_SESSION () {3;}' unless defined(&KERN_PROC_SESSION);
    eval 'sub KERN_PROC_TTY () {4;}' unless defined(&KERN_PROC_TTY);
    eval 'sub KERN_PROC_UID () {5;}' unless defined(&KERN_PROC_UID);
    eval 'sub KERN_PROC_RUID () {6;}' unless defined(&KERN_PROC_RUID);
    eval 'sub KERN_PROC_GID () {7;}' unless defined(&KERN_PROC_GID);
    eval 'sub KERN_PROC_RGID () {8;}' unless defined(&KERN_PROC_RGID);
    eval 'sub KERN_PROC_TTY_NODEV () { &NODEV;}' unless defined(&KERN_PROC_TTY_NODEV);
    eval 'sub KERN_PROC_TTY_REVOKE () {(( &dev_t)-2);}' unless defined(&KERN_PROC_TTY_REVOKE);
    if(defined(&_KERNEL) || defined(&_KMEMUSER)) {
	eval 'sub WMESGLEN () {8;}' unless defined(&WMESGLEN);
    }
    eval 'sub PTRTOUINT64 {
        my($p) = @_;
	    eval q((( &uint64_t)( &uintptr_t)($p)));
    }' unless defined(&PTRTOUINT64);
    eval 'sub UINT64TOPTR {
        my($u) = @_;
	    eval q((( &void *)( &uintptr_t)($u)));
    }' unless defined(&UINT64TOPTR);
    eval 'sub KI_NGROUPS () {16;}' unless defined(&KI_NGROUPS);
    eval 'sub KI_MAXCOMLEN () {24;}' unless defined(&KI_MAXCOMLEN);
    eval 'sub KI_WMESGLEN () {8;}' unless defined(&KI_WMESGLEN);
    eval 'sub KI_MAXLOGNAME () {24;}' unless defined(&KI_MAXLOGNAME);
    eval 'sub KI_MAXEMULLEN () {16;}' unless defined(&KI_MAXEMULLEN);
    eval 'sub KI_LNAMELEN () {20;}' unless defined(&KI_LNAMELEN);
    eval 'sub KI_NOCPU () {(~( &uint64_t)0);}' unless defined(&KI_NOCPU);
    eval 'sub EPROC_CTTY () {0x1;}' unless defined(&EPROC_CTTY);
    eval 'sub EPROC_SLEADER () {0x2;}' unless defined(&EPROC_SLEADER);
    eval 'sub P_ADVLOCK () {0x1;}' unless defined(&P_ADVLOCK);
    eval 'sub P_CONTROLT () {0x2;}' unless defined(&P_CONTROLT);
    eval 'sub L_INMEM () {0x4;}' unless defined(&L_INMEM);
    eval 'sub P_INMEM () { &L_INMEM;}' unless defined(&P_INMEM);
    eval 'sub P_NOCLDSTOP () {0x8;}' unless defined(&P_NOCLDSTOP);
    eval 'sub P_PPWAIT () {0x10;}' unless defined(&P_PPWAIT);
    eval 'sub P_PROFIL () {0x20;}' unless defined(&P_PROFIL);
    eval 'sub L_SELECT () {0x40;}' unless defined(&L_SELECT);
    eval 'sub P_SELECT () { &L_SELECT;}' unless defined(&P_SELECT);
    eval 'sub L_SINTR () {0x80;}' unless defined(&L_SINTR);
    eval 'sub P_SINTR () { &L_SINTR;}' unless defined(&P_SINTR);
    eval 'sub P_SUGID () {0x100;}' unless defined(&P_SUGID);
    eval 'sub L_SYSTEM () {0x200;}' unless defined(&L_SYSTEM);
    eval 'sub P_SYSTEM () { &L_SYSTEM;}' unless defined(&P_SYSTEM);
    eval 'sub L_SA () {0x400;}' unless defined(&L_SA);
    eval 'sub P_SA () { &L_SA;}' unless defined(&P_SA);
    eval 'sub P_TRACED () {0x800;}' unless defined(&P_TRACED);
    eval 'sub P_WAITED () {0x1000;}' unless defined(&P_WAITED);
    eval 'sub P_WEXIT () {0x2000;}' unless defined(&P_WEXIT);
    eval 'sub P_EXEC () {0x4000;}' unless defined(&P_EXEC);
    eval 'sub P_OWEUPC () {0x8000;}' unless defined(&P_OWEUPC);
    eval 'sub P_NOCLDWAIT () {0x20000;}' unless defined(&P_NOCLDWAIT);
    eval 'sub P_32 () {0x40000;}' unless defined(&P_32);
    eval 'sub P_CLDSIGIGN () {0x80000;}' unless defined(&P_CLDSIGIGN);
    eval 'sub P_SYSTRACE () {0x200000;}' unless defined(&P_SYSTRACE);
    eval 'sub P_CHTRACED () {0x400000;}' unless defined(&P_CHTRACED);
    eval 'sub P_STOPFORK () {0x800000;}' unless defined(&P_STOPFORK);
    eval 'sub P_STOPEXEC () {0x1000000;}' unless defined(&P_STOPEXEC);
    eval 'sub P_STOPEXIT () {0x2000000;}' unless defined(&P_STOPEXIT);
    eval 'sub P_SYSCALL () {0x4000000;}' unless defined(&P_SYSCALL);
    eval 'sub L_DETACHED () {0x800000;}' unless defined(&L_DETACHED);
    eval 'sub __SYSCTL_PROC_FLAG_BITS () {"\\20" "\\1ADVLOCK" "\\2CONTROLT" "\\3INMEM" "\\4NOCLDSTOP" "\\5PPWAIT" "\\6PROFIL" "\\7SELECT" "\\10SINTR" "\\11SUGID" "\\12SYSTEM" "\\13SA" "\\14TRACED" "\\15WAITED" "\\16WEXIT" "\\17EXEC" "\\20OWEUPC" "\\22NOCLDWAIT" "\\23P32" "\\24CLDSIGIGN" "\\26SYSTRACE" "\\27CHTRACED" "\\30STOPFORK" "\\31STOPEXEC" "\\32STOPEXIT" "\\33SYSCALL";}' unless defined(&__SYSCTL_PROC_FLAG_BITS);
    eval 'sub KERN_PROC_ARGV () {1;}' unless defined(&KERN_PROC_ARGV);
    eval 'sub KERN_PROC_NARGV () {2;}' unless defined(&KERN_PROC_NARGV);
    eval 'sub KERN_PROC_ENV () {3;}' unless defined(&KERN_PROC_ENV);
    eval 'sub KERN_PROC_NENV () {4;}' unless defined(&KERN_PROC_NENV);
    eval 'sub KERN_PROC_PATHNAME () {5;}' unless defined(&KERN_PROC_PATHNAME);
    eval 'sub KERN_PROC_CWD () {6;}' unless defined(&KERN_PROC_CWD);
    eval 'sub KERN_SYSVIPC_INFO () {1;}' unless defined(&KERN_SYSVIPC_INFO);
    eval 'sub KERN_SYSVIPC_MSG () {2;}' unless defined(&KERN_SYSVIPC_MSG);
    eval 'sub KERN_SYSVIPC_SEM () {3;}' unless defined(&KERN_SYSVIPC_SEM);
    eval 'sub KERN_SYSVIPC_SHM () {4;}' unless defined(&KERN_SYSVIPC_SHM);
    eval 'sub KERN_SYSVIPC_SHMMAX () {5;}' unless defined(&KERN_SYSVIPC_SHMMAX);
    eval 'sub KERN_SYSVIPC_SHMMNI () {6;}' unless defined(&KERN_SYSVIPC_SHMMNI);
    eval 'sub KERN_SYSVIPC_SHMSEG () {7;}' unless defined(&KERN_SYSVIPC_SHMSEG);
    eval 'sub KERN_SYSVIPC_SHMMAXPGS () {8;}' unless defined(&KERN_SYSVIPC_SHMMAXPGS);
    eval 'sub KERN_SYSVIPC_SHMUSEPHYS () {9;}' unless defined(&KERN_SYSVIPC_SHMUSEPHYS);
    eval 'sub KERN_SYSVIPC_MSG_INFO () {4;}' unless defined(&KERN_SYSVIPC_MSG_INFO);
    eval 'sub KERN_SYSVIPC_SEM_INFO () {5;}' unless defined(&KERN_SYSVIPC_SEM_INFO);
    eval 'sub KERN_SYSVIPC_SHM_INFO () {6;}' unless defined(&KERN_SYSVIPC_SHM_INFO);
    eval 'sub KERN_TKSTAT_NIN () {1;}' unless defined(&KERN_TKSTAT_NIN);
    eval 'sub KERN_TKSTAT_NOUT () {2;}' unless defined(&KERN_TKSTAT_NOUT);
    eval 'sub KERN_TKSTAT_CANCC () {3;}' unless defined(&KERN_TKSTAT_CANCC);
    eval 'sub KERN_TKSTAT_RAWCC () {4;}' unless defined(&KERN_TKSTAT_RAWCC);
    eval 'sub KERN_BUF_ALL () {0;}' unless defined(&KERN_BUF_ALL);
    eval 'sub KERN_BUFSLOP () {20;}' unless defined(&KERN_BUFSLOP);
    eval 'sub KERN_FILE_BYFILE () {1;}' unless defined(&KERN_FILE_BYFILE);
    eval 'sub KERN_FILE_BYPID () {2;}' unless defined(&KERN_FILE_BYPID);
    eval 'sub KERN_FILESLOP () {10;}' unless defined(&KERN_FILESLOP);
    eval 'sub KERN_EVCNT_COUNT_ANY () {0;}' unless defined(&KERN_EVCNT_COUNT_ANY);
    eval 'sub KERN_EVCNT_COUNT_NONZERO () {1;}' unless defined(&KERN_EVCNT_COUNT_NONZERO);
    eval 'sub KERN_ENTROPY_EPOCH () {1;}' unless defined(&KERN_ENTROPY_EPOCH);
    eval 'sub KVME_TYPE_NONE () {0;}' unless defined(&KVME_TYPE_NONE);
    eval 'sub KVME_TYPE_OBJECT () {1;}' unless defined(&KVME_TYPE_OBJECT);
    eval 'sub KVME_TYPE_VNODE () {2;}' unless defined(&KVME_TYPE_VNODE);
    eval 'sub KVME_TYPE_KERN () {3;}' unless defined(&KVME_TYPE_KERN);
    eval 'sub KVME_TYPE_DEVICE () {4;}' unless defined(&KVME_TYPE_DEVICE);
    eval 'sub KVME_TYPE_ANON () {5;}' unless defined(&KVME_TYPE_ANON);
    eval 'sub KVME_TYPE_SUBMAP () {6;}' unless defined(&KVME_TYPE_SUBMAP);
    eval 'sub KVME_TYPE_UNKNOWN () {255;}' unless defined(&KVME_TYPE_UNKNOWN);
    eval 'sub KVME_PROT_READ () {0x1;}' unless defined(&KVME_PROT_READ);
    eval 'sub KVME_PROT_WRITE () {0x2;}' unless defined(&KVME_PROT_WRITE);
    eval 'sub KVME_PROT_EXEC () {0x4;}' unless defined(&KVME_PROT_EXEC);
    eval 'sub KVME_FLAG_COW () {0x1;}' unless defined(&KVME_FLAG_COW);
    eval 'sub KVME_FLAG_NEEDS_COPY () {0x2;}' unless defined(&KVME_FLAG_NEEDS_COPY);
    eval 'sub KVME_FLAG_NOCOREDUMP () {0x4;}' unless defined(&KVME_FLAG_NOCOREDUMP);
    eval 'sub KVME_FLAG_PAGEABLE () {0x8;}' unless defined(&KVME_FLAG_PAGEABLE);
    eval 'sub KVME_FLAG_GROWS_UP () {0x10;}' unless defined(&KVME_FLAG_GROWS_UP);
    eval 'sub KVME_FLAG_GROWS_DOWN () {0x20;}' unless defined(&KVME_FLAG_GROWS_DOWN);
    eval 'sub HW_MACHINE () {1;}' unless defined(&HW_MACHINE);
    eval 'sub HW_MODEL () {2;}' unless defined(&HW_MODEL);
    eval 'sub HW_NCPU () {3;}' unless defined(&HW_NCPU);
    eval 'sub HW_BYTEORDER () {4;}' unless defined(&HW_BYTEORDER);
    eval 'sub HW_PHYSMEM () {5;}' unless defined(&HW_PHYSMEM);
    eval 'sub HW_USERMEM () {6;}' unless defined(&HW_USERMEM);
    eval 'sub HW_PAGESIZE () {7;}' unless defined(&HW_PAGESIZE);
    eval 'sub HW_DISKNAMES () {8;}' unless defined(&HW_DISKNAMES);
    eval 'sub HW_IOSTATS () {9;}' unless defined(&HW_IOSTATS);
    eval 'sub HW_MACHINE_ARCH () {10;}' unless defined(&HW_MACHINE_ARCH);
    eval 'sub HW_ALIGNBYTES () {11;}' unless defined(&HW_ALIGNBYTES);
    eval 'sub HW_CNMAGIC () {12;}' unless defined(&HW_CNMAGIC);
    eval 'sub HW_PHYSMEM64 () {13;}' unless defined(&HW_PHYSMEM64);
    eval 'sub HW_USERMEM64 () {14;}' unless defined(&HW_USERMEM64);
    eval 'sub HW_IOSTATNAMES () {15;}' unless defined(&HW_IOSTATNAMES);
    eval 'sub HW_NCPUONLINE () {16;}' unless defined(&HW_NCPUONLINE);
    eval 'sub USER_CS_PATH () {1;}' unless defined(&USER_CS_PATH);
    eval 'sub USER_BC_BASE_MAX () {2;}' unless defined(&USER_BC_BASE_MAX);
    eval 'sub USER_BC_DIM_MAX () {3;}' unless defined(&USER_BC_DIM_MAX);
    eval 'sub USER_BC_SCALE_MAX () {4;}' unless defined(&USER_BC_SCALE_MAX);
    eval 'sub USER_BC_STRING_MAX () {5;}' unless defined(&USER_BC_STRING_MAX);
    eval 'sub USER_COLL_WEIGHTS_MAX () {6;}' unless defined(&USER_COLL_WEIGHTS_MAX);
    eval 'sub USER_EXPR_NEST_MAX () {7;}' unless defined(&USER_EXPR_NEST_MAX);
    eval 'sub USER_LINE_MAX () {8;}' unless defined(&USER_LINE_MAX);
    eval 'sub USER_RE_DUP_MAX () {9;}' unless defined(&USER_RE_DUP_MAX);
    eval 'sub USER_POSIX2_VERSION () {10;}' unless defined(&USER_POSIX2_VERSION);
    eval 'sub USER_POSIX2_C_BIND () {11;}' unless defined(&USER_POSIX2_C_BIND);
    eval 'sub USER_POSIX2_C_DEV () {12;}' unless defined(&USER_POSIX2_C_DEV);
    eval 'sub USER_POSIX2_CHAR_TERM () {13;}' unless defined(&USER_POSIX2_CHAR_TERM);
    eval 'sub USER_POSIX2_FORT_DEV () {14;}' unless defined(&USER_POSIX2_FORT_DEV);
    eval 'sub USER_POSIX2_FORT_RUN () {15;}' unless defined(&USER_POSIX2_FORT_RUN);
    eval 'sub USER_POSIX2_LOCALEDEF () {16;}' unless defined(&USER_POSIX2_LOCALEDEF);
    eval 'sub USER_POSIX2_SW_DEV () {17;}' unless defined(&USER_POSIX2_SW_DEV);
    eval 'sub USER_POSIX2_UPE () {18;}' unless defined(&USER_POSIX2_UPE);
    eval 'sub USER_STREAM_MAX () {19;}' unless defined(&USER_STREAM_MAX);
    eval 'sub USER_TZNAME_MAX () {20;}' unless defined(&USER_TZNAME_MAX);
    eval 'sub USER_ATEXIT_MAX () {21;}' unless defined(&USER_ATEXIT_MAX);
    eval 'sub DDBCTL_RADIX () {1;}' unless defined(&DDBCTL_RADIX);
    eval 'sub DDBCTL_MAXOFF () {2;}' unless defined(&DDBCTL_MAXOFF);
    eval 'sub DDBCTL_MAXWIDTH () {3;}' unless defined(&DDBCTL_MAXWIDTH);
    eval 'sub DDBCTL_LINES () {4;}' unless defined(&DDBCTL_LINES);
    eval 'sub DDBCTL_TABSTOPS () {5;}' unless defined(&DDBCTL_TABSTOPS);
    eval 'sub DDBCTL_ONPANIC () {6;}' unless defined(&DDBCTL_ONPANIC);
    eval 'sub DDBCTL_FROMCONSOLE () {7;}' unless defined(&DDBCTL_FROMCONSOLE);
    eval 'sub CTL_DEBUG_NAME () {0;}' unless defined(&CTL_DEBUG_NAME);
    eval 'sub CTL_DEBUG_VALUE () {1;}' unless defined(&CTL_DEBUG_VALUE);
    eval 'sub PROC_CURPROC () {(~(1<< 31));}' unless defined(&PROC_CURPROC);
    eval 'sub PROC_PID_CORENAME () {1;}' unless defined(&PROC_PID_CORENAME);
    eval 'sub PROC_PID_LIMIT () {2;}' unless defined(&PROC_PID_LIMIT);
    eval 'sub PROC_PID_STOPFORK () {3;}' unless defined(&PROC_PID_STOPFORK);
    eval 'sub PROC_PID_STOPEXEC () {4;}' unless defined(&PROC_PID_STOPEXEC);
    eval 'sub PROC_PID_STOPEXIT () {5;}' unless defined(&PROC_PID_STOPEXIT);
    eval 'sub PROC_PID_PAXFLAGS () {6;}' unless defined(&PROC_PID_PAXFLAGS);
    eval 'sub PROC_PID_LIMIT_CPU () {( &RLIMIT_CPU+1);}' unless defined(&PROC_PID_LIMIT_CPU);
    eval 'sub PROC_PID_LIMIT_FSIZE () {( &RLIMIT_FSIZE+1);}' unless defined(&PROC_PID_LIMIT_FSIZE);
    eval 'sub PROC_PID_LIMIT_DATA () {( &RLIMIT_DATA+1);}' unless defined(&PROC_PID_LIMIT_DATA);
    eval 'sub PROC_PID_LIMIT_STACK () {( &RLIMIT_STACK+1);}' unless defined(&PROC_PID_LIMIT_STACK);
    eval 'sub PROC_PID_LIMIT_CORE () {( &RLIMIT_CORE+1);}' unless defined(&PROC_PID_LIMIT_CORE);
    eval 'sub PROC_PID_LIMIT_RSS () {( &RLIMIT_RSS+1);}' unless defined(&PROC_PID_LIMIT_RSS);
    eval 'sub PROC_PID_LIMIT_MEMLOCK () {( &RLIMIT_MEMLOCK+1);}' unless defined(&PROC_PID_LIMIT_MEMLOCK);
    eval 'sub PROC_PID_LIMIT_NPROC () {( &RLIMIT_NPROC+1);}' unless defined(&PROC_PID_LIMIT_NPROC);
    eval 'sub PROC_PID_LIMIT_NOFILE () {( &RLIMIT_NOFILE+1);}' unless defined(&PROC_PID_LIMIT_NOFILE);
    eval 'sub PROC_PID_LIMIT_SBSIZE () {( &RLIMIT_SBSIZE+1);}' unless defined(&PROC_PID_LIMIT_SBSIZE);
    eval 'sub PROC_PID_LIMIT_AS () {( &RLIMIT_AS+1);}' unless defined(&PROC_PID_LIMIT_AS);
    eval 'sub PROC_PID_LIMIT_NTHR () {( &RLIMIT_NTHR+1);}' unless defined(&PROC_PID_LIMIT_NTHR);
    eval 'sub PROC_PID_LIMIT_TYPE_SOFT () {1;}' unless defined(&PROC_PID_LIMIT_TYPE_SOFT);
    eval 'sub PROC_PID_LIMIT_TYPE_HARD () {2;}' unless defined(&PROC_PID_LIMIT_TYPE_HARD);
    eval 'sub CTL_PROC_PAXFLAGS_ASLR () {0x1;}' unless defined(&CTL_PROC_PAXFLAGS_ASLR);
    eval 'sub CTL_PROC_PAXFLAGS_MPROTECT () {0x2;}' unless defined(&CTL_PROC_PAXFLAGS_MPROTECT);
    eval 'sub CTL_PROC_PAXFLAGS_GUARD () {0x4;}' unless defined(&CTL_PROC_PAXFLAGS_GUARD);
    eval 'sub EMUL_LINUX () {1;}' unless defined(&EMUL_LINUX);
    eval 'sub EMUL_LINUX32 () {5;}' unless defined(&EMUL_LINUX32);
    if(defined(&_KERNEL)) {
	if(defined(&_KERNEL_OPT)) {
	    require './sys/opt_sysctl.ph';
	}
	if(defined(&DEBUG)) {
	}
	eval 'sub SYSCTLFN_PROTO () { &const \'int\' *, \'u_int\',  &void *, \'size_t\' *,  &const  &void *, \'size_t\',  &const \'int\' *, \'struct lwp\' *,  &const \'struct sysctlnode\' *;}' unless defined(&SYSCTLFN_PROTO);
	eval 'sub SYSCTLFN_ARGS () { &const \'int\' * &name, \'u_int\'  &namelen,  &void * &oldp, \'size_t\' * &oldlenp,  &const  &void * &newp, \'size_t\'  &newlen,  &const \'int\' * &oname, \'struct lwp\' * &l,  &const \'struct sysctlnode\' * &rnode;}' unless defined(&SYSCTLFN_ARGS);
	eval 'sub SYSCTLFN_CALL {
	    my($node) = @_;
    	    eval q( &name,  &namelen,  &oldp,  &oldlenp,  &newp,  &newlen,  &oname,  &l, $node);
	}' unless defined(&SYSCTLFN_CALL);
	if(defined(&RUMP_USE_CTOR)) {
	    require 'sys/kernel.ph';
	    eval 'sub _SYSCTL_REGISTER {
	        my($name) = @_;
    		eval q( &static \'struct sysctl_setup_chain\'  &__CONCAT( &ssc,$name) = { . &ssc_func = $name, };  &static  &void  &sysctlctor_$name( &void)  &__attribute__(( &constructor));  &static  &void  &sysctlctor_$name( &void) { \'struct sysctl_setup_chain\' * &ssc = & &__CONCAT( &ssc,$name);  &extern \'struct sysctl_boot_chain\'  &sysctl_boot_chain;  &if ( &cold) {  &LIST_INSERT_HEAD( &sysctl_boot_chain,  &ssc,  &ssc_entries); } }  &static  &void  &sysctldtor_$name( &void)  &__attribute__(( &destructor));  &static  &void  &sysctldtor_$name( &void) { \'struct sysctl_setup_chain\' * &ssc = & &__CONCAT( &ssc,$name);  &if ( &cold) {  &LIST_REMOVE( &ssc,  &ssc_entries); } });
	    }' unless defined(&_SYSCTL_REGISTER);
	} else {
	    eval 'sub _SYSCTL_REGISTER {
	        my($name) = @_;
    		eval q( &__link_set_add_text( &sysctl_funcs, $name););
	    }' unless defined(&_SYSCTL_REGISTER);
	}
	if(defined(&_MODULE)) {
	    eval 'sub SYSCTL_SETUP_PROTO {
	        my($name) = @_;
    		eval q( &void $name);
	    }' unless defined(&SYSCTL_SETUP_PROTO);
	    if(defined(&SYSCTL_DEBUG_SETUP)) {
		eval 'sub SYSCTL_SETUP {
		    my($name, $desc) = @_;
    		    eval q( &SYSCTL_SETUP_PROTO($name);  &static  &void  &__CONCAT( &___,$name);  &void $name(\'struct sysctllog\' ** &clog) {  &printf(\\"%s\\\\n\\", $desc);  &__CONCAT( &___,$name)( &clog); }  &_SYSCTL_REGISTER($name);  &static  &void  &__CONCAT( &___,$name)(\'struct sysctllog\' ** &clog));
		}' unless defined(&SYSCTL_SETUP);
	    } else {
		eval 'sub SYSCTL_SETUP {
		    my($name, $desc) = @_;
    		    eval q( &SYSCTL_SETUP_PROTO($name);  &_SYSCTL_REGISTER($name);  &void $name(\'struct sysctllog\' ** &clog));
		}' unless defined(&SYSCTL_SETUP);
	    }
	} else {
	    eval 'sub SYSCTL_SETUP_PROTO {
	        my($name) = @_;
    		eval q();
	    }' unless defined(&SYSCTL_SETUP_PROTO);
	    if(defined(&SYSCTL_DEBUG_SETUP)) {
		eval 'sub SYSCTL_SETUP {
		    my($name, $desc) = @_;
    		    eval q( &static  &void  &__CONCAT( &___,$name);  &static  &void $name(\'struct sysctllog\' ** &clog) {  &printf(\\"%s\\\\n\\", $desc);  &__CONCAT( &___,$name)( &clog); }  &_SYSCTL_REGISTER($name);  &static  &void  &__CONCAT( &___,$name)(\'struct sysctllog\' ** &clog));
		}' unless defined(&SYSCTL_SETUP);
	    } else {
		eval 'sub SYSCTL_SETUP {
		    my($name, $desc) = @_;
    		    eval q( &static  &void $name;  &_SYSCTL_REGISTER($name);  &static  &void $name(\'struct sysctllog\' ** &clog));
		}' unless defined(&SYSCTL_SETUP);
	    }
	}
	eval 'sub VERIFY_FN {
	    my($ctl_type, $c_type) = @_;
    	    eval q( &__always_inline  &static  &__inline  &void *  &__sysctl_verify_$ctl_type &_arg($c_type * &arg) {  &return  &arg; });
	}' unless defined(&VERIFY_FN);
	undef(&VERIFY_FN) if defined(&VERIFY_FN);
	eval 'sub sysctl_createv () {( &lg,  &cfl,  &rn,  &cn,  &fl,  &type,  &nm,  &desc,  &fn,  &qv,  &newp, ...)  &sysctl_createv( &lg,  &cfl,  &rn,  &cn,  &fl,  &type,  &nm,  &desc,  &fn,  &qv,  &__sysctl_verify_ &type &_arg( &newp),  &__VA_ARGS__);}' unless defined(&sysctl_createv);
	if(defined(&SYSCTL_INCLUDE_DESCR)) {
	    eval 'sub SYSCTL_DESCR {
	        my($s) = @_;
    		eval q($s);
	    }' unless defined(&SYSCTL_DESCR);
	} else {
	    eval 'sub SYSCTL_DESCR {
	        my($s) = @_;
    		eval q( &NULL);
	    }' unless defined(&SYSCTL_DESCR);
	}
    } else {
	require 'sys/cdefs.ph';
    }
    if(defined(&__COMPAT_SYSCTL)) {
    }
    if(defined(&_LP64) || ((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&LITTLE_ENDIAN) ? &LITTLE_ENDIAN : undef))) {
	eval 'sub __sysc_pad {
	    my($type) = @_;
    	    eval q(\'union union\' {  &uint64_t  &__sysc_upad; \'struct struct\' { $type  &__sysc_sdatum; }  &__sysc_ustr; });
	}' unless defined(&__sysc_pad);
    } else {
	eval 'sub __sysc_pad {
	    my($type) = @_;
    	    eval q(\'union union\' {  &uint64_t  &__sysc_upad; \'struct struct\' {  &uint32_t  &__sysc_spad; $type  &__sysc_sdatum; }  &__sysc_ustr; });
	}' unless defined(&__sysc_pad);
    }
    eval 'sub __sysc_unpad {
        my($x) = @_;
	    eval q( ($x->{__sysc_ustr}->{__sysc_sdatum}));
    }' unless defined(&__sysc_unpad);
    eval 'sub sysc_init_field {
        my($field, $value) = @_;
	    eval q(.$field = { . &__sysc_ustr = { . &__sysc_sdatum = ($value), }, });
    }' unless defined(&sysc_init_field);
    eval 'sub suc_child () { &__sysc_unpad( &_suc_child);}' unless defined(&suc_child);
    eval 'sub sud_data () { &__sysc_unpad( &_sud_data);}' unless defined(&sud_data);
    eval 'sub sud_offset () { &__sysc_unpad( &_sud_offset);}' unless defined(&sud_offset);
    eval 'sub sysctl_size () { &__sysc_unpad( &_sysctl_size);}' unless defined(&sysctl_size);
    eval 'sub sysctl_func () { &__sysc_unpad( &_sysctl_func);}' unless defined(&sysctl_func);
    eval 'sub sysctl_parent () { &__sysc_unpad( &_sysctl_parent);}' unless defined(&sysctl_parent);
    eval 'sub sysctl_desc () { &__sysc_unpad( &_sysctl_desc);}' unless defined(&sysctl_desc);
    eval 'sub sysctl_csize () { ($sysctl_un->{scu_child}->{suc_csize});}' unless defined(&sysctl_csize);
    eval 'sub sysctl_clen () { ($sysctl_un->{scu_child}->{suc_clen});}' unless defined(&sysctl_clen);
    eval 'sub sysctl_child () { ($sysctl_un->{scu_child}->{suc_child});}' unless defined(&sysctl_child);
    eval 'sub sysctl_data () { ($sysctl_un->{scu_data}->{sud_data});}' unless defined(&sysctl_data);
    eval 'sub sysctl_offset () { ($sysctl_un->{scu_data}->{sud_offset});}' unless defined(&sysctl_offset);
    eval 'sub sysctl_alias () { ($sysctl_un->{scu_alias});}' unless defined(&sysctl_alias);
    eval 'sub sysctl_idata () { ($sysctl_un->{scu_idata});}' unless defined(&sysctl_idata);
    eval 'sub sysctl_qdata () { ($sysctl_un->{scu_qdata});}' unless defined(&sysctl_qdata);
    eval 'sub sysctl_bdata () { ($sysctl_un->{scu_bdata});}' unless defined(&sysctl_bdata);
    eval 'sub __sysc_desc_roundup {
        my($x) = @_;
	    eval q((((($x) - 1) | ($sizeof{ &int32_t} - 1)) + 1));
    }' unless defined(&__sysc_desc_roundup);
    eval 'sub __sysc_desc_len {
        my($l) = @_;
	    eval q(( &offsetof(\'struct sysctldesc\',  &descr_str) +  &__sysc_desc_roundup($l)));
    }' unless defined(&__sysc_desc_len);
    eval 'sub __sysc_desc_adv {
        my($d, $l) = @_;
	    eval q((   &__UNCONST((( &const \'char\'*)($d)) +  &__sysc_desc_len($l))));
    }' unless defined(&__sysc_desc_adv);
    eval 'sub NEXT_DESCR {
        my($d) = @_;
	    eval q( &__sysc_desc_adv(($d), ($d)-> &descr_len));
    }' unless defined(&NEXT_DESCR);
    eval 'sub sysctl_rootof {
        my($n) = @_;
	    eval q({  &while ( ($n->{sysctl_parent}) !=  &NULL) $n =  ($n->{sysctl_parent}); ($n); });
    }' unless defined(&sysctl_rootof);
}
1;
