/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.util;

import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.Random;

public class SplitMix64Random
extends Random {
    private static final long serialVersionUID = 1L;
    private static final long PHI = -7046029254386353131L;
    private long x;

    public SplitMix64Random() {
        this(Util.randomSeed());
    }

    public SplitMix64Random(long seed) {
        this.setSeed(seed);
    }

    private static long staffordMix13(long z) {
        z = (z ^ z >>> 30) * -4658895280553007687L;
        z = (z ^ z >>> 27) * -7723592293110705685L;
        return z ^ z >>> 31;
    }

    private static int staffordMix4Upper32(long z) {
        z = (z ^ z >>> 33) * 7109453100751455733L;
        return (int)((z ^ z >>> 28) * -3808689974395783757L >>> 32);
    }

    @Override
    public long nextLong() {
        return SplitMix64Random.staffordMix13(this.x += -7046029254386353131L);
    }

    @Override
    public int nextInt() {
        return SplitMix64Random.staffordMix4Upper32(this.x += -7046029254386353131L);
    }

    @Override
    public int nextInt(int n) {
        return (int)this.nextLong(n);
    }

    @Override
    public long nextLong(long n) {
        if (n <= 0L) {
            throw new IllegalArgumentException("illegal bound " + n + " (must be positive)");
        }
        long t = SplitMix64Random.staffordMix13(this.x += -7046029254386353131L);
        long nMinus1 = n - 1L;
        if ((n & nMinus1) == 0L) {
            return t & nMinus1;
        }
        long u = t >>> 1;
        while (u + nMinus1 - (t = u % n) < 0L) {
            u = SplitMix64Random.staffordMix13(this.x += -7046029254386353131L) >>> 1;
        }
        return t;
    }

    @Override
    public double nextDouble() {
        return Double.longBitsToDouble(SplitMix64Random.staffordMix13(this.x += -7046029254386353131L) >>> 12 | 0x3FF0000000000000L) - 1.0;
    }

    @Override
    public float nextFloat() {
        return Float.intBitsToFloat(SplitMix64Random.staffordMix4Upper32(this.x += -7046029254386353131L) >>> 41 | 0x3F800000) - 1.0f;
    }

    @Override
    public boolean nextBoolean() {
        return SplitMix64Random.staffordMix4Upper32(this.x += -7046029254386353131L) < 0;
    }

    @Override
    public void nextBytes(byte[] bytes) {
        int i = bytes.length;
        int n = 0;
        while (i != 0) {
            n = Math.min(i, 8);
            long bits = SplitMix64Random.staffordMix13(this.x += -7046029254386353131L);
            while (n-- != 0) {
                bytes[--i] = (byte)bits;
                bits >>= 8;
            }
        }
    }

    @Override
    public void setSeed(long seed) {
        this.x = HashCommon.murmurHash3((long)seed);
    }

    public void setState(long state) {
        this.x = state;
    }
}

