/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.http;

import gnu.java.net.LineInputStream;
import gnu.java.net.protocol.http.HTTPDateFormat;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class Headers
extends LinkedHashMap {
    static final DateFormat dateFormat = new HTTPDateFormat();

    public boolean containsKey(Object key) {
        return super.containsKey(new Header((String)key));
    }

    public Object get(Object key) {
        return super.get(new Header((String)key));
    }

    public String getValue(String header) {
        return (String)super.get(new Header(header));
    }

    public int getIntValue(String header) {
        String val = this.getValue(header);
        if (val == null) {
            return -1;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public long getLongValue(String header) {
        String val = this.getValue(header);
        if (val == null) {
            return -1;
        }
        try {
            return Long.parseLong(val);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public Date getDateValue(String header) {
        String val = this.getValue(header);
        if (val == null) {
            return null;
        }
        try {
            return dateFormat.parse(val);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public Object put(Object key, Object value) {
        return super.put(new Header((String)key), value);
    }

    public Object remove(Object key) {
        return super.remove(new Header((String)key));
    }

    public void putAll(Map t) {
        Iterator i = t.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = (String)t.get(key);
            this.put(key, value);
        }
    }

    public Set keySet() {
        Set keys = super.keySet();
        LinkedHashSet ret = new LinkedHashSet();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            ret.add(((Header)i.next()).name);
        }
        return ret;
    }

    public Set entrySet() {
        Set entries = super.entrySet();
        LinkedHashSet ret = new LinkedHashSet();
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            ret.add(new HeaderEntry(entry));
        }
        return ret;
    }

    public void parse(InputStream in) throws IOException {
        LineInputStream lin = in instanceof LineInputStream ? (LineInputStream)in : new LineInputStream(in);
        String name = null;
        StringBuilder value = new StringBuilder();
        while (true) {
            String line;
            if ((line = lin.readLine()) == null) {
                if (name == null) break;
                this.addValue(name, value.toString());
                break;
            }
            int len = line.length();
            if (len < 2) {
                if (name == null) break;
                this.addValue(name, value.toString());
                break;
            }
            char c1 = line.charAt(0);
            if (c1 == ' ' || c1 == '\t') {
                int last = len - 1;
                if (line.charAt(last) != '\r') {
                    ++last;
                }
                value.append(line.substring(0, last));
                continue;
            }
            if (name != null) {
                this.addValue(name, value.toString());
            }
            int di = line.indexOf(58);
            name = line.substring(0, di);
            value.setLength(0);
            while (++di < len && line.charAt(di) == ' ') {
            }
            int last = len - 1;
            if (line.charAt(last) != '\r') {
                ++last;
            }
            value.append(line.substring(di, last));
        }
    }

    private final void addValue(String name, String value) {
        Header key = new Header(name);
        String old = (String)super.get(key);
        if (old == null) {
            super.put(key, value);
        } else {
            super.put(key, old + ", " + value);
        }
    }

    static class Header {
        final String name;

        public int hashCode() {
            return this.name.toLowerCase().hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof Header) {
                return ((Header)other).name.equalsIgnoreCase(this.name);
            }
            return false;
        }

        public String toString() {
            return this.name;
        }

        Header(String name) {
            if (name == null || name.length() == 0) {
                throw new IllegalArgumentException(name);
            }
            this.name = name;
        }
    }

    static class HeaderEntry
    implements Map.Entry {
        final Map.Entry entry;

        public Object getKey() {
            return ((Header)this.entry.getKey()).name;
        }

        public Object getValue() {
            return this.entry.getValue();
        }

        public Object setValue(Object value) {
            return this.entry.setValue(value);
        }

        public int hashCode() {
            return this.entry.hashCode();
        }

        public boolean equals(Object other) {
            return this.entry.equals(other);
        }

        public String toString() {
            return this.getKey().toString() + '=' + this.getValue();
        }

        HeaderEntry(Map.Entry entry) {
            this.entry = entry;
        }
    }
}

