;;; finder-inf.el --- keyword-to-package mapping
;; Keywords: help
;;; Commentary:
;; Don't edit this file.  It's generated by finder.el

;;; Code:

(setq finder-package-info '(
    ("abbrev.el"
        "abbrev mode commands for Emacs"
        (abbrev convenience))
    ("abbrevlist.el"
        "list one abbrev table alphabetically ordered."
        (abbrev))
    ("add-log.el"
        "change log maintenance commands for Emacs"
        (tools))
    ("allout.el"
        "Extensive outline mode for use alone and with other modes."
        (outlines))
    ("ange-ftp.el"
        "transparent FTP support for GNU Emacs"
        (comm))
    ("apropos.el"
        "apropos commands for users and programmers."
        (help))
    ("arc-mode.el"
        "simple editing of archives"
        (archives msdog editing major-mode))
    ("array.el"
        "array editing commands for Gnu Emacs"
        (extensions))
    ("auto-show.el"
        "perform automatic horizontal scrolling as point moves"
        (scroll display convenience))
    ("autoinsert.el"
        "automatic mode-dependent insertion of text into new files"
        (convenience))
    ("autorevert.el"
        "revert buffers when files on disk change"
        (convenience))
    ("avoid.el"
        "make mouse pointer stay out of the way of editing"
        (mouse))
    ("battery.el"
        "display battery status information."
        (hardware))
    ("bindings.el"
        "define standard key bindings and some variables."
        (internal))
    ("bookmark.el"
        "set bookmarks, maybe annotate them, jump to them later."
        (bookmarks  placeholders  annotations))
    ("browse-url.el"
        "Pass a URL to a WWW browser"
        (hypertext  hypermedia  mouse))
    ("buff-menu.el"
        "buffer menu main function and support functions."
        nil)
    ("byte-run.el"
        "byte-compiler support for inlining"
        (internal))
    ("case-table.el"
        "code to extend the character set and support case tables."
        (i18n))
    ("cdl.el"
        "Common Data Language (CDL) utility functions for Gnu Emacs"
        (data))
    ("chistory.el"
        "list command history"
        nil)
    ("cmuscheme.el"
        "Scheme process in a buffer. Adapted from tea.el."
        (processes  lisp))
    ("comint.el"
        "general command interpreter in a window stuff"
        (processes))
    ("compare-w.el"
        "compare text between windows for Emacs."
        nil)
    ("complete.el"
        "partial completion mechanism plus other goodies"
        (abbrev convenience))
    ("completion.el"
        "dynamic word-completion code"
        (abbrev convenience))
    ("cus-dep.el"
        "Find customization dependencies."
        (internal))
    ("cus-edit.el"
        "Tools for customizating Emacs and Lisp packages."
        (help  faces))
    ("cus-face.el"
        "customization support for faces."
        (help  faces))
    ("cus-load.el"
        "automatically extracted custom dependencies"
        nil)
    ("cus-start.el"
        "define customization properties of builtins."
        (internal))
    ("custom.el"
        "Tools for declaring and initializing options."
        (help  faces))
    ("dabbrev.el"
        "dynamic abbreviation package"
        (abbrev expand completion convenience))
    ("default.el"
        nil
        nil)
    ("delsel.el"
        "delete selection if you insert"
        nil)
    ("derived.el"
        "allow inheritance of major modes."
        nil)
    ("desktop.el"
        "save partial status of Emacs when killed"
        (customization))
    ("diff.el"
        "Run `diff' in compilation-mode."
        (unix  tools))
    ("dired-aux.el"
        "less commonly used parts of dired"
        nil)
    ("dired-x.el"
        "Sebastian Kremer's Extra DIRED hacked up for GNU Emacs19"
        (dired extensions))
    ("dired.el"
        "directory-browsing commands"
        nil)
    ("dirtrack.el"
        "Directory Tracking by watching the prompt"
        (processes))
    ("disp-table.el"
        "functions for dealing with char tables."
        (i18n))
    ("dos-fns.el"
        "MS-Dos specific functions."
        (internal))
    ("dos-vars.el"
        "MS-Dos specific user options."
        (internal))
    ("dos-w32.el"
        "Functions shared among MS-DOS and W32 (NT/95) platforms"
        (internal))
    ("double.el"
        "Support for keyboard remapping with double clicking"
        (i18n))
    ("ebuff-menu.el"
        "electric-buffer-list mode"
        nil)
    ("echistory.el"
        "Electric Command History Mode"
        nil)
    ("ediff-diff.el"
        "diff-related utilities"
        nil)
    ("ediff-help.el"
        "Code related to the contents of Ediff help buffers"
        nil)
    ("ediff-hook.el"
        "setup for Ediff's menus and autoloads"
        nil)
    ("ediff-init.el"
        "Macros, variables, and defsubsts used by Ediff"
        nil)
    ("ediff-merg.el"
        "merging utilities"
        nil)
    ("ediff-mult.el"
        "support for multi-file/multi-buffer processing in Ediff"
        nil)
    ("ediff-ptch.el"
        "Ediff's  patch support"
        nil)
    ("ediff-util.el"
        "the core commands and utilities of ediff"
        nil)
    ("ediff-vers.el"
        "version control interface to Ediff"
        nil)
    ("ediff-wind.el"
        "window manipulation utilities"
        nil)
    ("ediff.el"
        "a comprehensive visual interface to diff & patch"
        (comparing  merging  patching  version control.))
    ("edmacro.el"
        "keyboard macro editor"
        (abbrev))
    ("ehelp.el"
        "bindings for electric-help mode"
        (help  extensions))
    ("electric.el"
        "window maker and Command loop for `electric' modes."
        (extensions))
    ("emacs-lock.el"
        "prevents you from exiting emacs if a buffer is locked"
        (extensions  processes))
    ("emerge.el"
        "merge diffs under Emacs control"
        (unix  tools))
    ("enriched.el"
        "read and save files in text/enriched format"
        (wp  faces))
    ("env.el"
        "functions to manipulate environment variables."
        (processes  unix))
    ("expand.el"
        "make abbreviations more usable."
        (abbrev))
    ("facemenu.el"
        "create a face menu for interactively adding fonts to text"
        (faces))
    ("faces.el"
        "Lisp interface to the c \"face\" structure"
        nil)
    ("fast-lock.el"
        "Automagic text properties caching for fast Font Lock mode."
        (faces files))
    ("ffap.el"
        "find file (or url) at point"
        (files  hypermedia  matching  mouse  convenience))
    ("filecache.el"
        "Find files using a pre-loaded cache"
        (convenience))
    ("files.el"
        "file input and output commands for Emacs"
        nil)
    ("find-dired.el"
        "run a `find' command and dired the output"
        (unix))
    ("find-file.el"
        "find a file corresponding to this one given a pattern"
        (c  matching  tools))
    ("find-gc.el"
        "detect functions that call the garbage collector"
        nil)
    ("finder-inf.el"
        "keyword-to-package mapping"
        (help))
    ("finder.el"
        "topic & keyword-based code finder"
        (help))
    ("float-sup.el"
        "detect absence of floating-point support in Emacs runtime"
        nil)
    ("flow-ctrl.el"
        "help for lusers on cu(1) or ttys with wired-in ^S/^Q flow control"
        (hardware))
    ("foldout.el"
        "Folding extensions for outline-mode and outline-minor-mode."
        (folding  outlines))
    ("follow.el"
        "Minor mode, Synchronize windows showing the same buffer."
        (display  window  minor-mode  convenience))
    ("font-lock.el"
        "Electric font lock mode"
        (languages  faces))
    ("format.el"
        "read and save files in multiple formats"
        nil)
    ("forms-d2.el"
        "demo forms-mode"
        nil)
    ("forms-pass.el"
        "passwd file demo for forms-mode"
        nil)
    ("forms.el"
        "Forms mode: edit a file as a form to fill in"
        nil)
    ("frame.el"
        "multi-frame management independent of window systems."
        (internal))
    ("generic-x.el"
        "Extra Modes for generic-mode"
        (generic  comment  font-lock))
    ("generic.el"
        "Defining simple major modes with comment and font-lock."
        (generic  comment  font-lock))
    ("goto-addr.el"
        "click to browse URL or to send to e-mail address"
        (mh-e  www  mouse  mail))
    ("gud.el"
        "Grand Unified Debugger mode for running GDB and other debuggers"
        (unix  tools))
    ("help-macro.el"
        "Makes command line help such as help-for-help"
        nil)
    ("help.el"
        "help commands for Emacs"
        (help  internal))
    ("hexl.el"
        "edit a file in a hex dump format using the hexl filter."
        (data))
    ("hilit-chg.el"
        "minor mode displaying buffer changes with special face"
        (faces))
    ("hilit19.el"
        "customizable highlighting for Emacs19"
        (faces))
    ("hippie-exp.el"
        "expand text trying various ways to find its expansion."
        (abbrev convenience))
    ("hscroll.el"
        nil
        (display))
    ("icomplete.el"
        "minibuffer completion incremental feedback"
        (help  abbrev))
    ("ielm.el"
        "interaction mode for Emacs Lisp"
        (lisp))
    ("imenu.el"
        "Framework for mode-specific buffer indexes."
        (tools convenience))
    ("indent.el"
        "indentation commands for Emacs"
        nil)
    ("inf-lisp.el"
        "an inferior-lisp mode"
        (processes  lisp))
    ("info-look.el"
        "major-mode-sensitive Info index lookup facility."
        (help languages))
    ("info.el"
        "info package for Emacs."
        (help))
    ("informat.el"
        "info support functions package for Emacs"
        (help))
    ("isearch.el"
        "incremental search minor mode."
        nil)
    ("ispell.el"
        "Interface to International Ispell Version 3.1"
        nil)
    ("iswitchb.el"
        "switch between buffers using substrings"
        (extensions convenience))
    ("jka-compr.el"
        "reading/writing/loading compressed files"
        (data))
    ("kermit.el"
        "additions to shell mode for use with kermit, etc."
        (comm))
    ("lazy-lock.el"
        "Lazy demand-driven fontification for fast Font Lock mode."
        (faces files))
    ("ledit.el"
        "Emacs side of ledit interface"
        nil)
    ("loaddefs.el"
        "define autoloads from other files"
        (internal))
    ("loadhist.el"
        "lisp functions for working with feature groups"
        (internal))
    ("loadup.el"
        "load up standardly loaded Lisp files for Emacs."
        (internal))
    ("locate.el"
        "interface to the locate command"
        nil)
    ("lpr.el"
        "print Emacs buffer on line printer."
        (unix))
    ("ls-lisp.el"
        "emulate insert-directory completely in Emacs Lisp"
        (unix))
    ("macros.el"
        "non-primitive commands for keyboard macros."
        (abbrev))
    ("makesum.el"
        "generate key binding summary for Emacs"
        (help))
    ("man.el"
        "browse UNIX manual pages"
        (help))
    ("map-ynp.el"
        "General-purpose boolean question-asker."
        (lisp  extensions))
    ("menu-bar.el"
        "define a default menu bar."
        (internal))
    ("midnight.el"
        "run something every midnight, e.g., kill old buffers."
        (utilities))
    ("misc.el"
        "some nonstandard basic editing commands for Emacs"
        nil)
    ("mldrag.el"
        "mode line and vertical line dragging to resize windows"
        (mouse))
    ("mouse-copy.el"
        "one-click text copy and move"
        (mouse))
    ("mouse-drag.el"
        "use mouse-2 to do a new style of scrolling"
        (mouse))
    ("mouse-sel.el"
        "Multi-click selection support for Emacs 19"
        (mouse))
    ("mouse.el"
        "window system-independent mouse support"
        (hardware))
    ("msb.el"
        "Customizable buffer-selection with multiple menus."
        (mouse buffer menu))
    ("net-utils.el"
        "Network functions"
        (network communications))
    ("novice.el"
        "handling of disabled commands (\"novice mode\") for Emacs."
        (internal  help))
    ("options.el"
        "edit Options command for Emacs."
        nil)
    ("paren.el"
        "highlight matching paren."
        (languages  faces))
    ("patcomp.el"
        "used by patch files to update Emacs releases"
        nil)
    ("paths.el"
        "define pathnames for use by various Emacs commands."
        (internal))
    ("ph.el"
        "Client for the CCSO directory system (aka PH/QI)"
        (help))
    ("ps-bdf.el"
        "BDF font file handler for ps-print."
        (bdf  font  postscript))
    ("ps-mule.el"
        "Provide multi-byte character facility to ps-print."
        (print  postscript  multibyte  mule))
    ("ps-print.el"
        "Print text from the buffer as PostScript"
        (print  postscript))
    ("rcompile.el"
        "run a compilation on a remote machine"
        (tools  processes))
    ("rect.el"
        "rectangle functions for GNU Emacs."
        (internal))
    ("regi.el"
        "REGular expression Interpreting engine"
        (extensions  matching))
    ("register.el"
        "register commands for Emacs."
        (internal))
    ("repeat.el"
        "convenient way to repeat the previous command"
        (convenience  vi  repeat))
    ("replace.el"
        "replace commands for Emacs."
        nil)
    ("reposition.el"
        "center a Lisp function or comment on the screen"
        nil)
    ("resume.el"
        "process command line args from within a suspended Emacs job"
        (processes))
    ("rlogin.el"
        "remote login interface"
        (unix  comm))
    ("rot13.el"
        "display a buffer in rot13."
        nil)
    ("rsz-mini.el"
        "dynamically resize minibuffer to display entire contents"
        (minibuffer  window  frame  display))
    ("s-region.el"
        "set region using shift key."
        (terminals))
    ("saveplace.el"
        "automatically save place in files."
        (bookmarks  placeholders))
    ("scroll-all.el"
        "scroll all buffers together minor mode"
        (scroll crisp brief lock))
    ("scroll-bar.el"
        "window system-independent scroll bar support."
        (hardware))
    ("select.el"
        "lisp portion of standard selection support."
        (internal))
    ("server.el"
        "Lisp code for GNU Emacs running as server process."
        (processes))
    ("shadowfile.el"
        "automatic file copying for Emacs 19"
        (comm))
    ("shell.el"
        "specialized comint.el for running the shell."
        (processes))
    ("simple.el"
        "basic editing commands for Emacs"
        nil)
    ("site-init.el"
        nil
        nil)
    ("site-load.el"
        nil
        nil)
    ("skeleton.el"
        "Lisp language extension for writing statement skeletons"
        (extensions  abbrev  languages  tools))
    ("snmp-mode.el"
        "SNMP & SNMPv2 MIB major mode."
        (data))
    ("sort.el"
        "commands to sort text in an Emacs buffer."
        (unix))
    ("soundex.el"
        "implement Soundex algorithm"
        (matching))
    ("speedbar.el"
        "quick access to files and tags in a frame"
        (file  tags  tools))
    ("startup.el"
        "process Emacs shell arguments"
        (internal))
    ("strokes.el"
        "control Emacs through mouse strokes"
        (lisp  mouse  extensions))
    ("subdirs.el"
        nil
        nil)
    ("subr.el"
        "basic lisp subroutines for Emacs"
        nil)
    ("sun-curs.el"
        "cursor definitions for Sun windows"
        (hardware))
    ("sun-fns.el"
        "subroutines of Mouse handling for Sun windows"
        (hardware))
    ("tabify.el"
        "tab conversion commands for Emacs"
        nil)
    ("talk.el"
        "Allow several users to talk to each other through Emacs."
        (comm  frames))
    ("tar-mode.el"
        "simple editing of tar files from GNU emacs"
        (unix))
    ("tcp.el"
        "TCP/IP stream emulation for GNU Emacs"
        nil)
    ("telnet.el"
        "run a telnet session from within an Emacs buffer"
        nil)
    ("tempo.el"
        "Flexible template insertion"
        (extensions  languages  tools))
    ("term.el"
        "general command interpreter in a window stuff"
        nil)
    ("terminal.el"
        "terminal emulator for GNU Emacs."
        (comm  terminals))
    ("thingatpt.el"
        "Get the `thing' at point"
        (extensions  matching  mouse))
    ("time-stamp.el"
        "Maintain last change time stamps in files edited by Emacs"
        (tools))
    ("time.el"
        "display time and load in mode line of Emacs."
        nil)
    ("timer.el"
        "run a function with args at some time in future."
        nil)
    ("timezone.el"
        "time zone package for GNU Emacs"
        (news))
    ("tmm.el"
        "text mode access to menu-bar"
        nil)
    ("type-break.el"
        "encourage rests from typing at appropriate intervals"
        (extensions  timers))
    ("uncompress.el"
        "auto-decompression hook for visiting .Z files"
        nil)
    ("uniquify.el"
        "unique buffer names dependent on file name"
        nil)
    ("unused.el"
        "editing commands in GNU Emacs that turned out not to be used."
        (emulations))
    ("userlock.el"
        "handle file access contention between multiple users"
        (internal))
    ("vc-hooks.el"
        "resident support for version-control"
        nil)
    ("vc.el"
        "drive a version-control system from within Emacs"
        nil)
    ("vcursor.el"
        "manipulate an alternative (\"virtual\") cursor."
        (virtual cursor  convenience))
    ("version.el"
        "record version number of Emacs."
        (internal))
    ("view.el"
        "peruse file or buffer without editing."
        nil)
    ("vms-patch.el"
        "override parts of files.el for VMS."
        (vms))
    ("vmsproc.el"
        "run asynchronous VMS subprocesses under Emacs"
        (vms))
    ("vt-control.el"
        "Common VTxxx control functions"
        (terminals))
    ("vt100-led.el"
        "functions for LED control on VT-100 terminals & clones."
        (hardware))
    ("w32-fns.el"
        "Lisp routines for Windows NT."
        nil)
    ("webjump.el"
        "programmable Web hotlist"
        (comm www))
    ("which-func.el"
        "Print current function in mode line"
        (mode-line  imenu  tools))
    ("wid-browse.el"
        "Functions for browsing widgets."
        (extensions))
    ("wid-edit.el"
        "Functions for creating and using widgets."
        (extensions))
    ("widget.el"
        "a library of user interface components."
        (help  extensions  faces  hypermedia))
    ("window.el"
        "GNU Emacs window commands aside from those written in C."
        nil)
    ("winner.el"
        "Restore old window configurations"
        (windows))
    ("x-apollo.el"
        "Apollo support functions"
        nil)
    ("x-menu.el"
        "menu support for X "
        nil)
    ("xscheme.el"
        "run Scheme under Emacs"
        (languages  lisp))
    ("xt-mouse.el"
        "Support the mouse when emacs run in an xterm."
        (mouse  terminals))
    ("zone-mode.el"
        "major mode for editing DNS zone files."
        (dns  languages))
    ("advice.el"
        "an overloading mechanism for Emacs Lisp functions"
        (extensions  lisp  tools))
    ("assoc.el"
        "insert/delete/sort functions on association lists"
        (extensions))
    ("autoload.el"
        "maintain autoloads in loaddefs.el."
        (maint))
    ("backquote.el"
        "implement the ` Lisp construct"
        (extensions  internal))
    ("byte-opt.el"
        "the optimization passes of the emacs-lisp byte compiler."
        (internal))
    ("bytecomp.el"
        "compilation of Lisp code into byte code."
        (lisp))
    ("checkdoc.el"
        "Check documentation strings for style requirements"
        (docs  maint  lisp))
    ("cl-compat.el"
        "Common Lisp extensions for GNU Emacs Lisp (compatibility)"
        (extensions))
    ("cl-extra.el"
        "Common Lisp features, part 2"
        (extensions))
    ("cl-indent.el"
        "enhanced lisp-indent mode"
        (lisp  tools))
    ("cl-macs.el"
        "Common Lisp macros"
        (extensions))
    ("cl-seq.el"
        "Common Lisp features, part 3"
        (extensions))
    ("cl-specs.el"
        "Edebug specs for cl.el"
        (lisp  tools  maint))
    ("cl.el"
        "Common Lisp extensions for Emacs"
        (extensions))
    ("copyright.el"
        "update the copyright notice in current buffer"
        (maint  tools))
    ("cust-print.el"
        "handles print-level and print-circle."
        (extensions))
    ("debug.el"
        "debuggers and related commands for Emacs"
        (lisp  tools  maint))
    ("disass.el"
        "disassembler for compiled Emacs Lisp code"
        (internal))
    ("easy-mmode.el"
        "easy definition of minor modes."
        nil)
    ("easymenu.el"
        "support the easymenu interface for defining a menu."
        (emulations))
    ("edebug.el"
        "a source-level debugger for Emacs Lisp"
        (lisp  tools  maint))
    ("eldoc.el"
        "show function arglist or variable docstring in echo area"
        (extensions))
    ("elint.el"
        "Lint Emacs Lisp"
        (lisp))
    ("elp.el"
        "Emacs Lisp Profiler"
        (debugging lisp tools))
    ("eval-reg.el"
        "Redefine eval-region, and subrs that use it, in Lisp"
        (lisp))
    ("find-func.el"
        "find the definition of the Emacs Lisp function near point"
        (emacs-lisp  functions  variables))
    ("float.el"
        "obsolete floating point arithmetic package."
        (extensions))
    ("gulp.el"
        "Ask for updates for Lisp packages"
        (maintenance))
    ("helper.el"
        "utility help package supporting help in electric modes"
        (help))
    ("levents.el"
        "emulate the Lucid event data type and associated functions."
        nil)
    ("lisp-mnt.el"
        "minor mode for Emacs Lisp maintainers"
        (docs))
    ("lisp-mode.el"
        "Lisp mode, and its idiosyncratic commands."
        (lisp  languages))
    ("lisp.el"
        "Lisp editing commands for Emacs"
        (lisp  languages))
    ("lmenu.el"
        "emulate Lucid's menubar support"
        (emulations))
    ("lselect.el"
        "Lucid interface to X Selections"
        (emulations))
    ("lucid.el"
        "Emulate some Lucid Emacs functions."
        nil)
    ("pp.el"
        "pretty printer for Emacs Lisp"
        nil)
    ("profile.el"
        "generate run time measurements of Emacs Lisp functions"
        (lisp  tools))
    ("regexp-opt.el"
        "generate efficient regexps to match strings."
        (strings  regexps))
    ("ring.el"
        "handle rings of items"
        (extensions))
    ("shadow.el"
        "Locate Emacs Lisp file shadowings."
        (lisp))
    ("sregex.el"
        "symbolic regular expressions"
        nil)
    ("tq.el"
        "utility to maintain a transaction queue"
        (extensions))
    ("trace.el"
        "tracing facility for Emacs Lisp functions"
        (tools  lisp))
    ("crisp.el"
        "CRiSP/Brief Emacs emulator"
        (emulations brief crisp))
    ("edt-lk201.el"
        "Enhanced EDT Keypad Mode Emulation for LK-201 Keyboards"
        (emulations))
    ("edt-mapper.el"
        "Create an EDT LK-201 Map File for X-Windows Emacs"
        (emulations))
    ("edt-pc.el"
        "Enhanced EDT Keypad Mode Emulation for PC 101 Keyboards"
        (emulations))
    ("edt-vt100.el"
        "Enhanced EDT Keypad Mode Emulation for VT Series Terminals"
        (emulations))
    ("edt.el"
        "Enhanced EDT Keypad Mode Emulation for GNU Emacs 19"
        (emulations))
    ("mlconvert.el"
        "convert buffer of Mocklisp code to real lisp."
        (emulations))
    ("mlsupport.el"
        "run-time support for mocklisp code."
        (extensions))
    ("pc-mode.el"
        "emulate certain key bindings used on PCs."
        (emulations))
    ("pc-select.el"
        "emulate mark, cut, copy and paste from Motif"
        (convenience ))
    ("tpu-edt.el"
        "Emacs emulating TPU emulating EDT"
        (emulations))
    ("tpu-extras.el"
        "Scroll margins and free cursor mode for TPU-edt"
        (emulations))
    ("tpu-mapper.el"
        "Create a TPU-edt X-windows keymap file"
        (emulations))
    ("vi.el"
        "major mode for emulating \"vi\" editor under GNU Emacs."
        (emulations))
    ("vip.el"
        "a VI Package for GNU Emacs"
        (emulations))
    ("viper-cmd.el"
        "Vi command support for Viper"
        nil)
    ("viper-ex.el"
        "functions implementing the Ex commands for Viper"
        nil)
    ("viper-init.el"
        "some common definitions for Viper"
        nil)
    ("viper-keym.el"
        "Viper keymaps"
        nil)
    ("viper-macs.el"
        "functions implementing keyboard macros for Viper"
        nil)
    ("viper-mous.el"
        "mouse support for Viper"
        nil)
    ("viper-util.el"
        "Utilities used by viper.el"
        nil)
    ("viper.el"
        "A full-featured Vi emulator for Emacs."
        (emulations))
    ("ws-mode.el"
        "WordStar emulation mode for GNU Emacs"
        (emulations))
    ("earcon.el"
        "Sound effects for messages"
        nil)
    ("gnus-agent.el"
        "unplugged support for Gnus"
        nil)
    ("gnus-art.el"
        "article mode commands for Gnus"
        (news))
    ("gnus-async.el"
        "asynchronous support for Gnus"
        (news))
    ("gnus-audio.el"
        "Sound effects for Gnus"
        nil)
    ("gnus-bcklg.el"
        "backlog functions for Gnus"
        (news))
    ("gnus-cache.el"
        "cache interface for Gnus"
        (news))
    ("gnus-cite.el"
        "parse citations in articles for Gnus"
        nil)
    ("gnus-cus.el"
        "customization commands for Gnus"
        (news))
    ("gnus-demon.el"
        "daemonic Gnus behaviour"
        (news))
    ("gnus-draft.el"
        "draft message support for Gnus"
        (news))
    ("gnus-dup.el"
        "suppression of duplicate articles in Gnus"
        (news))
    ("gnus-eform.el"
        "a mode for editing forms for Gnus"
        (news))
    ("gnus-ems.el"
        "functions for making Gnus work under different Emacsen"
        (news))
    ("gnus-gl.el"
        "an interface to GroupLens for Gnus"
        (news  score))
    ("gnus-group.el"
        "group mode commands for Gnus"
        (news))
    ("gnus-int.el"
        "backend interface functions for Gnus"
        (news))
    ("gnus-kill.el"
        "kill commands for Gnus"
        (news))
    ("gnus-load.el"
        "automatically extracted custom dependencies"
        nil)
    ("gnus-logic.el"
        "advanced scoring code for Gnus"
        (news))
    ("gnus-mh.el"
        "mh-e interface for Gnus"
        (news))
    ("gnus-move.el"
        "commands for moving Gnus from one server to another"
        (news))
    ("gnus-msg.el"
        "mail and post interface for Gnus"
        (news))
    ("gnus-mule.el"
        "Provide multilingual environment to GNUS"
        (gnus  mule))
    ("gnus-nocem.el"
        "NoCeM pseudo-cancellation treatment"
        (news))
    ("gnus-range.el"
        "range and sequence functions for Gnus"
        (news))
    ("gnus-salt.el"
        "alternate summary mode interfaces for Gnus"
        (news))
    ("gnus-score.el"
        "scoring code for Gnus"
        (news))
    ("gnus-setup.el"
        "Initialization & Setup for Gnus 5"
        (news))
    ("gnus-soup.el"
        "SOUP packet writing support for Gnus"
        (news  mail))
    ("gnus-spec.el"
        "format spec functions for Gnus"
        (news))
    ("gnus-srvr.el"
        "virtual server support for Gnus"
        (news))
    ("gnus-start.el"
        "startup functions for Gnus"
        (news))
    ("gnus-sum.el"
        "summary mode commands for Gnus"
        (news))
    ("gnus-topic.el"
        "a folding minor mode for Gnus group buffers"
        (news))
    ("gnus-undo.el"
        "minor mode for undoing in Gnus"
        (news))
    ("gnus-util.el"
        "utility functions for Gnus"
        (news))
    ("gnus-uu.el"
        "extract (uu)encoded files in Gnus"
        nil)
    ("gnus-vm.el"
        "vm interface for Gnus"
        (news  mail))
    ("gnus-win.el"
        "window configuration functions for Gnus"
        (news))
    ("gnus.el"
        "a newsreader for GNU Emacs"
        (news  mail))
    ("message.el"
        "composing mail and news messages"
        (mail  news))
    ("messcompat.el"
        "making message mode compatible with mail mode"
        (mail  news))
    ("nnagent.el"
        "offline backend for Gnus"
        (news  mail))
    ("nnbabyl.el"
        "rmail mbox access for Gnus"
        (news  mail))
    ("nndir.el"
        "single directory newsgroup access for Gnus"
        (news))
    ("nndoc.el"
        "single file access for Gnus"
        (news))
    ("nndraft.el"
        "draft article access for Gnus"
        (news))
    ("nneething.el"
        "arbitrary file access for Gnus"
        (news  mail))
    ("nnfolder.el"
        "mail folder access for Gnus"
        (mail))
    ("nngateway.el"
        "posting news via mail gateways"
        (news  mail))
    ("nnheader.el"
        "header access macros for Gnus and its backends"
        (news))
    ("nnkiboze.el"
        "select virtual news access for Gnus"
        (news))
    ("nnlistserv.el"
        "retrieving articles via web mailing list archives"
        (news  mail))
    ("nnmail.el"
        "mail support functions for the Gnus mail backends"
        (news  mail))
    ("nnmbox.el"
        "mail mbox access for Gnus"
        (news  mail))
    ("nnmh.el"
        "mhspool access for Gnus"
        (news  mail))
    ("nnml.el"
        "mail spool access for Gnus"
        (news  mail))
    ("nnoo.el"
        "OO Gnus Backends"
        (news))
    ("nnsoup.el"
        "SOUP access for Gnus"
        (news  mail))
    ("nnspool.el"
        "spool access for GNU Emacs"
        (news))
    ("nntp.el"
        "nntp access for Gnus Copyright (C) 1987-90,92-97 Free"
        (news))
    ("nnvirtual.el"
        "virtual newsgroups access for Gnus"
        (news))
    ("nnweb.el"
        "retrieving articles via web search engines"
        (news))
    ("parse-time.el"
        "Parsing time strings"
        (util))
    ("pop3.el"
        "Post Office Protocol (RFC 1460) interface"
        (mail  pop3))
    ("score-mode.el"
        "mode for editing Gnus score files"
        (news  mail))
    ("ccl.el"
        "CCL (Code Conversion Language) compiler"
        (ccl  mule  multilingual  character set  coding-system))
    ("characters.el"
        "set syntax and category for multibyte characters"
        (multibyte character  character set  syntax  category))
    ("codepage.el"
        "MS-DOS specific coding systems."
        (i18n ms-dos codepage))
    ("encoded-kb.el"
        "Handler to input multibyte characters encoded somehow"
        nil)
    ("fontset.el"
        "Commands for handling fontset."
        (mule  multilingual  fontset))
    ("isearch-x.el"
        "extended isearch handling commands"
        (multilingual  isearch))
    ("iso-acc.el"
        "minor mode providing electric accent keys"
        (i18n))
    ("iso-ascii.el"
        "set up char tables for ISO 8859/1 on ASCII terminals."
        (i18n))
    ("iso-cvt.el"
        "translate ISO 8859-1 from/to various encodings"
        (tex  iso  latin  i18n))
    ("iso-insert.el"
        "insert functions for ISO 8859/1."
        (i18n))
    ("iso-swed.el"
        "set up char tables for ISO 8859/1 for Swedish/Finnish ttys"
        (i18n))
    ("iso-transl.el"
        "keyboard input definitions for ISO 8859/1."
        (i18n))
    ("kinsoku.el"
        "`Kinsoku' processing funcs."
        (mule  kinsoku))
    ("kkc.el"
        "Kana Kanji converter"
        (mule  multilingual  japanese  skk))
    ("latin-1.el"
        "set up case-conversion and syntax tables for ISO Latin-1"
        (i18n))
    ("latin-2.el"
        "set up case-conversion and syntax tables for ISO Latin-2"
        (i18n))
    ("latin-3.el"
        "set up case-conversion and syntax tables for ISO Latin-3"
        (i18n))
    ("latin-4.el"
        "set up case-conversion and syntax tables for ISO Latin-4"
        (i18n))
    ("latin-5.el"
        "set up case-conversion and syntax tables for ISO latin-5"
        (i18n))
    ("mule-cmds.el"
        "Commands for mulitilingual environment"
        (mule  multilingual))
    ("mule-conf.el"
        "configure multilingual environment"
        (mule  multilingual  character set  coding system))
    ("mule-diag.el"
        "Show diagnosis of multilingual environment (Mule)"
        (multilingual  charset  coding system  fontset  diagnosis))
    ("mule-util.el"
        "Utility functions for mulitilingual environment (mule)"
        (mule  multilingual))
    ("mule.el"
        "basic commands for mulitilingual environment"
        (mule  multilingual  character set  coding system))
    ("ogonek.el"
        "change the encoding of Polish diacritics"
        (i18n))
    ("quail.el"
        "Provides simple input method for multilingual text"
        (mule  multilingual  input method))
    ("skkdic-cnv.el"
        "Convert a SKK dictionary for `skkdic-utl'"
        (mule  multilingual  japanese  skk))
    ("skkdic-utl.el"
        "Utility functions for handling SKK dictionary"
        (mule  multilingual  japanese  skk))
    ("swedish.el"
        "miscellaneous functions for dealing with Swedish."
        (i18n))
    ("titdic-cnv.el"
        "convert cxterm dictionary (TIT format) to Quail package"
        (quail  tit  cxterm))
    ("china-util.el"
        "utilities for Chinese"
        (mule  multilingual  chinese))
    ("chinese.el"
        "Support for Chinese"
        (multilingual  chinese))
    ("cyril-util.el"
        "utilities for Cyrillic scripts"
        (mule  multilingual  cyrillic))
    ("cyrillic.el"
        "Support for Cyrillic"
        (multilingual  cyrillic))
    ("czech.el"
        "support for Czech"
        (multilingual  czech))
    ("devan-util.el"
        "Support for Devanagari Script Composition"
        (multilingual  indian  devanagari))
    ("devanagari.el"
        "Support for Devanagari"
        (multilingual  indian  devanagari))
    ("english.el"
        "English support"
        (multibyte character  character set  syntax  category))
    ("ethio-util.el"
        "utilities for Ethiopic"
        (mule  multilingual  ethiopic))
    ("ethiopic.el"
        "Support for Ethiopic"
        (multilingual  ethiopic))
    ("european.el"
        "European languages"
        (multilingual  european))
    ("greek.el"
        "Support for Greek"
        (multilingual  greek))
    ("hebrew.el"
        "Support for Hebrew"
        (multilingual  hebrew))
    ("indian.el"
        "Support for Indian Languages"
        (multilingual  indian))
    ("japan-util.el"
        "utilities for Japanese"
        (mule  multilingual  japanese))
    ("japanese.el"
        "Japanese support"
        (multilingual  japanese))
    ("korea-util.el"
        "utilities for Korean"
        (mule  multilingual  korean))
    ("korean.el"
        "Support for Korean"
        (multilingual  korean))
    ("lao-util.el"
        "utilities for Lao"
        (multilingual  lao))
    ("lao.el"
        "Support for Lao"
        (multilingual  lao))
    ("misc-lang.el"
        "support for miscellaneous languages (characters)"
        (multilingual  character set  coding system))
    ("romanian.el"
        "Support for Romanian"
        (multilingual  romanian))
    ("slovak.el"
        "Support for Slovak"
        (multilingual  slovak))
    ("thai-util.el"
        "utilities for Thai"
        (mule  multilingual  thai))
    ("thai.el"
        "Support for Thai"
        (multilingual  thai))
    ("tibet-util.el"
        "Support for inputting Tibetan characters"
        (multilingual  tibetan))
    ("tibetan.el"
        "Support for Tibetan language"
        (multilingual  tibetan))
    ("viet-util.el"
        "utilities for Vietnamese"
        (mule  multilingual  vietnamese))
    ("vietnamese.el"
        "Support for Vietnamese"
        (multilingual  vietnamese))
    ("blessmail.el"
        "Decide whether movemail needs special privileges."
        (internal))
    ("emacsbug.el"
        "command to report Emacs bugs to appropriate mailing list."
        (maint mail))
    ("feedmail.el"
        "assist other email packages to massage outgoing messages"
        (email  queue  mail  sendmail  message  spray  smtp  draft))
    ("mail-extr.el"
        "extract full name and address from RFC 822 mail header."
        (mail))
    ("mail-hist.el"
        "Headers and message body history for outgoing mail."
        (mail  history))
    ("mail-utils.el"
        "utility functions used both by rmail and rnews"
        (mail  news))
    ("mailabbrev.el"
        "abbrev-expansion of mail aliases."
        (mail))
    ("mailalias.el"
        "expand and complete mailing address aliases"
        (mail))
    ("mailheader.el"
        "Mail header parsing, merging, formatting"
        (tools  mail  news))
    ("mailpost.el"
        "RMAIL coupler to /usr/uci/post mailer"
        (mail))
    ("metamail.el"
        "Metamail interface for GNU Emacs"
        (mail  news  mime  multimedia))
    ("mh-comp.el"
        "mh-e functions for composing messages"
        nil)
    ("mh-e.el"
        "GNU Emacs interface to the MH mail system"
        (mail))
    ("mh-funcs.el"
        "mh-e functions not everyone will use right away"
        nil)
    ("mh-mime.el"
        "mh-e support for composing MIME messages"
        nil)
    ("mh-pick.el"
        "make a search pattern and search for a message in mh-e"
        nil)
    ("mh-seq.el"
        "mh-e sequences support"
        nil)
    ("mh-utils.el"
        "mh-e code needed for both sending and reading"
        nil)
    ("mspools.el"
        "show mail spools waiting to be read."
        (mail))
    ("reporter.el"
        "customizable bug reporting of lisp programs"
        (maint mail tools))
    ("rfc822.el"
        "hairy rfc822 parser for mail and news and suchlike"
        (mail))
    ("rmail.el"
        "main code of \"RMAIL\" mail reader for Emacs."
        (mail))
    ("rmailedit.el"
        "\"RMAIL edit mode\"  Edit the current message."
        (mail))
    ("rmailkwd.el"
        "part of the \"RMAIL\" mail reader for Emacs."
        (mail))
    ("rmailmsc.el"
        "miscellaneous support functions for the RMAIL mail reader"
        (mail))
    ("rmailout.el"
        "\"RMAIL\" mail reader for Emacs: output message to a file."
        (mail))
    ("rmailsort.el"
        "Rmail: sort messages."
        (mail))
    ("rmailsum.el"
        "make summary buffers for the mail reader"
        (mail))
    ("rnews.el"
        "USENET news reader for gnu emacs"
        (news))
    ("rnewspost.el"
        "USENET news poster/mailer for GNU Emacs"
        (mail  news))
    ("sc.el"
        "old name for supercite"
        nil)
    ("sendmail.el"
        "mail sending commands for Emacs."
        (mail))
    ("smtpmail.el"
        "simple SMTP protocol (RFC 821) for sending mail"
        (mail))
    ("supercite.el"
        "minor mode for citing mail and news replies"
        (mail  news))
    ("uce.el"
        "facilitate reply to unsolicited commercial email"
        (uce  unsolicited commercial email))
    ("undigest.el"
        "digest-cracking support for the RMAIL mail reader"
        (mail))
    ("unrmail.el"
        "convert Rmail files to mailbox files."
        (mail))
    ("vms-pmail.el"
        "use Emacs as the editor within VMS mail."
        (vms))
    ("blackbox.el"
        "blackbox game in Emacs Lisp"
        (games))
    ("bruce.el"
        "bruce phrase utility for overloading the Communications"
        (games))
    ("cookie1.el"
        "retrieve random phrases from fortune cookie files"
        (games))
    ("decipher.el"
        "Cryptanalyze monoalphabetic substitution ciphers"
        (games))
    ("dissociate.el"
        "scramble text amusingly for Emacs."
        (games))
    ("doctor.el"
        "psychological help for frustrated users."
        (games))
    ("dunnet.el"
        "Text adventure for Emacs"
        (games))
    ("gamegrid.el"
        "Library for implementing grid-based games on Emacs"
        (games))
    ("gametree.el"
        "manage game analysis trees in Emacs"
        (games))
    ("gomoku.el"
        "Gomoku game between you and Emacs"
        (games))
    ("handwrite.el"
        "turns your emacs buffer into a handwritten document"
        (cursive writing))
    ("hanoi.el"
        "towers of hanoi in GNUmacs"
        (games))
    ("landmark.el"
        "neural-network robot that learns landmarks"
        (gomoku neural network adaptive search chemotaxis))
    ("life.el"
        "John Horton Conway's `Life' game for GNU Emacs"
        (games))
    ("meese.el"
        "protect the impressionable young minds of America"
        (games))
    ("morse.el"
        "Convert text to morse code and back."
        nil)
    ("mpuz.el"
        "multiplication puzzle for GNU Emacs"
        (games))
    ("snake.el"
        "Implementation of Snake for Emacs"
        (games))
    ("solitaire.el"
        "game of solitaire in Emacs Lisp"
        (games))
    ("spook.el"
        "spook phrase utility for overloading the NSA line eater"
        (games))
    ("studly.el"
        "StudlyCaps (tm)(r)(c)(xxx)"
        (games))
    ("tetris.el"
        "Implementation of Tetris for Emacs"
        (games))
    ("yow.el"
        "quote random zippyisms"
        (games))
    ("ada-mode.el"
        "An Emacs major-mode for editing Ada source."
        (languages oop ada))
    ("ada-stmt.el"
        nil
        (languages  ada))
    ("asm-mode.el"
        "mode for editing assembler code"
        (tools  languages))
    ("awk-mode.el"
        "AWK code editing commands for Emacs"
        (unix  languages))
    ("c-mode.el"
        "C code editing commands for Emacs"
        (c))
    ("cc-align.el"
        "custom indentation functions for CC Mode"
        (c languages oop))
    ("cc-cmds.el"
        "user level commands for CC Mode"
        (c languages oop))
    ("cc-compat.el"
        "cc-mode compatibility with c-mode.el confusion"
        (c languages oop))
    ("cc-defs.el"
        "compile time definitions for CC Mode"
        (c languages oop))
    ("cc-engine.el"
        "core syntax guessing engine for CC mode"
        (c languages oop))
    ("cc-langs.el"
        "specific language support for CC Mode"
        (c languages oop))
    ("cc-make.el"
        "Simplifies compilation."
        (c languages oop))
    ("cc-menus.el"
        "imenu support for CC Mode"
        (c languages oop))
    ("cc-mode.el"
        "major mode for editing C, C++, Objective-C, and Java code"
        (c languages oop))
    ("cc-styles.el"
        "support for styles in CC Mode"
        (c languages oop))
    ("cc-vars.el"
        "user customization variables for CC Mode"
        (c languages oop))
    ("cmacexp.el"
        "expand C macros in a region"
        (c))
    ("compile.el"
        "run compiler as inferior of Emacs, parse error messages."
        (tools  processes))
    ("cperl-mode.el"
        "Perl code editing commands for Emacs"
        (languages  perl))
    ("cplus-md.el"
        "old C++ code editing mode for Emacs"
        (c))
    ("cpp.el"
        "Highlight or hide text according to cpp conditionals."
        (c  faces  tools))
    ("dcl-mode.el"
        "major mode for editing DCL command files"
        (dcl editing major-mode languages))
    ("etags.el"
        "etags facility for Emacs"
        (tools))
    ("executable.el"
        "base functionality for executable interpreter scripts"
        (languages  unix))
    ("f90.el"
        "Fortran-90 mode (free format)"
        (fortran  f90  languages))
    ("fortran.el"
        "Fortran mode for GNU Emacs"
        (languages))
    ("hideif.el"
        "hides selected code within ifdef."
        (c  outlines))
    ("hideshow.el"
        "minor mode cmds to selectively display blocks of code"
        (c c++ java lisp tools editing comments blocks hiding outlines))
    ("icon.el"
        "mode for editing Icon code"
        (languages))
    ("m4-mode.el"
        "m4 code editing commands for Emacs"
        (languages  faces))
    ("make-mode.el"
        "makefile editing commands for Emacs"
        (unix  tools))
    ("mantemp.el"
        "Create manual template instantiations from g++ 2.7.2 output."
        (g++  templates))
    ("meta-mode.el"
        "major mode for editing Metafont or MetaPost sources."
        (metafont  metapost  tex  languages))
    ("modula2.el"
        "Modula-2 editing support package"
        (languages))
    ("octave-hlp.el"
        "getting help on Octave symbols using info"
        (languages))
    ("octave-inf.el"
        "running Octave as an inferior Emacs process"
        (languages))
    ("octave-mod.el"
        "editing Octave source files under Emacs"
        (languages))
    ("pascal.el"
        "major mode for editing pascal source in Emacs"
        (languages))
    ("perl-mode.el"
        "Perl code editing commands for GNU Emacs"
        (languages))
    ("prolog.el"
        "major mode for editing and running Prolog under Emacs"
        (languages))
    ("scheme.el"
        "Scheme (and DSSSL) editing mode."
        (languages  lisp))
    ("sh-script.el"
        "shell-script editing commands for Emacs"
        (languages  unix))
    ("simula.el"
        "SIMULA 87 code editing commands for Emacs"
        (languages))
    ("sql.el"
        "specialized comint.el for SQL interpreters"
        (comm languages processes))
    ("tcl-mode.el"
        "a major-mode for editing tcl/tk scripts"
        (languages  processes  tools))
    ("vhdl-mode.el"
        "major mode for editing VHDL code"
        (languages vhdl))
    ("AT386.el"
        "terminal support package for IBM AT keyboards"
        (terminals))
    ("apollo.el"
        nil
        nil)
    ("bg-mouse.el"
        "GNU Emacs code for BBN Bitgraph mouse."
        (hardware))
    ("bobcat.el"
        nil
        nil)
    ("internal.el"
        "support for PC internal terminal"
        nil)
    ("iris-ansi.el"
        "configure Emacs for SGI xwsh and winterm apps"
        nil)
    ("keyswap.el"
        "swap BS and DEL keys"
        (terminals))
    ("linux.el"
        nil
        nil)
    ("lk201.el"
        nil
        nil)
    ("news.el"
        "keypad and function key bindings for the Sony NEWS keyboard"
        (terminals))
    ("pc-win.el"
        "setup support for `PC windows' (whatever that is)."
        nil)
    ("sun-mouse.el"
        "mouse handling for Sun windows"
        (hardware))
    ("sun.el"
        "keybinding for standard default sunterm keys"
        (terminals))
    ("sup-mouse.el"
        "supdup mouse support for lisp machines"
        (hardware))
    ("tvi970.el"
        "terminal support for the Televideo 970"
        (terminals))
    ("vt100.el"
        "define VT100 function key sequences in function-key-map"
        (terminals))
    ("vt102.el"
        nil
        nil)
    ("vt125.el"
        nil
        nil)
    ("vt200.el"
        nil
        nil)
    ("vt201.el"
        nil
        nil)
    ("vt220.el"
        nil
        nil)
    ("vt240.el"
        nil
        nil)
    ("vt300.el"
        nil
        nil)
    ("vt320.el"
        nil
        nil)
    ("vt400.el"
        nil
        nil)
    ("vt420.el"
        nil
        nil)
    ("w32-win.el"
        "parse switches controlling interface with W32 window system."
        (terminals))
    ("wyse50.el"
        "terminal support code for Wyse 50"
        (terminals))
    ("x-win.el"
        "parse switches controlling interface with X window system"
        (terminals))
    ("xterm.el"
        "define function key sequences for xterm"
        (terminals))
    ("bib-mode.el"
        "bib-mode, major mode for editing bib files."
        (bib))
    ("bibtex.el"
        "BibTeX mode for GNU Emacs"
        (bibtex  latex  tex))
    ("fill.el"
        "fill commands for Emacs"
        (wp))
    ("flyspell.el"
        "On-the-fly spell checker"
        (convenience))
    ("makeinfo.el"
        "run makeinfo conveniently"
        nil)
    ("nroff-mode.el"
        "GNU Emacs major mode for editing nroff source"
        (wp))
    ("ooutline.el"
        "outline mode commands for Emacs"
        (outlines))
    ("outline.el"
        "outline mode commands for Emacs"
        (outlines))
    ("page-ext.el"
        "extended page handling commands"
        nil)
    ("page.el"
        "page motion commands for emacs."
        nil)
    ("paragraphs.el"
        "paragraph and sentence parsing."
        (wp))
    ("picture.el"
        "\"Picture mode\" -- editing using quarter-plane screen model."
        nil)
    ("refbib.el"
        "convert refer-style references to ones usable by Latex bib"
        (bib  tex))
    ("refer.el"
        "look up references in bibliography files."
        (bib))
    ("reftex.el"
        "Minor mode for doing \\label, \\ref and \\cite in LaTeX"
        (tex))
    ("scribe.el"
        "scribe mode, and its idiosyncratic commands."
        (wp))
    ("sgml-mode.el"
        "SGML- and HTML-editing modes"
        (wp  hypermedia  comm  languages))
    ("spell.el"
        "spelling correction interface for Emacs."
        (wp  unix))
    ("tex-mode.el"
        "TeX, LaTeX, and SliTeX mode commands."
        (tex))
    ("texinfmt.el"
        "format Texinfo files into Info files."
        (maint  tex  docs))
    ("texinfo.el"
        "major mode for editing Texinfo files"
        (maint  tex  docs))
    ("texnfo-upd.el"
        "utilities for updating nodes and menus in Texinfo files"
        (maint  tex  docs))
    ("text-mode.el"
        "text mode, and its idiosyncratic commands."
        nil)
    ("two-column.el"
        "minor mode for editing of two-column text"
        nil)
    ("underline.el"
        "insert/remove underlining (done by overstriking) in Emacs."
        (wp))
    ("appt.el"
        "appointment notification functions."
        (calendar))
    ("cal-china.el"
        "calendar functions for the Chinese calendar."
        (calendar))
    ("cal-coptic.el"
        "calendar functions for the Coptic/Ethiopic calendars."
        (calendar))
    ("cal-dst.el"
        "calendar functions for daylight savings rules."
        (calendar))
    ("cal-french.el"
        "calendar functions for the French Revolutionary calendar."
        (calendar))
    ("cal-hebrew.el"
        "calendar functions for the Hebrew calendar."
        (calendar))
    ("cal-islam.el"
        "calendar functions for the Islamic calendar."
        (calendar))
    ("cal-iso.el"
        "calendar functions for the ISO calendar."
        (calendar))
    ("cal-julian.el"
        "calendar functions for the Julian calendar."
        (calendar))
    ("cal-mayan.el"
        "calendar functions for the Mayan calendars."
        (calendar))
    ("cal-menu.el"
        "calendar functions for menu bar and popup menu support"
        (calendar))
    ("cal-move.el"
        "calendar functions for movement in the calendar"
        (calendar))
    ("cal-persia.el"
        "calendar functions for the Persian calendar."
        (calendar))
    ("cal-tex.el"
        "calendar functions for printing calendars with LaTeX."
        (calendar))
    ("cal-x.el"
        "calendar windows in dedicated frames in X"
        (calendar))
    ("calendar.el"
        "Calendar functions."
        (calendar))
    ("diary-lib.el"
        "diary functions."
        (calendar))
    ("holidays.el"
        "holiday functions for the calendar package"
        (holidays  calendar))
    ("lunar.el"
        "calendar functions for phases of the moon."
        (calendar))
    ("solar.el"
        "calendar functions for solar events."
        (calendar))
))

(provide 'finder-inf)

;;; finder-inf.el ends here
